package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.ChartDefinitionDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ChartDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.ChartDefinitionVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * BOC首页报表配置
 * @author luban
 * @date 2020-06-18
 */ 
@Api(tags = {"用户中心：BOC首页报表配置"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-user-api-IChartDefinitionApi",path = "/v1/chartDefinition", name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}", url = "${dtyunxi.yundt.cube_base-center-user_api:}")
public interface IChartDefinitionApi {

    /**
     * 查询所有上报的报表信息
     * @return 报表信息
     */
    @RequestMapping(value = {"/chart"}, method = RequestMethod.GET)
    @ApiOperation(value = "获取所有报表分类", notes = "获取所有报表分类信息")
    RestResponse<List<ChartDto>> queryAllCharts();

    /**
     * 查询报表配置信息
     * @param userId 用户主键
     * @return 报表配置信息
     */
    @RequestMapping(value = {"/{userId}"}, method = RequestMethod.GET)
    @ApiOperation(value = "获取报表配置信息", notes = "获取报表配置信息")
    RestResponse<List<ChartDefinitionVo>> queryChartDefinitions(@PathVariable("userId") Long userId);

    /**
     *
     * @param chartDefinitionDto 报表配置信息
     * @return void
     */
    @RequestMapping(value = {""}, method = RequestMethod.POST)
    @ApiOperation(value = "添加报表配置信息", notes = "添加报表配置信息")
    RestResponse<Void> insertChartDefinition(@RequestBody ChartDefinitionDto chartDefinitionDto);

    /**
     * 修改报表定义信息
     * @param id 主键
     * @param chartDefinitionDto 报表配置信息
     * @return 无
     */
    @RequestMapping(value = {"/{id}"}, method = RequestMethod.PUT)
    @ApiOperation(value = "修改报表配置信息", notes = "修改报表配置信息")
    RestResponse<Void> updateChartDefinition(@PathVariable("id") Long id, @RequestBody ChartDefinitionDto chartDefinitionDto);

    /**
     * 删除报表配置信息
     * @param id 主键
     * @return 无
     */
    @RequestMapping(value = {"/{id}"}, method = RequestMethod.DELETE)
    @ApiOperation(value = "删除报表配置信息", notes = "删除报表配置信息")
    RestResponse<Void> deleteChartDefinition(@PathVariable("id") Long id);

    /**
     * 分页获取报表信息
     * @param type 表报类别
     * @param pageNum 当前页
     * @param pageSize 当前页数据量
     * @return 报表分页信息
     */
    @RequestMapping(value = {"/page"}, method = RequestMethod.GET)
    @ApiOperation(value = "分页查询报表信息", notes = "分页查询报表信息")
    RestResponse<PageInfo<ChartDto>> queryChartPage(@RequestParam(name = "type", required = false) String type, @RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize);
}
