package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.AddressDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.BillInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ContactsInfoDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * @author yufan
 * @time 2020/9/28 10:34
 */
@Api(tags = {"用户中心：【客商中心】客户地址、发票信息、联系人信息管理服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-user-api-ICustomerUserApi"
        , name = "${dtyunxi.yundt.cube_base-center-user_api.name:yundt-cube-center-user}"
        , path = "/v1/customer-user"
        , url = "${yundt.cube.center.user.api:}")
public interface ICustomerUserApi {
    /**
     * 创建客户地址
     *
     * @param addressDto    地址
     * @return Long
     */
    @PostMapping(value = {"/address/add"}, produces = {"application/json;charset=UTF-8"})
    @ApiOperation(value = "创建客户地址", notes = "创建客户地址")
    @Capability(capabilityCode = "user.customer.add-address")
    RestResponse<Long> addCustomerAddress(@RequestBody AddressDto addressDto);

    /**
     * 更新客户地址
     *
     * @param addressDto    地址
     * @return void
     */
    @PutMapping(value = {"/address/update"}, produces = {"application/json;charset=UTF-8"})
    @ApiOperation(value = "更新客户地址", notes = "更新客户地址")
    @Capability(capabilityCode = "user.customer.update-address")
    RestResponse<Void> updateCustomerAddress(@RequestBody AddressDto addressDto);

    /**
     * 删除客户地址
     *
     * @param id    主键
     * @return void
     */
    @DeleteMapping(value = {"/address/delete/{id}"}, produces = {"application/json;charset=UTF-8"})
    @ApiOperation(value = "删除客户地址", notes = "删除客户地址")
    @Capability(capabilityCode = "user.customer.delete-address")
    RestResponse<Void> deleteCustomerAddress(@PathVariable("id") Long id);

    /**
     * 创建发票信息
     *
     * @param billInfoDto    发票信息
     * @return Long
     */
    @PostMapping(value = {"/billinfo/add"}, produces = {"application/json;charset=UTF-8"})
    @ApiOperation(value = "创建发票信息", notes = "创建发票信息")
    @Capability(capabilityCode = "user.customer.add-billinfo")
    RestResponse<Long> addCustomerBillInfo(@RequestBody BillInfoDto billInfoDto);

    /**
     * 更新发票地址
     *
     * @param billInfoDto    发票信息
     * @return void
     */
    @PutMapping(value = {"/billinfo/update"}, produces = {"application/json;charset=UTF-8"})
    @ApiOperation(value = "更新发票地址", notes = "更新发票地址")
    @Capability(capabilityCode = "user.customer.update-billinfo")
    RestResponse<Void> updateCustomerBillInfo(@RequestBody BillInfoDto billInfoDto);

    /**
     * 删除发票地址
     *
     * @param id    主键
     * @return void
     */
    @DeleteMapping(value = {"/billinfo/delete/{id}"}, produces = {"application/json;charset=UTF-8"})
    @ApiOperation(value = "删除发票地址", notes = "删除发票地址")
    @Capability(capabilityCode = "user.customer.delete-billinfo")
    RestResponse<Void> deleteCustomerBillInfo(@PathVariable("id") Long id);

    /**
     * 创建客户联系人
     *
     * @param contactsInfoDto    联系人
     * @return Long
     */
    @PostMapping(value = {"/contacts/add"}, produces = {"application/json;charset=UTF-8"})
    @ApiOperation(value = "创建客户联系人", notes = "创建客户联系人")
    @Capability(capabilityCode = "user.customer.add-contacts")
    RestResponse<Long> addCustomerContactsInfo(@RequestBody ContactsInfoDto contactsInfoDto);

    /**
     * 更新客户联系人
     *
     * @param contactsInfoDto    联系人
     * @return Long
     */
    @PutMapping(value = {"/contacts/update"}, produces = {"application/json;charset=UTF-8"})
    @ApiOperation(value = "更新客户联系人", notes = "更新客户联系人")
    @Capability(capabilityCode = "user.customer.update-contacts")
    RestResponse<Void> updateCustomerContactsInfo(@RequestBody ContactsInfoDto contactsInfoDto);

    /**
     * 删除客户联系人
     *
     * @param id    主键
     * @return void
     */
    @DeleteMapping(value = {"/contacts/delete/{id}"}, produces = {"application/json;charset=UTF-8"})
    @ApiOperation(value = "删除客户联系人", notes = "删除客户联系人")
    @Capability(capabilityCode = "user.customer.delete-contacts")
    RestResponse<Void> deleteCustomerContactsInfo(@PathVariable("id") Long id);
}
