package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.TenantDomainRemoveDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.TenantDomainReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 租户服务
 */
@Api(tags = {"用户中心：租户服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-user-api-ITenantApi", path = "/v1/tenant", name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}", url = "${dtyunxi.yundt.cube_base-center-user_api:}")
public interface ITenantApi {

    /**
     * 设置租户的帐号域  单租户场景
     *
     * @param tenantDomainReqDto 设置租户的帐号域请求
     * @return
     */
    @PostMapping(value = "/user-domain")
    @ApiOperation(value = "设置租户的帐号域", notes = "设置租户的帐号域")
    @Capability(capabilityCode = "user.tenant.set-tenant-domain")
    RestResponse<Void> setTenantDomain(@RequestBody TenantDomainReqDto tenantDomainReqDto);

    /**
     * 删除租户的指定帐号域  单租户场景
     *
     * @param tenantDomainRemoveDto 删除租户的指定帐号域请求
     * @return
     */
    @DeleteMapping(value = "/user-domain")
    @ApiOperation(value = "删除应用的指定帐号域", notes = "删除应用的指定帐号域")
    @Capability(capabilityCode = "user.tenant.remove-tenant-domain")
    RestResponse<Void> removeTenantDomain(@SpringQueryMap TenantDomainRemoveDto tenantDomainRemoveDto);

}

