package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserDomainAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserDomainModifyReqDto;
import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 用户域服务接口
 *
 * @author qiuzhi
 * @since 2020-11-23
 */
@Api(tags = {"用户中心：用户账号域服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-user-api-IUserDomainApi",
        name = "${dtyunxi.yundt.cube_base-center-user_api.name:yundt-cube-center-user}",
        url = "${yundt.cube.center.user.api:}",
        path = "/v2/user-domain"
)
public interface IUserDomainApi {

    /**
     * 新增用户账号域
     *
     * @param reqDto 用户账号域添加请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增用户账号域", notes = "新增用户账号域")
    @Capability(capabilityCode = "addUserDomain")
    RestResponse<Long> addUserDomain(@RequestBody UserDomainAddReqDto reqDto);

    /**
     * 修改用户账号域
     *
     * @param reqDto 用户账号域修改请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改用户账号域", notes = "修改用户账号域")
    @Capability(capabilityCode = "modifyUserDomain")
    RestResponse<Void> modifyUserDomain(@RequestBody UserDomainModifyReqDto reqDto);

    /**
     * 删除用户账号域
     *
     * @param ids        用户账号域删除数据ID
     * @return 处理结果
     */
    @DeleteMapping("{ids}")
    @ApiOperation(value = "删除用户账号域", notes = "删除用户账号域")
    @Capability(capabilityCode = "removeUserDomain")
    RestResponse<Void> removeUserDomain(@PathVariable("ids") String ids);
}
