package com.dtyunxi.yundt.cube.center.user.api.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * 资源状态类型
 *
 * @author shuangqing
 * @since 2019-10-26
 */

public enum ResourceStatus {
    ENABLE(1),
    DISABLE(2);
    private final int value;

    private static Map<Integer, ResourceStatus> valueMap = new HashMap<>();

    static {
        for (ResourceStatus type : values()) {
            valueMap.put(type.value, type);
        }
    }

    public static ResourceStatus get(Integer value) {
        return valueMap.get(value);
    }

    ResourceStatus(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

}
