/**
 * @(#)ApplicationDto.java 1.0 May 17, 2018
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto;

import com.dtyunxi.yundt.cube.center.user.api.dto.response.RoleTemplateRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 应用Dto
 * 用于应用的数据传输对象
 *
 * @author 南枫
 * @since 1.0.0
 */
@ApiModel(value = "ApplicationDto", description = "应用")
public class ApplicationDto extends BaseDto {
    private static final long serialVersionUID = -9001996749478890048L;

    /**
     * 应用ID
     */
    @ApiModelProperty(value = "应用ID")
    private Long id;

    /**
     * 应用编号
     */
    @ApiModelProperty(value = "应用编号")
    @NotNull
    private String code;

    /**
     * 应用名称
     */
    @ApiModelProperty(value = "应用名称")
    @NotNull
    private String name;
    /**
     * 应用key
     */
    @ApiModelProperty(value = "应用key")
    private String appKey;
    /**
     * 应用类型：1:单租户,2:多租户
     */
    @ApiModelProperty(value = "应用类型：1:单租户,2:多租户")
    private Integer applicationType;
    /**
     * 状态 1启用 2禁用
     */
    @ApiModelProperty(value = "状态 1启用 2禁用")
    private Integer status;
    /**
     * 应用所属用户id
     */
    @ApiModelProperty(value = "应用所属用户id")
    @NotNull
    private Long ownerId;

    /**
     * 开发人员
     */
    private String developer;
    /**
     * 开发人手机号码
     */
    private String developerPhone;
    /**
     * 开发人邮箱号码
     */
    private String developerEamil;
    /**
     * 菜单
     */
    @ApiModelProperty(value = "资源菜单列表")
    private MenuDto menus;

    /**
     * 按钮
     */
    @ApiModelProperty(value = "资源按钮列表")
    private List<ButtonDto> buttons;

    /**
     * 角色模板列表
     */
    @ApiModelProperty(value = "角色模板列表")
    private List<RoleTemplateRespDto> roleTemplateRespDtos;


    public ApplicationDto() {
    }

    /**
     * 设置应用ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 获取应用ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 设置应用编号
     */
    public void setCode(String code) {
        this.code = code;
    }

    /**
     * 获取应用编号
     */
    public String getCode() {
        return this.code;
    }

    /**
     * 设置应用名称
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 获取应用名称
     */
    public String getName() {
        return this.name;
    }

    /**
     * 设置状态 1启用 2禁用
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 获取状态 1启用 2禁用
     */
    public Integer getStatus() {
        return this.status;
    }

    public MenuDto getMenus() {
        return menus;
    }

    public void setMenus(MenuDto menus) {
        this.menus = menus;
    }

    public List<ButtonDto> getButtons() {
        return buttons;
    }

    public void setButtons(List<ButtonDto> buttons) {
        this.buttons = buttons;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public Integer getApplicationType() {
        return applicationType;
    }

    public void setApplicationType(Integer applicationType) {
        this.applicationType = applicationType;
    }

    public String getDeveloper() {
        return developer;
    }

    public void setDeveloper(String developer) {
        this.developer = developer;
    }

    public String getDeveloperPhone() {
        return developerPhone;
    }

    public void setDeveloperPhone(String developerPhone) {
        this.developerPhone = developerPhone;
    }

    public String getDeveloperEamil() {
        return developerEamil;
    }

    public void setDeveloperEamil(String developerEamil) {
        this.developerEamil = developerEamil;
    }

    public List<RoleTemplateRespDto> getRoleTemplateRespDtos() {
        return roleTemplateRespDtos;
    }

    public void setRoleTemplateRespDtos(List<RoleTemplateRespDto> roleTemplateRespDtos) {
        this.roleTemplateRespDtos = roleTemplateRespDtos;
    }
}
