/**
 * @(#) BindingsDto.java 1.0 2018-10-24
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 第三方账号绑定
 *
 * @author 刘备
 * @since 1.0.0
 */
@ApiModel(value = "BindingsDto", description = "第三方账号绑定")
public class BindingsDto extends BaseDto {
    /**
     * 应用ID
     */
    @ApiModelProperty(value = "应用ID，新增时不填")
    private String applicationId;
    /**
     * 第三方应用ID
     */
    @ApiModelProperty(value = "第三方应用ID，与unionId不能同时为空")
    private String openId;

    /**
     * 账号域
     */
    @ApiModelProperty(value = "账号域")
    private String userDomain;

    /**
     * 微信的unionId
     */
    @ApiModelProperty(value = "微信的unionId，与openId不能同时为空")
    private String unionId;
    /**
     * 第三方类型：1 微信开放平台openId标识， 2 微信开发平台unionId标识  3 QQ互联网平台openId标识， 4 QQ互联平台unionId标识
     */
    @ApiModelProperty(value = "第三方类型类型,参考:com.dtyunxi.yundt.cube.center.user.api.constant.ThirdPlatform")
    private Integer thirdparyType;

    /**
     * 第三方类型：1 微信， 2 QQ， 3 新浪， 4 支付宝， 5 钉钉
     */
    @ApiModelProperty(value = "第三方类型类型,参考:com.dtyunxi.yundt.cube.center.user.api.constant.ThirdPlatform")
    private Integer thirdpartyType;

    /**
     * 状态：1可用   2禁用
     */
    @ApiModelProperty(value = "状态：1可用   2禁用，选填")
    private Integer status;

    @ApiModelProperty(value = "personId，选填")
    private Long personId;

    /**
     * 手机号
     */
    @ApiModelProperty(value = "手机号，选填")
    private String phone;

    /**
     * userId
     */
    @ApiModelProperty(value = "用户ID，新增时不填")
    private Long userId;

    public String getApplicationId() {
        return applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public Integer getThirdparyType() {
        return thirdparyType;
    }

    public void setThirdparyType(Integer thirdparyType) {
        this.thirdparyType = thirdparyType;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getPersonId() {
        return personId;
    }

    public void setPersonId(Long personId) {
        this.personId = personId;
    }
    public String getUserDomain() {
        return userDomain;
    }

    public void setUserDomain(String userDomain) {
        this.userDomain = userDomain;
    }

    public String getUnionId() {
        return unionId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Integer getThirdpartyType() {
        return thirdpartyType;
    }

    public void setThirdpartyType(Integer thirdpartyType) {
        this.thirdpartyType = thirdpartyType;
    }
}