package com.dtyunxi.yundt.cube.center.user.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.validation.constraints.NotNull;


/**
 * 栏位配置信息
 * @author luban
 * @date 2020-06-17
 */
@ApiModel(value = "HurdleInfoDto", description = "栏位配置信息")
public class HurdleDefinitionDto extends BaseDto{

    @ApiModelProperty(value = "栏位定义ID")
    private Long id;

    /**
     * 通知栏名称
     */
    @ApiModelProperty(value = "通知栏名称")
    @NotNull(message = "通知栏名称不能为空")
    private String name;

    /**
     * 图标地址
     */
    @ApiModelProperty(value = "图标地址")
    private String icon;

    /**
     * 栏位编码
     */
    @ApiModelProperty(value = "栏位编码")
    private String hurdleCode;

    /**
     * 所属前端实例
     */
    @ApiModelProperty(value = "所属前端实例")
    @NotNull(message = "栏位所属前端实例不能为空")
    private Long webInstance;

    /**
     * 自定义路径前缀
     * 完整url由4部分组成：域名 + 自定义路径前缀 + 网关配置服务前缀 + API路径
     */
    @Column(name = "url_prefix")
    private String urlPrefix;

    /**
     * 序号
     */
    @ApiModelProperty(value = "序号")
    private Integer sort;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getHurdleCode() {
        return hurdleCode;
    }

    public void setHurdleCode(String hurdleCode) {
        this.hurdleCode = hurdleCode;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Long getWebInstance() {
        return webInstance;
    }

    public void setWebInstance(Long webInstance) {
        this.webInstance = webInstance;
    }

    public String getUrlPrefix() {
        return urlPrefix;
    }

    public void setUrlPrefix(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }
}
