/**
 * @(#)PersonalInfoDto.java 1.0 May 17, 2018
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved. YUNXI
 * PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 个人信息Dto
 * 用于创建,查询,修改个人信息的数据传输对象
 *
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "PersonalInfoDto", description = "个人信息")
public class PersonalInfoDto extends BaseDto {

    private static final long serialVersionUID = -7424450130644901707L;

    /**
     * id
     */
    @ApiModelProperty(value = "id")
    private Long id;


    /**
     * 验证类型:支持身份证,护照,其他,默认身份证
     */
    @ApiModelProperty(value = "验证类型：支持身份证,护照,其他,默认身份证，选填")
    private String identityType;
    /**
     * 外部识别标记, 默认为空.
     */
    @ApiModelProperty(value = "外部识别标记，选填")
    private String outerIdentity;


    /**
     * 生日
     */
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    @ApiModelProperty(value = "生日，选填", allowEmptyValue = true)
    private Date birthday;
    /**
     * 省份
     */
    @ApiModelProperty(value = "省份，选填", allowEmptyValue = true)
    private String province;
    /**
     * 城市
     */
    @ApiModelProperty(value = "城市，选填", allowEmptyValue = true)
    private String city;
    /**
     * 区/县
     */
    @ApiModelProperty(value = "区/县，选填", allowEmptyValue = true)
    private String district;
    /**
     * 工作单位
     */
    @ApiModelProperty(value = "工作单位，选填", allowEmptyValue = true)
    private String company;
    /**
     * 职位
     */
    @ApiModelProperty(value = "职位，选填", allowEmptyValue = true)
    private String position;
    /**
     * 详细地址
     */
    @ApiModelProperty(value = "详细地址，选填", allowEmptyValue = true)
    private String address;
    /**
     * 性别
     */
    @ApiModelProperty(value = "性别，选填")
    private String sex;

    /**
     * 婚姻状态：0未婚，1已婚
     */
    @ApiModelProperty(value = "婚姻状态：0未婚，1已婚，选填")
    private Integer maritalStatus;

    /**
     * 教育水平:0小学，1初中，2高中，3专科，4本科，5硕士，6博士
     */
    @ApiModelProperty(value = "教育水平:0小学，1初中，2高中，3专科，4本科，5硕士，6博士，选填")
    private Integer educationLevel;

    /**
     * 所在行业
     */
    @ApiModelProperty(value = "所在行业，选填")
    private String industry;

    /**
     * 身份证号码
     */
    @ApiModelProperty(value = "身份证号码，选填")
    private String identityCard;
    /**
     * 真实姓名
     */
    @ApiModelProperty(value = "真实姓名，选填")
    private String realName;
    /**
     * 头像URL
     */
    @ApiModelProperty(value = "头像URL，选填", allowEmptyValue = true)
    private String avatar;
    /**
     * 所属用户Id
     */
    @ApiModelProperty(value = "所属用户Id，选填")
    private Long userId;

    /**
     * 邮政编码
     */
    @ApiModelProperty(value = "邮政编码，选填", allowEmptyValue = true)
    private String postcode;
    @ApiModelProperty(value = "扩展参数，格式为JSON，选填", allowEmptyValue = true)
    private String extraParams;

    @ApiModelProperty(value = "座机，选填", allowEmptyValue = true)
    private String tel;

    @ApiModelProperty(value = "扩展属性，选填", allowEmptyValue = true)
    private String extension;
    @ApiModelProperty(value = "是否对身份证号做实例级别的唯一性校验，默认不校验")
    private boolean checkIdCardUnique;

    public boolean isCheckIdCardUnique() {
        return checkIdCardUnique;
    }

    public void setCheckIdCardUnique(boolean checkIdCardUnique) {
        this.checkIdCardUnique = checkIdCardUnique;
    }

    @ApiModelProperty(value = "证件图片地址", allowEmptyValue = true)
    private String photoUrl;

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getExtraParams() {
        return extraParams;
    }

    public void setExtraParams(String extraParams) {
        this.extraParams = extraParams;
    }

    public Date getBirthday() {
        return birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public String getIdentityCard() {
        return identityCard;
    }

    public void setIdentityCard(String identityCard) {
        this.identityCard = identityCard;
    }

    public String getRealName() {
        return realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getPostcode() {
        return postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getIdentityType() {
        return identityType;
    }

    public void setIdentityType(String identityType) {
        this.identityType = identityType;
    }

    public String getOuterIdentity() {
        return outerIdentity;
    }

    public void setOuterIdentity(String outerIdentity) {
        this.outerIdentity = outerIdentity;
    }

    public String getTel() {
        return tel;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public Integer getMaritalStatus() {
        return maritalStatus;
    }

    public void setMaritalStatus(Integer maritalStatus) {
        this.maritalStatus = maritalStatus;
    }

    public Integer getEducationLevel() {
        return educationLevel;
    }

    public void setEducationLevel(Integer educationLevel) {
        this.educationLevel = educationLevel;
    }

    public String getIndustry() {
        return industry;
    }

    public void setIndustry(String industry) {
        this.industry = industry;
    }

    @Override
    public String getExtension() {
        return extension;
    }

    @Override
    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getPhotoUrl() {
        return photoUrl;
    }

    public void setPhotoUrl(String photoUrl) {
        this.photoUrl = photoUrl;
    }
}
