/**
 * @(#) RelationInfoDto.java 1.0 2018/11/28
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author 米修
 * @date 2018/11/28
 * @since 1.0.0
 */
@ApiModel(value = "RelationInfoDto", description = "注册人信息")
public class RelationInfoDto extends BaseDto {
    private static final long serialVersionUID = 9007832202953850823L;

    /**
     * 昵称
     */
    @ApiModelProperty(value = "昵称，选填")
    private String nickName;
    /**
     * 头像
     */
    @ApiModelProperty(value = "头像，选填")
    private String avatar;

    /**
     * 用户名/登录名
     */
    @ApiModelProperty(value = "用户名/登录名，选填")
    private String userName;

    /**
     * 个人ID
     */
    @ApiModelProperty(value = "个人ID，选填")
    private Long personId;

    /**
     * 用户ID
     */
    @ApiModelProperty(value = "用户ID，选填")
    private Long userId;

    /**
     * 第一个用户ID
     */
    @ApiModelProperty(value = "第一个用户ID，选填")
    private Long firstUserId;

    /**
     * 第二个用户ID
     */
    @ApiModelProperty(value = "第二个用户ID，选填")
    private Long secondUserId;

    /**
     * 关系类型: 1上下级关系 2同级关系 3主账号与子账号 4邀请关系
     */
    @ApiModelProperty(value = "关系类型，选填")
    private String relationType;

//    /**
//     * 关系建立时间
//     */
//    @ApiModelProperty(value = "关系建立时间")
//    private Date createTime;

    /**
     * 扩展值
     */
    @ApiModelProperty(value = "扩展值，选填")
    private String extension;

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getRelationType() {
        return relationType;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

//    @Override
//    public Date getCreateTime() {
//        return createTime;
//    }
//
//    @Override
//    public void setCreateTime(Date createTime) {
//        this.createTime = createTime;
//    }


    @Override
    public String getExtension() {
        return extension;
    }

    @Override
    public void setExtension(String extension) {
        this.extension = extension;
    }

    public Long getPersonId() {
        return personId;
    }

    public void setPersonId(Long personId) {
        this.personId = personId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getFirstUserId() {
        return firstUserId;
    }

    public void setFirstUserId(Long firstUserId) {
        this.firstUserId = firstUserId;
    }

    public Long getSecondUserId() {
        return secondUserId;
    }

    public void setSecondUserId(Long secondUserId) {
        this.secondUserId = secondUserId;
    }
}
