package com.dtyunxi.yundt.cube.center.user.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


@ApiModel(value = "UserModifyReqDto", description = "修改用户基本信息+关联的角色")
public class UserModifyReqDto extends BaseDto {

    @NotNull
    @ApiModelProperty(name = "id")
    private Long id;

    /**
     * 昵称
     */
    @ApiModelProperty(value = "昵称，选填")
    private String nickName;
    /**
     * 头像
     */
    @ApiModelProperty(value = "头像，选填")
    private String avatar;

    /**
     * 用户名/登录名
     */
    @ApiModelProperty(value = "用户名/登录名，根据注册方式选填，不填程序会自动生成类似29424100143的用户名。租户下唯一(租户隔离)或实例下唯一(实例隔离)")
    private String userName;

    /**
     * 密码
     */
    @ApiModelProperty(value = "密码, 根据注册方式选填")
    private String password;

    /**
     * 1启用2禁用
     */
    @ApiModelProperty(value = "1启用2禁用，不填，默认启用")
    private Integer status;

    /**
     * 激活状态
     * 0.未激活 1.已激活
     */
    @ApiModelProperty(value = "激活状态,0.未激活 1.已激活，选填")
    private Integer activeState;

    /**
     * 有效起始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "有效起始时间，选填")
    private Date validStartDate;

    /**
     * 有效结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "有效结束时间，选填")
    private Date validEndDate;

    /**
     * 手机号
     */
    @ApiModelProperty(value = "手机号。根据注册方式选填，租户下唯一(租户隔离)或实例下唯一(实例隔离)")
    private String phone;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱。根据注册方式选填，租户下唯一(租户隔离)或实例下唯一(实例隔离)")
    private String email;

    /**
     * 用户分类
     */
    @ApiModelProperty(value = "用户分类, 选填")
    private Integer userType;

    /**
     * 渠道编码
     */
    @ApiModelProperty(value = "渠道编码, 选填")
    private String channelCode;

    /**
     * 邀请码
     */
    @ApiModelProperty(value = "邀请码。选填，有值的话，接口将建立用户间的推荐关系")
    private String inviteCode;

    @ApiModelProperty(value = "邀请人姓名。选填")
    private String inviterName;

    /**
     * 注册时间
     */
    @ApiModelProperty(value = "注册时间")
    private Date registerTime;

    @ApiModelProperty(value = "个人信息id")
    private Long personId;

    @ApiModelProperty(value = "扩展属性")
    private String extension;

    /**
     * 个人简介
     */
    @ApiModelProperty(value = "个人简介, 选填")
    private String brief;

    /**
     * 密码md5的salt
     */
    @ApiModelProperty(value = "密码md5的salt, 选填")
    private String salt;

    @ApiModelProperty(name="roleCodes",value = "角色编码列表")
    private List<String> roleCodes=new ArrayList<>();

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getActiveState() {
        return activeState;
    }

    public void setActiveState(Integer activeState) {
        this.activeState = activeState;
    }

    public Date getValidStartDate() {
        return validStartDate;
    }

    public void setValidStartDate(Date validStartDate) {
        this.validStartDate = validStartDate;
    }

    public Date getValidEndDate() {
        return validEndDate;
    }

    public void setValidEndDate(Date validEndDate) {
        this.validEndDate = validEndDate;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getUserType() {
        return userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getInviteCode() {
        return inviteCode;
    }

    public void setInviteCode(String inviteCode) {
        this.inviteCode = inviteCode;
    }

    public String getInviterName() {
        return inviterName;
    }

    public void setInviterName(String inviterName) {
        this.inviterName = inviterName;
    }

    public Date getRegisterTime() {
        return registerTime;
    }

    public void setRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
    }

    public Long getPersonId() {
        return personId;
    }

    public void setPersonId(Long personId) {
        this.personId = personId;
    }

    @Override
    public String getExtension() {
        return extension;
    }

    @Override
    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getBrief() {
        return brief;
    }

    public void setBrief(String brief) {
        this.brief = brief;
    }

    public String getSalt() {
        return salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public List<String> getRoleCodes() {
        return roleCodes;
    }

    public void setRoleCodes(List<String> roleCodes) {
        this.roleCodes = roleCodes;
    }
}
