/**
 * @(#) UserRoleDto.java 1.0 2019-10-30
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.user.api.dto.boc.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 *
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "UserRoleDto", description = "用户角色关联关系Dto")
public class UserRoleDto extends BaseVo {
    @ApiModelProperty(value = "用户id")
    private Long id;

    @ApiModelProperty(value = "手机")
    private String phone;

    @ApiModelProperty(value = "用户名称")
    private String userName;

    @ApiModelProperty(value = "用户账号, 选填")
    private String account;

    @ApiModelProperty(value = "是否已关联角色，1:关联，0:未关联")
    private Integer isRoleRelated = 0;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public Integer getIsRoleRelated() {
        return isRoleRelated;
    }

    public void setIsRoleRelated(Integer isRoleRelated) {
        this.isRoleRelated = isRoleRelated;
    }
}
