package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import io.swagger.annotations.ApiModel;

import java.io.Serializable;

/**
 * @Description: 前端资源明细dto
 * @Author: 水镜
 * @Date: 2021/3/30 14:25
 * @Version: 0.1.0
 */
@ApiModel(value = "AppResourceDetailDto", description = "前端资源明细dto")
public class AppResourceDetailDto implements Serializable {

    private static final long serialVersionUID = -1L;

    /**
     * 应用编码
     */
    private String resourceCode;
    /**
     * 资源
     */
    private String resourceName;
    /**
     * 资源类型：1=菜单  2=按钮
     */
    private Integer type;
    /**
     * 父级资源编码
     */
    private String parentCode;
    /**
     * 资源
     */
    private String routePath;
    /**
     * 渲染器默认参数
     */
    private String urlParam;
    /**
     * 页面ID
     */
    private Long pageId;
    /**
     * 序号
     */
    private Integer sortNo;

    public String getResourceCode() {
        return resourceCode;
    }

    public void setResourceCode(String resourceCode) {
        this.resourceCode = resourceCode;
    }

    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getRoutePath() {
        return routePath;
    }

    public void setRoutePath(String routePath) {
        this.routePath = routePath;
    }

    public String getUrlParam() {
        return urlParam;
    }

    public void setUrlParam(String urlParam) {
        this.urlParam = urlParam;
    }

    public Long getPageId() {
        return pageId;
    }

    public void setPageId(Long pageId) {
        this.pageId = pageId;
    }

    public Integer getSortNo() {
        return sortNo;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }
}
