/**
 * @(#)PurchasePackageDto 1.0 2019/5/23
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 应用实例套餐购买绑定 ReqDto
 *
 * @author shuangqing  2019/5/23
 */
@ApiModel(value = "PurchasePackageDto", description = "应用实例套餐购买绑定 ReqDto")
public class PurchasePackageDto extends BaseDto {

    /**
     * 套餐ID
     */
    @NotNull
    @ApiModelProperty(value = "套餐id，必填")
    private Long appPackageId;
    /**
     * 用户ID
     */
    @NotNull
    @ApiModelProperty(value = "用户ID，必填")
    private Long userId;
    /**
     * 支付金额
     */
    @NotNull
    @ApiModelProperty(value = "支付金额，必填")
    private BigDecimal paymentAmount;
    /**
     * 有效期开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "有效期开始时间 格式：yyyy-MM-dd HH:mm:ss，必填")
    private Date validStartDate;
    /**
     * 有效期结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "有效期结束时间 格式：yyyy-MM-dd HH:mm:ss，必填")
    private Date validEndDate;
    /**
     * 备注
     */
    @ApiModelProperty(value = "备注，选填")
    private String remark;

    public Long getAppPackageId() {
        return appPackageId;
    }

    public void setAppPackageId(Long appPackageId) {
        this.appPackageId = appPackageId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public BigDecimal getPaymentAmount() {
        return paymentAmount;
    }

    public void setPaymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public Date getValidStartDate() {
        return validStartDate;
    }

    public void setValidStartDate(Date validStartDate) {
        this.validStartDate = validStartDate;
    }

    public Date getValidEndDate() {
        return validEndDate;
    }

    public void setValidEndDate(Date validEndDate) {
        this.validEndDate = validEndDate;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
