package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 *
 */

/**
 * @Description: 资源校验请求dto
 * @Author: 水镜
 * @Date: 2020/9/16 16:30
 * @Version: 0.1.0
 */
@ApiModel(value = "ResourceValidateDto", description = "资源校验请求dto")
public class ResourceValidateDto extends RequestDto {

    /**
     * 前端应用编码
     */
    @ApiModelProperty(name = "appCode", value = "应用编码")
    private String appCode;

    /**
     * 资源编码
     */
    @NotNull(message = "资源编码不能为空")
    @ApiModelProperty(value = "资源编码")
    private String code;

    public String getAppCode() {
        return appCode;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}