/**
 * @(#)MenuDto.java 1.0 May 17, 2018
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Min;

/**
 * 第三方账号绑定查询DTO
 *
 * @author 悠扬
 * @date 2019-03-29
 */
@ApiModel(value = "ThirdBindingQueryReq", description = "第三方账号绑定查询DTO")
public class ThirdBindingQueryReq extends BaseDto {
    private static final long serialVersionUID = 1125806338598984432L;

    /**
     * openId
     */
    @ApiModelProperty(value = "openId")
    private String openId;
    /**
     * unionId
     */
    @ApiModelProperty(value = "unionId")
    private String unionId;
    /**
     * 第三方平台代码: 1 微信， 2 QQ， 3 新浪， 4 支付宝， 5 钉钉
     */
    @ApiModelProperty(value = "第三方平台代码,可选值:1 微信， 2 QQ， 3 新浪， 4 支付宝， 5 钉钉 ,参考: com.dtyunxi.yundt.cube.center.user.api.constant.ThirdPlatform")
    @Min(1)
    private int thirdType;
    /**
     * 查询类型
     */
    @ApiModelProperty(name = "queryType"
            , value = "查询类型 0:默认,先查询openId,再查询unionId; 1:只查询openId, 2:只查询unionId,3:先查询unionId,再查询openId"
            , reference = "ThirdQueryType"
    )
    private int queryType;

    @ApiModelProperty(name = "domain", value = "帐号域")
    private String domain;

    public String getOpenId() {
        return openId;
    }

    public ThirdBindingQueryReq setOpenId(String openId) {
        this.openId = openId;
        return this;
    }

    public String getUnionId() {
        return unionId;
    }

    public ThirdBindingQueryReq setUnionId(String unionId) {
        this.unionId = unionId;
        return this;
    }

    public int getThirdType() {
        return thirdType;
    }

    public ThirdBindingQueryReq setThirdType(int thirdType) {
        this.thirdType = thirdType;
        return this;
    }

    public int getQueryType() {
        return queryType;
    }

    public ThirdBindingQueryReq setQueryType(int queryType) {
        this.queryType = queryType;
        return this;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }
}
