/**
 * @(#)UserByLoginNameTypeQueryDto 1.0 2020/2/17
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author shuangqing  2020/2/17
 */
@ApiModel(value = "UserByLoginNameTypeQueryDto", description = "根据登录名、登录名类型和数据范围查询一个用户信息请求dto")
public class UserByLoginNameTypeQueryDto extends BaseVo {

    @ApiModelProperty(value = "登录名")
    private String loginName;

    @ApiModelProperty(value = "登录名类型，1 name,2 phone,3 email")
    private Integer loginNameType;

    @ApiModelProperty(value = "帐号域")
    private String domain;

    @ApiModelProperty(value = "租户ID")
    private Long tenantId;

    @ApiModelProperty(value = "实例ID")
    private Long instanceId;

    @ApiModelProperty(value = "密码，当需要校验密码时必填")
    private String password;

    public String getLoginName() {
        return loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public Integer getLoginNameType() {
        return loginNameType;
    }

    public void setLoginNameType(Integer loginNameType) {
        this.loginNameType = loginNameType;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}
