/**
 * @(#) UserOrganizationRelateReqDto.java 1.0 2020-02-24
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 用户组织关联请求Dto
 *
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "UserOrgRelationReqDto", description = "用户组织关联请求Dto")
public class UserOrgRelationReqDto extends BaseDto {

    @ApiModelProperty(value = "用户id,必填")
    @NotNull
    private Long userId;

    @ApiModelProperty(value = "组织id列表,必填")
    @NotNull
    private List<Long> orgIds;

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public List<Long> getOrgIds() {
        return orgIds;
    }

    public void setOrgIds(List<Long> orgIds) {
        this.orgIds = orgIds;
    }
}
