/**
 * @(#)AppInstanceDto.java 1.0 May 17, 2018
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto.response;

import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 实例应用Dto
 * 用于实例应用的数据传输对象
 *
 * @author 南枫
 * @since 1.0.0
 */
public class AppInstanceQueryResDto extends BaseDto {
    private static final long serialVersionUID = 8419952058782958833L;

    @ApiModelProperty(value = "id")
    private Long id;
    /**
     * 用户ID
     */
    @ApiModelProperty(value = "用户id")
    @NotNull
    private Long owner;
    /**
     * 用户名称
     */
    @ApiModelProperty(value = "用户名称")
    private String ownerName;
    /**
     * 应用实例名称
     */
    @ApiModelProperty(value = "应用实例名称")
    private String appInsName;
    /**
     * 应用实例对应应用名称
     */
    @ApiModelProperty(value = "应用实例对应应用名称")
    private String appName;

    /**
     * 归属的业务空间ID
     */
    @ApiModelProperty(value = "归属的业务空间ID,0表示直接归属到租户")
    private Long bizSpaceId;
    /**
     * 应用实例对应应用的Id
     */
    @ApiModelProperty(value = "应用实例对应应用的Id")
    private Long applicationId;
    /**
     * 访问入口
     */
    @ApiModelProperty(value = "访问入口")
    private String hostName;
    /**
     * 域名入口
     */
    @ApiModelProperty(value = "域名入口")
    private String serverName;
    /**
     * 应用实例key
     */
    @ApiModelProperty(value = "应用实例key")
    private String appInsKey;
    /**
     * 订购类型：1，购买；2，体验
     */
    @ApiModelProperty(value = "订购类型：1，购买；2，体验")
    private Integer purchaseType;
    /**
     * 状态：1，启用；2，禁用
     */
    @ApiModelProperty(value = "状态：1，启用；2，禁用")
    private Integer status;
    /**
     * 有效开始日期
     */
    @ApiModelProperty(value = "有效开始日期 格式：yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date effectiveStartDate;
    /**
     * 有效结束日期
     */
    @ApiModelProperty(value = "有效结束日期 格式：yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date effectiveEndDate;
    /**
     * 应用key
     */
    @ApiModelProperty(value = "应用key")
    private String appKey;
    /**
     * 应用secret
     */
    @ApiModelProperty(value = "应用secret")
    private String appSecret;
    /**
     * 资源菜单列表
     */
    @Deprecated
    @ApiModelProperty(value = "资源菜单列表")
    private MenuQueryResDto menus;

    @ApiModelProperty(value = "资源菜单列表")
    private List<MenuQueryResDto> menuList;

    /**
     * 资源按钮列表
     */
    @ApiModelProperty(value = "资源按钮列表")
    private List<ButtonQueryResDto> buttons = new ArrayList<>();

    /**
     * 套餐Id
     */
    @ApiModelProperty(value = "套餐Id")
    private Long appPackageId;

    @ApiModelProperty(value = "数据初始化状态,由应用自己决定具体内容")
    private String dataInitStatus;

    /**
     * 应用默认使用的账号域, 默认取值为"default"
     */
    @ApiModelProperty(value = "应用默认使用的账号域")
    private String defDomain;

    /**
     * 默认之外, 应用其他支持的账号域, 可有多个,用英文半角逗号分隔
     */
    @ApiModelProperty(value = "默认之外, 应用其他支持的账号域, 可有多个,用英文半角逗号分隔")
    private Set<String> trustDomain;

    public String getDataInitStatus() {
        return dataInitStatus;
    }

    public void setDataInitStatus(String dataInitStatus) {
        this.dataInitStatus = dataInitStatus;
    }

    public Long getAppPackageId() {
        return appPackageId;
    }

    public void setAppPackageId(Long appPackageId) {
        this.appPackageId = appPackageId;
    }

    public String getAppInsName() {
        return appInsName;
    }

    public void setAppInsName(String appInsName) {
        this.appInsName = appInsName;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getOwnerName() {
        return ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getOwner() {
        return owner;
    }

    public void setOwner(Long owner) {
        this.owner = owner;
    }

    public String getAppInsKey() {
        return appInsKey;
    }

    public void setAppInsKey(String appInsKey) {
        this.appInsKey = appInsKey;
    }

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getEffectiveStartDate() {
        return effectiveStartDate;
    }

    public void setEffectiveStartDate(Date effectiveStartDate) {
        this.effectiveStartDate = effectiveStartDate;
    }

    public Date getEffectiveEndDate() {
        return effectiveEndDate;
    }

    public void setEffectiveEndDate(Date effectiveEndDate) {
        this.effectiveEndDate = effectiveEndDate;
    }

    public MenuQueryResDto getMenus() {
        return menus;
    }

    public void setMenus(MenuQueryResDto menus) {
        this.menus = menus;
    }

    public List<ButtonQueryResDto> getButtons() {
        return buttons;
    }

    public void setButtons(List<ButtonQueryResDto> buttons) {
        this.buttons = buttons;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getHostName() {
        return hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getServerName() {
        return serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public Long getApplicationId() {
        return applicationId;
    }

    public void setApplicationId(Long applicationId) {
        this.applicationId = applicationId;
    }

    public Long getBizSpaceId() {
        return bizSpaceId;
    }

    public AppInstanceQueryResDto setBizSpaceId(Long bizSpaceId) {
        this.bizSpaceId = bizSpaceId;
        return this;
    }

    public List<MenuQueryResDto> getMenuList() {
        return menuList;
    }

    public void setMenuList(List<MenuQueryResDto> menuList) {
        this.menuList = menuList;
    }

    public String getDefDomain() {
        return defDomain;
    }

    public void setDefDomain(String defDomain) {
        this.defDomain = defDomain;
    }

    public Set<String> getTrustDomain() {
        return trustDomain;
    }

    public void setTrustDomain(Set<String> trustDomain) {
        this.trustDomain = trustDomain;
    }
}
