/**
 * @(#)UserExceptionCode.java 1.0 2016-11-10
 * <p>
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.exception;

/**
 * 描述
 *
 * @author 管春
 * @since 0.6.0
 */
public enum UserExceptionCode implements IExceptionEnum {

    //EEEE("0", "操作成功"),
    //用户中心异常 3000<= code < 4000
    APPLICATION_EXCEPTION_CODE("3000", "根据应用模板id无法找到应用"),
    APPINSTANCE_IDCHECKE_FAIL("3001", "根据应用id无法找到应用"),

    USER_IDCHECK_FAIL("3002", "无法查找到用户信息"),
    EXIST_FAIL("3003", "对应信息已存在"),
    NON_EXIST_FAIL("3004", "对应信息不存在"),
    BEAN_COPY_FAIL("3005", "属性拷贝出错"),
    ORGANIZATION__IDCHECK_FAIL("3006", "通过组织id无法查找到组织信息"),
    ORGANIZATION_UPDATE_FAIL("3007", "更新组织部门信息异常"),

    ORGANIZATION__IDNULL_FAIL("3008", "更新组织信息id不能为空"),
    EMPLOYEE__IDCHECK_FAIL("3009", "通过员工id无法找到员工信息"),
    PROP_IDCHECK_FAIL("3010", "通过属性id无法找到属性信息"),
    BUTTON_IDCHECK_FAIL("3011", "通过按钮id无法找到按钮信息"),
    USERNAME_CHECK_FAIL("3012", "通过用户账号无法查找到用户信息"),
    MODIFYPW_CHECK_FAIL("3013", "密码不正确"),
    DELETE_ORG_FAIL("3014", "该组织下有子组织或者有员工，无法删除"),

    ORGANIZATION_APPID_FAIL("3015", "通过实例id查询不到组织信息"),
    EMPLOYEE_UPDATE_FAIL("3016", "更新员工信息异常，该员工已经在该组织下面"),

    USERGROUP_CHILD_FAIL("3017", "该用户组的子分组有数据，无法删除"),
    USERGROUP_USER_FAIL("3018", "该用户组下面有用户，无法删除"),
    PERSONALINFO_EXIST_FAIL("3019", "该用户已存在个人信息"),
    USERGROUP_PARENT_FAIL("3047", "通过parentId找不到对应用户组"),

    PERSONALINFO_NON_EXIST_FAIL("3020", "该用户对应的个人信息不存在"),

    BILLINFO_NON_EXIST_FAIL("3021", "开票信息不存在"),

    CONTACTINFO_NON_EXIST_FAIL("3022", "联系人信息不存在"),

    ADDRESSINFO_NON_EXIST_FAIL("3023", "地址信息不存在"),

    ORGANIZATIONINFO_EXIST_FAIL("3024", "用户对应的所属组织信息已存在"),
    ORGANIZATIONINFO_NON_EXIST_FAIL("3025", "用户所属组织信息不存在"),

    DATE_CHECKE_FAIL("3019", "日期不满足要求"),
    BUTTON_NOTEXIT_FAIL("3020", "按钮信息不存在"),
    MENU_NOTEXIT_FAIL("3021", "菜单信息不存在"),
    MENU_CHILD_FAIL("3042", "该菜单下有子节点，无法删除"),
    USERGROUP_FIND_FAIL("3022", "查询不到用户组信息"),
    USERGROUP_APPID_FAIL("3023", "通过实例id查询不到用户组信息"),

    EXAMPLE_PARSE_FAIL("3033", "解析example参数时出现错误"),
    SORT_INPUT_FAIL("3034", "sort的输入有误"),
    APPLICATION_EXIT_FAIL("3035", "该名称对应的应用模板已经存在"),
    APPINSTANCE_EXIT_FAIL("3036", "该名称对应的应用实例已经存在"),
    APPINSTANCE_HOST_EXIT_FAIL("3040", "该域名对应的应用实例已经存在"),
    BUTTON_EXIT_FAIL("3036", "按钮编码已存在！"),
    BUTTON_PATH_EXIT_FAIL("3037", "按钮路径已存在！"),
    MENU_CODE_EXIT_FAIL("3038", "菜单编码已存在！"),
    MENU_PATH_EXIT_FAIL("3039", "菜单路径已存在！"),

    OPENID_NON_EXIST_FAIL("3040", "openId不存在！"),

    ROLE_ID_INPUT_EMPTY("3041", "绑定的角色ID不能为空！"),
    DEVICE_FIND_FAIL("3043", "通过该用户id查询不到设备信息"),
    APPLICATION_DISABLED("3044", "应用ID已经被禁用"),
    CUSTOMER_EXIT_FAIL("3045", "客户已存在！"),
    CUSTOMER_NON_EXIT_FAIL("3046", "客户信息不存在！"),
    REFERENCED_BY_USER_ERROR("3047", "操作失败,无法删除已被用户引用的角色"),
    REFERENCED_BY_USER_GROUP_ERROR("3048", "操作失败，无法删除已被用户组引用的角色"),
    USER_NOT_BELONG_TO_GROUP("3049", "用户暂未属于任一用户组"),
    USER_GROUP_DATA_EXCEPTION("3050", "用户组数据异常，用户组的父用户组不能是自己"),
    INVALID_APP_KEY("3051", "Application-Key无效或已过期"),
    EMPTY_PHONE_USERID("3052", "参数错误，phone和userId必须提供一个，不能同时为空"),
    EMPTY_TENANT_ID("3053", "租户id不能为空"),
    EMPTY_INSTANCE_ID("3054", "实例id不能为空"),
    EMPTY_THIRDPARTYTYPE("3055", "第三方登录类型不能为空"),
    EMPLOYEE_NO_EXIST_FAIL("3056", "员工编号已存在"),
    MENU_APPID_FAIL("3057", "通过实例id查询不到菜单信息"),
    ROLE_TEMPLATE_EXIT_FAIL("3058", "角色模板已存在"),
    CACHE_EXIST_FAIL("3059", "获得锁失败"),
    ORG_CODE_EXIST("3060", "组织编号已存在"),

    USER_APP_INSTANCE_FAIL("3061", "操作失败，请先给用户授权应用的访问权限"),

    APP_INSTANCE_DOMAIN_EXIST("3061", "应用默认账号域不合法"),
    INVALID_USER("3062", "用户组只能添加用户的用户域在对应应用可用的用户域内的用户"),
    INVALID_USER_DOMAIN("3062", "参数账号域不合法"),
    ROLE_MSG_DISABLE_MODIFY("3063", "当前角色信息不允许修改或删除"),


    RESOURCE_TYPE_INVALID("3080", "资源类型不正确"),
    APP_ID_ILLEGAL("3081", "appid不合法"),
    APP_SECRET_ILLEGAL("3082","app_secret不合法"),

    INSTANCEID_NOTEXIST_FAIL("11013", "实例ID不存在"),
    VERIFYCODE_OVERTIME_FAIL("11011", "验证码已过期"),
    VERIFYCODE_ERROR_FAIL("11012", "验证码不正确"),
    USER_NOTEXIST_FAIL("11014", "用户不存在"),

    REQ_PARAM_ERROR("4001", "请求参数错误"),

    TOO_MATCH_REF("5001", "对应数据过多,一般期待只有一个数据"),

    RESOURCE_IMPORT_ERROR("6001", "部分资源或页面元素已存在或数据不符合要求");

    private final String code;
    private final String msg;

    UserExceptionCode(String val, String info) {
        this.code = val;
        this.msg = info;

    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getMsg() {
        return msg;

    }
}
