package com.dtyunxi.yundt.cube.center.user.api.query;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AbacAttrQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.AbacAttrApplicationRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.AbacAttrRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.AbacRoleAttrRespDto;
import com.github.pagehelper.PageInfo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

/**
 * ABAC模型配置服务接口
 *
 * @author ganguo
 */
@Api(tags = {"用户中心：ABAC模型配置查询服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-user-api-IAbacAttrQueryApi",
        name = "${dtyunxi.yundt.cube_organization-center-user_api.name:organization-center-user}",
        url = "${dtyunxi.yundt.cube_organization-center-user_api:}",
        path = "/v1/abac-attr"
)
public interface IAbacAttrQueryApi {

    /**
     * 根据角色id,获取角色关联的属性和属性值
     *
     */
//    @GetMapping("/app/{appId}/role/{roleId}")
//    @ApiOperation(value = "根据角色id,获取角色关联的属性和属性值", notes = "根据角色id,获取角色关联的属性和属性值")
//    @Capability(capabilityCode = "user.abac.role-attr")
//    RestResponse<AbacRoleAttrRespDto> listRoleAttrByRoleId(@PathVariable("roleId") Long roleId, @PathVariable("appId") Long appId) ;

    @GetMapping("/app/{instanceId}")
    @ApiOperation(value = "查询应用关联的属性", notes = "查询应用关联的属性")
    @Capability(capabilityCode = "user.abac.app-attr")
    RestResponse<List<AbacAttrRespDto>> listAttrByInstanceId(@PathVariable("instanceId")Long instanceId);



    @GetMapping("/page")
    @ApiOperation(value = "根据角色id,获取角色关联的属性和属性值", notes = "根据角色id,获取角色关联的属性和属性值")
    @Capability(capabilityCode = "user.abac.page-attr")
    RestResponse<PageInfo<AbacRoleAttrRespDto>> pageRoleAttrByRoleId(@SpringQueryMap AbacAttrQueryReqDto query);

    @GetMapping("/all")
    @ApiOperation(value = "查询所有abac模型属性项列表", notes = "查询所有abac模型属性项列表")
    @Capability(capabilityCode = "user.abac.list-all")
    RestResponse<List<AbacAttrRespDto>> listAll();
    
    @GetMapping("/{id}")
    @ApiOperation(value = "通过id查询abac模型属性项详情", notes = "通过id查询abac模型属性项详情")
    @Capability(capabilityCode = "user.abac.query-by-id")
    RestResponse<AbacAttrRespDto> queryById(@PathVariable("id") Long id);
    
    @GetMapping("/attr-app/page-by-filter")
    @ApiOperation(value = "通过filter参数分页查询属性项与应用模板关联关系", notes = "通过filter参数分页查询属性项与应用模板关联关系")
    @ApiImplicitParams({
        @ApiImplicitParam(name = "filter", value = "查询条件", dataType = "String", paramType = "query", required = true),
        @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "Integer", paramType = "query", required = true),
        @ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "Integer", paramType = "query", required = true)})
    @Capability(capabilityCode = "user.abac.attr-app-page-by-filter")
	RestResponse<PageInfo<AbacAttrApplicationRespDto>> pageAttrAppByFilter(@RequestParam("filter") String filter,
			@RequestParam("pageSize") Integer pageSize, @RequestParam("pageNum") Integer pageNum);
    
    @GetMapping("/attr-app/{id}")
    @ApiOperation(value = "通过id查询属性项与应用关联关系详情", notes = "通过id查询属性项与应用关联关系详情")
    @ApiImplicitParams({
        @ApiImplicitParam(name = "id", value = "属性项与应用关联关系id", dataType = "String", paramType = "path", required = true)})
    @Capability(capabilityCode = "user.abac.attr-app-query-by-id")
	RestResponse<AbacAttrApplicationRespDto> queryAttrAppById(@PathVariable("id") Long id);
}
