/**
 * @(#) IPersonalInfoQueryApi.java 1.0 2019/1/18
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.ApplicationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;

import java.util.List;

/**
 * 应用服务
 * create By qiudao on 2019/6/20
 */
@Api(tags = {"用户中心：应用服务拓展"})
@FeignClient(
        contextId="com-dtyunxi-yundt-cube-center-user-api-query-IBizApplicationQueryApi",
        path = "/v1/application",
        name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}",
        url = "${dtyunxi.yundt.cube_base-center-user_api:}"
)
public interface IBizApplicationQueryApi {

    /**
     * 查询应用列表
     * @return
     */
    @GetMapping(value = {"/allList"}, produces = "application/json")
    @ApiOperation(value = "查询应用列表", notes = "查询应用列表")
    @Capability(capabilityCode = "user.biz-application.query-list")
    RestResponse<List<ApplicationDto>> queryList();

}
