/**
 * @(#) IPersonalInfoQueryApi.java 1.0 2019/1/18
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.ButtonDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.MenuDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * 资源服务
 * create By qiudao on 2019/6/20
 */
@Api(tags = {"用户中心：资源信息拓展查询"})
@FeignClient(
        contextId="com-dtyunxi-yundt-cube-center-user-api-query-IBizResourceQueryApi",
        path = "/v1/resource",
        name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}",
        url = "${dtyunxi.yundt.cube_base-center-user_api:}"
)
public interface IBizResourceQueryApi {

    /**
     * 根据编号查询菜单信息
     * @param code 菜单编号
     * @return
     */
    @GetMapping(value = {"/menu/code/{code}"}, produces = "application/json")
    @ApiOperation(value = "根据编号查询菜单信息", notes = "根据编号查询菜单信息")
    @Capability(capabilityCode = "user.biz-resource.query-menu-by-code")
    RestResponse<List<MenuDto>> queryMenuByCode(@PathVariable("code") String code);

    /**
     * 根据ID查询菜单信息
     * @param id Id
     * @return
     */
    @GetMapping(value = {"/menu/{id}"}, produces = "application/json")
    @ApiOperation(value = "根据ID查询菜单信息", notes = "根据ID查询菜单信息")
    @Capability(capabilityCode = "user.biz-resource.query-menu-by-id")
    RestResponse<MenuDto> queryMenuById(@PathVariable("id") Long id);

    /**
     * 根据子菜单信息
     * @param parentCode parentCode
     * @return
     */
    @GetMapping(value = {"/menu/parent/{parentCode}"}, produces = "application/json")
    @ApiOperation(value = "根据子菜单信息", notes = "根据子菜单信息")
    @Capability(capabilityCode = "user.biz-resource.query-menu-by-parent-code")
    RestResponse<List<MenuDto>> queryMenuByParentCode(@PathVariable("parentCode") String parentCode);

    /**
     * 根据编号查询按钮信息
     * @param code 按钮编号
     * @return
     */
    @RequestMapping(value = {"/button/{code}"}, produces = "application/json", method = RequestMethod.GET)
    @ApiOperation(value = "根据编号查询按钮信息", notes = "根据编号查询按钮信息")
    @Capability(capabilityCode = "user.biz-resource.query-button-by-code")
    RestResponse<List<ButtonDto>> queryButtonByCode(@PathVariable("code") String code);

}
