/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.apiimpl;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.AppInstanceInitDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.AppRebindButtonsDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.AppRebindMenusDto;
import com.dtyunxi.yundt.cube.center.user.api.IApplicationApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppPurchaseDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppRegisterDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ButtonDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.MenuDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AppInstanceCreateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AppInstanceMenuIncrDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.SortReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.AppRegisterVo;
import com.dtyunxi.yundt.cube.center.user.biz.service.IApplicationService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="iApplicationApi")
public class ApplicationApiImpl
implements IApplicationApi {
    @Autowired
    private IApplicationService applicationService;

    public RestResponse<AppRegisterVo> register(AppRegisterDto dto) {
        AppRegisterVo appRegisterVo = this.applicationService.register(dto);
        return new RestResponse((Object)appRegisterVo);
    }

    public RestResponse<Void> modifyApp(Long appId, AppRegisterDto appRegisterDto) {
        appRegisterDto.setId(appId);
        this.applicationService.modifyApp(appRegisterDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeApp(List<Long> appIds) {
        this.applicationService.removeApp(appIds);
        return RestResponse.VOID;
    }

    public RestResponse<Long> addAppInstance(AppInstanceCreateReqDto reqDto) {
        return new RestResponse((Object)this.applicationService.addAppInstance(reqDto));
    }

    public RestResponse<Void> initAppInstance(Long instanceId, List<String> menuCodes, List<String> buttonCodes, Boolean updateOld, Boolean deleteOld) {
        this.applicationService.initAppInstance(instanceId, menuCodes, buttonCodes, updateOld, deleteOld);
        return new RestResponse();
    }

    public RestResponse<Void> reInitAppInstance(AppInstanceInitDto appInstanceInitDto) {
        this.applicationService.initAppInstance(appInstanceInitDto.getInstanceId(), appInstanceInitDto.getMenuCodes(), appInstanceInitDto.getButtonCodes(), appInstanceInitDto.getUpdateOld(), appInstanceInitDto.getDeleteOld());
        return new RestResponse();
    }

    public RestResponse<Void> incrementalAppInstanceResources(AppInstanceMenuIncrDto appInstanceMenuIncrDto) {
        this.applicationService.incrementalAppInstanceResources(appInstanceMenuIncrDto);
        return RestResponse.VOID;
    }

    public RestResponse<Long> modifyAppInsInfo(Long instanceId, AppPurchaseDto applicationDto) {
        applicationDto.setInstanceId(instanceId);
        this.applicationService.modifyAppInstanceAndRemoveCache(applicationDto);
        return new RestResponse();
    }

    public RestResponse<Void> removeAppIns(Long instanceId) {
        this.applicationService.removeAppIns(instanceId);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeInstanceMenuButton(Long instanceId, List<String> menuCodes, List<String> buttonCodes) {
        this.applicationService.removeInstanceMenuButton(instanceId, menuCodes, buttonCodes);
        return RestResponse.VOID;
    }

    public RestResponse<Void> updateInstanceMenuButtonParent(Long instanceId, String parentCode, List<String> menuCodes, List<String> buttonCodes) {
        this.applicationService.updateInstanceMenuButtonParent(instanceId, parentCode, menuCodes, buttonCodes);
        return RestResponse.VOID;
    }

    public RestResponse<Void> updateInstanceButtons(List<ButtonDto> dtos) {
        this.applicationService.updateInstanceButtons(dtos);
        return RestResponse.VOID;
    }

    public RestResponse<Boolean> appBindButton(Long appId, Long menuId, List<ButtonDto> buttonDtos) {
        return new RestResponse((Object)this.applicationService.appBindButton(appId, menuId, buttonDtos));
    }

    public RestResponse<Boolean> appUnBindButton(Long appId, Long menuId, List<Long> buttonIds) {
        return new RestResponse((Object)this.applicationService.appUnBindButton(appId, menuId, buttonIds));
    }

    public RestResponse<Long> appBindMenu(Long appId, MenuDto menuDto) {
        return new RestResponse((Object)this.applicationService.appBindMenu(appId, menuDto));
    }

    public RestResponse<Long> appRebindMenus(String appCode, List<String> menuCodes) {
        this.applicationService.appRebindMenus(appCode, menuCodes);
        return new RestResponse();
    }

    public RestResponse<Long> appRebindMenus(AppRebindMenusDto appRebindMenusDto) {
        this.applicationService.appRebindMenus(appRebindMenusDto.getAppCode(), appRebindMenusDto.getMenuCodes());
        return new RestResponse();
    }

    public RestResponse<Boolean> appRebindMenu(Integer type, String appCode, String menuCode) {
        return new RestResponse((Object)this.applicationService.appRebindResource(type, appCode, menuCode));
    }

    public RestResponse<Long> appRebindButtons(String appCode, String menuCode, List<String> buttonCodes) {
        this.applicationService.appRebindButtons(appCode, menuCode, buttonCodes);
        return new RestResponse();
    }

    public RestResponse<Long> appRebindButtons(AppRebindButtonsDto appRebindButtonsDto) {
        this.applicationService.appRebindButtons(appRebindButtonsDto.getAppCode(), appRebindButtonsDto.getMenuCode(), appRebindButtonsDto.getButtonCodes());
        return new RestResponse();
    }

    public RestResponse<Boolean> appRebindButton(Integer type, String appCode, String buttonCode) {
        return new RestResponse((Object)this.applicationService.appRebindResource(type, appCode, buttonCode));
    }

    public RestResponse<Boolean> modifyAppMenu(Long appId, Long id, MenuDto menuDto) {
        this.applicationService.modifyAppMenu(appId, id, menuDto);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Boolean> appUnBindMenu(Long appId, Long menuId) {
        return new RestResponse((Object)this.applicationService.appUnBindMenu(appId, menuId));
    }

    public RestResponse<Boolean> appInstanceInitializationMenus(Long id) {
        return new RestResponse((Object)this.applicationService.appInstanceInitializeMenus(id));
    }

    public RestResponse<Void> enableMenu(Long menuId, Long appId) {
        this.applicationService.enableMenu(menuId, appId);
        return RestResponse.VOID;
    }

    public RestResponse<Void> disableMenu(Long menuId, Long appId) {
        this.applicationService.disableMenu(menuId, appId);
        return RestResponse.VOID;
    }

    public RestResponse<Void> sortMenu(Long id, SortReqDto sortReqDto) {
        this.applicationService.sortMenu(id, sortReqDto);
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> modify(Long applicationId, Integer status) {
        AppRegisterDto appRegisterDto = new AppRegisterDto();
        appRegisterDto.setId(applicationId);
        appRegisterDto.setStatus(status);
        this.applicationService.modifyApp(appRegisterDto);
        return new RestResponse();
    }

    public RestResponse<Long> modifyAppIns(Long instanceId, Integer status) {
        AppPurchaseDto appPurchaseDto = new AppPurchaseDto();
        appPurchaseDto.setInstanceId(instanceId);
        appPurchaseDto.setStatus(status);
        this.applicationService.modifyAppInstanceAndRemoveCache(appPurchaseDto);
        return new RestResponse();
    }

    public RestResponse<Long> createAppInstance(AppInstanceCreateReqDto reqDto) {
        return new RestResponse((Object)this.applicationService.createAppInstance(reqDto));
    }

    public RestResponse<String> regenerateAppSecret(Long instanceId) {
        return new RestResponse((Object)this.applicationService.regenerateAppSecret(instanceId));
    }
}

