/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.ButtonDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RegisterChannelDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserGroupDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ResourceBaseDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ResourceValidateDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.MenuQueryResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.ResourceQueryResDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IResourceQueryApi;
import com.dtyunxi.yundt.cube.center.user.biz.service.IRegisterChannelService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IResourceService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserGroupService;
import com.dtyunxi.yundt.cube.center.user.biz.util.QueryUtil;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="iResourceQueryApi")
public class ResourceQueryApiImpl
implements IResourceQueryApi {
    @Autowired
    private IRegisterChannelService registerChannelService;
    @Autowired
    private IUserGroupService userGroupService;
    @Resource
    private IResourceService resourceService;

    public RestResponse<ResourceQueryResDto> queryResourceByCode(String code, List<String> res, ResourceBaseDto resourceDto) {
        return new RestResponse((Object)this.resourceService.queryResourceByCode(code, res, resourceDto));
    }

    public RestResponse<MenuQueryResDto> queryMenuByInstanceIdAndCode(Long instanceId, String code) {
        return new RestResponse((Object)this.resourceService.queryMenuByInstanceIdAndCode(instanceId, code));
    }

    public RestResponse<List<ResourceQueryResDto>> queryResourceParentsByCode(String code) {
        return new RestResponse(this.resourceService.queryResourceParentsByCode(code));
    }

    public RestResponse<PageInfo<ResourceQueryResDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.resourceService.queryByPage(filter, pageNum, pageSize));
    }

    public RestResponse<Boolean> checkResourceExist(ResourceValidateDto resourceValidateDto) {
        return new RestResponse((Object)this.resourceService.checkResourceExist(resourceValidateDto));
    }

    public RestResponse<RegisterChannelDto> queryChannelById(Long id, String filter) {
        return new RestResponse((Object)this.registerChannelService.queryByChannelId(id));
    }

    public RestResponse<List<RegisterChannelDto>> queryChannelsByApplicationKey(Long instanceId) {
        return new RestResponse(this.registerChannelService.queryChannelList(instanceId));
    }

    public RestResponse<PageInfo<RegisterChannelDto>> queryChannelByExample(String example, String filter, Integer pageNum, Integer pageSize, String sortStr) {
        filter = QueryUtil.mergeFilter(example, filter);
        return new RestResponse(this.registerChannelService.queryChannelByExample(filter, pageNum, pageSize));
    }

    public RestResponse<UserGroupDto> queryUserGroupByApplicationKey(Long instanceId) {
        return new RestResponse((Object)this.userGroupService.queryOne(instanceId));
    }

    public RestResponse<List<ButtonDto>> queryButtonsByMenuId(Long menuId, String filter) {
        ButtonDto buttonDto;
        try {
            buttonDto = (ButtonDto)JSON.parseObject((String)filter, ButtonDto.class);
        }
        catch (Exception e) {
            throw new BusinessRuntimeException("\u89e3\u6790filter\u51fa\u9519");
        }
        List<ButtonDto> buttonDtos = this.resourceService.findButtonByInstanceIdAndMenuId(buttonDto.getInstanceId(), menuId);
        return new RestResponse(buttonDtos);
    }
}

