/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.mq;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.notifier.config.NotifierFeignClientConfig;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.cube.starter.bundle.api.IChartHurdleApi;
import com.dtyunxi.cube.starter.bundle.config.FeignClientConfig;
import com.dtyunxi.cube.starter.bundle.dto.BundleDescDto;
import com.dtyunxi.cube.starter.bundle.dto.ChartDto;
import com.dtyunxi.cube.starter.bundle.dto.HurdleDto;
import com.dtyunxi.cube.starter.bundle.dto.HurdleInfoDto;
import com.dtyunxi.cube.starter.bundle.dto.response.ChartAndHurdleRespDto;
import com.dtyunxi.cube.starter.bundle.rest.FeignClientApiCaller;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.user.dao.das.ChartDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.HurdleDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.HurdleInfoDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.ChartEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.HurdleEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.HurdleInfoEo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="${boc.chart.hurdle.topic:SINGLE_TOPIC}", tag="${boc.chart.hurdle.topic:BOC_CHART_HURDLE_TAG}")
public class BocChartHurdleMqProcess
implements IMessageProcessor<BundleDescDto<ChartAndHurdleRespDto>> {
    private static Logger logger = LoggerFactory.getLogger(BocChartHurdleMqProcess.class);
    @Value(value="${app.started.lock.wait.timeout:310}")
    private int waitTimeout;
    @Value(value="${app.started.lock.lease.time:300}")
    private int leaseTime;
    @Autowired
    private FeignClientConfig feignClientConfig;
    @Autowired
    private ChartDas chartDas;
    @Autowired
    private HurdleDas hurdleDas;
    @Autowired
    private HurdleInfoDas hurdleInfoDas;
    @Autowired
    private ILockService lockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(BundleDescDto<ChartAndHurdleRespDto> message) {
        MessageResponse messageResponse;
        Mutex mutex;
        block5: {
            logger.info("\u5f00\u59cb\u5904\u7406\u5e94\u7528\u542f\u52a8MQ\u901a\u77e5\u6d88\u606f\uff0cmessage={}", (Object)JSON.toJSONString(message));
            mutex = null;
            Long startedRecordId = this.getId();
            mutex = this.lockService.lock("${dtyunxi.bundle.mq.bundle_description.tag:BUNDLE_DESCRIPTION_TAG}", message.getServiceId(), this.waitTimeout, this.leaseTime, TimeUnit.SECONDS);
            if (null == mutex) break block5;
            this.dealMessage(startedRecordId, message);
            logger.info("\u5e94\u7528\u542f\u52a8MQ\u901a\u77e5\u6d88\u606f\u5904\u7406\u5b8c\u6bd5");
            MessageResponse messageResponse2 = MessageResponse.SUCCESS;
            this.lockService.unlock(mutex);
            return messageResponse2;
        }
        try {
            logger.error("\u5e94\u7528\u542f\u52a8MQ\u901a\u77e5\u6d88\u606f\uff0cserviceId={}\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25", (Object)message.getServiceId());
            messageResponse = MessageResponse.ERROR;
        }
        catch (Exception e) {
            MessageResponse messageResponse3;
            try {
                logger.error("\u5e94\u7528\u542f\u52a8MQ\u901a\u77e5\u6d88\u606f\u5904\u7406\u5931\u8d25", (Throwable)e);
                messageResponse3 = MessageResponse.ERROR;
            }
            catch (Throwable throwable) {
                this.lockService.unlock(mutex);
                throw throwable;
            }
            this.lockService.unlock(mutex);
            return messageResponse3;
        }
        this.lockService.unlock(mutex);
        return messageResponse;
    }

    protected void dealMessage(Long startedRecordId, BundleDescDto<ChartAndHurdleRespDto> message) {
        if (message.getContent() == null) {
            FeignClientApiCaller feignClientApiCaller = new FeignClientApiCaller();
            if (message.getIp().indexOf("/") != -1) {
                message.setIp(message.getIp().split("/")[1]);
            }
            RestResponse restResponse = (RestResponse)feignClientApiCaller.process(o -> o.loadChartsAndHurdles(), message.getIp(), message.getPort(), IChartHurdleApi.class, (NotifierFeignClientConfig)this.feignClientConfig);
            logger.info("\u5e94\u7528\u529f\u80fd\u5305\u7269\u6599\u5df2\u62c9\u53d6");
            this.save((ChartAndHurdleRespDto)restResponse.getData());
        } else {
            this.save((ChartAndHurdleRespDto)message.getContent());
        }
    }

    public Long getId() {
        return IdGenrator.getDistributedId();
    }

    private void save(ChartAndHurdleRespDto chartAndHurdleRespDto) {
        if (chartAndHurdleRespDto == null) {
            return;
        }
        this.saveCharts(chartAndHurdleRespDto.getChartDtoList());
        this.saveHurdles(chartAndHurdleRespDto.getHurdleDtoList());
    }

    private void saveCharts(List<ChartDto> chartDtoList) {
        if (chartDtoList == null || chartDtoList.isEmpty()) {
            return;
        }
        for (ChartDto chartDto : chartDtoList) {
            ChartEo chartEo = this.chartDas.queryByCode(chartDto.getCode());
            if (chartEo == null) {
                chartEo = new ChartEo();
                BeanUtils.copyProperties((Object)chartDto, (Object)chartEo);
                this.chartDas.insert((BaseEo)chartEo);
                continue;
            }
            BeanUtils.copyProperties((Object)chartDto, (Object)chartEo);
            this.chartDas.update((BaseEo)chartEo);
        }
    }

    private void saveHurdles(List<HurdleDto> hurdleDtos) {
        if (hurdleDtos == null || hurdleDtos.isEmpty()) {
            return;
        }
        for (HurdleDto hurdleDto : hurdleDtos) {
            HurdleEo hurdleEo = this.hurdleDas.queryByCode(hurdleDto.getCode());
            if (hurdleEo == null) {
                hurdleEo = new HurdleEo();
                BeanUtils.copyProperties((Object)hurdleDto, (Object)hurdleEo);
                this.hurdleDas.insert((BaseEo)hurdleEo);
            } else {
                BeanUtils.copyProperties((Object)hurdleDto, (Object)hurdleEo);
                this.hurdleDas.update((BaseEo)hurdleEo);
            }
            List hurdleInfoDtoList = hurdleDto.getHurdleInfoDtoList();
            this.hurdleInfoDas.deleteByHurdleCode(hurdleDto.getCode());
            if (hurdleInfoDtoList == null || hurdleInfoDtoList.isEmpty()) continue;
            this.insertHurdleInfo(hurdleInfoDtoList);
        }
    }

    public void insertHurdleInfo(List<HurdleInfoDto> hurdleInfoDtoList) {
        ArrayList<HurdleInfoEo> list = new ArrayList<HurdleInfoEo>(hurdleInfoDtoList.size());
        for (HurdleInfoDto hurdleInfoDto : hurdleInfoDtoList) {
            HurdleInfoEo eo = new HurdleInfoEo();
            BeanUtils.copyProperties((Object)hurdleInfoDto, (Object)eo);
            list.add(eo);
        }
        this.hurdleInfoDas.insertBatch(list);
    }
}

