/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.datalimit.aop.DataLimitAspect;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.constant.ResourceType;
import com.dtyunxi.yundt.cube.center.user.api.dto.AccessBaseDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.AccessDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ButtonDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.MenuDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ResourceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleAccessDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleResourceRemoveReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleUserRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserAccessRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserRoleRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.UserAccessVo;
import com.dtyunxi.yundt.cube.center.user.api.exception.UserExceptionCode;
import com.dtyunxi.yundt.cube.center.user.biz.exception.BizException;
import com.dtyunxi.yundt.cube.center.user.biz.service.IAbacAttrApplicationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IAccessService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IApplicationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IResourceService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.AccessDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.AppInstanceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.AppRenewalInstanceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.ButtonDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.MenuDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.RoleAccessRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.RoleDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserGroupDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserGroupRoleRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserRoleRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AccessEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AppInstanceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.ButtonEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.MenuEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.ResourceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RoleAccessRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RoleEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdButtonEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdMenuEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdRoleAccessRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdUserGroupRoleRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdUserRoleRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserGroupEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserGroupRoleRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserRoleRelationEo;
import com.dtyunxi.yundt.cube.center.user.ext.access.IAfterAddUserRoleExt;
import com.dtyunxi.yundt.cube.center.user.ext.access.IAfterDeleteUserRoleExt;
import com.dtyunxi.yundt.cube.center.user.ext.access.IBeforeAddUserRoleExt;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class AccessServiceImpl
implements IAccessService {
    private static final Logger logger = LoggerFactory.getLogger(AccessServiceImpl.class);
    @Resource
    private RoleDas roleDas;
    @Resource
    private UserDas userDas;
    @Resource
    private AccessDas accessDas;
    @Resource
    private RoleAccessRelationDas roleAccessRelationDas;
    @Resource
    private UserRoleRelationDas userRoleRelationDas;
    @Resource
    private UserGroupRoleRelationDas userGroupRoleRelationDas;
    @Resource
    private UserGroupDas userGroupDas;
    @Resource
    private IResourceService resourceService;
    @Resource
    private IApplicationService applicationService;
    @Resource
    private AppInstanceDas appInstanceDas;
    @Resource
    private AppRenewalInstanceDas appRenewalInstanceDas;
    @Resource
    private MenuDas menuDas;
    @Resource
    private ButtonDas buttonDas;
    @Resource
    private IContext context;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IBeforeAddUserRoleExt beforeAddUserRoleExt;
    @Resource
    private IAfterAddUserRoleExt afterAddUserRoleExt;
    @Resource
    private IAfterDeleteUserRoleExt afterDeleteUserRoleExt;
    @Resource
    private IAbacAttrApplicationService abacAttrApplicationService;
    @Value(value="${request.user.id.source.ctrl:0}")
    private Integer userIdSourceCtrl;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void giveRoleResource(Long instanceId, List<RoleAccessDto> roleAccessList) {
        if (CollectionUtil.isEmpty(roleAccessList)) {
            return;
        }
        Long tenantId = this.applicationService.queryTenantIdByAppInsId(instanceId);
        Map<Long, RoleEo> roleEoMap = this.getRoleMapByRoleAccess(roleAccessList);
        for (RoleAccessDto roleAccessDto : roleAccessList) {
            Long roleId = roleAccessDto.getRoleId();
            Set accessSet = roleAccessDto.getAccessSet();
            RoleEo roleEo = roleEoMap.get(roleId);
            AssertUtil.isTrue(null != roleEo, "\u89d2\u8272\u4e0d\u5b58\u5728");
            Map<String, AccessEo> accessMap = this.getAccessMap(roleEo);
            for (AccessDto accessDto : accessSet) {
                String key = instanceId + "-" + accessDto.getResourceType() + "-" + accessDto.getResourceCode();
                AccessEo accessEo = accessMap.get(key);
                if (accessEo == null) {
                    accessEo = new AccessEo();
                    DtoHelper.dto2Eo((BaseVo)accessDto, (BaseEo)accessEo);
                    accessEo.setInstanceId(instanceId);
                    accessEo.setTenantId(tenantId);
                    this.complementResourceCode(accessDto, accessEo);
                    this.accessDas.insert((BaseEo)accessEo);
                    RoleAccessRelationEo roleAccessRelationEo = new RoleAccessRelationEo();
                    roleAccessRelationEo.setRoleId(roleId);
                    roleAccessRelationEo.setAccessId(accessEo.getId());
                    roleAccessRelationEo.setInstanceId(instanceId);
                    roleAccessRelationEo.setTenantId(tenantId);
                    this.roleAccessRelationDas.insert((BaseEo)roleAccessRelationEo);
                    continue;
                }
                this.accessDas.update((BaseEo)accessEo);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateRoleResources(Long instanceId, List<RoleAccessDto> roleAccessList) {
        if (CollectionUtil.isEmpty(roleAccessList)) {
            return;
        }
        Long tenantId = this.applicationService.queryTenantIdByAppInsId(instanceId);
        for (RoleAccessDto roleAccessDto : roleAccessList) {
            Long roleId = roleAccessDto.getRoleId();
            RoleEo roleEo = (RoleEo)this.roleDas.selectByPrimaryKey(roleId);
            AssertUtil.isTrue(null != roleEo, "\u89d2\u8272\u4e0d\u5b58\u5728");
            this.accessDas.logicDeleteByRoleId(roleId);
            this.deleteRoleAccessRelation(roleId);
            ArrayList roleAccessRelationEoList = Lists.newArrayList();
            for (AccessDto accessDto : roleAccessDto.getAccessSet()) {
                AccessEo accessEo = new AccessEo();
                DtoHelper.dto2Eo((BaseVo)accessDto, (BaseEo)accessEo);
                accessEo.setInstanceId(instanceId);
                accessEo.setTenantId(tenantId);
                this.complementResourceCode(accessDto, accessEo);
                this.accessDas.insert((BaseEo)accessEo);
                RoleAccessRelationEo roleAccessRelationEo = new RoleAccessRelationEo();
                roleAccessRelationEo.setRoleId(roleId);
                roleAccessRelationEo.setAccessId(accessEo.getId());
                roleAccessRelationEo.setRoleCode(roleAccessDto.getCode());
                roleAccessRelationEo.setAccessCode(accessDto.getCode());
                roleAccessRelationEo.setTenantId(tenantId);
                roleAccessRelationEo.setInstanceId(instanceId);
                if (roleAccessRelationEo.getExtension() == null) {
                    roleAccessRelationEo.setExtension("");
                }
                roleAccessRelationEoList.add(roleAccessRelationEo);
            }
            this.roleAccessRelationDas.insertBatch((List)roleAccessRelationEoList);
        }
    }

    private void complementResourceCode(AccessDto accessDto, AccessEo accessEo) {
        Integer resourceType = accessDto.getResourceType();
        if (accessEo.getResourceCode() == null && accessDto.getResourceId() != null && resourceType != null) {
            if (ResourceType.MENU.equals(resourceType)) {
                MenuEo tmp = (MenuEo)this.menuDas.selectByPrimaryKey(accessDto.getResourceId());
                if (tmp == null) {
                    throw new BizException(UserExceptionCode.MENU_NOTEXIT_FAIL.getCode(), UserExceptionCode.MENU_NOTEXIT_FAIL.getMsg());
                }
                accessEo.setResourceCode(tmp.getCode());
            } else if (ResourceType.BUTTON.equals(resourceType)) {
                ButtonEo tmp = (ButtonEo)this.buttonDas.selectByPrimaryKey(accessDto.getResourceId());
                if (tmp == null) {
                    throw new BizException(UserExceptionCode.BUTTON_IDCHECK_FAIL.getCode(), UserExceptionCode.BUTTON_IDCHECK_FAIL.getMsg());
                }
                accessEo.setResourceCode(tmp.getCode());
            } else {
                throw new BizException(UserExceptionCode.RESOURCE_TYPE_INVALID.getCode(), UserExceptionCode.RESOURCE_TYPE_INVALID.getMsg());
            }
        }
    }

    private MenuDto complementMenuDto(MenuDto dto, Map<String, Long> parentMap) {
        if ("-1".equals(dto.getParentCode())) {
            dto.setParentId(ResourceEo.ROOT_PARENT_ID);
        } else {
            Long parentId = parentMap.get(dto.getParentCode());
            if (parentId != null) {
                dto.setParentId(parentId);
            }
        }
        return dto;
    }

    private ButtonDto complementButtonDto(ButtonDto dto, Map<String, Long> buttonIdCodeMap) {
        if ("-1".equals(dto.getParentCode())) {
            dto.setMenuId(ResourceEo.ROOT_PARENT_ID);
        } else {
            Long menuId = buttonIdCodeMap.get(dto.getParentCode());
            if (menuId != null) {
                dto.setMenuId(menuId);
            }
        }
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateRoleResources(Long roleId, Set<AccessDto> accessDtos) {
        RoleEo roleEo = this.roleDas.findByIdOrElseThrow(roleId);
        RoleAccessDto roleAccessDto = new RoleAccessDto();
        roleAccessDto.setRoleId(roleId);
        roleAccessDto.setCode(roleEo.getCode());
        roleAccessDto.setAccessSet(accessDtos);
        roleAccessDto.setInstanceId(roleEo.getInstanceId());
        this.updateRoleResources(roleEo.getInstanceId(), Lists.newArrayList((Object[])new RoleAccessDto[]{roleAccessDto}));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRoleResourcesRelation(List<RoleResourceRemoveReqDto> roleResourceRemoveReqDtos) {
        for (RoleResourceRemoveReqDto roleResourceRemoveReqDto : roleResourceRemoveReqDtos) {
            if (StringUtils.isBlank((CharSequence)roleResourceRemoveReqDto.getRoleCode()) && roleResourceRemoveReqDto.getRoleId() == null) {
                throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), UserExceptionCode.REQ_PARAM_ERROR.getMsg());
            }
            if (StringUtils.isNotBlank((CharSequence)roleResourceRemoveReqDto.getRoleCode())) {
                RoleEo roleEo = new RoleEo();
                roleEo.setCode(roleResourceRemoveReqDto.getRoleCode());
                if (this.roleDas.count((BaseEo)roleEo) < 0) {
                    throw new BizException(UserExceptionCode.NON_EXIST_FAIL.getCode(), UserExceptionCode.NON_EXIST_FAIL.getMsg());
                }
            } else if (roleResourceRemoveReqDto.getRoleId() != null && this.roleDas.selectByPrimaryKey(roleResourceRemoveReqDto.getRoleId()) == null) {
                throw new BizException(UserExceptionCode.NON_EXIST_FAIL.getCode(), UserExceptionCode.NON_EXIST_FAIL.getMsg());
            }
            if (CollectionUtils.isEmpty((Collection)roleResourceRemoveReqDto.getAccessBaseDtos())) {
                RoleAccessRelationEo roleAccessRelationEo = new RoleAccessRelationEo();
                roleAccessRelationEo.setRoleCode(roleResourceRemoveReqDto.getRoleCode());
                roleAccessRelationEo.setId(roleResourceRemoveReqDto.getRoleId());
                List roleAccessRelationEos = this.roleAccessRelationDas.select((BaseEo)roleAccessRelationEo);
                if (!CollectionUtils.isNotEmpty((Collection)roleAccessRelationEos)) continue;
                Set accessCodes = roleAccessRelationEos.stream().map(StdRoleAccessRelationEo::getAccessCode).collect(Collectors.toSet());
                for (String accessCode : accessCodes) {
                    AccessEo accessEo = new AccessEo();
                    accessEo.setCode(accessCode);
                    this.accessDas.logicDelete((BaseEo)accessEo);
                }
                for (RoleAccessRelationEo eo : roleAccessRelationEos) {
                    this.roleAccessRelationDas.logicDelete((BaseEo)eo);
                }
                continue;
            }
            List accessBaseDtos = roleResourceRemoveReqDto.getAccessBaseDtos();
            for (AccessBaseDto accessBaseDto : accessBaseDtos) {
                AccessEo accessEo = new AccessEo();
                accessEo.setId(accessBaseDto.getAccessId());
                accessEo.setCode(accessBaseDto.getAccessCode());
                this.accessDas.logicDelete((BaseEo)accessEo);
                RoleAccessRelationEo roleAccessRelationEo = new RoleAccessRelationEo();
                roleAccessRelationEo.setRoleId(roleResourceRemoveReqDto.getRoleId());
                roleAccessRelationEo.setAccessId(accessBaseDto.getAccessId());
                roleAccessRelationEo.setAccessCode(accessBaseDto.getAccessCode());
                roleAccessRelationEo.setRoleCode(roleResourceRemoveReqDto.getRoleCode());
                this.roleAccessRelationDas.logicDelete((BaseEo)roleAccessRelationEo);
            }
        }
    }

    private void deleteRoleAccessRelation(Long roleId) {
        RoleAccessRelationEo roleAccessRelationEo = new RoleAccessRelationEo();
        roleAccessRelationEo.setRoleId(roleId);
        this.roleAccessRelationDas.logicDelete((BaseEo)roleAccessRelationEo);
    }

    @Override
    public void removeRoleResources(Long instanceId, List<RoleAccessDto> roleAccessList) {
        Long tenantId = this.applicationService.queryTenantIdByAppInsId(instanceId);
        Map<Long, RoleEo> roleEoMap = this.getRoleMapByRoleAccess(roleAccessList);
        for (RoleAccessDto roleAccessDto : roleAccessList) {
            Long roleId = roleAccessDto.getRoleId();
            Set accessDelSet = roleAccessDto.getAccessSet();
            RoleEo roleEo = roleEoMap.get(roleId);
            AssertUtil.isTrue(null != roleEo, "\u89d2\u8272\u4e0d\u5b58\u5728");
            AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)accessDelSet), "\u6743\u9650\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            Map<String, AccessEo> accessMap = this.getAccessMap(roleEo);
            for (AccessDto accessDto : accessDelSet) {
                String key = instanceId + "-" + accessDto.getResourceType() + "-" + accessDto.getResourceId();
                AccessEo mAccessEo = accessMap.get(key);
                if (mAccessEo == null) continue;
                AssertUtil.isTrue(accessDto.getPermissions() != null && mAccessEo.getPermissions() != null, "permissions \u4e0d\u80fd\u4e3anull");
                mAccessEo.setPermissions(Integer.valueOf(~accessDto.getPermissions().intValue() & mAccessEo.getPermissions()));
                mAccessEo.setTenantId(tenantId);
                this.accessDas.update((BaseEo)mAccessEo);
            }
            roleEo.setTenantId(tenantId);
            this.roleDas.update((BaseEo)roleEo);
        }
    }

    private Map<Long, RoleEo> getRoleMapByRoleAccess(List<RoleAccessDto> roleAccessList) {
        HashMap roleMap = Maps.newHashMap();
        HashSet roleIdSet = Sets.newHashSet();
        for (RoleAccessDto roleAccessDto : roleAccessList) {
            roleIdSet.add(roleAccessDto.getRoleId());
        }
        List roleList = this.roleDas.queryByIds((Set)roleIdSet);
        for (RoleEo roleEo : roleList) {
            roleMap.put(roleEo.getId(), roleEo);
        }
        return roleMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void giveUserRole(Long instanceId, Long userId, List<Long> roleIdList) {
        Long tenantId = this.applicationService.queryTenantIdByAppInsId(instanceId);
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(null != userEo, "\u7528\u6237\u4e0d\u5b58\u5728");
        Map<Long, RoleEo> roleMap = this.getAppInsRoleMap(instanceId);
        if (roleMap.isEmpty()) {
            logger.info("\u5e94\u7528\u5b9e\u4f8bKey[{}] \u7684\u89d2\u8272\u4e0d\u5b58\u5728", (Object)instanceId);
            return;
        }
        this.beforeAddUserRoleExtHandle(instanceId, userId);
        for (Long roleId : roleIdList) {
            RoleEo roleEo = roleMap.get(roleId);
            AssertUtil.isTrue(null != roleEo, "\u89d2\u8272ID[" + roleId + "]\u4e0d\u5b58\u5728");
            if (this.isExistsRelation(userId, roleId)) continue;
            UserRoleRelationEo userRoleRelationEo = new UserRoleRelationEo();
            userRoleRelationEo.setUserId(userId);
            userRoleRelationEo.setRoleId(roleId);
            userRoleRelationEo.setRoleCode(roleEo.getCode());
            userRoleRelationEo.setTenantId(tenantId);
            userRoleRelationEo.setInstanceId(instanceId);
            this.userRoleRelationDas.insert((BaseEo)userRoleRelationEo);
        }
        this.afterAddUserRoleExtHandle(instanceId, userId);
    }

    @Override
    public void afterAddUserRoleExtHandle(Long instanceId, Long userId) {
        UserRoleRelationEo eo = this.getUserRoleRelationEo(instanceId, userId);
        this.cacheService.delCache("AccessServiceImpl:queryUserRoleByUserId:" + userId);
        this.afterAddUserRoleExt.execute((Object)eo);
    }

    private UserRoleRelationEo getUserRoleRelationEo(Long instanceId, Long userId) {
        UserRoleRelationEo eo = new UserRoleRelationEo();
        eo.setInstanceId(instanceId);
        eo.setUserId(userId);
        return eo;
    }

    @Override
    public void beforeAddUserRoleExtHandle(Long instanceId, Long userId) {
        UserRoleRelationEo eo = this.getUserRoleRelationEo(instanceId, userId);
        this.beforeAddUserRoleExt.execute((Object)eo);
    }

    private boolean isExistsRelation(Long userId, Long roleId) {
        UserRoleRelationEo userRoleRelationEo = new UserRoleRelationEo();
        userRoleRelationEo.setUserId(userId);
        userRoleRelationEo.setRoleId(roleId);
        return this.userRoleRelationDas.count((BaseEo)userRoleRelationEo) > 0;
    }

    @Override
    public void deleteUserRoleRelation(Long userId, Long instanceId) {
        List operableIds = this.roleDas.findOperableIds(userId, instanceId);
        if (CollectionUtils.isEmpty((Collection)operableIds)) {
            return;
        }
        SqlFilter filter = SqlFilter.in((String)"role_id", (Object)operableIds);
        UserRoleRelationEo userRoleRelationEo = new UserRoleRelationEo();
        userRoleRelationEo.setSqlFilters(Collections.singletonList(filter));
        userRoleRelationEo.setUserId(userId);
        userRoleRelationEo.setInstanceId(instanceId);
        this.userRoleRelationDas.delete((BaseEo)userRoleRelationEo);
        this.afterDeleteUserRoleExtHandle(instanceId, userId);
    }

    @Override
    public void afterDeleteUserRoleExtHandle(Long instanceId, Long userId) {
        UserRoleRelationEo eo = this.getUserRoleRelationEo(instanceId, userId);
        this.cacheService.delCache("AccessServiceImpl:queryUserRoleByUserId:" + userId);
        this.afterDeleteUserRoleExt.execute((Object)eo);
    }

    private void deleteUserRoleRelation(Long userId) {
        UserRoleRelationEo userRoleRelationEo = new UserRoleRelationEo();
        userRoleRelationEo.setUserId(userId);
        this.userRoleRelationDas.delete((BaseEo)userRoleRelationEo);
        this.userRoleRelationDas.select((BaseEo)userRoleRelationEo, Integer.valueOf(1), Integer.valueOf(5000)).stream().map(BaseEo::getInstanceId).distinct().forEach(instanceId -> this.cacheService.delCache("AccessServiceImpl:queryUserRoleByUserId:" + userId));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addUserRoles(Long instanceId, Long userId, List<Long> roleIdList) {
        Long tenantId = this.applicationService.queryTenantIdByAppInsId(instanceId);
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(null != userEo, "\u7528\u6237\u4e0d\u5b58\u5728");
        Map<Long, RoleEo> roleMap = this.getAppInsRoleMap(instanceId);
        if (roleMap.isEmpty()) {
            logger.info("\u5e94\u7528\u5b9e\u4f8bKey[{}] \u7684\u89d2\u8272\u4e0d\u5b58\u5728", (Object)instanceId);
            return;
        }
        this.beforeAddUserRoleExtHandle(instanceId, userId);
        this.deleteUserRoleRelation(userId, instanceId);
        for (Long roleId : roleIdList) {
            RoleEo roleEo = roleMap.get(roleId);
            AssertUtil.isTrue(null != roleEo, "\u89d2\u8272ID[" + roleId + "]\u4e0d\u5b58\u5728");
            UserRoleRelationEo userRoleRelationEo = new UserRoleRelationEo();
            userRoleRelationEo.setUserId(userId);
            userRoleRelationEo.setRoleId(roleId);
            userRoleRelationEo.setRoleCode(roleEo.getCode());
            userRoleRelationEo.setTenantId(tenantId);
            userRoleRelationEo.setInstanceId(instanceId);
            this.userRoleRelationDas.insert((BaseEo)userRoleRelationEo);
        }
        this.afterAddUserRoleExtHandle(instanceId, userId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addUserRolesByCode(Long userId, List<String> roleCodeList) {
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(null != userEo, "\u7528\u6237\u4e0d\u5b58\u5728");
        Map<String, RoleEo> roleMap = this.getRoleMap(roleCodeList);
        if (roleMap.size() == 0) {
            throw new BizException(UserExceptionCode.NON_EXIST_FAIL.getCode(), "\u89d2\u8272\u7f16\u7801" + UserExceptionCode.NON_EXIST_FAIL.getMsg());
        }
        this.deleteUserRoleRelation(userId);
        HashSet instanceIdList = Sets.newHashSet();
        for (String roleCode : roleCodeList) {
            RoleEo r = roleMap.get(roleCode);
            AssertUtil.isTrue(null != r, "\u89d2\u8272code[" + roleCode + "]\u4e0d\u5b58\u5728");
            UserRoleRelationEo userRoleRelationEo = new UserRoleRelationEo();
            userRoleRelationEo.setUserId(userId);
            userRoleRelationEo.setRoleId(r.getId());
            userRoleRelationEo.setRoleCode(roleCode);
            Long instanceId = r.getInstanceId();
            this.beforeAddUserRoleExtHandle(instanceId, userId);
            this.userRoleRelationDas.insert((BaseEo)userRoleRelationEo);
            this.cacheService.delCache("AccessServiceImpl:queryUserRoleByUserId:" + userId);
            instanceIdList.add(instanceId);
        }
        this.afterDeleteUserRoleExtHandle(null, userId);
        if (CollectionUtils.isNotEmpty((Collection)instanceIdList)) {
            for (Long instanceId : instanceIdList) {
                this.afterAddUserRoleExtHandle(instanceId, userId);
            }
        }
    }

    private Map<Long, RoleEo> getAppInsRoleMap(Long instanceId) {
        RoleEo tenantRole;
        HashMap roleMap = Maps.newHashMap();
        List roleEoList = this.roleDas.findByInstanceId(instanceId);
        for (RoleEo role : roleEoList) {
            roleMap.put(role.getId(), role);
        }
        RoleEo devRole = this.roleDas.findFirstByCode("developer");
        if (devRole != null) {
            roleMap.put(devRole.getId(), devRole);
        }
        if ((tenantRole = this.roleDas.findFirstByCode("tenant")) != null) {
            roleMap.put(tenantRole.getId(), tenantRole);
        }
        return roleMap;
    }

    private Map<String, AccessEo> getAccessMap(RoleEo roleEo) {
        List accessSet = this.accessDas.findByRoleId(roleEo.getId());
        HashMap accessMap = Maps.newHashMap();
        for (AccessEo accessEo : accessSet) {
            String key = roleEo.getInstanceId() + "-" + accessEo.getResourceType() + "-" + accessEo.getResourceCode();
            AccessEo mAccessEo = (AccessEo)accessMap.get(key);
            AccessEo accessEo2 = mAccessEo = mAccessEo == null ? accessEo : mAccessEo;
            if (mAccessEo.getPermissions() != null && accessEo.getPermissions() != null) {
                mAccessEo.setPermissions(Integer.valueOf(mAccessEo.getPermissions() | accessEo.getPermissions()));
            }
            accessMap.put(key, mAccessEo);
        }
        return accessMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void giveUserGroupRole(Long instanceId, Long userGroupId, List<Long> roleIdList) {
        Long tenantId = this.applicationService.queryTenantIdByAppInsId(instanceId);
        UserGroupEo userGroupEo = (UserGroupEo)this.userGroupDas.selectByPrimaryKey(userGroupId);
        AssertUtil.isTrue(null != userGroupEo, "\u7528\u6237\u7ec4\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(roleIdList), "\u89d2\u8272\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        Map<Long, RoleEo> roleMap = this.getAppInsRoleMap(instanceId);
        AssertUtil.isTrue(!roleMap.isEmpty(), "\u5e94\u7528\u5b9e\u4f8bKey[" + instanceId + "] \u7684\u89d2\u8272\u4e0d\u5b58\u5728");
        for (Long roleId : roleIdList) {
            RoleEo roleEo = roleMap.get(roleId);
            AssertUtil.isTrue(null != roleEo, "\u89d2\u8272ID[" + roleId + "]\u4e0d\u5b58\u5728");
            UserGroupRoleRelationEo userGroupRoleRelationEo = new UserGroupRoleRelationEo();
            userGroupRoleRelationEo.setRoleId(roleId);
            userGroupRoleRelationEo.setUserGroupId(userGroupId);
            this.userGroupRoleRelationDas.insert((BaseEo)userGroupRoleRelationEo);
            roleEo.setTenantId(tenantId);
        }
        userGroupEo.setTenantId(tenantId);
        this.userGroupDas.update((BaseEo)userGroupEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addUserGroupRolesByCode(Long userGroupId, List<String> roleCodeList) {
        UserGroupEo userGroupEo = (UserGroupEo)this.userGroupDas.selectByPrimaryKey(userGroupId);
        AssertUtil.isTrue(null != userGroupEo, "\u7528\u6237\u7ec4\u4e0d\u5b58\u5728");
        Map<String, RoleEo> roleMap = this.getRoleMap(roleCodeList);
        if (roleMap.size() == 0) {
            throw new BizException(UserExceptionCode.NON_EXIST_FAIL.getCode(), "\u89d2\u8272\u7f16\u7801" + UserExceptionCode.NON_EXIST_FAIL.getMsg());
        }
        UserGroupRoleRelationEo userRoleRelationEo = new UserGroupRoleRelationEo();
        userRoleRelationEo.setUserGroupId(userGroupId);
        this.userGroupRoleRelationDas.logicDelete((BaseEo)userRoleRelationEo);
        for (String roleCode : roleCodeList) {
            RoleEo eo = roleMap.get(roleCode);
            AssertUtil.isTrue(null != eo, "\u89d2\u8272code[" + roleCode + "]\u4e0d\u5b58\u5728");
            UserGroupRoleRelationEo userGroupRoleRelationEo = new UserGroupRoleRelationEo();
            userGroupRoleRelationEo.setRoleId(eo.getId());
            userGroupRoleRelationEo.setRoleCode(roleCode);
            userGroupRoleRelationEo.setUserGroupId(userGroupId);
            this.userGroupRoleRelationDas.insert((BaseEo)userGroupRoleRelationEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeUserRoles(Long userId, String roleCodes) {
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(null != userEo, "id\u4e3a" + userId + "\u7684\u7528\u6237\u4e0d\u5b58\u5728");
        Object[] roleCodeArray = StringUtils.split((String)roleCodes, (String)",");
        ArrayList<String> roleCodeList = new ArrayList<String>();
        CollectionUtils.addAll(roleCodeList, (Object[])roleCodeArray);
        Map<String, RoleEo> roleMap = this.getRoleMap(roleCodeList);
        if (roleMap.size() == 0) {
            throw new BizException(UserExceptionCode.NON_EXIST_FAIL.getCode(), "\u89d2\u8272\u7f16\u7801" + UserExceptionCode.NON_EXIST_FAIL.getMsg());
        }
        for (String roleCode : roleCodeList) {
            RoleEo eo = roleMap.get(roleCode);
            AssertUtil.isTrue(null != eo, "\u89d2\u8272code[" + roleCode + "]\u4e0d\u5b58\u5728");
            UserRoleRelationEo userRoleRelationEo = new UserRoleRelationEo();
            userRoleRelationEo.setUserId(userId);
            userRoleRelationEo.setRoleCode(roleCode);
            this.userRoleRelationDas.delete((BaseEo)userRoleRelationEo);
            userRoleRelationEo.setRoleId(eo.getId());
            userRoleRelationEo.setRoleCode(null);
            this.userRoleRelationDas.delete((BaseEo)userRoleRelationEo);
            this.afterDeleteUserRoleExtHandle(eo.getInstanceId(), userId);
        }
    }

    private Map<String, RoleEo> getRoleMap(List<String> roleCodeList) {
        RoleEo roleEo = new RoleEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"code", (Object)StringUtils.join(roleCodeList, (String)",")));
        roleEo.setSqlFilters(sqlFilters);
        List roleEos = this.roleDas.select((BaseEo)roleEo);
        HashMap<String, RoleEo> roleMap = new HashMap<String, RoleEo>();
        if (CollectionUtils.isNotEmpty((Collection)roleEos)) {
            for (RoleEo eo : roleEos) {
                roleMap.put(eo.getCode(), eo);
            }
        }
        return roleMap;
    }

    @Override
    public Integer queryPermissions(Long instanceId, Long userId, String filter) {
        Integer permissions = 0;
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)filter), "filter \u4e0d\u80fd\u4e3a\u7a7a");
        ResourceDto resourceParam = (ResourceDto)JSON.parseObject((String)filter, ResourceDto.class);
        UserAccessVo userAccessVo = this.queryUserAccess(instanceId, userId);
        Set accessDtoSet = userAccessVo.getAccessSet();
        ArrayList menuIds = Lists.newArrayList();
        ArrayList buttonIds = Lists.newArrayList();
        for (AccessDto accessDto : accessDtoSet) {
            int resType = accessDto.getResourceType();
            if (1 == resType) {
                menuIds.add(accessDto.getResourceId());
                continue;
            }
            if (2 != resType) continue;
            buttonIds.add(accessDto.getResourceId());
        }
        Map<String, MenuEo> menuEoMap = this.getMenuEoMap(menuIds);
        Map<String, ButtonEo> buttonEoMap = this.getButtonEoMap(buttonIds);
        for (AccessDto accessDto : accessDtoSet) {
            Integer p = accessDto.getPermissions();
            int resType = accessDto.getResourceType();
            Long resId = accessDto.getResourceId();
            ResourceDto resourceDto = new ResourceDto();
            if (1 == resType) {
                DtoHelper.eo2Dto((BaseEo)((BaseEo)menuEoMap.get(resId.toString())), (BaseVo)resourceDto);
            } else if (2 == resType) {
                DtoHelper.eo2Dto((BaseEo)((BaseEo)buttonEoMap.get(resId.toString())), (BaseVo)resourceDto);
            }
            if (resourceParam == null) continue;
            if (resourceParam.getAction() != null && resourceParam.getAction().contains(resourceDto.getAction())) {
                permissions = permissions | p;
            }
            if (resourceParam.getCode() != null && resourceParam.getCode().equals(resourceDto.getCode())) {
                permissions = permissions | p;
            }
            if (resourceParam.getName() != null && resourceParam.getName().equals(resourceDto.getName())) {
                permissions = permissions | p;
            }
            if (resourceParam.getRoutePath() == null || !resourceParam.getRoutePath().equals(resourceDto.getRoutePath())) continue;
            permissions = permissions | p;
        }
        return permissions;
    }

    private Map<String, ButtonEo> getButtonEoMap(List<Long> buttonIds) {
        HashMap buttonEoMap = Maps.newHashMap();
        List<ButtonEo> buttonEoList = this.resourceService.findButtonByIds(buttonIds);
        for (ButtonEo buttonEo : buttonEoList) {
            if (buttonEo.getStatus() != null && buttonEo.getStatus() != 1) continue;
            buttonEoMap.put(buttonEo.getId().toString(), buttonEo);
        }
        return buttonEoMap;
    }

    private Map<String, MenuEo> getMenuEoMap(List<Long> menuIds) {
        HashMap menuEoMap = Maps.newHashMap();
        List<MenuEo> menuEoList = this.resourceService.findMenuByIds(menuIds);
        for (MenuEo menuEo : menuEoList) {
            if (menuEo.getStatus() != null && menuEo.getStatus() != 1) continue;
            menuEoMap.put(menuEo.getId().toString(), menuEo);
        }
        return menuEoMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public UserAccessVo queryUserAccess(Long instanceId, Long userId) {
        UserAccessVo userAccessVo = new UserAccessVo();
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(null != userEo, "\u7528\u6237\u4e0d\u5b58\u5728");
        userAccessVo.setUserId(userId);
        userAccessVo.setUserName(userEo.getUserName());
        HashSet roleSet = Sets.newHashSet();
        Set roleIdSet = this.abacAttrApplicationService.getUserRoleRelationByUserAttr(userId, instanceId).stream().filter(c -> c.getRoleId() != null).map(StdUserRoleRelationEo::getRoleId).collect(Collectors.toSet());
        List userRoles = this.roleDas.queryByIds(roleIdSet);
        roleSet.addAll(userRoles);
        List userGroupList = this.userGroupDas.findByAppInsAndUserId(instanceId, userId);
        for (UserGroupEo userGroupEo : userGroupList) {
            if (userGroupEo.getStatus() != null && userGroupEo.getStatus() != 1) continue;
            List userGroupRoles = this.roleDas.findByUserGroupId(userGroupEo.getId());
            roleSet.addAll(userGroupRoles);
        }
        this.setRoleAccess(instanceId, userAccessVo, roleSet);
        return userAccessVo;
    }

    @Override
    public UserAccessRespDto queryUserAccessResources(Long instanceId, Long userId, String filter) {
        JSONObject jsonObject;
        DataLimitAspect.skipAllTable();
        if (this.userIdSourceCtrl.equals(0)) {
            userId = this.context.userId();
        } else if (this.userIdSourceCtrl.equals(2) && this.context.userId() != null) {
            userId = this.context.userId();
        }
        AssertUtil.isTrue(null != userId, "\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a");
        boolean withNoFirstNode = false;
        if (StringUtils.isNotBlank((CharSequence)filter) && (jsonObject = JSONObject.parseObject((String)filter)).get((Object)"withNoFirstNode") != null && jsonObject.get((Object)"withNoFirstNode").equals(1)) {
            withNoFirstNode = true;
        }
        UserAccessRespDto userAccessRespDto = new UserAccessRespDto();
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(null != userEo, "\u7528\u6237\u4e0d\u5b58\u5728");
        userAccessRespDto.setUserId(userId);
        userAccessRespDto.setUserName(userEo.getUserName());
        userAccessRespDto.setNickName(userEo.getNickName());
        HashSet roleSet = Sets.newHashSet();
        Set roleIdSet = this.abacAttrApplicationService.getUserRoleRelationByUserAttr(userId, instanceId).stream().filter(c -> c.getRoleId() != null).map(StdUserRoleRelationEo::getRoleId).collect(Collectors.toSet());
        List userRoles = this.roleDas.queryByIds(roleIdSet);
        roleSet.addAll(userRoles);
        List userGroupList = this.userGroupDas.findByAppInsAndUserId(instanceId, userId);
        for (Object userGroupEo : userGroupList) {
            if (userGroupEo.getStatus() != null && userGroupEo.getStatus() != 1) continue;
            List userGroupRoles = this.roleDas.findByUserGroupId(userGroupEo.getId());
            roleSet.addAll(userGroupRoles);
        }
        this.distinctRoleSet(roleSet);
        HashSet roleDtoSet = Sets.newHashSet();
        for (Object roleEo : roleSet) {
            Long roleAppIns = roleEo.getInstanceId();
            if (roleAppIns != null && instanceId != null && !roleAppIns.equals(instanceId) && !"tenant".equals(roleEo.getCode())) continue;
            RoleDto roleDto = new RoleDto();
            DtoHelper.eo2Dto((BaseEo)roleEo, (BaseVo)roleDto);
            roleDtoSet.add(roleDto);
        }
        userAccessRespDto.setRoleSet((Set)roleDtoSet);
        HashSet accessSet = Sets.newHashSet();
        for (RoleDto roleDto : roleDtoSet) {
            List accessCodes;
            List accessEoList;
            accessSet.addAll(this.accessDas.findByRoleId(roleDto.getId()));
            RoleAccessRelationEo roleAccessRelationEo = new RoleAccessRelationEo();
            roleAccessRelationEo.setRoleCode(roleDto.getCode());
            roleAccessRelationEo.setInstanceId(instanceId);
            List roleAccessRelationEos = this.roleAccessRelationDas.select((BaseEo)roleAccessRelationEo, Integer.valueOf(1), Integer.valueOf(5000));
            if (!CollectionUtils.isNotEmpty((Collection)roleAccessRelationEos) || !CollectionUtils.isNotEmpty((Collection)(accessEoList = this.accessDas.selectByAccessCode(accessCodes = roleAccessRelationEos.stream().filter(eo -> StringUtils.isNotBlank((CharSequence)eo.getAccessCode())).map(StdRoleAccessRelationEo::getAccessCode).collect(Collectors.toList()), instanceId)))) continue;
            accessSet.addAll(accessEoList);
        }
        this.distinctAccessSet(accessSet);
        HashSet accessDtoSet = Sets.newHashSet();
        DtoHelper.eoList2DtoList((Collection)accessSet, (Collection)accessDtoSet, AccessDto.class);
        userAccessRespDto.setAccessSet((Set)accessDtoSet);
        ArrayList buttonDtos = new ArrayList();
        if (accessSet.stream().anyMatch(e -> "**".equals(e.getCode()))) {
            List menuEos = this.menuDas.selectByInstanceId(instanceId);
            List<MenuDto> menuDtos = this.processMenuTree(menuEos, withNoFirstNode);
            userAccessRespDto.setMenus(menuDtos);
            List buttonEos = this.buttonDas.selectByInstanceId(instanceId);
            DtoHelper.eoList2DtoList((Collection)buttonEos, buttonDtos, ButtonDto.class);
            userAccessRespDto.setButtons(buttonDtos);
        } else {
            List buttonEoByCode;
            ArrayList<String> menuCodes = new ArrayList<String>();
            ArrayList<String> buttonCodes = new ArrayList<String>();
            for (AccessEo accessEo : accessSet) {
                int type = accessEo.getResourceType();
                if (type == 1) {
                    menuCodes.add(accessEo.getResourceCode());
                    continue;
                }
                if (type != 2) continue;
                buttonCodes.add(accessEo.getResourceCode());
            }
            List menuEos = new ArrayList();
            if (CollectionUtils.isNotEmpty(menuCodes)) {
                menuEos = this.menuDas.selectByCodes(menuCodes, instanceId);
            }
            if (CollectionUtils.isNotEmpty(menuEos)) {
                ArrayList menuIds = new ArrayList();
                List<MenuEo> menuResults = menuEos.stream().filter(v -> {
                    boolean flag;
                    boolean bl = flag = !menuIds.contains(v.getId());
                    if (flag) {
                        menuIds.add(v.getId());
                    }
                    return flag;
                }).collect(Collectors.toList());
                List<MenuDto> menuDtos = this.processMenuTree(menuResults, withNoFirstNode);
                userAccessRespDto.setMenus(menuDtos);
            }
            ArrayList buttonEos = new ArrayList();
            if (CollectionUtils.isNotEmpty(buttonCodes) && CollectionUtils.isNotEmpty((Collection)(buttonEoByCode = this.buttonDas.selectByCodes(buttonCodes, instanceId)))) {
                buttonEos.addAll(buttonEoByCode);
            }
            if (CollectionUtils.isNotEmpty(buttonEos)) {
                ArrayList buttonIds = new ArrayList();
                List buttonResults = buttonEos.stream().filter(v -> {
                    boolean flag;
                    boolean bl = flag = !buttonIds.contains(v.getId());
                    if (flag) {
                        buttonIds.add(v.getId());
                    }
                    return flag;
                }).collect(Collectors.toList());
                DtoHelper.eoList2DtoList(buttonResults, buttonDtos, ButtonDto.class);
                userAccessRespDto.setButtons(buttonDtos);
            }
        }
        DataLimitAspect.cleanSkipTable();
        return userAccessRespDto;
    }

    public static List<MenuDto> buildTree(String parentCode, List<MenuDto> menus) {
        ArrayList<MenuDto> tree = new ArrayList<MenuDto>();
        for (MenuDto menu : menus) {
            if (!parentCode.equals(menu.getParentCode())) continue;
            tree.add(menu);
            menu.setChildren(AccessServiceImpl.buildTree(menu.getCode(), menus));
        }
        tree.sort(Comparator.comparing(ResourceDto::getSortNo));
        return tree;
    }

    private List<MenuDto> processMenuTree(List<MenuEo> menuEos, boolean withNoFirstNode) {
        Map<String, Long> menuIdCodeMap = menuEos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getCode())).collect(Collectors.toMap(StdMenuEo::getCode, BaseEo::getId, (k1, k2) -> k2));
        List<MenuDto> menuDtos = menuEos.stream().map(e -> {
            MenuDto menuDto = new MenuDto();
            DtoHelper.eo2Dto((BaseEo)e, (BaseVo)menuDto);
            menuDto.setName_i1(e.getNameI1());
            menuDto.setName_i2(e.getNameI2());
            this.complementMenuDto(menuDto, menuIdCodeMap);
            return menuDto;
        }).collect(Collectors.toList());
        List<MenuDto> dtoList = AccessServiceImpl.buildTree("0", menuDtos);
        if (withNoFirstNode) {
            ArrayList<MenuDto> tmp = new ArrayList<MenuDto>(dtoList.size());
            for (MenuDto menuDto : dtoList) {
                tmp.addAll(menuDto.getChildren());
            }
            dtoList = tmp;
        }
        return dtoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public UserAccessVo queryUserGroupAccess(Long instanceId, Long userGroupId, String filter) {
        UserAccessVo userAccessVo = new UserAccessVo();
        UserGroupEo userGroupEo = (UserGroupEo)this.userGroupDas.selectByPrimaryKey(userGroupId);
        AssertUtil.isTrue(null != userGroupEo, "\u7528\u6237\u7ec4\u4e0d\u5b58\u5728");
        HashSet roleSet = Sets.newHashSet();
        List userGroupRoles = this.roleDas.findByUserGroupId(userGroupId);
        roleSet.addAll(userGroupRoles);
        this.setRoleAccess(instanceId, userAccessVo, roleSet);
        return userAccessVo;
    }

    @Override
    public List<UserRoleRespDto> queryUserRole(UserRoleReqDto userRoleReqDto) {
        DataLimitAspect.skipAllTable();
        Long userId = userRoleReqDto.getUserId();
        Assert.isTrue((userId != null ? 1 : 0) != 0, (String)(UserExceptionCode.REQ_PARAM_ERROR.getMsg() + ":\u7528\u6237id\u4e0d\u80fd\u4e3anull"));
        List<Object> userRoleRespDtos = this.queryUserRoleByUserId(userId);
        Long instanceId = userRoleReqDto.getInstanceId();
        Long orgId = userRoleReqDto.getBelongOrgId();
        Integer roleType = userRoleReqDto.getRoleType();
        userRoleRespDtos = userRoleRespDtos.stream().filter(dto -> {
            if (instanceId != null && !instanceId.equals(dto.getInstanceId())) {
                return false;
            }
            if (orgId != null && !orgId.equals(dto.getBelongOrgId())) {
                return false;
            }
            return roleType == null || roleType.equals(dto.getRoleType());
        }).collect(Collectors.toList());
        DataLimitAspect.cleanSkipTable();
        return userRoleRespDtos;
    }

    private List<UserRoleRespDto> queryUserRoleByUserId(Long userId) {
        if (userId == null) {
            return Collections.emptyList();
        }
        String redisKey = "AccessServiceImpl:queryUserRoleByUserId:" + userId;
        ArrayList<UserRoleRespDto> userRoleRespDtos = new ArrayList<UserRoleRespDto>();
        HashSet roleIds = new HashSet();
        List<UserRoleRelationEo> userRoleRelationEos = this.abacAttrApplicationService.getUserRoleRelationByUserAttr(userId, null);
        if (CollectionUtils.isNotEmpty(userRoleRelationEos)) {
            roleIds.addAll(userRoleRelationEos.stream().map(StdUserRoleRelationEo::getRoleId).collect(Collectors.toSet()));
        }
        UserGroupRoleRelationEo userGroupRoleRelationEo = new UserGroupRoleRelationEo();
        userGroupRoleRelationEo.setUserId(userId);
        List userGroupRoleRelationEos = this.userGroupRoleRelationDas.select((BaseEo)userGroupRoleRelationEo, Integer.valueOf(0), Integer.valueOf(4096));
        if (CollectionUtils.isNotEmpty((Collection)userGroupRoleRelationEos)) {
            roleIds.addAll(userGroupRoleRelationEos.stream().map(StdUserGroupRoleRelationEo::getRoleId).collect(Collectors.toSet()));
        }
        if (roleIds.size() > 0) {
            for (Long roleId : roleIds) {
                UserRoleRespDto userRoleRespDto = new UserRoleRespDto();
                RoleEo roleEo = (RoleEo)this.roleDas.selectByPrimaryKey(roleId);
                if (roleEo == null) {
                    throw new BizException(UserExceptionCode.NON_EXIST_FAIL.getCode(), UserExceptionCode.NON_EXIST_FAIL.getMsg() + ":\u89d2\u8272\u4e0d\u5b58\u5728");
                }
                DtoHelper.eo2Dto((BaseEo)roleEo, (BaseVo)userRoleRespDto);
                userRoleRespDto.setRoleId(roleId);
                AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(roleEo.getInstanceId());
                if (appInstanceEo != null) {
                    userRoleRespDto.setAppInstanceName(appInstanceEo.getAppInsName());
                }
                userRoleRespDtos.add(userRoleRespDto);
            }
        }
        this.cacheService.setCache(redisKey, userRoleRespDtos);
        return userRoleRespDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setRoleUserRelation(RoleUserRelationReqDto roleUserRelationReqDto) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)roleUserRelationReqDto.getRoleCode()), "\u89d2\u8272code\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)roleUserRelationReqDto.getUserIds()), "\u7528\u6237\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        RoleEo roleEo = new RoleEo();
        roleEo.setInstanceId(instanceId);
        roleEo.setCode(roleUserRelationReqDto.getRoleCode());
        List roleEos = this.roleDas.select((BaseEo)roleEo);
        if (roleEos.size() == 1) {
            UserRoleRelationEo userRoleIdRelationEo = new UserRoleRelationEo();
            userRoleIdRelationEo.setRoleId(((RoleEo)roleEos.get(0)).getId());
            this.userRoleRelationDas.delete((BaseEo)userRoleIdRelationEo);
            UserRoleRelationEo userRoleCodeRelationEo = new UserRoleRelationEo();
            userRoleCodeRelationEo.setRoleCode(roleUserRelationReqDto.getRoleCode());
            userRoleCodeRelationEo.setInstanceId(instanceId);
            this.userRoleRelationDas.delete((BaseEo)userRoleIdRelationEo);
            for (Long userId : roleUserRelationReqDto.getUserIds()) {
                UserRoleRelationEo userRoleRelationEo = new UserRoleRelationEo();
                userRoleRelationEo.setUserId(userId);
                userRoleRelationEo.setRoleId(((RoleEo)roleEos.get(0)).getId());
                userRoleRelationEo.setTenantId(tenantId);
                userRoleRelationEo.setInstanceId(instanceId);
                this.beforeAddUserRoleExtHandle(instanceId, userId);
                this.userRoleRelationDas.insert((BaseEo)userRoleRelationEo);
                this.afterAddUserRoleExtHandle(instanceId, userId);
            }
        } else {
            throw new BizException(UserExceptionCode.NON_EXIST_FAIL.getCode(), "\u6570\u636e\u4e0d\u7b26\u5408\u9884\u671f\uff0c\u8bf7\u68c0\u67e5");
        }
    }

    private void setRoleAccess(Long instanceId, UserAccessVo userAccessVo, Set<RoleEo> roleSet) {
        HashSet roleDtoSet = Sets.newHashSet();
        for (RoleEo roleEo : roleSet) {
            Long roleAppIns = roleEo.getInstanceId();
            if (roleAppIns != null && instanceId != null && roleAppIns.compareTo(instanceId) != 0 && !"tenant".equals(roleEo.getCode())) continue;
            RoleDto roleDto = new RoleDto();
            roleDto.setCode(roleEo.getCode());
            roleDto.setId(roleEo.getId());
            roleDtoSet.add(roleDto);
        }
        if (CollectionUtils.isEmpty((Collection)roleDtoSet)) {
            return;
        }
        userAccessVo.setRoleSet((Set)roleDtoSet);
        HashSet accessIdSet = new HashSet(64);
        ArrayList<Long> roleIdList = new ArrayList<Long>();
        ArrayList<String> roleCodeList = new ArrayList<String>();
        for (RoleDto roleDto : roleDtoSet) {
            roleIdList.add(roleDto.getId());
            roleCodeList.add(roleDto.getCode());
        }
        List<RoleAccessRelationEo> roleAccessRelationEoListById = this.getRoleAccessRelationBatch("role_id", instanceId, roleIdList);
        List<RoleAccessRelationEo> roleAccessRelationEoListByCode = this.getRoleAccessRelationBatch("role_code", instanceId, roleCodeList);
        if (CollectionUtils.isNotEmpty(roleAccessRelationEoListByCode)) {
            accessIdSet.addAll(roleAccessRelationEoListByCode.stream().map(StdRoleAccessRelationEo::getAccessId).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(roleAccessRelationEoListById)) {
            accessIdSet.addAll(roleAccessRelationEoListById.stream().map(StdRoleAccessRelationEo::getAccessId).collect(Collectors.toList()));
        }
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"id", (Object)StringUtils.join(accessIdSet, (String)",")));
        AccessEo accessEo = new AccessEo();
        accessEo.setSqlFilters(sqlFilterList);
        List accessEoList = this.accessDas.select((BaseEo)accessEo, Integer.valueOf(1), Integer.valueOf(5000));
        if (CollectionUtils.isEmpty((Collection)accessEoList)) {
            return;
        }
        HashSet accessEoSet = new HashSet(accessEoList);
        HashSet accessDtoSet = Sets.newHashSet();
        List menuEos = this.menuDas.selectByInstanceId(instanceId);
        List buttonEos = this.buttonDas.selectByInstanceId(instanceId);
        if (accessEoSet.stream().anyMatch(e -> "**".equals(e.getCode()))) {
            Map<String, Long> menuIdCodeMap = menuEos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getCode())).collect(Collectors.toMap(StdMenuEo::getCode, BaseEo::getId, (k1, k2) -> k2));
            List menuAccesses = menuEos.stream().map(e -> {
                MenuDto dto = new MenuDto();
                DtoHelper.eo2Dto((BaseEo)e, (BaseVo)dto, (String[])new String[]{"children"});
                dto = this.complementMenuDto(dto, menuIdCodeMap);
                dto.setName_i1(e.getNameI1());
                dto.setName_i2(e.getNameI2());
                AccessDto accessDto = new AccessDto();
                accessDto.setMenuDto(dto);
                accessDto.setPermissions(Integer.valueOf(15));
                accessDto.setResourceId(e.getId());
                accessDto.setResourceCode(e.getCode());
                accessDto.setResourceType(Integer.valueOf(1));
                return accessDto;
            }).collect(Collectors.toList());
            accessDtoSet.addAll(menuAccesses);
            List buttonAccess = buttonEos.stream().map(e -> {
                ButtonDto dto = new ButtonDto();
                DtoHelper.eo2Dto((BaseEo)e, (BaseVo)dto, (String[])new String[]{"children"});
                dto = this.complementButtonDto(dto, menuIdCodeMap);
                AccessDto accessDto = new AccessDto();
                accessDto.setButtonDto(dto);
                accessDto.setPermissions(Integer.valueOf(15));
                accessDto.setResourceId(e.getId());
                accessDto.setResourceCode(e.getCode());
                accessDto.setResourceType(Integer.valueOf(2));
                return accessDto;
            }).collect(Collectors.toList());
            accessDtoSet.addAll(buttonAccess);
        } else {
            DtoHelper.eoList2DtoList(accessEoSet, (Collection)accessDtoSet, AccessDto.class);
            this.addResource(accessDtoSet, menuEos, buttonEos);
        }
        userAccessVo.setAccessSet((Set)accessDtoSet);
    }

    private List<RoleAccessRelationEo> getRoleAccessRelationBatch(String colName, Long instanceId, List valueList) {
        if (CollectionUtils.isEmpty((Collection)valueList)) {
            return new ArrayList<RoleAccessRelationEo>();
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)colName, (Object)StringUtils.join((Iterable)valueList, (String)",")));
        RoleAccessRelationEo roleAccessRelationEo = new RoleAccessRelationEo();
        roleAccessRelationEo.setInstanceId(instanceId);
        roleAccessRelationEo.setSqlFilters(sqlFilters);
        return this.roleAccessRelationDas.select((BaseEo)roleAccessRelationEo, Integer.valueOf(1), Integer.valueOf(5000));
    }

    private void distinctRoleSet(Set<RoleEo> roleSet) {
        HashMap map = Maps.newHashMap();
        for (RoleEo roleEo : roleSet) {
            map.putIfAbsent(roleEo.getId(), roleEo);
        }
        roleSet.clear();
        for (Long key : map.keySet()) {
            roleSet.add((RoleEo)map.get(key));
        }
    }

    private void distinctAccessSet(Set<AccessEo> accessSet) {
        HashMap map = Maps.newHashMap();
        for (AccessEo access : accessSet) {
            map.putIfAbsent(access.getInstanceId() + "-" + access.getResourceType() + "-" + access.getResourceCode(), access);
        }
        accessSet.clear();
        for (String key : map.keySet()) {
            accessSet.add((AccessEo)map.get(key));
        }
    }

    private void addResource(Set<AccessDto> accessDtoSet, List<MenuEo> menuEos, List<ButtonEo> buttonEos) {
        HashMap<String, Long> menuCodeMapToMenuId = new HashMap<String, Long>();
        menuCodeMapToMenuId.put("-1", ResourceEo.ROOT_PARENT_ID);
        Map<String, MenuEo> codeMenuMap = menuEos.stream().collect(Collectors.toMap(StdMenuEo::getCode, m -> m));
        HashSet<AccessDto> notExists = new HashSet<AccessDto>();
        for (AccessDto accessDto : accessDtoSet) {
            if (1 == accessDto.getResourceType()) {
                MenuEo menuEo = codeMenuMap.get(accessDto.getResourceCode());
                if (menuEo == null || StringUtils.isBlank((CharSequence)menuEo.getParentCode())) {
                    notExists.add(accessDto);
                    continue;
                }
                menuCodeMapToMenuId.put(menuEo.getCode(), menuEo.getId());
                Long parentId = (Long)menuCodeMapToMenuId.get(menuEo.getParentCode());
                if (parentId == null) {
                    MenuEo parent = codeMenuMap.get(menuEo.getParentCode());
                    if (parent == null) {
                        notExists.add(accessDto);
                        logger.warn("\u83dc\u5355\u6839\u636e\u5b9e\u4f8b{}\u548c\u7236\u7f16\u7801{}\u627e\u4e0d\u5230\u83dc\u5355", (Object)menuEo.getInstanceId(), (Object)menuEo.getParentCode());
                        continue;
                    }
                    parentId = parent.getId();
                    menuCodeMapToMenuId.put(menuEo.getParentCode(), parentId);
                }
                MenuDto menuDto = new MenuDto();
                DtoHelper.eo2Dto((BaseEo)menuEo, (BaseVo)menuDto);
                menuDto.setParentId(parentId);
                menuDto.setName_i1(menuEo.getNameI1());
                menuDto.setName_i2(menuEo.getNameI2());
                accessDto.setResourceId(menuEo.getId());
                accessDto.setMenuDto(menuDto);
                continue;
            }
            if (2 != accessDto.getResourceType()) continue;
            Map<String, ButtonEo> codeButtonMap = buttonEos.stream().collect(Collectors.toMap(StdButtonEo::getCode, b -> b));
            ButtonEo buttonEo = codeButtonMap.get(accessDto.getResourceCode());
            if (buttonEo == null || StringUtils.isBlank((CharSequence)buttonEo.getParentCode())) {
                notExists.add(accessDto);
                continue;
            }
            Long parentId = (Long)menuCodeMapToMenuId.get(buttonEo.getParentCode());
            if (parentId == null) {
                MenuEo parent = codeMenuMap.get(buttonEo.getParentCode());
                if (parent == null) {
                    notExists.add(accessDto);
                    logger.warn("\u6309\u94ae\u6839\u636e\u5b9e\u4f8b{}\u548c\u7236\u7f16\u7801{}\u627e\u4e0d\u5230\u83dc\u5355", (Object)buttonEo.getInstanceId(), (Object)buttonEo.getParentCode());
                    continue;
                }
                parentId = parent.getId();
                menuCodeMapToMenuId.put(buttonEo.getParentCode(), parentId);
            }
            ButtonDto buttonDto = new ButtonDto();
            DtoHelper.eo2Dto((BaseEo)buttonEo, (BaseVo)buttonDto);
            buttonDto.setMenuId(parentId);
            accessDto.setResourceId(buttonEo.getId());
            accessDto.setButtonDto(buttonDto);
        }
        accessDtoSet.removeAll(notExists);
    }
}

