/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.AddressDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.BillInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ContactsInfoDto;
import com.dtyunxi.yundt.cube.center.user.biz.service.ICustomerUserService;
import com.dtyunxi.yundt.cube.center.user.dao.das.AddressDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.BillInfoDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.ContactsInfoDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AddressEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.BillInfoEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.ContactsInfoEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="customerUserService")
public class CustomerUserServiceImpl
implements ICustomerUserService {
    @Resource
    private BillInfoDas billInfoDas;
    @Resource
    private ContactsInfoDas contactsInfoDas;
    @Resource
    private AddressDas addressDas;

    @Override
    public Long addCustomerAddress(AddressDto addressDto) {
        AddressEo addressEo = new AddressEo();
        DtoHelper.dto2Eo((BaseVo)addressDto, (BaseEo)addressEo);
        this.addressDas.insert((BaseEo)addressEo);
        if (null != addressDto.getStatus() && addressDto.getStatus() == 1) {
            this.addressDas.updateStatusByOrgInfoId(addressEo.getOrgInfoId(), addressEo.getAddressType(), addressEo.getId());
        }
        return addressEo.getId();
    }

    @Override
    public int updateCustomerAddress(AddressDto addressDto) {
        AddressEo addressEo = new AddressEo();
        DtoHelper.dto2Eo((BaseVo)addressDto, (BaseEo)addressEo);
        int rows = this.addressDas.updateSelective((BaseEo)addressEo);
        if (null != addressDto.getStatus() && addressDto.getStatus() == 1) {
            this.addressDas.updateStatusByOrgInfoId(addressEo.getOrgInfoId(), addressEo.getAddressType(), addressEo.getId());
        }
        return rows;
    }

    @Override
    public void deleteCustomerAddress(Long id) {
        this.addressDas.deleteById(id);
    }

    @Override
    public Long addCustomerBillInfo(BillInfoDto billInfoDto) {
        BillInfoEo billInfoEo = new BillInfoEo();
        DtoHelper.dto2Eo((BaseVo)billInfoDto, (BaseEo)billInfoEo);
        this.billInfoDas.insert((BaseEo)billInfoEo);
        return billInfoEo.getId();
    }

    @Override
    public int updateCustomerBillInfo(BillInfoDto billInfoDto) {
        BillInfoEo billInfoEo = new BillInfoEo();
        DtoHelper.dto2Eo((BaseVo)billInfoDto, (BaseEo)billInfoEo);
        int rows = this.billInfoDas.updateSelective((BaseEo)billInfoEo);
        return rows;
    }

    @Override
    public void deleteCustomerBillInfo(Long id) {
        this.billInfoDas.deleteById(id);
    }

    @Override
    public Long addCustomerContactsInfo(ContactsInfoDto contactsInfoDto) {
        ContactsInfoEo contactsInfoEo = new ContactsInfoEo();
        DtoHelper.dto2Eo((BaseVo)contactsInfoDto, (BaseEo)contactsInfoEo);
        this.contactsInfoDas.insert((BaseEo)contactsInfoEo);
        return contactsInfoEo.getId();
    }

    @Override
    public int updateCustomerContactsInfo(ContactsInfoDto contactsInfoDto) {
        ContactsInfoEo contactsInfoEo = new ContactsInfoEo();
        DtoHelper.dto2Eo((BaseVo)contactsInfoDto, (BaseEo)contactsInfoEo);
        int rows = this.contactsInfoDas.updateSelective((BaseEo)contactsInfoEo);
        return rows;
    }

    @Override
    public void deleteCustomerContactsInfo(Long id) {
        this.contactsInfoDas.deleteById(id);
    }

    @Override
    public AddressDto queryAddressById(Long id) {
        AddressEo accessEo = (AddressEo)this.addressDas.selectByPrimaryKey(id);
        AddressDto accessDto = new AddressDto();
        DtoHelper.eo2Dto((BaseEo)accessEo, (BaseVo)accessDto);
        return accessDto;
    }

    @Override
    public List<AddressDto> queryAddressListByOrgInfoId(Long orgInfoId) {
        AddressEo addressEo = new AddressEo();
        addressEo.setOrgInfoId(orgInfoId);
        List addressEoList = this.addressDas.select((BaseEo)addressEo);
        ArrayList<AddressDto> addressDtoList = new ArrayList<AddressDto>();
        DtoHelper.eoList2DtoList((Collection)addressEoList, addressDtoList, AddressDto.class);
        return addressDtoList;
    }

    @Override
    public List<AddressDto> queryAddressListByOrgInfoIdList(List<Long> orgInfoIdList) {
        AddressEo addressEo = new AddressEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (CollectionUtils.isNotEmpty(orgInfoIdList)) {
            sqlFilterList.add(SqlFilter.in((String)"org_info_id", (Object)StringUtils.join(orgInfoIdList, (String)",")));
        }
        addressEo.setSqlFilters(sqlFilterList);
        List addressEoList = this.addressDas.select((BaseEo)addressEo);
        ArrayList<AddressDto> addressDtoList = new ArrayList<AddressDto>();
        DtoHelper.eoList2DtoList((Collection)addressEoList, addressDtoList, AddressDto.class);
        return addressDtoList;
    }

    @Override
    public BillInfoDto queryBillInfoById(Long id) {
        BillInfoEo billInfoEo = (BillInfoEo)this.billInfoDas.selectByPrimaryKey(id);
        BillInfoDto billInfoDto = new BillInfoDto();
        DtoHelper.eo2Dto((BaseEo)billInfoEo, (BaseVo)billInfoDto);
        return billInfoDto;
    }

    @Override
    public List<BillInfoDto> queryBillInfoListByOrgInfoId(Long orgInfoId) {
        BillInfoEo billInfoEo = new BillInfoEo();
        billInfoEo.setOrgInfoId(orgInfoId);
        List billInfoEoList = this.billInfoDas.select((BaseEo)billInfoEo);
        ArrayList<BillInfoDto> billInfoDtoList = new ArrayList<BillInfoDto>();
        DtoHelper.eoList2DtoList((Collection)billInfoEoList, billInfoDtoList, BillInfoDto.class);
        return billInfoDtoList;
    }

    @Override
    public List<BillInfoDto> queryBillInfoListByOrgInfoIdList(List<Long> orgInfoIdList) {
        BillInfoEo billInfoEo = new BillInfoEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (CollectionUtils.isNotEmpty(orgInfoIdList)) {
            sqlFilterList.add(SqlFilter.in((String)"org_info_id", (Object)StringUtils.join(orgInfoIdList, (String)",")));
        }
        billInfoEo.setSqlFilters(sqlFilterList);
        List billInfoEoList = this.billInfoDas.select((BaseEo)billInfoEo);
        ArrayList<BillInfoDto> billInfoDtoList = new ArrayList<BillInfoDto>();
        DtoHelper.eoList2DtoList((Collection)billInfoEoList, billInfoDtoList, BillInfoDto.class);
        return billInfoDtoList;
    }

    @Override
    public ContactsInfoDto queryContactsInfoById(Long id) {
        ContactsInfoEo contactsInfoEo = (ContactsInfoEo)this.contactsInfoDas.selectByPrimaryKey(id);
        ContactsInfoDto contactsInfoDto = new ContactsInfoDto();
        DtoHelper.eo2Dto((BaseEo)contactsInfoEo, (BaseVo)contactsInfoDto);
        return contactsInfoDto;
    }

    @Override
    public List<ContactsInfoDto> queryContactsInfoListByOrgInfoId(Long orgInfoId) {
        ContactsInfoEo contactsInfoEo = new ContactsInfoEo();
        contactsInfoEo.setOrgInfoId(orgInfoId);
        List contactsInfoEoList = this.contactsInfoDas.select((BaseEo)contactsInfoEo);
        ArrayList<ContactsInfoDto> contactsInfoDtoList = new ArrayList<ContactsInfoDto>();
        DtoHelper.eoList2DtoList((Collection)contactsInfoEoList, contactsInfoDtoList, ContactsInfoDto.class);
        return contactsInfoDtoList;
    }

    @Override
    public List<ContactsInfoDto> queryContactsInfoListByOrgInfoIdList(List<Long> orgInfoIdList) {
        ContactsInfoEo contactsInfoEo = new ContactsInfoEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (CollectionUtils.isNotEmpty(orgInfoIdList)) {
            sqlFilterList.add(SqlFilter.in((String)"org_info_id", (Object)StringUtils.join(orgInfoIdList, (String)",")));
        }
        contactsInfoEo.setSqlFilters(sqlFilterList);
        List contactsInfoEoList = this.contactsInfoDas.select((BaseEo)contactsInfoEo);
        ArrayList<ContactsInfoDto> contactsInfoDtoList = new ArrayList<ContactsInfoDto>();
        DtoHelper.eoList2DtoList((Collection)contactsInfoEoList, contactsInfoDtoList, ContactsInfoDto.class);
        return contactsInfoDtoList;
    }
}

