/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.apiimpl;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.IAccessApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleAccessDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.request.RoleCreateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.request.RoleModifyDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleAccessCreateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleAccessModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleAccessTemCreateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleAccessTemRemoveReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleGenerateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleRemoveReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleResourceRemoveReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleTemplateCreateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleTemplateModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleUserRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.biz.service.IAccessService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IBocAccessService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IRoleService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IRoleTemplateService;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Component;

@Component(value="iAccessApi")
public class AccessApiImpl
implements IAccessApi {
    @Resource
    private IRoleService roleService;
    @Resource
    private IAccessService accessService;
    @Resource
    private IRoleTemplateService roleTemplateService;
    @Resource
    private IBocAccessService bocAccessService;

    public RestResponse<Void> createRole(Long instanceId, List<RoleAccessCreateReqDto> createReqDtos) {
        this.roleService.create(instanceId, createReqDtos);
        return RestResponse.VOID;
    }

    public RestResponse<RoleDto> createRole(Long instanceId, RoleAccessCreateReqDto createReqDto) {
        return new RestResponse((Object)this.roleService.create(instanceId, createReqDto));
    }

    public RestResponse<Void> updateRoleByCode(String code, RoleModifyReqDto roleModifyReqDto) {
        this.roleService.updateRoleByCode(code, roleModifyReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> updateRole(Long roleId, RoleAccessModifyReqDto modifyReqDto) {
        this.roleService.update(roleId, modifyReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> deleteRole(List<Long> roleIdList) {
        this.roleService.deleteInBatch(roleIdList);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> deleteRoleByCode(RoleRemoveReqDto roleRemoveReqDto) {
        this.roleService.deleteRoleByCode(roleRemoveReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> giveRoleResources(Long instanceId, List<RoleAccessDto> roleAccessList) {
        this.accessService.giveRoleResource(instanceId, roleAccessList);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> addRoleResources(Long instanceId, @Valid List<RoleAccessDto> roleAccessList) {
        this.accessService.updateRoleResources(instanceId, roleAccessList);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> removeRoleResourcesRelation(List<RoleResourceRemoveReqDto> roleResourceRemoveReqDtos) {
        this.accessService.removeRoleResourcesRelation(roleResourceRemoveReqDtos);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeRoleResources(Long instanceId, List<RoleAccessDto> roleAccessList) {
        this.accessService.removeRoleResources(instanceId, roleAccessList);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> giveUserRoles(Long instanceId, Long userId, List<Long> roleIdList) {
        this.accessService.giveUserRole(instanceId, userId, roleIdList);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> addUserRoles(Long instanceId, Long userId, List<Long> roleIdList) {
        this.accessService.addUserRoles(instanceId, userId, roleIdList);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> addUserRolesByCode(Long userId, List<String> roleCodeList) {
        this.accessService.addUserRolesByCode(userId, roleCodeList);
        return RestResponse.VOID;
    }

    public RestResponse<Void> giveUserGroupRoles(Long instanceId, Long userGroupId, List<Long> roleIdList) {
        this.accessService.giveUserGroupRole(instanceId, userGroupId, roleIdList);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> addUserGroupRolesByCode(Long userGroupId, List<String> roleCodeList) {
        this.accessService.addUserGroupRolesByCode(userGroupId, roleCodeList);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeUserRoles(Long userId, String roleCodes) {
        this.accessService.removeUserRoles(userId, roleCodes);
        return RestResponse.VOID;
    }

    public RestResponse<Void> generateRole(List<RoleGenerateReqDto> roleGenerateReqDtos) {
        this.roleService.generateRole(roleGenerateReqDtos);
        return RestResponse.VOID;
    }

    public RestResponse<Void> giveRoleTemplateResource(List<RoleAccessTemCreateReqDto> roleAccessTemCreateReqDtos) {
        this.roleTemplateService.giveRoleTemplateResource(roleAccessTemCreateReqDtos);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeRoleTemplateResource(List<RoleAccessTemRemoveReqDto> roleAccessTemRemoveReqDtos) {
        this.roleTemplateService.removeRoleTemplateResource(roleAccessTemRemoveReqDtos);
        return RestResponse.VOID;
    }

    public RestResponse<Long> addRoleTemplate(RoleTemplateCreateReqDto roleTemplateCreateReqDto) {
        return new RestResponse((Object)this.roleTemplateService.addRoleTemplate(roleTemplateCreateReqDto));
    }

    public RestResponse<Void> modifyRoleTemplate(String code, RoleTemplateModifyReqDto roleTemplateModifyReqDto) {
        this.roleTemplateService.modifyRoleTemplate(code, roleTemplateModifyReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeRoleTemplate(List<String> codes) {
        this.roleTemplateService.removeRoleTemplate(codes);
        return RestResponse.VOID;
    }

    public RestResponse<Void> setRoleUserRelation(RoleUserRelationReqDto roleUserRelationReqDto) {
        this.accessService.setRoleUserRelation(roleUserRelationReqDto);
        return RestResponse.VOID;
    }

    public RestResponse grantUserRoles(@NotNull(message="\u5b9e\u4f8bID\u4e0d\u5141\u8bb8\u4e3a\u7a7a") @NotNull(message="\u5b9e\u4f8bID\u4e0d\u5141\u8bb8\u4e3a\u7a7a") Long instanceId, @NotNull(message="\u89d2\u8272ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a") @NotNull(message="\u89d2\u8272ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a") Long roleId, List<Long> userIdList) {
        this.bocAccessService.giveUserRoles(instanceId, roleId, userIdList);
        return RestResponse.VOID;
    }

    public RestResponse<Long> createRoleAndGiveResource(RoleCreateReqDto roleCreateReqDto, Long instanceId) {
        return new RestResponse((Object)this.bocAccessService.createRoleAndGiveResource(roleCreateReqDto, instanceId));
    }

    public RestResponse<Void> modifyRoleAndGiveResource(Long roleId, RoleModifyDto roleModifyDto) {
        this.bocAccessService.modifyRoleAndAddResource(roleId, roleModifyDto);
        return RestResponse.VOID;
    }
}

