/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.TenantDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.request.GiveRolesReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.request.UserModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.request.UserQueryDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.response.TenantManagerRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.response.UserRoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserInstanceRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.UserAccessVo;
import com.dtyunxi.yundt.cube.center.user.biz.condition.Criteria;
import com.dtyunxi.yundt.cube.center.user.biz.service.IAccessService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IBocUserService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IRoleService;
import com.dtyunxi.yundt.cube.center.user.biz.service.ITenantService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserAppInstanceService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.RoleDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserRoleRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdUserRoleRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BocUserServiceImpl
implements IBocUserService {
    private static Logger logger = LoggerFactory.getLogger(BocUserServiceImpl.class);
    @Resource
    private ITenantService tenantService;
    @Resource
    private IAccessService accessService;
    @Resource
    private IUserService userService;
    @Resource
    private IRoleService roleService;
    @Resource
    private RoleDas roleDas;
    @Resource
    private IContext context;
    @Resource
    private IUserAppInstanceService userAppInstanceService;
    @Resource
    private UserRoleRelationDas userRoleRelationDas;

    @Override
    public TenantManagerRespDto queryTenantOverview(Long userId) {
        UserDto userDto = this.userService.queryUser(userId);
        Long tenantId = userDto.getTenantId();
        TenantDto tenantDto = this.tenantService.queryById(tenantId);
        try {
            TenantManagerRespDto tenantManagerRespDto = new TenantManagerRespDto();
            tenantManagerRespDto.setTenantManagerAccount(userDto.getUserName());
            tenantManagerRespDto.setPhone(userDto.getPhone());
            tenantManagerRespDto.setTenantName(tenantDto.getTenantName());
            tenantManagerRespDto.setTenantCode(tenantDto.getTenantCode());
            return tenantManagerRespDto;
        }
        catch (Exception e) {
            throw new BizException("\u6570\u636e\u5b57\u6bb5\u7f3a\u5931, \u8bf7\u786e\u8ba4\u6570\u636e\u5b8c\u6574\u6027");
        }
    }

    @Override
    public void batchDelete(List<Long> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            for (Long id : ids) {
                this.userService.delete(id);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long createUserAndGiveRoles(UserDto userDto, List<GiveRolesReqDto> giveRoleReqList, List<Long> instanceIds) {
        userDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        RoleDto roleDto = this.roleService.queryRoleByCodeOrName(ServiceContext.getContext().getRequestInstanceId(), "APPMANAGER", null);
        if (roleDto != null) {
            if (null == userDto.getRoleSet()) {
                userDto.setRoleSet(new HashSet());
            }
            userDto.getRoleSet().add(roleDto);
        }
        UserEo user = this.userService.addUser(ServiceContext.getContext().getRequestInstanceId(), userDto);
        if (CollectionUtils.isNotEmpty(instanceIds)) {
            UserInstanceRelationReqDto dto = new UserInstanceRelationReqDto();
            dto.setUserId(user.getId());
            dto.setInstanceIds(instanceIds);
            this.userAppInstanceService.addUserInstanceRelationAll(dto);
        }
        for (GiveRolesReqDto giveRolesReqDto : giveRoleReqList) {
            if (!CollectionUtils.isNotEmpty((Collection)giveRolesReqDto.getRoleIdList())) continue;
            this.accessService.giveUserRole(giveRolesReqDto.getInstanceId(), user.getId(), giveRolesReqDto.getRoleIdList());
        }
        return user.getId();
    }

    @Override
    public PageInfo<UserDto> queryUser(Long tenantId, String account, String userName, String phone, String email, Integer pageNum, Integer pageSize) {
        Criteria criteria = this.getCriteria(account, userName, phone, email);
        criteria.setTenantId(tenantId);
        String filter = String.valueOf(JSONObject.toJSON((Object)criteria));
        return this.userService.queryByPage(filter, pageNum, pageSize);
    }

    private Criteria getCriteria(String account, String userName, String phone, String email) {
        Criteria criteria = new Criteria();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (StringUtils.isNotEmpty((CharSequence)account)) {
            SqlFilter accountSqlFilter = new SqlFilter();
            accountSqlFilter.setProperty("account");
            accountSqlFilter.setOperator(SqlFilter.Operator.like);
            accountSqlFilter.setValue((Object)("%" + account + "%"));
            sqlFilterList.add(accountSqlFilter);
        }
        if (StringUtils.isNotEmpty((CharSequence)userName)) {
            SqlFilter userNameSqlFilter = new SqlFilter();
            userNameSqlFilter.setProperty("userName");
            userNameSqlFilter.setOperator(SqlFilter.Operator.like);
            userNameSqlFilter.setValue((Object)("%" + userName + "%"));
            sqlFilterList.add(userNameSqlFilter);
        }
        if (StringUtils.isNotEmpty((CharSequence)phone)) {
            SqlFilter phoneSqlFilter = new SqlFilter();
            phoneSqlFilter.setProperty("phone");
            phoneSqlFilter.setOperator(SqlFilter.Operator.eq);
            phoneSqlFilter.setValue((Object)phone);
            sqlFilterList.add(phoneSqlFilter);
        }
        if (StringUtils.isNotEmpty((CharSequence)email)) {
            SqlFilter emailSqlFilter = new SqlFilter();
            emailSqlFilter.setProperty("email");
            emailSqlFilter.setOperator(SqlFilter.Operator.like);
            emailSqlFilter.setValue((Object)("%" + email + "%"));
            sqlFilterList.add(emailSqlFilter);
        }
        criteria.setFilters(sqlFilterList);
        return criteria;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyUserAndGiveRoles(Long userId, UserModifyReqDto userModifyReqDto) {
        UserDto user = this.userService.queryUser(userId);
        AssertUtil.isTrue(user != null, "\u7528\u6237\u8d26\u53f7\u4e0d\u5b58\u5728 | userId = " + userId);
        if (CollectionUtils.isNotEmpty((Collection)userModifyReqDto.getInstanceIds())) {
            UserInstanceRelationReqDto dto = new UserInstanceRelationReqDto();
            dto.setUserId(userId);
            dto.setInstanceIds(userModifyReqDto.getInstanceIds());
            this.userAppInstanceService.addUserInstanceRelation(dto);
        }
        UserDto userDto = new UserDto();
        BeanUtils.copyProperties((Object)userModifyReqDto, (Object)userDto);
        userDto.setId(userId);
        this.userService.update(userDto);
        if (CollectionUtils.isNotEmpty((Collection)userModifyReqDto.getRoleCodes())) {
            Long instanceId = this.context.instanceId();
            Long tenantId = user.getTenantId();
            logger.info("\u5f53\u524d\u5b9e\u4f8bid = " + instanceId + ", \u79df\u6237id = " + tenantId);
            UserAccessVo userAccessVo = this.accessService.queryUserAccess(instanceId, userId);
            if (CollectionUtils.isNotEmpty((Collection)userAccessVo.getRoleSet())) {
                ArrayList delRoleIds = new ArrayList();
                userAccessVo.getRoleSet().stream().forEach(r -> delRoleIds.add(r.getId()));
                this.userService.removeUserRoles(userId, delRoleIds.toArray(new Long[delRoleIds.size()]));
            }
            HashSet<RoleDto> roleSet = new HashSet<RoleDto>();
            userModifyReqDto.getRoleCodes().stream().forEach(r -> {
                RoleDto roleDto = this.roleService.queryRoleByCodeOrName(instanceId, (String)r, null);
                if (roleDto == null) {
                    logger.debug("\u89d2\u8272\u4e0d\u5b58\u5728\u6216\u4e0d\u5f52\u5c5e\u5f53\u524d\u5b9e\u4f8b\uff0c\u8df3\u8fc7.. roleCode = " + r + ", intanceId = " + instanceId);
                } else {
                    roleDto = new RoleDto();
                    roleDto.setCode(r);
                    roleSet.add(roleDto);
                }
            });
            this.userService.addUserRoles(userId, roleSet, instanceId, tenantId);
        }
        ArrayList processDtos = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)userModifyReqDto.getGiveRolesReqDtoList())) {
            processDtos.addAll(userModifyReqDto.getGiveRolesReqDtoList());
        }
        if (CollectionUtils.isNotEmpty(processDtos)) {
            for (GiveRolesReqDto giveRolesReqDto : processDtos) {
                if (CollectionUtils.isNotEmpty((Collection)giveRolesReqDto.getRoleIdList())) {
                    this.accessService.addUserRoles(giveRolesReqDto.getInstanceId(), userId, giveRolesReqDto.getRoleIdList());
                    continue;
                }
                this.accessService.deleteUserRoleRelation(userId, giveRolesReqDto.getInstanceId());
            }
        }
    }

    @Override
    public PageInfo<UserRoleDto> queryByPageAndRoleId(Long roleId, UserQueryDto userQueryReqDto, Integer pageNum, Integer pageSize) {
        UserDto userDto = new UserDto();
        CubeBeanUtils.copyProperties((Object)userDto, (Object)userQueryReqDto, (String[])new String[0]);
        Criteria criteria = this.getCriteria(userDto.getAccount(), userDto.getUserName(), userDto.getPhone(), userDto.getEmail());
        criteria.setTenantId(ServiceContext.getContext().getRequestTenantId());
        PageInfo<UserDto> userDtoPageInfo = this.userService.queryByPage(JSONObject.toJSONString((Object)criteria), pageNum, pageSize);
        ArrayList userRoleDtoList = Lists.newArrayList();
        List userDtoList = userDtoPageInfo.getList();
        if (CollectionUtils.isNotEmpty((Collection)userDtoList)) {
            List userIdList = userDtoList.stream().map(UserDto::getId).collect(Collectors.toList());
            List userRoleRelationEoList = this.userRoleRelationDas.selectByRoleIdAndUserIdList(roleId, userIdList);
            List relatedUserIdList = null;
            if (CollectionUtils.isNotEmpty((Collection)userRoleRelationEoList)) {
                relatedUserIdList = userRoleRelationEoList.stream().map(StdUserRoleRelationEo::getUserId).distinct().collect(Collectors.toList());
            }
            for (UserDto dto : userDtoList) {
                UserRoleDto userRoleDto = new UserRoleDto();
                CubeBeanUtils.copyProperties((Object)userRoleDto, (Object)dto, (String[])new String[0]);
                userRoleDto.setIsRoleRelated(Integer.valueOf(0));
                if (CollectionUtils.isNotEmpty(relatedUserIdList) && relatedUserIdList.contains(dto.getId())) {
                    userRoleDto.setIsRoleRelated(Integer.valueOf(1));
                }
                userRoleDtoList.add(userRoleDto);
            }
        }
        PageInfo dtoPageInfo = new PageInfo((List)userRoleDtoList);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, userDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        return dtoPageInfo;
    }
}

