/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.constant.BusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.user.api.constant.EnumUtils;
import com.dtyunxi.yundt.cube.center.user.api.constant.IEnum;
import com.dtyunxi.yundt.cube.center.user.api.constant.InstanceChannelEnum;
import com.dtyunxi.yundt.cube.center.user.api.constant.JumpTypeEnum;
import com.dtyunxi.yundt.cube.center.user.api.constant.TerminalTypeEnum;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppInstanceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ApplicationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.response.ApplicationQueryRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.response.UserAppInstanceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AppInstanceQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AppInstanceResourceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ApplicationQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.BizSpaceEnableInstanceReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ExternalAppQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.application.AppInstanceUserQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.application.ApplicationBatchQueryDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.AppInstanceQueryResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.AppInstanceSummaryResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.ApplicationQueryResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.BizSpaceEnableInstanceRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EnumRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.ExternalAppQueryRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.InstanceInitResourceResDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IApplicationQueryApi;
import com.dtyunxi.yundt.cube.center.user.biz.service.IApplicationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.user.biz.util.QueryUtil;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

@Component(value="applicationQueryApi")
public class ApplicationQueryApiImpl
implements IApplicationQueryApi {
    private Logger logger = LoggerFactory.getLogger(ApplicationQueryApiImpl.class);
    @Resource
    private IApplicationService applicationService;
    @Resource
    private IUserService userService;

    public RestResponse<ApplicationDto> queryById(Long applicationId, String filter) {
        ApplicationQueryReqDto reqDto = (ApplicationQueryReqDto)JSON.parseObject((String)filter, ApplicationQueryReqDto.class);
        reqDto.setId(applicationId);
        return new RestResponse((Object)this.applicationService.queryOne(reqDto));
    }

    public RestResponse<ApplicationQueryResDto> queryByCodeAndResources(String code, List<String> res) {
        return new RestResponse((Object)this.applicationService.queryByCodeAndResources(code, res));
    }

    public RestResponse<PageInfo<ApplicationDto>> queryByExample(String example, String filter, Integer pageNum, Integer pageSize) {
        filter = QueryUtil.mergeFilter(example, filter);
        return new RestResponse(this.applicationService.queryApplicationsByExample(filter, pageNum, pageSize));
    }

    public RestResponse<AppInstanceDto> queryInsById(Long instanceId, String filter) {
        return new RestResponse((Object)this.applicationService.queryInstanceOne(instanceId));
    }

    public RestResponse<InstanceInitResourceResDto> queryAppInstanceInitResource(Long instanceId, List<String> res) {
        return new RestResponse((Object)this.applicationService.queryAppInstanceInitResource(instanceId, res));
    }

    public RestResponse<AppInstanceQueryResDto> queryInsByInstanceIdAndResources(Long instanceId, Long menuId, List<String> res, String filter) {
        AppInstanceResourceDto appInstanceResourceDto = (AppInstanceResourceDto)JSON.parseObject((String)filter, AppInstanceResourceDto.class);
        if (appInstanceResourceDto == null) {
            appInstanceResourceDto = new AppInstanceResourceDto();
        }
        appInstanceResourceDto.setInstanceId(instanceId);
        appInstanceResourceDto.setMenuId(menuId);
        appInstanceResourceDto.setRes(res);
        return new RestResponse((Object)this.applicationService.queryInstanceResources(appInstanceResourceDto));
    }

    public RestResponse<AppInstanceQueryResDto> queryInstanceResources(AppInstanceResourceDto appInstanceResourceDto) {
        return new RestResponse((Object)this.applicationService.queryInstanceResources(appInstanceResourceDto));
    }

    public RestResponse<AppInstanceQueryResDto> queryInsByInstanceIdAndUserIdAndResources(Long instanceId, Long userId, List<String> res, String filter) {
        return new RestResponse((Object)this.applicationService.queryInsByInstanceIdAndUserIdAndResources(instanceId, userId, res));
    }

    public RestResponse<AppInstanceQueryResDto> queryUserResources(AppInstanceUserQueryReqDto req) {
        return new RestResponse((Object)this.applicationService.queryUserResources(req));
    }

    public RestResponse<List<AppInstanceDto>> queryAppInstanceList(String applicationId, String filter) {
        return new RestResponse(this.applicationService.queryAppInstanceListById(applicationId));
    }

    public RestResponse<Integer> countAppInstances() {
        return new RestResponse((Object)this.applicationService.countAppInstances());
    }

    public RestResponse<List<AppInstanceDto>> queryAppInstanceByTenantId(Long tenantId, String filter) {
        return new RestResponse(this.applicationService.queryAppInstanceByTenantId(tenantId));
    }

    public RestResponse<List<AppInstanceDto>> queryAppInstanceList(Long owner, String filter) {
        return new RestResponse(this.applicationService.queryAppInstanceListByUser(owner));
    }

    public RestResponse<PageInfo<AppInstanceDto>> queryInstanceByExample(String example, String filter, Integer pageNum, Integer pageSize) {
        filter = QueryUtil.mergeFilter(example, filter);
        return new RestResponse(this.applicationService.queryAppInstanceByExample(filter, pageNum, pageSize));
    }

    public RestResponse<List<AppInstanceSummaryResDto>> queryInstanceSummaries(AppInstanceQueryReqDto queryReq, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.applicationService.queryInstanceSummaries(queryReq, pageNum, pageSize));
    }

    public RestResponse<PageInfo<AppInstanceDto>> queryInstances(AppInstanceQueryReqDto queryReq, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.applicationService.queryAppInstance(queryReq, pageNum, pageSize));
    }

    public RestResponse<AppInstanceDto> queryByHostName(String key, String filter) {
        return new RestResponse((Object)this.applicationService.getInstanceBySearchKey(key));
    }

    public RestResponse<AppInstanceDto> findByHostname(String hostname) {
        return new RestResponse((Object)this.applicationService.getInstanceBySearchKey(hostname));
    }

    public RestResponse<AppInstanceDto> findByHostnameInOneTime(ApplicationBatchQueryDto applicationBatchQueryDto) {
        return new RestResponse((Object)this.applicationService.findByHostnameInOneTime(applicationBatchQueryDto));
    }

    public RestResponse<List<Long>> queryUserAuthInstanceList(Long userId) {
        return new RestResponse(this.applicationService.queryUserAuthInstanceList(userId));
    }

    public RestResponse<List<BizSpaceEnableInstanceRespDto>> queryEnableInstanceNum(BizSpaceEnableInstanceReqDto bizSpaceEnableInstanceReqDto) {
        return new RestResponse(this.applicationService.queryEnableInstanceNum(bizSpaceEnableInstanceReqDto));
    }

    public RestResponse<List<UserAppInstanceDto>> queryInstanceByTenantId(Long tenantId, Long userId) {
        this.applicationService.reqShouldFromPlatformApp();
        return new RestResponse(this.applicationService.queryInstanceByTenantId(tenantId, userId));
    }

    public RestResponse<List<ApplicationQueryRespDto>> queryAppByTenantId(Long tenantId) {
        this.applicationService.reqShouldFromPlatformApp();
        return new RestResponse(this.applicationService.queryAppByTenantId(tenantId));
    }

    public RestResponse<ExternalAppQueryRespDto> verifyExternalApp(ExternalAppQueryReqDto externalAppQueryReqDto) {
        return new RestResponse((Object)this.applicationService.verifyExternalApp(externalAppQueryReqDto));
    }

    public RestResponse<List<EnumRespDto>> queryInstanceChannel() {
        return new RestResponse((Object)EnumUtils.getEnumRespDtoList((IEnum[])InstanceChannelEnum.values()));
    }

    public RestResponse<List<EnumRespDto>> queryInstanceBusinessType() {
        return new RestResponse((Object)EnumUtils.getEnumRespDtoList((IEnum[])BusinessTypeEnum.values()));
    }

    public RestResponse<List<EnumRespDto>> queryInstanceTerminalType() {
        return new RestResponse((Object)EnumUtils.getEnumRespDtoList((IEnum[])TerminalTypeEnum.values()));
    }

    public RestResponse<List<EnumRespDto>> queryInstanceJumpType() {
        return new RestResponse((Object)EnumUtils.getEnumRespDtoList((IEnum[])JumpTypeEnum.values()));
    }

    public RestResponse<ApplicationDto> queryByIdAndResources(Long appId, String[] params, String filter) {
        return new RestResponse((Object)this.applicationService.queryByIdAndParams(appId, params));
    }

    public RestResponse<AppInstanceDto> queryInsByIdAndResources(Long instanceId, String[] params, String filter) {
        return new RestResponse((Object)this.applicationService.queryInsByIdAndParams(instanceId, params));
    }
}

