/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.limit.biz.service.IDataLimitRuleService;
import com.dtyunxi.yundt.cube.center.user.api.constant.BaseConstant;
import com.dtyunxi.yundt.cube.center.user.api.dto.AccessDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ButtonDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.MenuDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleAccessDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleAccessCreateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleAccessModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleGenerateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleRemoveReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.RoleRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.RoleUserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.exception.IExceptionEnum;
import com.dtyunxi.yundt.cube.center.user.api.exception.UserExceptionCode;
import com.dtyunxi.yundt.cube.center.user.biz.constant.RoleEnableModify;
import com.dtyunxi.yundt.cube.center.user.biz.constant.RoleTypeEnum;
import com.dtyunxi.yundt.cube.center.user.biz.exception.BizException;
import com.dtyunxi.yundt.cube.center.user.biz.service.IAbacAttrApplicationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IAccessService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IApplicationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IRoleService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.util.Collection2SqlInConditionUtil;
import com.dtyunxi.yundt.cube.center.user.biz.vo.RoleQueryVo;
import com.dtyunxi.yundt.cube.center.user.dao.das.AccessDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.AccessTemplateDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.AppInstanceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.ApplicationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.ButtonDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.GroupUserRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.MenuDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.ResourceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.RoleAccessRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.RoleAccessTemplateRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.RoleDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.RoleTemplateDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserGroupRoleRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserRoleRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AccessEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AccessTemplateEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AppInstanceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.ButtonEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.GroupUserRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.MenuEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.ResourceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RoleAccessRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RoleAccessTemplateRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RoleEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RoleTemplateEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdAppInstanceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdGroupUserRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdRoleAccessTemplateRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdRoleEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdRoleTemplateEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdUserGroupRoleRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdUserRoleRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserGroupRoleRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserRoleRelationEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class RoleServiceImpl
implements IRoleService {
    @Resource
    private RoleDas roleDas;
    @Resource
    private UserRoleRelationDas userRoleRelationDas;
    @Resource
    private UserGroupRoleRelationDas userGroupRoleRelationDas;
    @Resource
    private AccessDas accessDas;
    @Resource
    private IApplicationService applicationService;
    @Resource
    private MenuDas menuDas;
    @Resource
    private ButtonDas buttonDas;
    @Resource
    private RoleTemplateDas roleTemplateDas;
    @Resource
    private GroupUserRelationDas groupUserRelationDas;
    @Resource
    private UserDas userDas;
    @Resource
    private RoleAccessTemplateRelationDas roleAccessTemplateRelationDas;
    @Resource
    private AccessTemplateDas accessTemplateDas;
    @Resource
    private RoleAccessRelationDas roleAccessRelationDas;
    @Resource
    private AppInstanceDas appInstanceDas;
    @Resource
    private ApplicationDas applicationDas;
    @Resource
    private ResourceDas resourceDas;
    @Resource
    private IAbacAttrApplicationService abacAttrApplicationService;
    @Resource
    private IDataLimitRuleService dataLimitRuleService;
    @Resource
    private IAccessService accessService;
    private static final Logger logger = LoggerFactory.getLogger(RoleServiceImpl.class);

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void create(Long instanceId, List<RoleAccessCreateReqDto> createReqDtos) {
        RoleEo roleEo;
        Long tenantId = this.applicationService.queryTenantIdByAppInsId(instanceId);
        AssertUtil.isTrue(null != instanceId, "Application-Key\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(createReqDtos), "\u89d2\u8272\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        this.applicationService.assertAppInstanceExists(instanceId);
        Map<String, RoleEo> appRoleMap = this.getAppRoleMap(instanceId);
        ArrayList roleInsertList = Lists.newArrayList();
        HashMap customRoleIdCreateDtoMap = Maps.newHashMap();
        HashSet genCodes = Sets.newHashSet();
        for (RoleAccessCreateReqDto roleAccessCreateReqDto : createReqDtos) {
            roleEo = new RoleEo();
            DtoHelper.dto2Eo((BaseVo)roleAccessCreateReqDto, (BaseEo)roleEo);
            if (StringUtils.isBlank((CharSequence)roleEo.getCode())) {
                String code = null;
                while (code == null) {
                    code = RandomStringUtils.randomAlphabetic((int)15);
                    if (!appRoleMap.containsKey("CODE-" + code) && !genCodes.contains(code)) continue;
                    logger.debug(String.format("\u751f\u6210\u91cd\u590d\u7684[code=%s]\u5df2\u5b58\u5728\uff0c\u91cd\u65b0\u751f\u6210", code));
                    code = null;
                }
                genCodes.add(code);
                roleEo.setCode(code);
                roleAccessCreateReqDto.setCode(code);
            }
            this.checkDuplicate(appRoleMap, roleEo);
            this.checkStatus4create(roleEo);
            roleEo.setInstanceId(instanceId);
            roleEo.setIsEnableModify(RoleEnableModify.YES.getCode());
            appRoleMap.put(roleEo.getCode(), roleEo);
            appRoleMap.put(roleEo.getName(), roleEo);
            roleEo.setTenantId(tenantId);
            if (roleEo.getExtension() == null) {
                roleEo.setExtension("");
            }
            RoleTypeEnum roleTypeEnum = roleAccessCreateReqDto.getRefRoleId() == null ? RoleTypeEnum.STANDARD : RoleTypeEnum.CUSTOM;
            roleEo.setRoleType(Integer.valueOf(roleTypeEnum.getCode()));
            roleInsertList.add(roleEo);
            if (roleTypeEnum != RoleTypeEnum.CUSTOM) continue;
            customRoleIdCreateDtoMap.put(roleEo, roleAccessCreateReqDto);
        }
        this.roleDas.insertBatch((List)roleInsertList);
        for (Map.Entry entry : customRoleIdCreateDtoMap.entrySet()) {
            roleEo = (RoleEo)entry.getKey();
            RoleAccessCreateReqDto createReqDto = (RoleAccessCreateReqDto)entry.getValue();
            this.grantAccessAndDataLimitFromRefRole(roleEo.getId(), roleEo.getRefRoleId(), createReqDto.getAccessSet());
        }
    }

    private RoleEo checkStatus4create(RoleEo roleEo) {
        if (roleEo.getStatus() == null) {
            roleEo.setStatus(Integer.valueOf(1));
        } else if (roleEo.getStatus() != 1 && roleEo.getStatus() != 2) {
            throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), UserExceptionCode.REQ_PARAM_ERROR.getMsg());
        }
        return roleEo;
    }

    private Map<String, RoleEo> getAppRoleMap(Long instanceId) {
        HashMap appRoleMap = Maps.newHashMap();
        List appRoleList = this.roleDas.findByInstanceId(instanceId);
        for (RoleEo roleEo : appRoleList) {
            appRoleMap.put("CODE-" + roleEo.getCode(), roleEo);
            appRoleMap.put("NAME-" + roleEo.getName(), roleEo);
        }
        return appRoleMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RoleDto create(Long instanceId, RoleAccessCreateReqDto createReqDto) {
        AssertUtil.isTrue(null != instanceId, "Application-Key\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(createReqDto != null, "\u89d2\u8272\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        this.applicationService.assertAppInstanceExists(instanceId);
        Long tenantId = this.applicationService.queryTenantIdByAppInsId(instanceId);
        Map<String, RoleEo> appRoleMap = this.getAppRoleMap(instanceId);
        RoleEo roleEo = new RoleEo();
        DtoHelper.dto2Eo((BaseVo)createReqDto, (BaseEo)roleEo);
        if (StringUtils.isBlank((CharSequence)roleEo.getCode())) {
            String code = null;
            while (code == null) {
                code = RandomStringUtils.randomAlphabetic((int)15);
                if (!appRoleMap.containsKey("CODE-" + code)) continue;
                logger.debug(String.format("\u751f\u6210\u91cd\u590d\u7684[code=%s]\u5df2\u5b58\u5728\uff0c\u91cd\u65b0\u751f\u6210", code));
                code = null;
            }
            roleEo.setCode(code);
            createReqDto.setCode(code);
        }
        this.checkDuplicate(appRoleMap, roleEo);
        this.checkStatus4create(roleEo);
        roleEo.setInstanceId(instanceId);
        roleEo.setTenantId(tenantId);
        RoleTypeEnum roleTypeEnum = createReqDto.getRefRoleId() == null ? RoleTypeEnum.STANDARD : RoleTypeEnum.CUSTOM;
        roleEo.setRoleType(Integer.valueOf(roleTypeEnum.getCode()));
        this.roleDas.insert((BaseEo)roleEo);
        if (roleTypeEnum == RoleTypeEnum.CUSTOM) {
            this.grantAccessAndDataLimitFromRefRole(roleEo.getId(), roleEo.getRefRoleId(), createReqDto.getAccessSet());
        }
        RoleDto dto = new RoleDto();
        DtoHelper.eo2Dto((BaseEo)roleEo, (BaseVo)dto);
        return dto;
    }

    private void grantAccessAndDataLimitFromRefRole(Long roleId, Long refRoleId, Set<AccessDto> accessDtos) {
        RoleEo refRole = this.roleDas.findByIdOrElseThrow(refRoleId);
        if (!RoleTypeEnum.STANDARD.eqWithCode(refRole.getRoleType())) {
            throw new BizException("\u53ea\u6709\u6807\u51c6\u89d2\u8272\u53ef\u88ab\u5f15\u7528\uff1a" + refRoleId);
        }
        this.dataLimitRuleService.copyRoleRule(refRoleId, roleId);
        if (CollectionUtils.isEmpty(accessDtos)) {
            return;
        }
        this.accessService.updateRoleResources(roleId, accessDtos);
    }

    private void checkDuplicate(Map<String, RoleEo> appRoleMap, RoleEo roleEo) {
        String code = roleEo.getCode();
        String name = roleEo.getName();
        AssertUtil.isTrue(!appRoleMap.containsKey("CODE-" + code), "\u89d2\u8272\u7f16\u7801[" + code + "] \u5df2\u5b58\u5728");
        AssertUtil.isTrue(!appRoleMap.containsKey("NAME-" + name), "\u89d2\u8272\u540d\u79f0[" + name + "] \u5df2\u5b58\u5728");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(Long roleId, RoleAccessModifyReqDto modifyReqDto) {
        boolean standard2Custom;
        AssertUtil.isTrue(null != roleId, "ID\u4e0d\u80fd\u4e3a\u7a7a");
        RoleEo roleEo = this.roleDas.findByIdOrElseThrow(roleId);
        this.validateRoleIsEnableModify(roleEo);
        Map<String, RoleEo> appRoleMap = this.getAppRoleMap(roleEo.getInstanceId());
        String code = modifyReqDto.getCode();
        code = StringUtils.isBlank((CharSequence)code) ? roleEo.getCode() : code;
        String name = modifyReqDto.getName();
        RoleEo codeRole = appRoleMap.get("CODE-" + code);
        RoleEo nameRole = appRoleMap.get("NAME-" + name);
        boolean hCode = codeRole == null || codeRole.getId().compareTo(roleId) == 0;
        AssertUtil.isTrue(hCode, "\u89d2\u8272\u7f16\u7801[" + code + "] \u5df2\u5b58\u5728");
        boolean hName = nameRole == null || nameRole.getId().compareTo(roleId) == 0;
        AssertUtil.isTrue(hName, "\u89d2\u8272\u540d\u79f0[" + name + "] \u5df2\u5b58\u5728");
        boolean bl = standard2Custom = roleEo.getRefRoleId() == null && modifyReqDto.getRefRoleId() != null;
        if (standard2Custom) {
            throw new BizException("\u4e0d\u652f\u6301\u6807\u51c6\u89d2\u8272\u548c\u81ea\u5b9a\u4e49\u89d2\u8272\u4e4b\u95f4\u8f6c\u6362");
        }
        if (RoleTypeEnum.CUSTOM.eqWithCode(roleEo.getRoleType())) {
            if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getAccessSet())) {
                this.accessService.updateRoleResources(roleId, modifyReqDto.getAccessSet());
            }
            if (Objects.nonNull(modifyReqDto.getRefRoleId()) && modifyReqDto.getRefRoleId().longValue() != roleEo.getRefRoleId().longValue()) {
                this.dataLimitRuleService.copyRoleRule(modifyReqDto.getRefRoleId(), roleId, true);
            }
        }
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)roleEo, (String[])new String[]{"tenantId", "instanceId"});
        this.roleDas.update((BaseEo)roleEo);
    }

    @Override
    public void updateRoleByCode(String code, RoleModifyReqDto roleModifyReqDto) {
        RoleEo roleEo = new RoleEo();
        roleEo.setCode(code);
        List resultList = this.roleDas.select((BaseEo)roleEo);
        if (CollectionUtils.isEmpty((Collection)resultList) || resultList.size() > 1) {
            throw new BizException(UserExceptionCode.NON_EXIST_FAIL.getCode(), UserExceptionCode.NON_EXIST_FAIL.getMsg() + "\u6216" + UserExceptionCode.TOO_MATCH_REF.getMsg());
        }
        roleEo.setId(((RoleEo)resultList.get(0)).getId());
        this.validateRoleIsEnableModify((RoleEo)resultList.get(0));
        if (StringUtils.isNotBlank((CharSequence)roleModifyReqDto.getName())) {
            RoleEo queryEo = new RoleEo();
            queryEo.setName(roleEo.getName());
            List roleEos = this.roleDas.select((BaseEo)queryEo);
            if (CollectionUtils.isNotEmpty((Collection)roleEos) && roleEos.size() == 1 && !((RoleEo)roleEos.get(0)).getCode().equals(code)) {
                throw new BizException(UserExceptionCode.ROLE_TEMPLATE_EXIT_FAIL.getCode(), UserExceptionCode.ROLE_TEMPLATE_EXIT_FAIL.getMsg() + ":name \u9700\u552f\u4e00");
            }
        }
        DtoHelper.dto2Eo((BaseVo)roleModifyReqDto, (BaseEo)roleEo, (String[])new String[]{"code", "instanceId", "tenantId"});
        this.roleDas.updateSelective((BaseEo)roleEo);
    }

    @Override
    public void delete(Long roleId) {
        RoleEo roleEo = (RoleEo)this.roleDas.selectByPrimaryKey(roleId);
        if (null != roleEo) {
            this.validateRoleIsEnableModify(roleEo);
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        SqlFilter sqlFilter = new SqlFilter();
        sqlFilter.setValue((Object)roleId);
        sqlFilter.setProperty("roleId");
        sqlFilter.setOperator(SqlFilter.Operator.eq);
        sqlFilters.add(sqlFilter);
        UserRoleRelationEo userRoleRelationEo = new UserRoleRelationEo();
        userRoleRelationEo.setSqlFilters(sqlFilters);
        int referencedByUser = this.userRoleRelationDas.count((BaseEo)userRoleRelationEo);
        AssertUtil.isTrue(referencedByUser <= 0, (IExceptionEnum)UserExceptionCode.REFERENCED_BY_USER_ERROR);
        UserGroupRoleRelationEo userGroupRoleRelationEo = new UserGroupRoleRelationEo();
        userGroupRoleRelationEo.setSqlFilters(sqlFilters);
        int referencedByUserGroup = this.userGroupRoleRelationDas.count((BaseEo)userGroupRoleRelationEo);
        AssertUtil.isTrue(referencedByUserGroup <= 0, (IExceptionEnum)UserExceptionCode.REFERENCED_BY_USER_GROUP_ERROR);
        this.roleDas.logicDeleteById(roleId);
        this.dataLimitRuleService.logicDeleteByRoleId(roleId);
    }

    @Override
    public RoleAccessDto queryById(Long roleId) {
        RoleAccessDto roleAccessDto = new RoleAccessDto();
        RoleEo roleEo = (RoleEo)this.roleDas.selectByPrimaryKey(roleId);
        AssertUtil.isTrue(null != roleEo, "\u89d2\u8272\u4e0d\u5b58\u5728");
        List accessEoList = this.accessDas.findByRoleId(roleId);
        HashSet accessDtoSet = Sets.newHashSet();
        DtoHelper.eoList2DtoList((Collection)accessEoList, (Collection)accessDtoSet, AccessDto.class);
        this.addResource(accessDtoSet);
        roleAccessDto.setRoleId(roleId);
        roleAccessDto.setAccessSet((Set)accessDtoSet);
        return roleAccessDto;
    }

    private void addResource(Set<AccessDto> accessDtoSet) {
        HashMap<String, Long> menuCodeMapToMenuId = new HashMap<String, Long>();
        menuCodeMapToMenuId.put("-1", ResourceEo.ROOT_PARENT_ID);
        HashSet<AccessDto> notExists = new HashSet<AccessDto>();
        for (AccessDto accessDto : accessDtoSet) {
            MenuEo parent;
            Long parentId;
            if (1 == accessDto.getResourceType()) {
                MenuEo menuEo = this.menuDas.selectByInstanceIdAndCode(accessDto.getInstanceId(), accessDto.getResourceCode());
                if (menuEo == null || StringUtils.isBlank((CharSequence)menuEo.getParentCode())) {
                    notExists.add(accessDto);
                    continue;
                }
                menuCodeMapToMenuId.put(menuEo.getCode(), menuEo.getId());
                parentId = (Long)menuCodeMapToMenuId.get(menuEo.getParentCode());
                if (parentId == null) {
                    parent = this.menuDas.selectByInstanceIdAndCode(menuEo.getInstanceId(), menuEo.getParentCode());
                    if (parent == null) {
                        notExists.add(accessDto);
                        logger.warn("\u83dc\u5355\u6839\u636e\u5b9e\u4f8b{}\u548c\u7236\u7f16\u7801{}\u627e\u4e0d\u5230\u83dc\u5355", (Object)menuEo.getInstanceId(), (Object)menuEo.getParentCode());
                        continue;
                    }
                    parentId = parent.getId();
                    menuCodeMapToMenuId.put(menuEo.getParentCode(), parentId);
                }
                MenuDto menuDto = new MenuDto();
                DtoHelper.eo2Dto((BaseEo)menuEo, (BaseVo)menuDto);
                menuDto.setParentId(parentId);
                accessDto.setResourceId(menuEo.getId());
                accessDto.setMenuDto(menuDto);
                continue;
            }
            if (2 != accessDto.getResourceType()) continue;
            ButtonEo buttonEo = this.buttonDas.selectByInstanceIdAndCode(accessDto.getInstanceId(), accessDto.getResourceCode());
            if (buttonEo == null || StringUtils.isBlank((CharSequence)buttonEo.getParentCode())) {
                notExists.add(accessDto);
                continue;
            }
            parentId = (Long)menuCodeMapToMenuId.get(buttonEo.getParentCode());
            if (parentId == null) {
                parent = this.menuDas.selectByInstanceIdAndCode(buttonEo.getInstanceId(), buttonEo.getParentCode());
                if (parent == null) {
                    notExists.add(accessDto);
                    logger.warn("\u6309\u94ae\u6839\u636e\u5b9e\u4f8b{}\u548c\u7236\u7f16\u7801{}\u627e\u4e0d\u5230\u83dc\u5355", (Object)buttonEo.getInstanceId(), (Object)buttonEo.getParentCode());
                    continue;
                }
                parentId = parent.getId();
                menuCodeMapToMenuId.put(buttonEo.getParentCode(), parentId);
            }
            ButtonDto buttonDto = new ButtonDto();
            DtoHelper.eo2Dto((BaseEo)buttonEo, (BaseVo)buttonDto);
            buttonDto.setMenuId(parentId);
            accessDto.setResourceId(buttonEo.getId());
            accessDto.setButtonDto(buttonDto);
        }
        accessDtoSet.removeAll(notExists);
    }

    @Override
    public RoleDto queryRoleByRoleId(Long roleId) {
        RoleEo roleEo = (RoleEo)this.roleDas.selectByPrimaryKey(roleId);
        RoleDto roleDto = new RoleDto();
        DtoHelper.eo2Dto((BaseEo)roleEo, (BaseVo)roleDto);
        return roleDto;
    }

    @Override
    public RoleDto queryRoleByCodeOrName(Long instanceId, String code, String name) {
        List roleEoList;
        Assert.notNull((Object)instanceId, (String)"\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((StringUtils.isNotBlank((CharSequence)code) || StringUtils.isNotBlank((CharSequence)name) ? 1 : 0) != 0, (String)"\u89d2\u8272code\u4e0e\u89d2\u8272\u540d\u79f0\u81f3\u5c11\u67091\u4e2a\u4e0d\u80fd\u4e3a\u7a7a");
        RoleEo roleEo = new RoleEo();
        roleEo.setInstanceId(instanceId);
        if (StringUtils.isNotBlank((CharSequence)code)) {
            roleEo.setCode(code);
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            roleEo.setName(name);
        }
        if (CollectionUtils.isNotEmpty((Collection)(roleEoList = this.roleDas.select((BaseEo)roleEo)))) {
            RoleEo eo = (RoleEo)roleEoList.get(0);
            RoleDto roleDto = new RoleDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)roleDto);
            return roleDto;
        }
        return null;
    }

    @Override
    public PageInfo<RoleDto> queryByExample(String filter, Integer pageNumber, Integer pageSize) {
        logger.info("\u89d2\u8272\u5217\u8868\u67e5\u8be2queryByExample\uff1a{}", (Object)filter);
        RoleDto dto = new RoleDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            dto = (RoleDto)JSON.parseObject((String)JSON.toJSONString((Object)filter), RoleDto.class);
        }
        dto.setPageNum(pageNumber);
        dto.setPageSize(pageSize);
        PageInfo roleDtoPageInfo = this.roleDas.queryPageRoles(dto);
        Map map = (Map)JSONObject.parseObject((String)filter, Map.class);
        if ("true".equals(MapUtils.getString((Map)map, (Object)"countRelationUserAndGroupNum")) && roleDtoPageInfo.getList() != null) {
            List roleDtoList = roleDtoPageInfo.getList();
            for (RoleDto roleDto : roleDtoList) {
                List userEoList = this.userRoleRelationDas.selectUserByRoleId(roleDto.getId());
                int userRelationNum = 0;
                if (CollectionUtils.isNotEmpty((Collection)userEoList)) {
                    userRelationNum = (int)userEoList.stream().map(BaseEo::getId).distinct().count();
                }
                roleDto.setUserRelationNum(Integer.valueOf(userRelationNum));
                List userGroupEoList = this.userGroupRoleRelationDas.selectUserGroupByRoleId(roleDto.getId());
                int userGroupRelationNum = 0;
                if (CollectionUtils.isNotEmpty((Collection)userGroupEoList)) {
                    userGroupRelationNum = (int)userGroupEoList.stream().map(BaseEo::getId).distinct().count();
                }
                roleDto.setUserGroupRelationNum(Integer.valueOf(userGroupRelationNum));
            }
        }
        return roleDtoPageInfo;
    }

    @Override
    public RoleEo findByAppInsAndCode(Long instanceId, String code) {
        RoleEo roleEo = new RoleEo();
        roleEo.setCode(code);
        roleEo.setInstanceId(instanceId);
        List roleEoList = this.roleDas.select((BaseEo)roleEo);
        if (CollectionUtils.isNotEmpty((Collection)roleEoList)) {
            return (RoleEo)roleEoList.get(0);
        }
        return null;
    }

    @Override
    public RoleEo save(RoleDto roleDto) {
        RoleEo roleEo = new RoleEo();
        DtoHelper.dto2Eo((BaseVo)roleDto, (BaseEo)roleEo);
        roleEo.setStatus(Integer.valueOf(1));
        this.roleDas.insert((BaseEo)roleEo);
        return roleEo;
    }

    @Override
    public RoleEo findByTenant() {
        return this.roleDas.findFirstByCode("tenant");
    }

    @Override
    public RoleEo findByDeveloper() {
        return this.roleDas.findFirstByCode("developer");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteInBatch(List<Long> roleIdList) {
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(roleIdList), "roleIdList \u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>(roleIdList.size());
        SqlFilter sqlFilter = new SqlFilter();
        sqlFilter.setValue((Object)Collection2SqlInConditionUtil.transefer(roleIdList));
        sqlFilter.setProperty("roleId");
        sqlFilter.setOperator(SqlFilter.Operator.in);
        sqlFilters.add(sqlFilter);
        UserRoleRelationEo userRoleRelationEo = new UserRoleRelationEo();
        userRoleRelationEo.setSqlFilters(sqlFilters);
        int referencedByUser = this.userRoleRelationDas.count((BaseEo)userRoleRelationEo);
        AssertUtil.isTrue(referencedByUser <= 0, (IExceptionEnum)UserExceptionCode.REFERENCED_BY_USER_ERROR);
        UserGroupRoleRelationEo userGroupRoleRelationEo = new UserGroupRoleRelationEo();
        userGroupRoleRelationEo.setSqlFilters(sqlFilters);
        int referencedByUserGroup = this.userGroupRoleRelationDas.count((BaseEo)userGroupRoleRelationEo);
        AssertUtil.isTrue(referencedByUserGroup <= 0, (IExceptionEnum)UserExceptionCode.REFERENCED_BY_USER_GROUP_ERROR);
        List roleEoList = this.roleDas.queryByIds(new HashSet<Long>(roleIdList));
        roleEoList.forEach(roleEo -> {
            this.validateRoleIsEnableModify((RoleEo)roleEo);
            this.roleDas.logicDelete((BaseEo)roleEo);
            this.dataLimitRuleService.logicDeleteByRoleId(roleEo.getId());
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteRoleByCode(RoleRemoveReqDto roleRemoveReqDto) {
        Assert.notNull((Object)roleRemoveReqDto.getInstanceId(), (String)"\u5e94\u7528\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (StringUtils.isBlank((CharSequence)roleRemoveReqDto.getRodeCodes())) {
            throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), UserExceptionCode.REQ_PARAM_ERROR.getMsg());
        }
        String[] rodeCodeList = StringUtils.split((String)roleRemoveReqDto.getRodeCodes(), (String)",");
        if (rodeCodeList.length > 0) {
            List roleEos = this.roleDas.selectByCodeList(new HashSet<String>(Arrays.asList(rodeCodeList)), roleRemoveReqDto.getInstanceId());
            if (CollectionUtils.isNotEmpty((Collection)roleEos) && rodeCodeList.length == roleEos.size()) {
                List roleIds = roleEos.stream().map(StdRoleEo::getId).collect(Collectors.toList());
                List userRoleRelationIdEos = this.userRoleRelationDas.selectByRodeIdList(roleIds);
                List userRoleRelationCodeEos = this.userRoleRelationDas.selectByRodeCodeList(Arrays.asList(rodeCodeList), roleRemoveReqDto.getInstanceId());
                AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)userRoleRelationIdEos), UserExceptionCode.REFERENCED_BY_USER_ERROR.getMsg());
                AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)userRoleRelationCodeEos), UserExceptionCode.REFERENCED_BY_USER_ERROR.getMsg());
                List userGroupRoleRelationIdEos = this.userGroupRoleRelationDas.selectByRodeIdList(roleIds);
                List userGroupRoleRelationCodeEos = this.userGroupRoleRelationDas.selectByRodeCodeList(Arrays.asList(rodeCodeList), roleRemoveReqDto.getInstanceId());
                AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)userGroupRoleRelationIdEos), UserExceptionCode.REFERENCED_BY_USER_ERROR.getMsg());
                AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)userGroupRoleRelationCodeEos), UserExceptionCode.REFERENCED_BY_USER_ERROR.getMsg());
                for (RoleEo r : roleEos) {
                    this.validateRoleIsEnableModify(r);
                    this.roleDas.logicDelete((BaseEo)r);
                    this.dataLimitRuleService.logicDeleteByRoleId(r.getId());
                }
            }
        } else {
            throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), UserExceptionCode.REQ_PARAM_ERROR.getMsg());
        }
    }

    @Override
    public List<RoleDto> queryByUserId(Long userId) {
        List<UserRoleRelationEo> roleRelationEos = this.abacAttrApplicationService.getUserRoleRelationByUserAttr(userId, null);
        if (CollectionUtils.isEmpty(roleRelationEos)) {
            return new ArrayList<RoleDto>();
        }
        Set roleIds = roleRelationEos.stream().map(StdUserRoleRelationEo::getRoleId).collect(Collectors.toSet());
        List roleEos = this.roleDas.queryByIds(roleIds);
        ArrayList roleDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)roleEos, (Collection)roleDtos, RoleDto.class);
        return roleDtos;
    }

    @Override
    public List<RoleDto> queryByUserIdAndInstanceId(Long userId, Long instanceId) {
        Set roleIdSet = this.abacAttrApplicationService.getUserRoleRelationByUserAttr(userId, instanceId).stream().filter(c -> c.getRoleId() != null).map(StdUserRoleRelationEo::getRoleId).collect(Collectors.toSet());
        List roleEos = this.roleDas.queryByIds(roleIdSet);
        ArrayList roleDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)roleEos, (Collection)roleDtos, RoleDto.class);
        return roleDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generateRole(List<RoleGenerateReqDto> roleGenerateReqDtos) {
        this.checkParam(roleGenerateReqDtos);
        for (RoleGenerateReqDto roleGenerateReqDto : roleGenerateReqDtos) {
            Set<String> roleTemCodes = this.checkRoleTemCode(roleGenerateReqDto);
            if (!CollectionUtils.isNotEmpty(roleTemCodes)) continue;
            List roleTemplateEos = this.roleTemplateDas.selectByCodeList(roleTemCodes);
            for (RoleTemplateEo roleTemplateEo : roleTemplateEos) {
                RoleEo roleEo = new RoleEo();
                CubeBeanUtils.copyProperties((Object)roleEo, (Object)roleTemplateEo, (String[])new String[]{"id"});
                roleEo.setUpdateTime(null);
                roleEo.setCreateTime(null);
                roleEo.setInstanceId(roleGenerateReqDto.getAppInstanceId());
                roleEo.setTenantId(roleGenerateReqDto.getTenantId());
                this.roleDas.insert((BaseEo)roleEo);
                RoleAccessRelationEo roleAccessRelationEo = new RoleAccessRelationEo();
                roleAccessRelationEo.setRoleId(roleEo.getId());
                roleAccessRelationEo.setRoleCode(roleEo.getCode());
                RoleAccessTemplateRelationEo roleAccessTemplateRelationEo = new RoleAccessTemplateRelationEo();
                roleAccessTemplateRelationEo.setRoleTemplateCode(roleTemplateEo.getCode());
                List roleAccessTemplateRelationEos = this.roleAccessTemplateRelationDas.select((BaseEo)roleAccessTemplateRelationEo);
                Set accessTemlateCodes = roleAccessTemplateRelationEos.stream().filter(r -> r.getAccessTemplateCode() != null).map(StdRoleAccessTemplateRelationEo::getAccessTemplateCode).collect(Collectors.toSet());
                if (!CollectionUtils.isNotEmpty(accessTemlateCodes)) continue;
                List accessTemplateEos = this.accessTemplateDas.selectByCodeList(accessTemlateCodes);
                for (AccessTemplateEo templateEo : accessTemplateEos) {
                    ResourceEo resourceEo = new ResourceEo();
                    resourceEo.setCode(templateEo.getResourceCode());
                    List resourceEos = this.resourceDas.select((BaseEo)resourceEo);
                    if (!CollectionUtils.isNotEmpty((Collection)resourceEos) || resourceEos.size() != 1) continue;
                    ResourceEo resourceInsertEo = (ResourceEo)resourceEos.get(0);
                    AccessEo accessEo = new AccessEo();
                    CubeBeanUtils.copyProperties((Object)accessEo, (Object)templateEo, (String[])new String[]{"id"});
                    accessEo.setResourceCode(resourceInsertEo.getCode());
                    accessEo.setResourceType(resourceInsertEo.getType());
                    accessEo.setInstanceId(roleGenerateReqDto.getAppInstanceId());
                    accessEo.setTenantId(roleGenerateReqDto.getTenantId());
                    this.accessDas.insert((BaseEo)accessEo);
                    roleAccessRelationEo.setAccessId(accessEo.getId());
                    roleAccessRelationEo.setAccessCode(accessEo.getCode());
                    roleAccessRelationEo.setInstanceId(roleGenerateReqDto.getAppInstanceId());
                    roleAccessRelationEo.setTenantId(roleGenerateReqDto.getTenantId());
                    roleAccessRelationEo.setId(null);
                    this.roleAccessRelationDas.insert((BaseEo)roleAccessRelationEo);
                }
            }
        }
    }

    private void checkParam(List<RoleGenerateReqDto> roleGenerateReqDtos) {
        List applicationEos;
        List appInstanceEos;
        Set appInstanceIds = roleGenerateReqDtos.stream().filter(r -> r.getAppInstanceId() != null).map(RoleGenerateReqDto::getAppInstanceId).collect(Collectors.toSet());
        Set appInstanceCodes = roleGenerateReqDtos.stream().filter(r -> r.getAppInstanceCode() != null).map(RoleGenerateReqDto::getAppInstanceCode).collect(Collectors.toSet());
        Set applicationIds = roleGenerateReqDtos.stream().filter(r -> r.getApplicationId() != null).map(RoleGenerateReqDto::getApplicationId).collect(Collectors.toSet());
        Set applicationCodes = roleGenerateReqDtos.stream().filter(r -> r.getApplicationCode() != null).map(RoleGenerateReqDto::getApplicationCode).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(appInstanceIds) && CollectionUtils.isNotEmpty((Collection)(appInstanceEos = this.appInstanceDas.selectByIdList(appInstanceIds))) && appInstanceEos.size() != appInstanceIds.size()) {
            throw new BizException(UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getCode(), UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getMsg());
        }
        if (CollectionUtils.isNotEmpty(appInstanceCodes) && CollectionUtils.isNotEmpty((Collection)(appInstanceEos = this.appInstanceDas.selectByCodeList(appInstanceCodes))) && appInstanceEos.size() != appInstanceCodes.size()) {
            throw new BizException(UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getCode(), UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getMsg());
        }
        if (CollectionUtils.isNotEmpty(applicationIds) && CollectionUtils.isNotEmpty((Collection)(applicationEos = this.applicationDas.selectByIdList(applicationIds))) && applicationEos.size() != applicationIds.size()) {
            throw new BizException(UserExceptionCode.NON_EXIST_FAIL.getCode(), UserExceptionCode.NON_EXIST_FAIL.getMsg());
        }
        if (CollectionUtils.isNotEmpty(applicationCodes) && CollectionUtils.isNotEmpty((Collection)(applicationEos = this.applicationDas.selectByCodeList(applicationCodes))) && applicationEos.size() != applicationCodes.size()) {
            throw new BizException(UserExceptionCode.NON_EXIST_FAIL.getCode(), UserExceptionCode.NON_EXIST_FAIL.getMsg());
        }
    }

    private Set<String> checkRoleTemCode(RoleGenerateReqDto roleGenerateReqDto) {
        List roleEos;
        Set<String> roleTemCodes = null;
        if (CollectionUtils.isNotEmpty((Collection)roleGenerateReqDto.getRoleTemplateCodes())) {
            roleTemCodes = new HashSet<String>(roleGenerateReqDto.getRoleTemplateCodes());
        } else {
            RoleTemplateEo roleTemplateEo = new RoleTemplateEo();
            roleTemplateEo.setApplicationId(roleGenerateReqDto.getApplicationId());
            roleTemplateEo.setApplicationCode(roleGenerateReqDto.getApplicationCode());
            List roleTemplateEos = this.roleTemplateDas.select((BaseEo)roleTemplateEo);
            if (CollectionUtils.isEmpty((Collection)roleTemplateEos)) {
                return roleTemCodes;
            }
            roleTemCodes = roleTemplateEos.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getCode())).map(StdRoleTemplateEo::getCode).collect(Collectors.toSet());
        }
        if (CollectionUtils.isNotEmpty(roleTemCodes) && CollectionUtils.isNotEmpty((Collection)(roleEos = this.roleDas.selectByCodeList(roleTemCodes, roleGenerateReqDto.getAppInstanceId()))) && roleEos.size() > 0) {
            throw new BizException(UserExceptionCode.EXIST_FAIL.getCode(), UserExceptionCode.EXIST_FAIL.getMsg() + "code\u5df2\u5b58\u5728");
        }
        return roleTemCodes;
    }

    @Override
    public RoleUserRespDto queryRoleUser(String code) {
        RoleUserRespDto roleUserRespDto = new RoleUserRespDto();
        roleUserRespDto.setRoleCode(code);
        RoleEo roleEo = new RoleEo();
        roleEo.setCode(code);
        List roleEos = this.roleDas.select((BaseEo)roleEo);
        if (CollectionUtils.isNotEmpty((Collection)roleEos)) {
            if (roleEos.size() > 1) {
                throw new BizException(UserExceptionCode.TOO_MATCH_REF.getCode(), UserExceptionCode.TOO_MATCH_REF.getMsg());
            }
            Long roleId = ((RoleEo)roleEos.get(0)).getId();
            UserRoleRelationEo userRoleRelationEo = new UserRoleRelationEo();
            userRoleRelationEo.setRoleId(roleId);
            List userRoleRelationEos = this.userRoleRelationDas.select((BaseEo)userRoleRelationEo);
            UserGroupRoleRelationEo userGroupRoleRelationEo = new UserGroupRoleRelationEo();
            userGroupRoleRelationEo.setRoleId(roleId);
            List userGroupRoleRelationEos = this.userGroupRoleRelationDas.select((BaseEo)userGroupRoleRelationEo);
            HashSet userIds = new HashSet();
            if (CollectionUtils.isNotEmpty((Collection)userRoleRelationEos)) {
                userIds.addAll(userRoleRelationEos.stream().map(StdUserRoleRelationEo::getUserId).collect(Collectors.toSet()));
            }
            if (CollectionUtils.isNotEmpty((Collection)userGroupRoleRelationEos)) {
                Set userGroupIds = userGroupRoleRelationEos.stream().map(StdUserGroupRoleRelationEo::getUserGroupId).collect(Collectors.toSet());
                GroupUserRelationEo groupUserRelationEo = new GroupUserRelationEo();
                ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
                sqlFilters.add(SqlFilter.in((String)"user_group_id", (Object)StringUtils.join(userGroupIds, (String)",")));
                groupUserRelationEo.setSqlFilters(sqlFilters);
                List groupUserRelationEos = this.groupUserRelationDas.select((BaseEo)groupUserRelationEo);
                userIds.addAll(groupUserRelationEos.stream().map(StdGroupUserRelationEo::getUserId).collect(Collectors.toSet()));
            }
            if (CollectionUtils.isNotEmpty(userIds)) {
                ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
                sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(userIds, (String)",")));
                UserEo userEo = new UserEo();
                userEo.setSqlFilters(sqlFilters);
                List userEos = this.userDas.select((BaseEo)userEo);
                ArrayList userRespDtos = new ArrayList();
                DtoHelper.eoList2DtoList((Collection)userEos, userRespDtos, UserRespDto.class);
                roleUserRespDto.setUserRespDtos(userRespDtos);
            }
        }
        return roleUserRespDto;
    }

    @Override
    public RoleRespDto queryRoleByCode(String code) {
        RoleRespDto roleRespDto = new RoleRespDto();
        RoleEo roleEo = new RoleEo();
        roleEo.setCode(code);
        List roleEos = this.roleDas.select((BaseEo)roleEo);
        if (CollectionUtils.isNotEmpty((Collection)roleEos)) {
            DtoHelper.eo2Dto((BaseEo)((BaseEo)roleEos.get(0)), (BaseVo)roleRespDto);
        }
        return roleRespDto;
    }

    @Override
    public RoleEo queryRole(Long tenantId, String appCode, String roleCode) {
        AppInstanceEo instanceEo = this.applicationService.queryInstanceByCode(tenantId, appCode);
        if (instanceEo == null) {
            throw new BizException(UserExceptionCode.NON_EXIST_FAIL.getCode(), "\u79df\u6237:" + tenantId + "\u672a\u5f00\u901a\u5e94\u7528:appCode=" + appCode);
        }
        RoleEo queryEo = new RoleEo();
        queryEo.setCode(roleCode);
        queryEo.setInstanceId(instanceEo.getId());
        List list = this.roleDas.select((BaseEo)queryEo, Integer.valueOf(0), Integer.valueOf(1));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return (RoleEo)list.get(0);
        }
        return null;
    }

    private void validateRoleIsEnableModify(RoleEo roleEo) {
        Assert.isTrue((boolean)BaseConstant.TRUE.equals(roleEo.getIsEnableModify()), (String)UserExceptionCode.ROLE_MSG_DISABLE_MODIFY.getMsg());
    }

    @Override
    public List<RoleEo> queryByInstanceIds(Set<Long> instanceIds) {
        if (CollectionUtils.isNotEmpty(instanceIds)) {
            RoleEo roleEo = new RoleEo();
            roleEo.setStatus(Integer.valueOf(1));
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"instance_id", (Object)StringUtils.join(instanceIds, (String)",")));
            roleEo.setSqlFilters(sqlFilters);
            return this.roleDas.select((BaseEo)roleEo);
        }
        return null;
    }

    @Override
    public List<RoleEo> queryByIds(Set<Long> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            RoleEo roleEo = this.getRoleEo(ids, null);
            return this.roleDas.select((BaseEo)roleEo);
        }
        return null;
    }

    @Override
    public List<RoleQueryVo> queryRoleAndAppInstanceByIds(Set<Long> ids) {
        RoleEo roleEo;
        List roleEoList;
        if (CollectionUtils.isNotEmpty(ids) && CollectionUtils.isNotEmpty((Collection)(roleEoList = this.roleDas.select((BaseEo)(roleEo = this.getRoleEo(ids, null)))))) {
            return this.getRoleQueryVos(roleEoList);
        }
        return null;
    }

    private RoleEo getRoleEo(Set<Long> ids, String name) {
        RoleEo roleEo = new RoleEo();
        roleEo.setStatus(Integer.valueOf(1));
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ids, (String)",")));
        if (StringUtils.isNotBlank((CharSequence)name)) {
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + name + "%")));
        }
        roleEo.setSqlFilters(sqlFilters);
        return roleEo;
    }

    private List<RoleQueryVo> getRoleQueryVos(List<RoleEo> roleEoList) {
        ArrayList voList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)voList, roleEoList, RoleQueryVo.class);
        Set instanceIds = roleEoList.stream().map(BaseEo::getInstanceId).collect(Collectors.toSet());
        List appInstanceEoList = this.appInstanceDas.selectByIdList(instanceIds);
        if (CollectionUtils.isNotEmpty((Collection)appInstanceEoList)) {
            Map<Long, String> map = appInstanceEoList.stream().collect(Collectors.toMap(BaseEo::getId, StdAppInstanceEo::getAppInsName));
            voList.forEach(vo -> vo.setAppInsName((String)map.get(vo.getInstanceId())));
        }
        return voList;
    }

    @Override
    public PageInfo<RoleQueryVo> queryRoleAndAppInstanceByIds(Set<Long> ids, String name, Integer pageNum, Integer pageSize) {
        if (CollectionUtils.isNotEmpty(ids)) {
            RoleEo roleEo = this.getRoleEo(ids, name);
            PageInfo roleEoPageInfo = this.roleDas.selectPage((BaseEo)roleEo, pageNum, pageSize);
            return this.getRoleQueryVoPageInfo((PageInfo<RoleEo>)roleEoPageInfo);
        }
        return null;
    }

    private PageInfo<RoleQueryVo> getRoleQueryVoPageInfo(PageInfo<RoleEo> roleEoPageInfo) {
        if (roleEoPageInfo != null && CollectionUtil.isNotEmpty((Collection)roleEoPageInfo.getList())) {
            List<RoleQueryVo> voList = this.getRoleQueryVos(roleEoPageInfo.getList());
            PageInfo voPageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)voPageInfo, roleEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            voPageInfo.setList(voList);
            return voPageInfo;
        }
        return null;
    }

    @Override
    public PageInfo<RoleQueryVo> queryRoleAndAppInstanceNotInIds(Set<Long> ids, RoleEo roleEo, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List eoList = this.roleDas.selectNotInIds(roleEo, ids);
        PageInfo roleEoPageInfo = new PageInfo(eoList);
        return this.getRoleQueryVoPageInfo((PageInfo<RoleEo>)roleEoPageInfo);
    }

    @Override
    public List<RoleEo> queryByTenantId(Long tenantId) {
        RoleEo roleEo = new RoleEo();
        roleEo.setStatus(Integer.valueOf(1));
        roleEo.setTenantId(tenantId);
        return this.roleDas.select((BaseEo)roleEo, Integer.valueOf(1), Integer.valueOf(1000));
    }
}

