/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.data.limit.biz.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RegexUtil {
    private static final Pattern VAR_PATTERN = Pattern.compile("(?<=\\#\\{).*?(?=\\})");
    private static final Pattern RULE_ID_PATTERN = Pattern.compile("(?<=\\{rule\\:).*?(?=\\})");
    private static final Pattern EXPRESSION_GROUP_PATTERN = Pattern.compile("(?<=\\[).*?(?=\\])");
    private static final Pattern JOIN_PATTERN = Pattern.compile("(?<=JOIN_START).*?(?=JOIN_END)");
    private static final Pattern SYSTEM_DEFAULT_PATTERN = Pattern.compile("(?<=SYSTEM_START).*?(?=SYSTEM_END)");
    private static final Pattern FUN_PATTERN = Pattern.compile("(?<=FUN_START).*?(?=FUN_END)");
    private static final Pattern FUN_PARAM_PATTERN = Pattern.compile("(?<=\\().*?(?=\\))");

    public static List<String> getVarCodeList(String str) {
        return RegexUtil.getMatcherList(str, VAR_PATTERN);
    }

    public static List<Long> getRuleIdList(String str) {
        ArrayList ruleIdList = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            Matcher matcher = RULE_ID_PATTERN.matcher(str);
            while (matcher.find()) {
                ruleIdList.add(Long.valueOf(matcher.group()));
            }
        }
        return ruleIdList;
    }

    public static List<String> getExpressionGroupList(String str) {
        return RegexUtil.getMatcherList(str, EXPRESSION_GROUP_PATTERN);
    }

    public static List<String> getRefList(String str) {
        return RegexUtil.getMatcherList(str, JOIN_PATTERN);
    }

    public static List<String> getSystemDefaultList(String str) {
        return RegexUtil.getMatcherList(str, SYSTEM_DEFAULT_PATTERN);
    }

    public static List<String> getFunList(String str) {
        return RegexUtil.getMatcherList(str, FUN_PATTERN);
    }

    public static List<String> getFunParamList(String str) {
        return RegexUtil.getMatcherList(str, FUN_PARAM_PATTERN);
    }

    private static List<String> getMatcherList(String str, Pattern pattern) {
        ArrayList list = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            Matcher matcher = pattern.matcher(str);
            while (matcher.find()) {
                list.add(matcher.group());
            }
        }
        return list;
    }
}

