/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.AddressDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppInstanceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RelationInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.TenantDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserBatchQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserEmployeeQueryRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserGroupDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.request.UserQueryDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.response.TenantManagerRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.response.UserRoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AddressQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.BindingsQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.PrivateTenantReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ThirdBindingQueryReq;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserByLoginNameTypeQueryDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.BindingsQueryRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.UserVo;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.cube.center.user.biz.exception.BizException;
import com.dtyunxi.yundt.cube.center.user.biz.service.IApplicationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IBocUserService;
import com.dtyunxi.yundt.cube.center.user.biz.service.ITenantService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserAppInstanceService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserGroupService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserRelationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.util.QueryUtil;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;

@Component(value="userQueryApi")
public class UserQueryApiImpl
implements IUserQueryApi {
    @Autowired
    private IUserService userService;
    @Autowired
    private IUserGroupService userGroupService;
    @Autowired
    private ITenantService tenantService;
    @Autowired
    private IApplicationService applicationService;
    @Autowired
    private IUserRelationService userRelationService;
    @Resource
    private IBocUserService bocUserService;
    @Resource
    private IUserAppInstanceService userAppInstanceService;
    @Resource
    private IContext context;

    public RestResponse<PageInfo<UserRespDto>> query(UserBatchQueryReqDto userBatchQueryReqDto, Integer pageNum, Integer pageSize) {
        Long tenantId;
        UserEo queryEo = new UserEo();
        DtoHelper.dto2EoWithSqlFilter((BaseVo)userBatchQueryReqDto, (BaseEo)queryEo);
        if (userBatchQueryReqDto.getInstanceId() != null) {
            boolean platformAppReqing = this.applicationService.isGlobalInstance(ServiceContext.getContext().getRequestInstanceId());
            if (platformAppReqing) {
                queryEo.setInstanceId(userBatchQueryReqDto.getInstanceId());
            } else {
                queryEo.setInstanceId(null);
            }
        }
        if ((tenantId = ServiceContext.getContext().getRequestTenantId()) == null) {
            throw new BizException("", "\u7f3a\u5c11\u79df\u6237\u4fe1\u606f");
        }
        queryEo.setTenantId(tenantId);
        PageInfo<UserEo> eoPageInfo = this.userService.query(queryEo, pageNum, pageSize);
        ArrayList respDtoList = new ArrayList();
        if (null != eoPageInfo && CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            List userEos = eoPageInfo.getList();
            DtoHelper.eoList2DtoList((Collection)userEos, respDtoList, UserRespDto.class);
        }
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        dtoPageInfo.setList(respDtoList);
        return new RestResponse((Object)dtoPageInfo);
    }

    public RestResponse<UserDto> queryByLoginStr(String loginStr, Long instanceId, String filter) {
        UserDto userDto = this.userService.queryByLoginStr(loginStr, instanceId, filter);
        return new RestResponse((Object)userDto);
    }

    public RestResponse<UserDto> queryByLoginNameAndType(String loginName, Integer loginNameType, Long tenantId, Long instanceId) {
        UserDto userDto = this.userService.queryByLoginNameAndType(loginName, loginNameType, tenantId, instanceId, null);
        return new RestResponse((Object)userDto);
    }

    public RestResponse<UserDto> queryByLoginNameAndType(UserByLoginNameTypeQueryDto userByLoginNameTypeQueryDto) {
        String domain = userByLoginNameTypeQueryDto.getDomain();
        if (StringUtils.isBlank((CharSequence)domain) && null != userByLoginNameTypeQueryDto.getExtFields() && null != userByLoginNameTypeQueryDto.getExtFields().get("domain")) {
            domain = (String)userByLoginNameTypeQueryDto.getExtFields().get("domain");
        }
        Long instanceId = userByLoginNameTypeQueryDto.getInstanceId() == null ? this.context.instanceId() : userByLoginNameTypeQueryDto.getInstanceId();
        Long tenantId = userByLoginNameTypeQueryDto.getTenantId() == null ? this.context.tenantId() : userByLoginNameTypeQueryDto.getTenantId();
        UserDto userDto = this.userService.queryByLoginNameAndType(userByLoginNameTypeQueryDto.getLoginName(), userByLoginNameTypeQueryDto.getLoginNameType(), tenantId, instanceId, domain, userByLoginNameTypeQueryDto.getPassword());
        return new RestResponse((Object)userDto);
    }

    public RestResponse<UserDto> queryByPhone(String phone, String filter) {
        UserDto userDto = this.userService.queryByPhone(phone, filter);
        return new RestResponse((Object)userDto);
    }

    public RestResponse<UserDto> queryById(Long userId, String filter) {
        return new RestResponse((Object)this.userService.queryUser(userId));
    }

    public RestResponse<UserDto> queryById() {
        Long userId = ServiceContext.getContext().getRequestUserId();
        AssertUtil.isTrue(userId != null, "\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        return new RestResponse((Object)this.userService.queryUser(userId));
    }

    public RestResponse<UserVo> queryByIdAndResource(Long userId, String[] res, String filter) {
        return new RestResponse((Object)this.userService.queryUserByIdAndRes(userId, res, filter));
    }

    public RestResponse<PageInfo<UserDto>> queryByExample(String example, String filter, Integer pageNum, Integer pageSize) {
        filter = QueryUtil.mergeFilter(example, filter);
        return new RestResponse(this.userService.queryPage(filter, pageNum, pageSize));
    }

    public RestResponse<PageInfo<UserDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.userService.queryByPage(filter, pageNum, pageSize));
    }

    public RestResponse<PageInfo<TenantDto>> queryTenantByExample(String example, String filter, Integer pageNum, Integer pageSize) {
        filter = QueryUtil.mergeFilter(example, filter);
        return new RestResponse(this.tenantService.queryByPage(filter, pageNum, pageSize));
    }

    public RestResponse<TenantDto> queryTenantByUserId(Long userId) {
        return new RestResponse((Object)this.tenantService.queryByUserId(userId));
    }

    public RestResponse<TenantDto> queryPrivateTenant(PrivateTenantReqDto privateTenantReqDto) {
        Long userId = privateTenantReqDto.getUserId();
        if (userId == null) {
            userId = this.context.userId();
        }
        AssertUtil.isTrue(null != userId, "\u7528\u6237\u672a\u767b\u5f55");
        UserDto userDto = this.userService.queryUser(userId);
        AssertUtil.isTrue(null != userDto, "\u7528\u6237\u4e0d\u5b58\u5728");
        Long tenantId = userDto.getTenantId();
        AssertUtil.isTrue(null != tenantId && tenantId != -1L, "\u7528\u6237\u4fe1\u606f\u5f02\u5e38\uff1a\u65e0\u5f52\u5c5e\u79df\u6237");
        if (tenantId < 10L) {
            return this.queryTenantByUserId(userId);
        }
        return this.queryTenantById(tenantId);
    }

    public RestResponse<TenantDto> queryTenantById(Long tenantId) {
        return new RestResponse((Object)this.tenantService.queryById(tenantId));
    }

    public RestResponse<TenantDto> queryTenantByInstanceId(Long instanceId) {
        return new RestResponse((Object)this.tenantService.queryTenantByInstanceId(instanceId));
    }

    public RestResponse<PageInfo<UserDto>> queryByRoleCode(String roleCode, String example, String filter, Integer pageNum, Integer pageSize) {
        filter = QueryUtil.mergeFilter(example, filter);
        return new RestResponse(this.userService.findByRoleCode(filter, roleCode, pageNum, pageSize));
    }

    public RestResponse<List<UserDto>> queryByIdList(String ids, String filter) {
        return new RestResponse(this.userService.queryByIdList(ids));
    }

    public RestResponse<UserDto> queryBindingUser(@PathVariable(value="openId") String openId, @PathVariable(value="thirdparyType") Integer thirdparyType) {
        return new RestResponse((Object)this.userService.queryBindingUser(openId, thirdparyType));
    }

    public RestResponse<PageInfo<RelationInfoDto>> queryRelationInfo(String filter, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.userRelationService.queryRelationInfo(filter, pageNum, pageSize));
    }

    public RestResponse<UserDto> queryBindingUserMultiInstanceTenant(String openId, Integer thirdparyType, String filter) {
        JSONObject jsonObj = JSON.parseObject((String)filter);
        return new RestResponse((Object)this.userService.queryBindingUserMultiInstanceTenant(openId, thirdparyType, jsonObj.getLong("instanceId"), jsonObj.getLong("tenantId")));
    }

    public RestResponse<UserDto> queryBindingUserByThirdId(String filter) {
        ThirdBindingQueryReq queryReq = (ThirdBindingQueryReq)JSON.parseObject((String)filter, ThirdBindingQueryReq.class);
        return new RestResponse((Object)this.userService.queryBindingUserByThirdId(queryReq));
    }

    public RestResponse<List<BindingsQueryRespDto>> queryBindingByUserId(BindingsQueryReqDto bindingsQueryReqDto) {
        return new RestResponse(this.userService.queryBindingByUserId(bindingsQueryReqDto));
    }

    public RestResponse<PageInfo<UserGroupDto>> queryUserGroupByPage(String filter, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.userGroupService.queryByPage(filter, pageNum, pageSize));
    }

    public RestResponse<List<UserGroupDto>> findUserGroupOfUser(Long userId) {
        return new RestResponse(this.userGroupService.findUserGroupOfUser(userId));
    }

    public RestResponse<List<UserGroupDto>> queryByGroupType(Integer type, Long tenantId) {
        return new RestResponse(this.userGroupService.queryByGroupType(type, tenantId));
    }

    public RestResponse<List<UserRespDto>> queryUserByGroupType(Integer type, Long tenantId) {
        return new RestResponse(this.userService.queryByGroupType(type, tenantId));
    }

    public RestResponse<PageInfo<UserEmployeeQueryRespDto>> queryPageByUserAndEmployeeInfo(String filter, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.userService.queryPageByUserAndEmployeeInfo(filter, pageNum, pageSize));
    }

    public RestResponse<List<UserRespDto>> queryUserByGroupId(Long userGroupId) {
        return new RestResponse(this.userService.queryUserByGroupId(userGroupId));
    }

    public RestResponse<PageInfo<UserRoleDto>> queryByPageAndRoleId(@NotNull(message="\u89d2\u8272ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a") @NotNull(message="\u89d2\u8272ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a") Long roleId, UserQueryDto userQueryDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.bocUserService.queryByPageAndRoleId(roleId, userQueryDto, pageNum, pageSize));
    }

    public RestResponse<PageInfo<UserRoleDto>> queryNotRelateRoleUser(Long roleId, UserQueryDto userQueryDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.userService.queryNotRelateRoleUser(roleId, userQueryDto, pageNum, pageSize));
    }

    public RestResponse<PageInfo<UserDto>> queryUser(Long tenantId, String account, String userName, String phone, String email, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.bocUserService.queryUser(tenantId, account, userName, phone, email, pageNum, pageSize));
    }

    public RestResponse<TenantManagerRespDto> queryTenantOverview(Long userId) {
        return new RestResponse((Object)this.bocUserService.queryTenantOverview(userId));
    }

    public RestResponse<PageInfo<AddressDto>> queryAddress(AddressQueryReqDto addressQueryReqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.userService.queryAddress(addressQueryReqDto, pageNum, pageSize));
    }

    public RestResponse<PageInfo<AppInstanceDto>> queryUserInstanceRelation(Long userId, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.userAppInstanceService.queryUserInstanceRelation(userId, pageNum, pageSize));
    }

    public RestResponse<Boolean> isNeedModifyPassword(Long userId) {
        return new RestResponse((Object)this.userService.isNeedModifyPassword(userId));
    }

    public RestResponse<AddressDto> queryDefaultAddress(Long userId) {
        return new RestResponse((Object)this.userService.queryDefaultAddress(userId));
    }

    public RestResponse<PageInfo<AddressDto>> queryUserAddress(AddressQueryReqDto addressQueryReqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.userService.queryUserAddress(addressQueryReqDto, pageNum, pageSize));
    }
}

