/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.codec.Coder;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.ExceptionCode;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.TwoTuple;
import com.dtyunxi.yundt.cube.center.func.api.IBizSpaceApi;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizSpaceAppInstanceRelationReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizSpaceQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizSpaceRespDto;
import com.dtyunxi.yundt.cube.center.func.api.query.IBizSpaceQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.constant.InstanceChannelEnum;
import com.dtyunxi.yundt.cube.center.user.api.constant.ResourceStatus;
import com.dtyunxi.yundt.cube.center.user.api.constant.ResourceType;
import com.dtyunxi.yundt.cube.center.user.api.constant.SortEnum;
import com.dtyunxi.yundt.cube.center.user.api.constant.StatusEnum;
import com.dtyunxi.yundt.cube.center.user.api.dto.AccessDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppInstanceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppPurchaseDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppRegisterDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ApplicationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ButtonDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.MenuDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ResourceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.response.ApplicationQueryRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.response.UserAppInstanceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AppInstanceCreateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AppInstanceMenuIncrDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AppInstanceQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AppInstanceResourceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AppResourceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ApplicationQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.BizSpaceEnableInstanceReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ExternalAppQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleGenerateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleTemplateCreateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleTemplateDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.SortReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.TenantDomainQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.application.AppInstanceUserQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.application.ApplicationBatchQueryDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.application.DataInstanceStatusUpdateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.AppInstanceQueryResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.AppInstanceSummaryResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.ApplicationQueryResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.BizSpaceEnableInstanceRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.ButtonQueryResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.ExternalAppQueryRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.InstanceInitResourceResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.MenuQueryResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.ResourceQueryResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.RoleTemplateRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.AppRegisterVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.UserAccessVo;
import com.dtyunxi.yundt.cube.center.user.api.exception.UserExceptionCode;
import com.dtyunxi.yundt.cube.center.user.biz.cache.AppInstanceCacheUpdater;
import com.dtyunxi.yundt.cube.center.user.biz.service.IAccessService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IAppInstanceEventService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IApplicationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IInstanceRelationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IRoleService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IRoleTemplateService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserDomainService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.util.Collection2SqlInConditionUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.AppInstanceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.ApplicationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.ApplicationResourceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.ButtonDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.MenuDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.PackageButtonRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.PackageMenuRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.ResourceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.RoleTemplateDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.TenantDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AppInstanceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.ApplicationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.ApplicationResourceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.ButtonEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.MenuEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.PackageButtonRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.PackageMenuRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.ResourceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RoleTemplateEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdButtonEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdMenuEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdResourceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.TenantEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.dtyunxi.yundt.cube.center.user.ext.application.IAppInstanceDetectExt;
import com.dtyunxi.yundt.cube.center.user.ext.application.IInstanceHostServerCheckExt;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.context.biz.ServiceContextUtil;
import com.dtyunxi.yundt.module.context.common.callback.IAppInstanceCallBack;
import com.dtyunxi.yundt.module.context.common.config.AppRecognitionConfig;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

@Service
public class ApplicationServiceImpl
implements IApplicationService {
    private Logger logger = LoggerFactory.getLogger(ApplicationServiceImpl.class);
    @Resource
    private ApplicationDas applicationDas;
    @Resource
    private AppInstanceDas appInstanceDas;
    @Resource
    private ButtonDas buttonDas;
    @Resource
    private MenuDas menuDas;
    @Resource
    private UserDas userDas;
    @Resource
    private TenantDas tenantDas;
    @Resource
    private IRoleService roleService;
    @Resource
    private PackageMenuRelationDas packageMenuRelationDas;
    @Resource
    private PackageButtonRelationDas packageButtonRelationDas;
    @Resource
    private ApplicationResourceDas applicationResourceDas;
    @Resource
    private ResourceDas resourceDas;
    @Resource
    private IRoleTemplateService roleTemplateService;
    @Resource
    private RoleTemplateDas roleTemplateDas;
    @Resource
    private IAccessService accessService;
    @Resource
    private IAppInstanceDetectExt appInstanceDetectExt;
    @Resource
    private IBizSpaceApi bizSpaceApi;
    @Resource
    private IInstanceHostServerCheckExt instanceHostServerCheckExt;
    @Resource
    private IUserDomainService userDomainService;
    @Resource
    private IUserService userService;
    @Resource
    private IContext context;
    @Autowired
    private AppRecognitionConfig appRecognitionConfig;
    @Autowired
    private AppInstanceCacheUpdater appInstanceCacheUpdater;
    @Resource
    private IInstanceRelationService instanceRelationService;
    @Resource
    private IBizSpaceQueryApi bizSpaceQueryApi;
    @Resource
    private IAppInstanceEventService appInstanceEventService;

    private static Long getId() {
        return IdGenrator.getDistributedId();
    }

    private static AppInstanceDto getAppInsDto(AppInstanceEo appInstanceEo) {
        AppInstanceDto appInstanceDto = new AppInstanceDto();
        DtoHelper.eo2Dto((BaseEo)appInstanceEo, (BaseVo)appInstanceDto, (String[])new String[]{"buttons", "menus", "application"});
        return appInstanceDto;
    }

    private static Map<String, Boolean> returnResourceOrNot(String[] res) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("button", false);
        map.put("menu", false);
        map.put("withRoleTemplate", false);
        if (res == null || res.length == 0) {
            return map;
        }
        for (String resource : res) {
            if ("buttons".equals(resource)) {
                map.put("button", true);
                continue;
            }
            if ("menus".equals(resource)) {
                map.put("menu", true);
                continue;
            }
            if (!"withRoleTemplate".equals(resource)) continue;
            map.put("withRoleTemplate", true);
        }
        return map;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public AppRegisterVo register(AppRegisterDto appRegisterDto) {
        UserEo userEo;
        if (StringUtils.isNotBlank((CharSequence)appRegisterDto.getCode())) {
            ApplicationEo record = new ApplicationEo();
            record.setCode(appRegisterDto.getCode());
            if (this.applicationDas.count((BaseEo)record) > 0) {
                throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), "\u7f16\u7801code\u4e3a" + appRegisterDto.getCode() + "\u7684\u5e94\u7528\u6a21\u677f\u5df2\u5b58\u5728");
            }
        }
        if (appRegisterDto.getOwnerId() != null && (userEo = (UserEo)this.userDas.selectByPrimaryKey(appRegisterDto.getOwnerId())) == null) {
            this.logger.info("\u7528\u6237\u6ce8\u518c\u5e94\u7528\u6a21\u677f\uff0c\u65e0\u6cd5\u901a\u8fc7\u7528\u6237id\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f,\u7528\u6237id\u4e3a:" + appRegisterDto.getOwnerId());
            throw new BizException(UserExceptionCode.USER_IDCHECK_FAIL.getCode(), UserExceptionCode.USER_IDCHECK_FAIL.getMsg());
        }
        ApplicationEo applicationEo = this.applicationDas.findByName(appRegisterDto.getName());
        if (applicationEo != null) {
            this.logger.info("\u7528\u6237\u6ce8\u518c\u5e94\u7528\u6a21\u677f\uff0c\u540d\u79f0\u5df2\u7ecf\u5b58\u5728:" + appRegisterDto.getName());
            throw new BizException(UserExceptionCode.APPLICATION_EXIT_FAIL.getCode(), UserExceptionCode.APPLICATION_EXIT_FAIL.getMsg());
        }
        String json = JSON.toJSONString((Object)appRegisterDto);
        ApplicationEo application = (ApplicationEo)JSON.parseObject((String)json, ApplicationEo.class);
        if (application.getStatus() == null) {
            application.setStatus(Integer.valueOf(0));
        }
        String appKey = Coder.md5Hex((String)Coder.randomNum((int)32));
        String appSecret = Coder.md5Hex((String)Coder.randomNum((int)32));
        application.setAppKey(appKey);
        application.setAppSecret(appSecret);
        this.applicationDas.insert((BaseEo)application);
        if (application.getId() != null) {
            AppRegisterVo appRegisterVo = new AppRegisterVo();
            appRegisterVo.setAppId(application.getId());
            appRegisterVo.setAppKey(appKey);
            appRegisterVo.setAppSecret(appSecret);
            if (CollectionUtils.isNotEmpty((Collection)appRegisterDto.getRoleTemplateDtos())) {
                for (RoleTemplateDto roleTemplateDto : appRegisterDto.getRoleTemplateDtos()) {
                    RoleTemplateCreateReqDto roleTemplateCreateReqDto = new RoleTemplateCreateReqDto();
                    CubeBeanUtils.copyProperties((Object)roleTemplateCreateReqDto, (Object)roleTemplateDto, (String[])new String[0]);
                    roleTemplateCreateReqDto.setApplicationId(application.getId());
                    this.roleTemplateService.addRoleTemplate(roleTemplateCreateReqDto);
                }
            }
            return appRegisterVo;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyApp(AppRegisterDto appRegisterDto) {
        ApplicationEo existEo = (ApplicationEo)this.applicationDas.selectByPrimaryKey(appRegisterDto.getId());
        if (existEo == null) {
            throw new BizException(UserExceptionCode.APPLICATION_EXCEPTION_CODE.getCode(), UserExceptionCode.APPLICATION_EXCEPTION_CODE.getMsg());
        }
        ApplicationEo applicationEo = new ApplicationEo();
        applicationEo.setId(appRegisterDto.getId());
        applicationEo.setCode(null);
        if (appRegisterDto.getDeveloper() != null) {
            applicationEo.setDeveloper(appRegisterDto.getDeveloper());
        }
        if (appRegisterDto.getDeveloperEamil() != null) {
            applicationEo.setDeveloperEamil(appRegisterDto.getDeveloperEamil());
        }
        if (appRegisterDto.getDeveloperPhone() != null) {
            applicationEo.setDeveloperPhone(appRegisterDto.getDeveloperPhone());
        }
        if (appRegisterDto.getName() != null) {
            ApplicationEo record = this.applicationDas.findByName(appRegisterDto.getName());
            if (record != null && !record.getId().equals(existEo.getId())) {
                throw new BizException(UserExceptionCode.APPLICATION_EXIT_FAIL.getCode(), UserExceptionCode.APPLICATION_EXIT_FAIL.getMsg());
            }
            applicationEo.setName(appRegisterDto.getName());
        }
        if (appRegisterDto.getApplicationType() != null) {
            applicationEo.setApplicationType(appRegisterDto.getApplicationType());
        }
        if (appRegisterDto.getStatus() != null) {
            applicationEo.setStatus(appRegisterDto.getStatus());
        }
        this.applicationDas.updateSelective((BaseEo)applicationEo);
        if (CollectionUtils.isNotEmpty((Collection)appRegisterDto.getRoleTemplateDtos())) {
            RoleTemplateEo roleTemplateEo = new RoleTemplateEo();
            roleTemplateEo.setApplicationId(applicationEo.getId());
            this.roleTemplateDas.logicDelete((BaseEo)roleTemplateEo);
            for (RoleTemplateDto roleTemplateDto : appRegisterDto.getRoleTemplateDtos()) {
                RoleTemplateCreateReqDto roleTemplateCreateReqDto = new RoleTemplateCreateReqDto();
                CubeBeanUtils.copyProperties((Object)roleTemplateCreateReqDto, (Object)roleTemplateDto, (String[])new String[0]);
                roleTemplateCreateReqDto.setApplicationId(applicationEo.getId());
                this.roleTemplateService.addRoleTemplate(roleTemplateCreateReqDto);
            }
        }
    }

    @Override
    public void removeApp(List<Long> appIds) {
        appIds.forEach(e -> this.applicationDas.logicDeleteById(e));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void appRebindMenus(String appCode, List<String> menuCodes) {
        ApplicationEo applicationEo;
        if (menuCodes == null) {
            menuCodes = new ArrayList<String>();
        }
        if ((applicationEo = this.applicationDas.selectByCode(appCode)) == null) {
            this.logger.info("\u7ed1\u5b9a\u83dc\u5355\uff0c\u65e0\u6cd5\u901a\u8fc7\u5e94\u7528\u7f16\u7801\u67e5\u8be2\u5230\u5e94\u7528\u4fe1\u606f,\u5e94\u7528\u7f16\u7801code\u4e3a:" + appCode);
            throw new BizException(UserExceptionCode.APPLICATION_EXCEPTION_CODE.getCode(), UserExceptionCode.APPLICATION_EXCEPTION_CODE.getMsg());
        }
        if (2 == applicationEo.getStatus()) {
            this.logger.info("\u65e0\u6cd5\u4fee\u6539\u83dc\u5355\uff0c\u8be5\u5e94\u7528\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u5e94\u7528\u7f16\u7801code\uff1a{}", (Object)appCode);
            throw new BizException(UserExceptionCode.APPLICATION_DISABLED.getCode(), UserExceptionCode.APPLICATION_DISABLED.getMsg());
        }
        List<String> duplicateMenuCodes = ApplicationServiceImpl.getDuplicateElements(menuCodes);
        if (duplicateMenuCodes.size() > 0) {
            throw new BizException("\u91cd\u590d\u83dc\u5355\u7f16\u7801:" + StringUtils.join(duplicateMenuCodes, (String)","));
        }
        if (!menuCodes.contains("0")) {
            menuCodes.add("0");
        }
        List olds = this.applicationResourceDas.findByAppCodeAndType(appCode, Integer.valueOf(ResourceType.MENU.getValue()));
        List oldMenuCodes = olds.stream().map(StdResourceEo::getCode).collect(Collectors.toList());
        ArrayList<ApplicationResourceEo> news = new ArrayList<ApplicationResourceEo>();
        for (String menuCode : menuCodes) {
            ApplicationResourceEo applicationResourceEo = new ApplicationResourceEo();
            applicationResourceEo.setApplicationCode(appCode);
            applicationResourceEo.setResourceCode(menuCode);
            applicationResourceEo.setExtension("");
            news.add(applicationResourceEo);
        }
        List<String> finalMenuCodes = menuCodes;
        List<ApplicationResourceEo> deletes = olds.stream().filter(e -> !finalMenuCodes.contains(e.getCode())).map(e -> {
            ApplicationResourceEo eo = new ApplicationResourceEo();
            eo.setApplicationCode(appCode);
            eo.setResourceCode(e.getCode());
            return eo;
        }).collect(Collectors.toList());
        List<ApplicationResourceEo> inserts = news.stream().filter(e -> !oldMenuCodes.contains(e.getResourceCode())).collect(Collectors.toList());
        inserts.forEach(e -> {
            ResourceEo select = new ResourceEo();
            select.setCode(e.getResourceCode());
            if (this.resourceDas.count((BaseEo)select) < 1) {
                throw new BusinessRuntimeException("\u83dc\u5355\u7f16\u7801\u4e3a" + e.getResourceCode() + "\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
            }
        });
        if (deletes.size() > 0) {
            deletes.forEach(e -> this.applicationResourceDas.logicDeleteByExample((BaseEo)e));
        }
        if (inserts.size() > 0) {
            this.applicationResourceDas.insertBatch(inserts);
        }
    }

    @Override
    public boolean appRebindResource(Integer type, String appCode, String resourceCode) {
        ApplicationResourceEo record = new ApplicationResourceEo();
        record.setApplicationCode(appCode);
        record.setResourceCode(resourceCode);
        record.setDr(0);
        if (type == 1) {
            if (this.applicationResourceDas.count((BaseEo)record) == 0) {
                if (this.applicationDas.selectByCode(appCode) == null) {
                    throw new BizException("\u7f16\u7801\u4e3a" + appCode + "\u7684\u5e94\u7528\u6a21\u677f\u4e0d\u5b58\u5728");
                }
                if (this.resourceDas.selectByCode(resourceCode) == null) {
                    throw new BizException("\u7f16\u7801\u4e3a" + resourceCode + "\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
                }
                record.setExtension("");
                this.applicationResourceDas.insert((BaseEo)record);
                return true;
            }
        } else if (type == 2) {
            this.applicationResourceDas.logicDelete((BaseEo)record);
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void appRebindButtons(String appCode, String menuCode, List<String> buttonCodes) {
        ApplicationEo applicationEo;
        if (buttonCodes == null) {
            buttonCodes = new ArrayList<String>();
        }
        if ((applicationEo = this.applicationDas.selectByCode(appCode)) == null) {
            this.logger.info("\u7ed1\u5b9a\u83dc\u5355\uff0c\u65e0\u6cd5\u901a\u8fc7\u5e94\u7528\u7f16\u7801\u67e5\u8be2\u5230\u5e94\u7528\u4fe1\u606f,\u5e94\u7528\u7f16\u7801code\u4e3a:" + appCode);
            throw new BizException(UserExceptionCode.APPLICATION_EXCEPTION_CODE.getCode(), UserExceptionCode.APPLICATION_EXCEPTION_CODE.getMsg());
        }
        if (2 == applicationEo.getStatus()) {
            this.logger.info("\u65e0\u6cd5\u4fee\u6539\u83dc\u5355\uff0c\u8be5\u5e94\u7528\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u5e94\u7528\u7f16\u7801code\uff1a{}", (Object)appCode);
            throw new BizException(UserExceptionCode.APPLICATION_DISABLED.getCode(), UserExceptionCode.APPLICATION_DISABLED.getMsg());
        }
        List<String> duplicateButtonCodes = ApplicationServiceImpl.getDuplicateElements(buttonCodes);
        if (duplicateButtonCodes.size() > 0) {
            throw new BizException("\u91cd\u590d\u6309\u94ae\u7f16\u7801:" + StringUtils.join(duplicateButtonCodes, (String)","));
        }
        List olds = StringUtils.isBlank((CharSequence)menuCode) ? this.applicationResourceDas.findByAppCodeAndType(appCode, Integer.valueOf(ResourceType.BUTTON.getValue())) : this.applicationResourceDas.findByAppCodeAndTypeAndParentCode(appCode, Integer.valueOf(ResourceType.BUTTON.getValue()), menuCode);
        List oldButtonCodes = olds.stream().map(StdResourceEo::getCode).collect(Collectors.toList());
        ArrayList<ApplicationResourceEo> news = new ArrayList<ApplicationResourceEo>();
        for (String buttonCode : buttonCodes) {
            ApplicationResourceEo applicationResourceEo = new ApplicationResourceEo();
            applicationResourceEo.setApplicationCode(appCode);
            applicationResourceEo.setResourceCode(buttonCode);
            applicationResourceEo.setExtension("");
            news.add(applicationResourceEo);
        }
        List<String> finalButtonCodes = buttonCodes;
        List<ApplicationResourceEo> deletes = olds.stream().filter(e -> !finalButtonCodes.contains(e.getCode())).map(e -> {
            ApplicationResourceEo eo = new ApplicationResourceEo();
            eo.setResourceCode(e.getCode());
            eo.setApplicationCode(appCode);
            return eo;
        }).collect(Collectors.toList());
        List<ApplicationResourceEo> inserts = news.stream().filter(e -> !oldButtonCodes.contains(e.getResourceCode())).collect(Collectors.toList());
        inserts.forEach(e -> {
            ResourceEo select = new ResourceEo();
            select.setCode(e.getResourceCode());
            if (this.resourceDas.count((BaseEo)select) < 1) {
                throw new BizException("\u6309\u94ae\u7f16\u7801\u4e3a" + e.getResourceCode() + "\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
            }
        });
        if (deletes.size() > 0) {
            deletes.forEach(e -> this.applicationResourceDas.logicDeleteByExample((BaseEo)e));
        }
        if (inserts.size() > 0) {
            this.applicationResourceDas.insertBatch(inserts);
        }
    }

    @Override
    public Long registerAppResource(AppResourceDto appResourceDto) {
        String appCode = appResourceDto.getAppCode();
        String appName = appResourceDto.getAppName();
        ApplicationEo applicationEo = this.applicationDas.selectByCode(appCode);
        if (applicationEo != null) {
            this.logger.debug("\u5e94\u7528\u6a21\u677f\u5df2\u5b58\u5728\uff0c\u8fdb\u884c\u66f4\u65b0\uff0cappCode = {}", (Object)appCode);
            ApplicationEo updateEo = new ApplicationEo();
            updateEo.setId(applicationEo.getId());
            updateEo.setName(appName);
            this.applicationDas.updateSelective((BaseEo)updateEo);
        } else {
            this.logger.debug("\u521b\u5efa\u5e94\u7528\u6a21\u677f\uff0cappCode = {}", (Object)appCode);
            applicationEo = new ApplicationEo();
            applicationEo.setCode(appCode);
            applicationEo.setName(appName);
            applicationEo.setOwnerId(Long.valueOf(1L));
            applicationEo.setStatus(Integer.valueOf(1));
            String appKey = Coder.md5Hex((String)Coder.randomNum((int)32));
            String appSecret = Coder.md5Hex((String)Coder.randomNum((int)32));
            applicationEo.setAppKey(appKey);
            applicationEo.setAppSecret(appSecret);
            applicationEo.setTenantId(Long.valueOf(1L));
            this.applicationDas.insert((BaseEo)applicationEo);
        }
        this.registerResource(appResourceDto);
        return applicationEo.getId();
    }

    private void registerResource(AppResourceDto appResourceDto) {
        String appCode = appResourceDto.getAppCode();
        HashMap<String, ResourceEo> menuResourceMap = new HashMap<String, ResourceEo>();
        HashMap<String, Map<String, ResourceEo>> menuCode2ButtonResourceMap = new HashMap<String, Map<String, ResourceEo>>();
        this.wrapResourceMap(appResourceDto, menuResourceMap, menuCode2ButtonResourceMap);
        ArrayList<String> menuCodeList = new ArrayList<String>(menuResourceMap.keySet());
        List existMenuList = this.applicationResourceDas.findByAppCodeAndType(appCode, Integer.valueOf(ResourceType.MENU.getValue()));
        existMenuList.forEach(r -> {
            String menuCode = r.getCode();
            if ("0".equals(menuCode)) {
                return;
            }
            ResourceEo resourceEo = (ResourceEo)menuResourceMap.get(menuCode);
            if (resourceEo != null) {
                resourceEo.setId(r.getId());
                this.resourceDas.updateSelective((BaseEo)resourceEo);
                menuResourceMap.remove(menuCode);
            } else {
                this.resourceDas.deleteById(r.getId());
            }
        });
        ArrayList leftResourceList = new ArrayList(menuResourceMap.values());
        if (CollectionUtils.isNotEmpty(leftResourceList)) {
            this.logger.debug(MessageFormat.format("\u5e94\u7528\uff08appCode={0}\uff09\u5f85\u65b0\u589e\u8d44\u6e90{1}\u4e2a", appCode, leftResourceList.size()));
            ArrayList addResourceList = new ArrayList();
            leftResourceList.forEach(e -> {
                String addResourceCode = e.getCode();
                this.logger.debug(MessageFormat.format("\u65b0\u589e\u8d44\u6e90code={0}", addResourceCode));
                ResourceEo queryResourceEo = new ResourceEo();
                queryResourceEo.setCode(addResourceCode);
                if (this.resourceDas.count((BaseEo)queryResourceEo) == 0) {
                    addResourceList.add(e);
                }
            });
            this.logger.debug(MessageFormat.format("\u5e94\u7528\uff08appCode={0}\uff09\u6700\u7ec8\u65b0\u589e\u8d44\u6e90{1}\u4e2a", appCode, addResourceList.size()));
            this.resourceDas.insertBatch(addResourceList);
        } else {
            this.logger.debug(MessageFormat.format("\u5e94\u7528\uff08appCode={0}\uff09\u65e0\u65b0\u589e\u8d44\u6e90", appCode));
        }
        this.appRebindMenus(appCode, menuCodeList);
        if (menuCode2ButtonResourceMap.size() == 0) {
            return;
        }
        List existAppButtonList = this.applicationResourceDas.findByAppCodeAndType(appCode, Integer.valueOf(ResourceType.BUTTON.getValue()));
        Map<String, List<ResourceEo>> existMenuCode2ButtonMap = existAppButtonList.stream().collect(Collectors.groupingBy(StdResourceEo::getParentCode));
        for (String menuCode : existMenuCode2ButtonMap.keySet()) {
            List<ResourceEo> existButtonList = existMenuCode2ButtonMap.get(menuCode);
            Map buttonResourceMap = (Map)menuCode2ButtonResourceMap.get(menuCode);
            existButtonList.forEach(r -> {
                String buttonCode = r.getCode();
                if (buttonResourceMap == null || buttonResourceMap.get(buttonCode) == null) {
                    this.resourceDas.deleteById(r.getId());
                } else {
                    ResourceEo resourceEo = (ResourceEo)buttonResourceMap.get(buttonCode);
                    resourceEo.setId(r.getId());
                    this.resourceDas.updateSelective((BaseEo)resourceEo);
                    buttonResourceMap.remove(buttonCode);
                }
            });
        }
        for (String menuCode : menuCode2ButtonResourceMap.keySet()) {
            Map buttonResourceMap = (Map)menuCode2ButtonResourceMap.get(menuCode);
            ArrayList addButtonResourceList = new ArrayList(buttonResourceMap.values());
            if (CollectionUtils.isNotEmpty(addButtonResourceList)) {
                this.resourceDas.insertBatch(addButtonResourceList);
            }
            if (buttonResourceMap.size() <= 0) continue;
            ArrayList<String> buttonCodeList = new ArrayList<String>(buttonResourceMap.keySet());
            this.appRebindButtons(appCode, menuCode, buttonCodeList);
        }
    }

    private void wrapResourceMap(AppResourceDto appResourceDto, Map<String, ResourceEo> menuResourceMap, Map<String, Map<String, ResourceEo>> menuCode2ButtonResourceMap) {
        String appCode = appResourceDto.getAppCode();
        String appName = appResourceDto.getAppName();
        List resourceDetailList = appResourceDto.getResourceDetailList();
        Long tenantId = 1L;
        ArrayList buttonResources = new ArrayList();
        resourceDetailList.forEach(r -> {
            String resourceCode = r.getResourceCode();
            ResourceEo resourceEo = new ResourceEo();
            resourceEo.setCode(resourceCode);
            resourceEo.setName(r.getResourceName());
            String parentCode = r.getParentCode();
            resourceEo.setParentCode(StringUtils.isBlank((CharSequence)parentCode) ? "0" : parentCode);
            resourceEo.setType(r.getType());
            resourceEo.setRoutePath(r.getRoutePath());
            resourceEo.setUrlParam(r.getUrlParam());
            Long pageId = r.getPageId();
            resourceEo.setPageId(pageId != null ? String.valueOf(pageId) : null);
            resourceEo.setStatus(Integer.valueOf(ResourceStatus.ENABLE.getValue()));
            resourceEo.setTenantId(tenantId);
            resourceEo.setExtension("");
            if (resourceEo.getType().equals(ResourceType.BUTTON.getValue())) {
                buttonResources.add(resourceEo);
            } else {
                menuResourceMap.put(resourceCode, resourceEo);
            }
        });
        if (CollectionUtils.isNotEmpty(buttonResources)) {
            Map<String, List<ResourceEo>> menu2ButtonsMap = buttonResources.stream().collect(Collectors.groupingBy(StdResourceEo::getParentCode));
            for (String menuCode : menu2ButtonsMap.keySet()) {
                List<ResourceEo> buttons = menu2ButtonsMap.get(menuCode);
                Map buttonResourceMap = buttons.stream().collect(Collectors.toMap(StdResourceEo::getCode, Function.identity(), (k1, k2) -> k1));
                menuCode2ButtonResourceMap.put(menuCode, buttonResourceMap);
            }
        }
    }

    @Override
    public ApplicationDto queryOne(ApplicationQueryReqDto reqDto) {
        ApplicationEo application = (ApplicationEo)this.applicationDas.selectByPrimaryKey(reqDto.getId());
        if (application == null) {
            this.logger.info("\u67e5\u8be2\u5e94\u7528\u8be6\u60c5\uff0c\u65e0\u6cd5\u901a\u8fc7\u5e94\u7528id\u67e5\u8be2\u5230\u5e94\u7528\u4fe1\u606f,\u5e94\u7528id\u4e3a:" + reqDto.getId());
            throw new BizException(UserExceptionCode.APPLICATION_EXCEPTION_CODE.getCode(), UserExceptionCode.APPLICATION_EXCEPTION_CODE.getMsg());
        }
        ApplicationDto dto = new ApplicationDto();
        DtoHelper.eo2Dto((BaseEo)application, (BaseVo)dto);
        if (reqDto.getWithRoleTemplate() != null && reqDto.getWithRoleTemplate().booleanValue()) {
            dto.setRoleTemplateRespDtos(this.getRoleTemplateByApplicationId(reqDto.getId()));
        }
        return dto;
    }

    @Override
    public ApplicationQueryResDto queryByCodeAndResources(String code, List<String> res) {
        ApplicationEo applicationEo = this.applicationDas.selectByCode(code);
        if (applicationEo == null) {
            this.logger.info("\u67e5\u8be2\u5e94\u7528\u8be6\u60c5\uff0c\u65e0\u6cd5\u901a\u8fc7\u5e94\u7528\u7f16\u7801\u67e5\u8be2\u5230\u5e94\u7528\u4fe1\u606f,\u5e94\u7528\u7f16\u7801\u4e3a:" + code);
            throw new BizException(UserExceptionCode.APPLICATION_EXCEPTION_CODE.getCode(), UserExceptionCode.APPLICATION_EXCEPTION_CODE.getMsg());
        }
        ApplicationQueryResDto resDto = new ApplicationQueryResDto();
        DtoHelper.eo2Dto((BaseEo)applicationEo, (BaseVo)resDto);
        if (res != null && res.contains("menus")) {
            List rootList = ResourceDas.buildTree((String)"-1", (String)code, this.applicationResourceDas.findByAppCodeAndType(code, Integer.valueOf(ResourceType.MENU.getValue())).stream().map(e -> {
                ResourceQueryResDto nodeDto = new ResourceQueryResDto();
                DtoHelper.eo2Dto((BaseEo)e, (BaseVo)nodeDto);
                return nodeDto;
            }).collect(Collectors.toList()));
            if (rootList.size() == 1) {
                resDto.setMenus((ResourceQueryResDto)rootList.get(0));
            } else if (rootList.size() > 1) {
                throw new BizException("\u83dc\u5355\u6570\u636e\u5f02\u5e38");
            }
        }
        if (res != null && res.contains("buttons")) {
            List buttonResources = this.applicationResourceDas.findByAppCodeAndType(code, Integer.valueOf(ResourceType.BUTTON.getValue()));
            ArrayList buttonDtos = new ArrayList();
            DtoHelper.eoList2DtoList((Collection)buttonResources, buttonDtos, ResourceQueryResDto.class);
            resDto.setButtons(buttonDtos);
        }
        return resDto;
    }

    @Override
    public PageInfo<ApplicationDto> queryApplicationsByExample(String filter, Integer pageNum, Integer pageSize) {
        ApplicationEo applicationEo = new ApplicationEo();
        applicationEo.setSqlFilters(this.addApplicationSqlFilter(filter));
        applicationEo.setOrderByDesc("update_time");
        PageInfo page = this.applicationDas.selectPage((BaseEo)applicationEo, pageNum, pageSize);
        ArrayList applicationDtos = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)page.getList(), applicationDtos, ApplicationDto.class);
        JSONObject jsonObject = JSON.parseObject((String)filter);
        if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("withRoleTemplate")) && "1".equals(jsonObject.getString("withRoleTemplate"))) {
            for (ApplicationDto applicationDto : applicationDtos) {
                applicationDto.setRoleTemplateRespDtos(this.getRoleTemplateByApplicationId(applicationDto.getId()));
            }
        }
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)page, (String[])new String[]{"list", "navigatepageNums"});
        dtoPageInfo.setList(applicationDtos);
        return dtoPageInfo;
    }

    private static <T> List<T> getDuplicateElements(List<T> list) {
        if (CollectionUtil.isEmpty(list)) {
            return new ArrayList();
        }
        return list.stream().collect(Collectors.toMap(e -> e, e -> 1, Integer::sum)).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void initAppInstance(Long instanceId, List<String> menuCodes, List<String> buttonCodes, Boolean updateOld, Boolean deleteOld) {
        if (menuCodes.size() == 0) {
            throw new BizException("\u8d44\u6e90\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> duplicateMenuCode = ApplicationServiceImpl.getDuplicateElements(menuCodes);
        if (duplicateMenuCode.size() > 0) {
            throw new BizException("\u91cd\u590d\u8d44\u6e90\u83dc\u5355\u7f16\u7801:" + StringUtils.join(duplicateMenuCode, (String)","));
        }
        List<String> duplicateButtonCode = ApplicationServiceImpl.getDuplicateElements(buttonCodes);
        if (duplicateButtonCode.size() > 0) {
            throw new BizException("\u91cd\u590d\u8d44\u6e90\u6309\u94ae\u7f16\u7801:" + StringUtils.join(duplicateButtonCode, (String)","));
        }
        if (deleteOld.booleanValue() && !menuCodes.contains("0")) {
            menuCodes.add("0");
        }
        List menuResources = this.resourceDas.selectByCodes(menuCodes);
        List buttonResources = this.resourceDas.selectByCodes(buttonCodes);
        this.syncAppInstanceMenuButton(instanceId, menuResources, buttonResources, updateOld, deleteOld);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void incrementalAppInstanceResources(AppInstanceMenuIncrDto appInstanceMenuIncrDto) {
        Long instanceId = appInstanceMenuIncrDto.getInstanceId();
        if (null == instanceId) {
            instanceId = this.context.instanceId();
        }
        List menuCodes = appInstanceMenuIncrDto.getMenuCodes();
        List buttonCodes = appInstanceMenuIncrDto.getButtonCodes();
        Boolean isUpdateResourceName = false;
        if (null != appInstanceMenuIncrDto.getUpdateResourceName()) {
            isUpdateResourceName = appInstanceMenuIncrDto.getUpdateResourceName();
        }
        if (CollectionUtils.isEmpty((Collection)menuCodes) && CollectionUtils.isEmpty((Collection)buttonCodes)) {
            throw new BizException("\u8d44\u6e90\u83dc\u5355\u7f16\u7801\u548c\u8d44\u6e90\u6309\u94ae\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (CollectionUtils.isNotEmpty((Collection)menuCodes) && !menuCodes.contains("0")) {
            menuCodes.add("0");
        }
        List menuResources = this.resourceDas.selectByCodes(menuCodes, ResourceType.MENU.getValue());
        List buttonResources = this.resourceDas.selectByCodes(buttonCodes, ResourceType.BUTTON.getValue());
        if (CollectionUtils.isNotEmpty((Collection)menuResources)) {
            this.incrementalAppInstanceMenus(instanceId, menuResources, isUpdateResourceName);
        }
        if (CollectionUtils.isNotEmpty((Collection)buttonResources)) {
            this.incrementalAppInstanceButtons(instanceId, buttonResources, isUpdateResourceName);
        }
    }

    private void incrementalAppInstanceMenus(Long instanceId, List<ResourceEo> menuResources, Boolean isUpdateResourceName) {
        List menuQueryEos = this.menuDas.selectByInstanceId(instanceId);
        Map<Object, Object> code2Menu = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)menuQueryEos)) {
            code2Menu = menuQueryEos.stream().collect(Collectors.toMap(StdMenuEo::getCode, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList<MenuEo> insertMenuEos = new ArrayList<MenuEo>();
        ArrayList<MenuEo> processedMenuEos = new ArrayList<MenuEo>();
        for (ResourceEo menu : menuResources) {
            MenuEo dbEo2 = null;
            if (code2Menu.size() > 0) {
                dbEo2 = (MenuEo)code2Menu.get(menu.getCode());
            }
            if (null != dbEo2) {
                MenuEo updateMenuEo = new MenuEo();
                if (!isUpdateResourceName.booleanValue()) {
                    CubeBeanUtils.copyProperties((Object)updateMenuEo, (Object)menu, (String[])new String[]{"id", "code", "name", "instanceId", "createTime", "createPerson", "children"});
                } else {
                    CubeBeanUtils.copyProperties((Object)updateMenuEo, (Object)menu, (String[])new String[]{"id", "code", "instanceId", "createTime", "createPerson", "children"});
                }
                processedMenuEos.add(dbEo2);
                updateMenuEo.setId(dbEo2.getId());
                this.menuDas.updateSelective((BaseEo)updateMenuEo);
                continue;
            }
            MenuEo insertMenuEo = new MenuEo();
            CubeBeanUtils.copyProperties((Object)insertMenuEo, (Object)menu, (String[])new String[]{"id", "instanceId", "createTime", "createPerson", "children"});
            insertMenuEo.setInstanceId(instanceId);
            insertMenuEos.add(insertMenuEo);
        }
        if (CollectionUtils.isNotEmpty(insertMenuEos)) {
            this.menuDas.insertBatch(insertMenuEos);
        }
        if (CollectionUtils.isNotEmpty(processedMenuEos)) {
            menuQueryEos.removeAll(processedMenuEos);
            if (CollectionUtils.isNotEmpty((Collection)menuQueryEos)) {
                menuQueryEos.forEach(dbEo -> this.menuDas.logicDelete((BaseEo)dbEo));
            }
        }
    }

    private void incrementalAppInstanceButtons(Long instanceId, List<ResourceEo> buttonResources, Boolean isUpdateResourceName) {
        List menus = this.menuDas.selectByInstanceId(instanceId);
        Map<String, Long> menuMap = menus.stream().collect(Collectors.toMap(StdMenuEo::getCode, BaseEo::getId));
        List buttonQueryEos = this.buttonDas.selectByInstanceId(instanceId);
        Map<Object, Object> code2Button = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)buttonQueryEos)) {
            code2Button = buttonQueryEos.stream().collect(Collectors.toMap(StdButtonEo::getCode, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList<ButtonEo> insertButtonEos = new ArrayList<ButtonEo>();
        ArrayList<ButtonEo> processedButtonEos = new ArrayList<ButtonEo>();
        for (ResourceEo button : buttonResources) {
            ButtonEo dbEo2 = null;
            if (code2Button.size() > 0) {
                dbEo2 = (ButtonEo)code2Button.get(button.getCode());
            }
            if (null != dbEo2) {
                ButtonEo updateButtonEo = new ButtonEo();
                if (!isUpdateResourceName.booleanValue()) {
                    CubeBeanUtils.copyProperties((Object)updateButtonEo, (Object)button, (String[])new String[]{"id", "code", "name", "instanceId", "createTime", "createPerson", "children"});
                } else {
                    CubeBeanUtils.copyProperties((Object)updateButtonEo, (Object)button, (String[])new String[]{"id", "code", "instanceId", "createTime", "createPerson", "children"});
                }
                processedButtonEos.add(dbEo2);
                updateButtonEo.setId(dbEo2.getId());
                this.buttonDas.updateSelective((BaseEo)updateButtonEo);
                continue;
            }
            if (menuMap.get(button.getParentCode()) == null) continue;
            ButtonEo insertButtonEo = new ButtonEo();
            CubeBeanUtils.copyProperties((Object)insertButtonEo, (Object)button, (String[])new String[]{"id", "instanceId", "createTime", "createPerson", "children"});
            insertButtonEo.setInstanceId(instanceId);
            insertButtonEo.setMenuId(menuMap.get(button.getParentCode()));
            insertButtonEos.add(insertButtonEo);
        }
        if (CollectionUtils.isNotEmpty(insertButtonEos)) {
            this.buttonDas.insertBatch(insertButtonEos);
        }
        if (CollectionUtils.isNotEmpty(processedButtonEos)) {
            buttonQueryEos.removeAll(processedButtonEos);
            if (CollectionUtils.isNotEmpty((Collection)buttonQueryEos)) {
                buttonQueryEos.forEach(dbEo -> this.buttonDas.logicDelete((BaseEo)dbEo));
            }
        }
    }

    private void syncAppInstanceMenuButton(Long instanceId, List<ResourceEo> menuResources, List<ResourceEo> buttonResources, Boolean updateOld, Boolean deleteOld) {
        List oldMenus = this.menuDas.selectByInstanceId(instanceId);
        List oldButtons = this.buttonDas.selectByInstanceId(instanceId);
        Map<String, Long> oldMenuMap = oldMenus.stream().collect(Collectors.toMap(StdMenuEo::getCode, BaseEo::getId));
        Map<String, Long> oldButtonMap = oldButtons.stream().collect(Collectors.toMap(StdButtonEo::getCode, BaseEo::getId));
        List<MenuEo> menus = menuResources.stream().map(t -> {
            MenuEo r = new MenuEo();
            CubeBeanUtils.copyProperties((Object)r, (Object)t, (String[])new String[0]);
            Long tmp = (Long)oldMenuMap.get(r.getCode());
            r.setId(tmp == null ? ApplicationServiceImpl.getId() : tmp);
            r.setInstanceId(instanceId);
            return r;
        }).collect(Collectors.toList());
        Map<String, Long> menuMap = menus.stream().collect(Collectors.toMap(StdMenuEo::getCode, BaseEo::getId));
        List<ButtonEo> buttons = buttonResources.stream().map(t -> {
            ButtonEo r = new ButtonEo();
            CubeBeanUtils.copyProperties((Object)r, (Object)t, (String[])new String[0]);
            Long tmp = (Long)oldButtonMap.get(r.getCode());
            r.setId(tmp == null ? ApplicationServiceImpl.getId() : tmp);
            r.setInstanceId(instanceId);
            Long menuId = (Long)oldMenuMap.get(r.getParentCode());
            if (menuId == null) {
                menuId = (Long)menuMap.get(r.getParentCode());
            }
            r.setMenuId(menuId);
            return r;
        }).collect(Collectors.toList());
        this.handleAppInstance(updateOld, deleteOld, menus, buttons, oldMenus, oldButtons);
    }

    private void handleAppInstance(Boolean updateOld, Boolean deleteOld, List<MenuEo> menus, List<ButtonEo> buttons, List<MenuEo> oldMenus, List<ButtonEo> oldButtons) {
        List oldMenuCodes = oldMenus.stream().map(StdMenuEo::getCode).collect(Collectors.toList());
        List oldButtonCodes = oldButtons.stream().map(StdButtonEo::getCode).collect(Collectors.toList());
        List insertMenus = menus.stream().filter(e -> !oldMenuCodes.contains(e.getCode())).collect(Collectors.toList());
        List insertButtons = buttons.stream().filter(e -> !oldButtonCodes.contains(e.getCode()) && e.getMenuId() != null).collect(Collectors.toList());
        if (insertMenus.size() > 0) {
            this.menuDas.insertBatch(insertMenus);
        }
        if (insertButtons.size() > 0) {
            this.buttonDas.insertBatch(insertButtons);
        }
        Map<String, MenuEo> menuMap = menus.stream().collect(Collectors.toMap(StdMenuEo::getCode, e -> e));
        Map<String, ButtonEo> buttonMap = buttons.stream().collect(Collectors.toMap(StdButtonEo::getCode, e -> e));
        if (updateOld.booleanValue()) {
            oldMenus.stream().filter(e -> menuMap.containsKey(e.getCode())).forEach(e -> {
                MenuEo menuEo = (MenuEo)menuMap.get(e.getCode());
                CubeBeanUtils.copyProperties((Object)e, (Object)menuEo, (String[])new String[]{"id", "code", "instanceId", "createTime", "createPerson", "children"});
                this.menuDas.updateSelective((BaseEo)e);
            });
            oldButtons.stream().filter(e -> buttonMap.containsKey(e.getCode())).forEach(e -> {
                ButtonEo buttonEo = (ButtonEo)buttonMap.get(e.getCode());
                CubeBeanUtils.copyProperties((Object)e, (Object)buttonEo, (String[])new String[]{"id", "code", "instanceId", "createTime", "createPerson", "children"});
                this.buttonDas.updateSelective((BaseEo)e);
            });
        }
        if (deleteOld.booleanValue()) {
            List deleteMenus = oldMenus.stream().filter(e -> !menuMap.containsKey(e.getCode())).map(BaseEo::getId).collect(Collectors.toList());
            List deleteButtons = oldButtons.stream().filter(e -> !buttonMap.containsKey(e.getCode())).map(BaseEo::getId).collect(Collectors.toList());
            if (deleteMenus.size() > 0) {
                this.menuDas.deleteBatch(deleteMenus);
                this.buttonDas.deleteByMenuIds(deleteMenus);
            }
            if (deleteButtons.size() > 0) {
                this.buttonDas.deleteBatch(deleteButtons);
            }
        }
    }

    private void initRoleAndAccess(Long appId, Long instanceId, Long tenantId) {
        RoleGenerateReqDto generateReqDto = new RoleGenerateReqDto();
        generateReqDto.setApplicationId(appId);
        generateReqDto.setAppInstanceId(instanceId);
        generateReqDto.setTenantId(tenantId);
        ArrayList<RoleGenerateReqDto> list = new ArrayList<RoleGenerateReqDto>(1);
        list.add(generateReqDto);
        this.roleService.generateRole(list);
    }

    @Override
    public boolean isGlobalInstance(Long instanceId) {
        if (instanceId != null) {
            return instanceId <= 10L;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addAppInstance(AppInstanceCreateReqDto reqDto) {
        ApplicationEo application = this.addAppInstanceCheck(reqDto);
        this.checkInstanceDefDomain(reqDto);
        final AppInstanceEo appInstanceEo = this.saveAppInstance(reqDto);
        this.bindRelation(appInstanceEo);
        if (ObjectUtil.equal((Object)InstanceChannelEnum.PARTNER.getKey(), (Object)reqDto.getInstanceChannel())) {
            return appInstanceEo.getId();
        }
        this.allocateResource(reqDto, application, appInstanceEo);
        this.initRoleAndAccess(reqDto.getAppId(), appInstanceEo.getId(), reqDto.getTenantId());
        if (ObjectUtil.equal((Object)InstanceChannelEnum.THIRD_PARTY.getKey(), (Object)reqDto.getInstanceChannel())) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCommit() {
                    ApplicationServiceImpl.this.appInstanceEventService.pushEvent(appInstanceEo, "ADD");
                }
            });
        }
        return appInstanceEo.getId();
    }

    private void allocateResource(AppInstanceCreateReqDto reqDto, ApplicationEo application, AppInstanceEo appInstanceEo) {
        MenuEo menuEo;
        List menuResources = this.applicationResourceDas.findByAppCodeAndType(reqDto.getAppCode(), Integer.valueOf(ResourceType.MENU.getValue()));
        List buttonResources = this.applicationResourceDas.findByAppCodeAndType(reqDto.getAppCode(), Integer.valueOf(ResourceType.BUTTON.getValue()));
        this.syncAppInstanceMenuButton(appInstanceEo.getId(), menuResources, buttonResources, false, false);
        if ((application == null || application.getMenuId() == null) && (menuEo = this.menuDas.selectByInstanceIdAndCode(appInstanceEo.getId(), "0")) != null) {
            Long rootMenuId = menuEo.getId();
            ApplicationEo record = new ApplicationEo();
            record.setId(application.getId());
            record.setMenuId(rootMenuId);
            this.applicationDas.updateSelective((BaseEo)record);
        }
    }

    private void bindRelation(AppInstanceEo appInstanceEo) {
        if (StringUtils.isNotBlank((CharSequence)appInstanceEo.getBizSpaceCode())) {
            BizSpaceAppInstanceRelationReqDto rBizSpaceAppInstanceReqDto = new BizSpaceAppInstanceRelationReqDto();
            rBizSpaceAppInstanceReqDto.setAppInstanceId(appInstanceEo.getId());
            rBizSpaceAppInstanceReqDto.setBizSpaceCode(appInstanceEo.getBizSpaceCode());
            this.bizSpaceApi.addBizSpaceAppInstanceRelation(rBizSpaceAppInstanceReqDto);
        }
    }

    private AppInstanceEo saveAppInstance(AppInstanceCreateReqDto reqDto) {
        AppInstanceEo appInstanceEo = new AppInstanceEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)appInstanceEo);
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getTrustDomain())) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String domain : reqDto.getTrustDomain()) {
                if (domain.equals(reqDto.getDefDomain())) continue;
                stringBuilder.append(domain);
                stringBuilder.append(",");
            }
            String trustDomain = stringBuilder.toString();
            if (trustDomain.endsWith(",") && trustDomain.length() > 1) {
                appInstanceEo.setTrustDomain(trustDomain.substring(0, trustDomain.length() - 1));
            }
        }
        if (StringUtils.isBlank((CharSequence)appInstanceEo.getBizSpaceCode())) {
            appInstanceEo.setBizSpaceCode("0");
        }
        appInstanceEo.setApplicationId(reqDto.getAppId());
        appInstanceEo.setTenantId(reqDto.getTenantId());
        if (reqDto.getStatus() == null) {
            appInstanceEo.setStatus(Integer.valueOf(1));
        }
        String appSecret = Coder.md5Hex((String)Coder.randomNum((int)32));
        String appKey = Coder.md5Hex((String)Coder.randomNum((int)32));
        appInstanceEo.setAppKey(appKey);
        appInstanceEo.setAppSecret(appSecret);
        this.appInstanceDas.insert((BaseEo)appInstanceEo);
        return appInstanceEo;
    }

    private void checkInstanceDefDomain(AppInstanceCreateReqDto reqDto) {
        if (StringUtils.isBlank((CharSequence)reqDto.getDefDomain()) && CollectionUtils.isNotEmpty((Collection)reqDto.getTrustDomain())) {
            throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), "\u5fc5\u987b\u6307\u5b9a\u5e94\u7528\u7684\u9ed8\u8ba4\u8d26\u53f7\u57df");
        }
        TenantDomainQueryReqDto dto = new TenantDomainQueryReqDto();
        dto.setTenantId(reqDto.getTenantId());
        Set<String> domainSet = this.userDomainService.queryTenantDomain(dto);
        if (CollectionUtils.isEmpty(domainSet)) {
            throw new BizException(UserExceptionCode.NON_EXIST_FAIL.getCode(), "\u5f53\u524d\u79df\u6237\u6ca1\u6709\u8bbe\u7f6e\u8d26\u53f7\u57df");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDefDomain())) {
            if (!domainSet.contains(reqDto.getDefDomain())) {
                throw new BizException(UserExceptionCode.APP_INSTANCE_DOMAIN_EXIST.getCode(), UserExceptionCode.APP_INSTANCE_DOMAIN_EXIST.getMsg());
            }
        } else {
            TenantEo eo = (TenantEo)this.tenantDas.selectByPrimaryKey(reqDto.getTenantId());
            reqDto.setDefDomain(eo.getDefDomain());
        }
    }

    private ApplicationEo addAppInstanceCheck(AppInstanceCreateReqDto reqDto) {
        AppInstanceEo record;
        TenantEo tenantEo;
        if (ObjectUtil.equal((Object)InstanceChannelEnum.THIRD_PARTY.getKey(), (Object)reqDto.getInstanceChannel())) {
            AssertUtil.isTrue(reqDto.getAccountType() != null, "\u8d26\u53f7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(StrUtil.isNotBlank((CharSequence)reqDto.getAccount()), "\u7b2c\u4e09\u65b9\u5e94\u7528\u8d26\u53f7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(StrUtil.isNotBlank((CharSequence)reqDto.getInstanceConfig()), "\u7b2c\u4e09\u65b9\u5e94\u7528\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ApplicationEo application = null;
        if (reqDto.getInstanceChannel() == null || !ObjectUtil.equal((Object)InstanceChannelEnum.PARTNER.getKey(), (Object)reqDto.getInstanceChannel())) {
            ApplicationEo applicationEo = application = reqDto.getAppId() != null ? (ApplicationEo)this.applicationDas.selectByPrimaryKey(reqDto.getAppId()) : this.applicationDas.selectByCode(reqDto.getAppCode());
            if (application == null) {
                throw new BizException(UserExceptionCode.APPLICATION_EXCEPTION_CODE.getCode(), UserExceptionCode.APPLICATION_EXCEPTION_CODE.getMsg());
            }
            reqDto.setAppId(application.getId());
            reqDto.setAppCode(application.getCode());
        }
        if ((tenantEo = (TenantEo)this.tenantDas.selectByPrimaryKey(reqDto.getTenantId())) == null) {
            throw new BizException("\u79df\u6237\u4e0d\u5b58\u5728,\u79df\u6237id\u4e3a" + reqDto.getTenantId());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getAppInsName())) {
            record = new AppInstanceEo();
            record.setTenantId(reqDto.getTenantId());
            record.setAppInsName(reqDto.getAppInsName());
            if (this.appInstanceDas.count((BaseEo)record) > 0) {
                throw new BizException(UserExceptionCode.APPINSTANCE_EXIT_FAIL.getCode(), UserExceptionCode.APPINSTANCE_EXIT_FAIL.getMsg());
            }
        }
        this.instanceHostServerCheckExt.checkHostName(reqDto);
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCode())) {
            record = new AppInstanceEo();
            record.setTenantId(reqDto.getTenantId());
            record.setCode(reqDto.getCode());
            if (this.appInstanceDas.count((BaseEo)record) > 0) {
                throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), "\u5f53\u524d\u79df\u6237\u4e0b\u5e94\u7528\u7f16\u7801\u91cd\u590d,\u5e94\u7528\u7f16\u7801\u4e3a" + reqDto.getAppCode());
            }
        } else {
            reqDto.setCode("");
        }
        return application;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addBocInstance(Long tenantId, String bizSpaceCode) {
        Long bocAppId = 2L;
        String bocCode = "BOC";
        ApplicationEo eo = (ApplicationEo)this.applicationDas.selectByPrimaryKey(bocAppId);
        if (eo == null) {
            return;
        }
        AppInstanceCreateReqDto instanceDto = new AppInstanceCreateReqDto();
        instanceDto.setCode(bocCode);
        instanceDto.setAppCode(bocCode);
        instanceDto.setAppId(bocAppId);
        instanceDto.setHostName("");
        instanceDto.setServerName("");
        instanceDto.setAppInsName("BOC\u5546\u4e1a\u8fd0\u8425\u4e2d\u5fc3");
        instanceDto.setTenantId(tenantId);
        instanceDto.setBizSpaceCode(bizSpaceCode);
        this.addAppInstance(instanceDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addMpcInstance(Long tenantId, String bizSpaceCode) {
        ApplicationEo queryEo = new ApplicationEo();
        queryEo.setCode("MPC");
        queryEo.setStatus(Integer.valueOf(1));
        List list = this.applicationDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            ApplicationEo applicationEo = (ApplicationEo)list.get(0);
            AppInstanceCreateReqDto instanceDto = new AppInstanceCreateReqDto();
            instanceDto.setCode("MPC");
            instanceDto.setAppCode(applicationEo.getCode());
            instanceDto.setAppId(applicationEo.getId());
            instanceDto.setHostName("");
            instanceDto.setServerName("");
            instanceDto.setAppInsName(applicationEo.getName());
            instanceDto.setTenantId(tenantId);
            instanceDto.setBizSpaceCode(bizSpaceCode);
            this.addAppInstance(instanceDto);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TwoTuple<AppInstanceEo, AppInstanceEo> modifyAppInstance(AppPurchaseDto reqDto) {
        AppInstanceEo record;
        Long instanceId = reqDto.getInstanceId();
        AppInstanceEo dbEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        if (dbEo == null) {
            throw new BizException(UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getCode(), UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getMsg());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getAppInsName()) && !dbEo.getAppInsName().equals(reqDto.getAppInsName())) {
            record = new AppInstanceEo();
            record.setTenantId(dbEo.getTenantId());
            record.setAppInsName(reqDto.getAppInsName());
            record.setSqlFilters(Collections.singletonList(SqlFilter.ne((String)"id", (Object)instanceId)));
            if (this.appInstanceDas.count((BaseEo)record) > 0) {
                throw new BizException(UserExceptionCode.APPINSTANCE_EXIT_FAIL.getCode(), UserExceptionCode.APPINSTANCE_EXIT_FAIL.getMsg());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getHostName()) && !dbEo.getHostName().equals(reqDto.getHostName())) {
            record = new AppInstanceEo();
            record.setHostName(reqDto.getHostName());
            record.setSqlFilters(Collections.singletonList(SqlFilter.ne((String)"id", (Object)instanceId)));
            if (this.appInstanceDas.count((BaseEo)record) > 0) {
                throw new BizException(UserExceptionCode.APPINSTANCE_HOST_EXIT_FAIL.getCode(), UserExceptionCode.APPINSTANCE_HOST_EXIT_FAIL.getMsg());
            }
        }
        AppInstanceEo updateEo = new AppInstanceEo();
        updateEo.setId(dbEo.getId());
        if (reqDto.getEffectiveEndDate() != null) {
            updateEo.setEffectiveEndDate(reqDto.getEffectiveEndDate());
        }
        if (reqDto.getEffectiveStartDate() != null) {
            updateEo.setEffectiveStartDate(reqDto.getEffectiveStartDate());
        }
        if (reqDto.getPurchaseType() != null) {
            updateEo.setPurchaseType(reqDto.getPurchaseType());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getHostName())) {
            updateEo.setHostName(reqDto.getHostName());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getServerName())) {
            updateEo.setServerName(reqDto.getServerName());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getAppInsName())) {
            updateEo.setAppInsName(reqDto.getAppInsName());
        }
        if (reqDto.getStatus() != null) {
            updateEo.setStatus(reqDto.getStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getBizSpaceCode())) {
            updateEo.setBizSpaceCode(reqDto.getBizSpaceCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDataInitStatus())) {
            updateEo.setBizSpaceCode(reqDto.getDataInitStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getLogoUrl())) {
            updateEo.setLogoUrl(reqDto.getLogoUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDescription())) {
            updateEo.setDescription(reqDto.getDescription());
        }
        if (reqDto.getJumpType() != null) {
            updateEo.setJumpType(reqDto.getJumpType());
        }
        if (reqDto.getFootTable() != null) {
            updateEo.setFootTable(reqDto.getFootTable());
        }
        if (reqDto.getInstanceChannel() != null) {
            updateEo.setInstanceChannel(reqDto.getInstanceChannel());
        }
        if (reqDto.getBusinessType() != null) {
            updateEo.setBusinessType(reqDto.getBusinessType());
        }
        if (reqDto.getTerminalType() != null) {
            updateEo.setTerminalType(reqDto.getTerminalType());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getAccount())) {
            updateEo.setAccount(reqDto.getAccount());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getInstanceConfig())) {
            updateEo.setInstanceConfig(reqDto.getInstanceConfig());
        }
        if (reqDto.getAccountType() != null) {
            updateEo.setAccountType(reqDto.getAccountType());
        }
        this.appInstanceDas.updateSelective((BaseEo)updateEo);
        if (StringUtils.isBlank((CharSequence)reqDto.getLogoUrl()) && StringUtils.isNotBlank((CharSequence)dbEo.getLogoUrl())) {
            AppInstanceEo newDbEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
            newDbEo.setLogoUrl("");
            this.appInstanceDas.update((BaseEo)newDbEo);
        }
        if (updateEo.getApplicationId() == null) {
            updateEo.setApplicationId(dbEo.getApplicationId());
        }
        if (updateEo.getTenantId() == null) {
            updateEo.setTenantId(dbEo.getTenantId());
        }
        return new TwoTuple((Object)dbEo, (Object)updateEo);
    }

    @Override
    public void modifyAppInstanceAndRemoveCache(AppPurchaseDto appPurchaseDto) {
        TwoTuple<AppInstanceEo, AppInstanceEo> twoTuple = this.modifyAppInstance(appPurchaseDto);
        this.appInstanceCacheUpdater.removeCache((AppInstanceEo)twoTuple.getFirst());
        this.appInstanceCacheUpdater.updateCache((AppInstanceEo)twoTuple.getSecond());
    }

    @Override
    public void removeAppIns(Long instanceId) {
        AppInstanceEo deleteEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        this.appInstanceDas.logicDeleteById(instanceId);
        this.appInstanceCacheUpdater.removeCache(deleteEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeInstanceMenuButton(Long instanceId, List<String> menuCodes, List<String> buttonCodes) {
        if (menuCodes.size() == 0 && buttonCodes.size() == 0) {
            throw new BizException("\u8d44\u6e90\u83dc\u5355\u7f16\u7801\u548c\u8d44\u6e90\u6309\u94ae\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        if (appInstanceEo == null) {
            throw new BizException("id\u4e3a" + instanceId + "\u7684\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        menuCodes.forEach(e -> {
            MenuEo example = new MenuEo();
            example.setInstanceId(instanceId);
            example.setCode(e);
            this.menuDas.logicDeleteByExample((BaseEo)example);
        });
        buttonCodes.forEach(e -> {
            ButtonEo example = new ButtonEo();
            example.setInstanceId(instanceId);
            example.setCode(e);
            this.buttonDas.logicDeleteByExample((BaseEo)example);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateInstanceMenuButtonParent(Long instanceId, String parentCode, List<String> menuCodes, List<String> buttonCodes) {
        if (menuCodes.size() == 0 && buttonCodes.size() == 0) {
            throw new BizException("\u8d44\u6e90\u83dc\u5355\u7f16\u7801\u548c\u8d44\u6e90\u6309\u94ae\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        MenuEo menuEo = this.menuDas.selectByInstanceIdAndCode(instanceId, parentCode);
        if (menuEo == null) {
            throw new BizException("\u5e94\u7528id\u4e3a" + instanceId + ",\u7f16\u7801\u4e3a" + parentCode + "\u7684\u83dc\u5355\u4e0d\u5b58\u5728");
        }
        if (CollectionUtils.isNotEmpty(menuCodes)) {
            this.menuDas.updateParentByInstanceIdAndCodes(parentCode, menuCodes);
        }
        if (CollectionUtils.isNotEmpty(buttonCodes)) {
            this.buttonDas.updateParentByInstanceIdAndCodes(parentCode, menuEo.getId(), buttonCodes);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateInstanceButtons(List<ButtonDto> dtos) {
        dtos.forEach(e -> {
            ButtonEo eo;
            if (e.getStatus() != null && !Arrays.asList(1, 2).contains(e.getStatus())) {
                throw new BizException("\u5e94\u7528\u6309\u94ae\u72b6\u6001\u5fc5\u987b\u4e3a1\u542f\u7528\u62162\u7981\u7528");
            }
            if (e.getId() != null) {
                eo = (ButtonEo)this.buttonDas.selectByPrimaryKey(e.getId());
                if (eo == null) {
                    throw new BizException("\u6839\u636e\u6309\u94aeid\u627e\u4e0d\u5230\u5e94\u7528\u6309\u94ae");
                }
            } else if (e.getInstanceId() != null && StringUtils.isNotBlank((CharSequence)e.getCode())) {
                eo = this.buttonDas.selectByInstanceIdAndCode(e.getInstanceId(), e.getCode());
                if (eo == null) {
                    throw new BizException("\u6839\u636e\u5e94\u7528id\u548c\u6309\u94ae\u7f16\u7801\u627e\u4e0d\u5230\u5e94\u7528\u6309\u94ae");
                }
            } else {
                throw new BizException("\u6309\u94aeid\u5fc5\u4f20");
            }
            CubeBeanUtils.copyProperties((Object)eo, (Object)e, (String[])new String[]{"id", "code", "parentCode", "menuId", "createTime", "createPerson", "instanceId", "tenantId"});
            this.buttonDas.updateSelective((BaseEo)eo);
        });
    }

    @Override
    public Integer countAppInstances() {
        AppInstanceEo record = new AppInstanceEo();
        record.setDr(0);
        return this.appInstanceDas.count((BaseEo)record);
    }

    @Override
    public List<AppInstanceDto> queryAppInstanceListById(String applicationId) {
        ArrayList<AppInstanceDto> appInstanceDtos = new ArrayList<AppInstanceDto>();
        List appInstances = this.appInstanceDas.findByApplicationId(Long.decode(applicationId));
        if (CollectionUtils.isNotEmpty((Collection)appInstances)) {
            for (AppInstanceEo appInstance : appInstances) {
                try {
                    AppInstanceDto appInstanceDto = ApplicationServiceImpl.getAppInsDto(appInstance);
                    Set<String> trustDomains = this.appInstanceTrustDomainStringToSet(appInstance.getTrustDomain());
                    appInstanceDto.setTrustDomain(trustDomains);
                    appInstanceDtos.add(appInstanceDto);
                }
                catch (Exception e) {
                    this.logger.info("\u901a\u8fc7\u5e94\u7528\u5b9e\u4f8bid\u67e5\u8be2\u5e94\u7528\u5b9e\u4f8b\u5217\u8868\u5f02\u5e38");
                    throw new BizException(UserExceptionCode.BEAN_COPY_FAIL.getCode(), UserExceptionCode.BEAN_COPY_FAIL.getMsg());
                }
            }
        }
        return appInstanceDtos;
    }

    @Override
    public List<AppInstanceDto> queryAppInstanceByTenantId(Long tenantId) {
        AppInstanceEo appInstanceEo = new AppInstanceEo();
        appInstanceEo.setTenantId(tenantId);
        List appInstances = this.appInstanceDas.select((BaseEo)appInstanceEo, Integer.valueOf(0), Integer.valueOf(4096));
        ArrayList<AppInstanceDto> appInstanceDtos = new ArrayList<AppInstanceDto>();
        if (CollectionUtils.isNotEmpty((Collection)appInstances)) {
            for (AppInstanceEo appInstance : appInstances) {
                try {
                    AppInstanceDto appInstanceDto = ApplicationServiceImpl.getAppInsDto(appInstance);
                    Set<String> trustDomains = this.appInstanceTrustDomainStringToSet(appInstance.getTrustDomain());
                    appInstanceDto.setTrustDomain(trustDomains);
                    appInstanceDtos.add(appInstanceDto);
                }
                catch (Exception e) {
                    this.logger.info("\u901a\u8fc7\u79df\u6237ID\u67e5\u8be2\u5e94\u7528\u5b9e\u4f8b\u5217\u8868\u5f02\u5e38");
                    throw new BizException(UserExceptionCode.BEAN_COPY_FAIL.getCode(), UserExceptionCode.BEAN_COPY_FAIL.getMsg());
                }
            }
        }
        return appInstanceDtos;
    }

    @Override
    public List<AppInstanceDto> queryAppInstanceListByUser(Long userId) {
        ArrayList<AppInstanceDto> appInstanceDtos = new ArrayList<AppInstanceDto>();
        List appInstances = this.appInstanceDas.findAppInstancesByOwner(userId);
        if (CollectionUtils.isNotEmpty((Collection)appInstances)) {
            for (AppInstanceEo appInstance : appInstances) {
                try {
                    AppInstanceDto appInstanceDto = ApplicationServiceImpl.getAppInsDto(appInstance);
                    Set<String> trustDomains = this.appInstanceTrustDomainStringToSet(appInstance.getTrustDomain());
                    appInstanceDto.setTrustDomain(trustDomains);
                    appInstanceDtos.add(appInstanceDto);
                }
                catch (Exception e) {
                    this.logger.error("\u901a\u8fc7\u7528\u6237id\u67e5\u8be2\u5e94\u7528\u5b9e\u4f8b\u5217\u8868\u5f02\u5e38", (Throwable)e);
                    throw new BizException(UserExceptionCode.BEAN_COPY_FAIL.getCode(), UserExceptionCode.BEAN_COPY_FAIL.getMsg());
                }
            }
        }
        return appInstanceDtos;
    }

    @Override
    public void assertAppInstanceExists(Long instanceId) {
        AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        AssertUtil.isTrue(appInstanceEo != null, "Application-Key\u4e0d\u5b58\u5728");
    }

    @Override
    public PageInfo<AppInstanceDto> queryAppInstanceByExample(String filter, Integer pageNum, Integer pageSize) {
        AppInstanceEo appInstanceEo = new AppInstanceEo();
        appInstanceEo.setSqlFilters(this.addAppInstanceSqlFilter(filter));
        appInstanceEo.setOrderByDesc("update_time");
        PageInfo page = this.appInstanceDas.selectPage((BaseEo)appInstanceEo, pageNum, pageSize);
        PageInfo<AppInstanceDto> appInstanceDtoPageInfo = this.fillAppInstanceResponseDto((PageInfo<AppInstanceEo>)page);
        return appInstanceDtoPageInfo;
    }

    private PageInfo<AppInstanceDto> fillAppInstanceResponseDto(PageInfo<AppInstanceEo> page) {
        ArrayList<AppInstanceDto> appInstanceDtos = new ArrayList<AppInstanceDto>();
        HashMap<Long, String> map = new HashMap<Long, String>();
        for (AppInstanceEo applicationEo : page.getList()) {
            ApplicationEo application;
            AppInstanceDto appInstanceDto = new AppInstanceDto();
            DtoHelper.eo2Dto((BaseEo)applicationEo, (BaseVo)appInstanceDto);
            Set<String> trustDomains = this.appInstanceTrustDomainStringToSet(applicationEo.getTrustDomain());
            appInstanceDto.setTrustDomain(trustDomains);
            appInstanceDtos.add(appInstanceDto);
            if (applicationEo.getApplicationId() == null || (application = (ApplicationEo)this.applicationDas.selectByPrimaryKey(applicationEo.getApplicationId())) == null) continue;
            map.put(applicationEo.getId(), application.getName());
        }
        PageInfo appInstanceDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)appInstanceDtoPageInfo, page, (String[])new String[]{"list", "navigatepageNums"});
        appInstanceDtoPageInfo.setList(appInstanceDtos);
        for (AppInstanceDto appInstanceDto : appInstanceDtoPageInfo.getList()) {
            UserEo userEo;
            if (appInstanceDto.getOwner() != null && (userEo = (UserEo)this.userDas.selectByPrimaryKey(appInstanceDto.getOwner())) != null) {
                appInstanceDto.setOwnerName(userEo.getUserName());
            }
            for (Map.Entry entry : map.entrySet()) {
                if (((Long)entry.getKey()).compareTo(appInstanceDto.getId()) != 0) continue;
                appInstanceDto.setAppName((String)entry.getValue());
            }
        }
        return appInstanceDtoPageInfo;
    }

    @Override
    public PageInfo<AppInstanceDto> queryAppInstance(AppInstanceQueryReqDto queryReq, Integer pageNum, Integer pageSize) {
        AppInstanceEo queryCriteria = this.packInstanceCriteria(queryReq);
        if (queryCriteria == null) {
            return PageInfo.of(new ArrayList());
        }
        PageInfo page = this.appInstanceDas.selectPage((BaseEo)queryCriteria, pageNum, pageSize);
        PageInfo<AppInstanceDto> appInstanceDtoPageInfo = this.fillAppInstanceResponseDto((PageInfo<AppInstanceEo>)page);
        return appInstanceDtoPageInfo;
    }

    private AppInstanceEo packInstanceCriteria(AppInstanceQueryReqDto queryReq) {
        AppInstanceEo criteria = new AppInstanceEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (queryReq != null) {
            DtoHelper.dto2Eo((BaseVo)queryReq, (BaseEo)criteria);
            if (StringUtils.isNotBlank((CharSequence)queryReq.getAppInsCode())) {
                criteria.setCode(queryReq.getAppInsCode());
            }
            if (StringUtils.isNotBlank((CharSequence)queryReq.getAppCode())) {
                criteria.setApplicationCode(queryReq.getAppCode());
            }
            if (!queryReq.isIncludeTenantApp()) {
                sqlFilterList.add(SqlFilter.gt((String)"application_id", (Object)100L));
            }
            if (this.isGlobalInstance(ServiceContextUtil.getRequestApplicationId())) {
                criteria.setTenantId(queryReq.getQueryTenantId());
            } else {
                Long requestTenantId = ServiceContext.getContext().getRequestTenantId();
                if (requestTenantId != null) {
                    criteria.setTenantId(requestTenantId);
                } else {
                    this.logger.warn("\u6ca1\u6709\u4f20\u9012\u79df\u6237\u4fe1\u606f,\u8fd4\u56de\u7a7a\u67e5\u8be2");
                    return null;
                }
            }
        }
        criteria.setSqlFilters(sqlFilterList);
        return criteria;
    }

    @Override
    public void reqShouldFromPlatformApp() {
        Long reqInstanceId = ServiceContext.getContext().getRequestInstanceId();
        if (!this.isPlatformAppInstance(reqInstanceId)) {
            throw new com.dtyunxi.yundt.cube.center.user.biz.exception.BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), "\u4ec5\u5e73\u53f0\u5e94\u7528(\u5982MPC/BOC)\u624d\u53ef\u4f7f\u7528\u672c\u63a5\u53e3");
        }
    }

    @Override
    public boolean isPlatformAppInstance(Long instanceId) {
        if (instanceId == null) {
            return false;
        }
        AppInstanceEo appInstance = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        if (appInstance != null) {
            return this.isPlatformApp(appInstance.getApplicationId());
        }
        return false;
    }

    private boolean isPlatformApp(Long appId) {
        if (appId != null) {
            return appId <= 10L || appId == 101L;
        }
        return false;
    }

    @Override
    public List<AppInstanceSummaryResDto> queryInstanceSummaries(AppInstanceQueryReqDto queryReq, Integer pageNum, Integer pageSize) {
        AppInstanceEo queryCriteria = this.packInstanceCriteria(queryReq);
        if (queryCriteria == null) {
            return new ArrayList<AppInstanceSummaryResDto>();
        }
        List page = this.appInstanceDas.select((BaseEo)queryCriteria, pageNum, pageSize);
        List<AppInstanceSummaryResDto> resultList = page.stream().map(eo -> {
            AppInstanceSummaryResDto respDto = new AppInstanceSummaryResDto();
            respDto.setAppInsCode(eo.getCode()).setBizSpaceCode(eo.getBizSpaceCode()).setId(eo.getId()).setName(eo.getAppInsName()).setStatus(eo.getStatus());
            return respDto;
        }).collect(Collectors.toList());
        return resultList;
    }

    @Override
    public AppInstanceDto queryByHostName(String hostName) {
        AppInstanceEo appInstanceEo = this.appInstanceDas.findByHostName(hostName);
        if (appInstanceEo == null && (appInstanceEo = this.instanceRelationService.getByMoreHostName(hostName)) == null) {
            return null;
        }
        AppInstanceDto appInstanceDto = new AppInstanceDto();
        DtoHelper.eo2Dto((BaseEo)appInstanceEo, (BaseVo)appInstanceDto);
        appInstanceDto.setAppKey(appInstanceEo.getAppKey());
        appInstanceDto.setAppSecret(appInstanceEo.getAppSecret());
        return appInstanceDto;
    }

    @Override
    public Long queryTenantIdByAppInsId(Long instanceId) {
        if (instanceId == null) {
            return null;
        }
        AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        if (appInstanceEo != null) {
            return appInstanceEo.getTenantId();
        }
        return null;
    }

    @Override
    public AppInstanceDto queryByAppKey(String appInsKey) {
        AppInstanceEo appInstanceEo = this.appInstanceDas.queryByAppKey(appInsKey);
        if (appInstanceEo == null) {
            return null;
        }
        return this.convert2AppInstanceDto(appInstanceEo);
    }

    @Override
    public AppInstanceDto queryInstanceOne(Long instanceId) {
        AppInstanceEo appInstance = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        return this.convert2AppInstanceDto(appInstance);
    }

    private AppInstanceDto convert2AppInstanceDto(AppInstanceEo appInstance) {
        AppInstanceDto appInstanceDto = new AppInstanceDto();
        if (appInstance != null && appInstance.getApplicationId() != null) {
            try {
                CubeBeanUtils.copyProperties((Object)appInstanceDto, (Object)appInstance, (String[])new String[0]);
                appInstanceDto.setApplicationId(appInstance.getApplicationId());
                Set<String> trustDomainSet = this.appInstanceTrustDomainStringToSet(appInstance.getTrustDomain());
                appInstanceDto.setTrustDomain(trustDomainSet);
                return appInstanceDto;
            }
            catch (Exception e) {
                this.logger.info("\u901a\u8fc7\u5e94\u7528\u5b9e\u4f8bid\u67e5\u8be2\u5e94\u7528\u5b9e\u4f8b\uff0ceo\u8f6cdto\u5c5e\u6027\u8f6c\u6362\u5931\u8d25:\u5b9e\u4f8bid\u4e3a" + appInstance.getId() + "\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
                throw new BizException(UserExceptionCode.BEAN_COPY_FAIL.getCode(), UserExceptionCode.BEAN_COPY_FAIL.getMsg());
            }
        }
        return null;
    }

    @Override
    public RestResponse<List<UserAppInstanceDto>> queryInstanceByTenantId(Long tenantId, Long userId) {
        List<UserAppInstanceDto> userAppInstanceDtos = this.userService.queryInstanceByTenantId(tenantId, userId);
        return new RestResponse(userAppInstanceDtos);
    }

    @Override
    public List<ApplicationQueryRespDto> queryAppByTenantId(Long tenantId) {
        List<AppInstanceDto> appInstanceDtoList = this.queryAppInstanceByTenantId(tenantId);
        ArrayList<ApplicationQueryRespDto> applicationQueryRespDtoList = new ArrayList<ApplicationQueryRespDto>();
        if (CollectionUtils.isEmpty(appInstanceDtoList)) {
            return applicationQueryRespDtoList;
        }
        Map<Object, Object> bizSpaceCode2NameMap = new HashMap();
        BizSpaceQueryReqDto bizSpaceQueryReqDto = new BizSpaceQueryReqDto();
        RestResponse restResponse = this.bizSpaceQueryApi.queryByPage(bizSpaceQueryReqDto, Integer.valueOf(1), Integer.valueOf(100));
        if ("0".equals(restResponse.getResultCode()) && restResponse.getData() != null && CollectionUtils.isNotEmpty((Collection)((PageInfo)restResponse.getData()).getList())) {
            List bizSpaceRespDtoList = ((PageInfo)restResponse.getData()).getList();
            bizSpaceCode2NameMap = bizSpaceRespDtoList.stream().collect(Collectors.toMap(BizSpaceRespDto::getCode, BizSpaceRespDto::getName));
        }
        ApplicationQueryReqDto applicationQueryReqDto = new ApplicationQueryReqDto();
        for (AppInstanceDto appInstanceDto : appInstanceDtoList) {
            if (appInstanceDto.getApplicationId() == null || ObjectUtil.equal((Object)InstanceChannelEnum.PARTNER.getKey(), (Object)appInstanceDto.getInstanceChannel())) continue;
            ApplicationQueryRespDto applicationQueryRespDto = new ApplicationQueryRespDto();
            applicationQueryReqDto.setId(appInstanceDto.getApplicationId());
            applicationQueryReqDto.setWithRoleTemplate(Boolean.valueOf(false));
            ApplicationDto applicationDto = this.queryOne(applicationQueryReqDto);
            if ("MPC".equals(appInstanceDto.getCode())) continue;
            applicationQueryRespDto.setAppTempName(applicationDto.getName());
            if (StrUtil.isNotBlank((CharSequence)appInstanceDto.getBizSpaceCode())) {
                appInstanceDto.setBizSpaceName((String)bizSpaceCode2NameMap.get(appInstanceDto.getBizSpaceCode()));
            }
            applicationQueryRespDto.setAppInstanceDto(appInstanceDto);
            applicationQueryRespDtoList.add(applicationQueryRespDto);
        }
        return applicationQueryRespDtoList;
    }

    @Override
    public InstanceInitResourceResDto queryAppInstanceInitResource(Long instanceId, List<String> res) {
        if (CollectionUtils.isEmpty(res) || res.stream().anyMatch(e -> !"menus".equals(e) && !"buttons".equals(e))) {
            throw new BizException("res\u53ea\u80fd\u4e3abuttons,menus\u6216\u8005buttons\u6216\u8005menus");
        }
        AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        if (appInstanceEo == null) {
            throw new BizException("\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        ApplicationEo applicationEo = (ApplicationEo)this.applicationDas.selectByPrimaryKey(appInstanceEo.getApplicationId());
        if (applicationEo == null) {
            throw new BizException("\u5e94\u7528\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        String code = applicationEo.getCode();
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new BizException("\u5e94\u7528\u6a21\u677f\u7f16\u7801\u4e0d\u5b58\u5728");
        }
        InstanceInitResourceResDto result = new InstanceInitResourceResDto();
        if (res.contains("menus")) {
            List menuResources = this.applicationResourceDas.findByAppCodeAndType(code, Integer.valueOf(ResourceType.MENU.getValue()));
            List menusCodes = this.menuDas.selectByInstanceId(instanceId).stream().map(StdMenuEo::getCode).collect(Collectors.toList());
            List rootList = ResourceDas.buildTree((String)"-1", (String)applicationEo.getCode(), menuResources.stream().map(e -> {
                ResourceQueryResDto nodeDto = new ResourceQueryResDto();
                DtoHelper.eo2Dto((BaseEo)e, (BaseVo)nodeDto);
                nodeDto.setChecked(Boolean.valueOf(menusCodes.contains(e.getCode())));
                return nodeDto;
            }).collect(Collectors.toList()));
            if (rootList.size() == 1) {
                result.setMenus((ResourceQueryResDto)rootList.get(0));
            } else if (rootList.size() > 1) {
                throw new BizException("\u83dc\u5355\u6570\u636e\u5f02\u5e38");
            }
        }
        if (res.contains("buttons")) {
            List buttonResources = this.applicationResourceDas.findByAppCodeAndType(code, Integer.valueOf(ResourceType.BUTTON.getValue()));
            List buttonCodes = this.buttonDas.selectByInstanceId(instanceId).stream().map(StdButtonEo::getCode).collect(Collectors.toList());
            ArrayList buttonDtos = new ArrayList();
            DtoHelper.eoList2DtoList((Collection)buttonResources, buttonDtos, ResourceQueryResDto.class);
            buttonDtos.forEach(e -> e.setChecked(Boolean.valueOf(buttonCodes.contains(e.getCode()))));
            result.setButtons(buttonDtos);
        }
        return result;
    }

    @Override
    public AppInstanceQueryResDto queryInstanceResources(AppInstanceResourceDto appInstanceResourceDto) {
        Long instanceId = appInstanceResourceDto.getInstanceId();
        Long menuId = appInstanceResourceDto.getMenuId();
        List res = appInstanceResourceDto.getRes();
        String buttonName = appInstanceResourceDto.getButtonName();
        if (CollectionUtils.isEmpty((Collection)res) || res.stream().anyMatch(e -> !"menus".equals(e) && !"buttons".equals(e))) {
            throw new BizException("res\u53ea\u80fd\u4e3abuttons,menus\u6216\u8005buttons\u6216\u8005menus");
        }
        AppInstanceEo appInstance = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        AppInstanceQueryResDto resDto = new AppInstanceQueryResDto();
        DtoHelper.eo2Dto((BaseEo)appInstance, (BaseVo)resDto);
        Set<String> trustDomainSet = this.appInstanceTrustDomainStringToSet(appInstance.getTrustDomain());
        resDto.setTrustDomain(trustDomainSet);
        if (menuId == null) {
            if (res.contains("menus")) {
                List menuEos = this.menuDas.selectByInstanceId(instanceId);
                List rootList = MenuDas.buildTree((String)"-1", menuEos.stream().map(e -> {
                    MenuQueryResDto nodeDto = new MenuQueryResDto();
                    DtoHelper.eo2Dto((BaseEo)e, (BaseVo)nodeDto);
                    nodeDto.setName_i1(e.getNameI1());
                    nodeDto.setName_i2(e.getNameI2());
                    return nodeDto;
                }).collect(Collectors.toList()));
                if (rootList.size() == 1) {
                    resDto.setMenus((MenuQueryResDto)rootList.get(0));
                } else if (rootList.size() > 1) {
                    throw new BizException("\u83dc\u5355\u6570\u636e\u5f02\u5e38");
                }
            }
            if (res.contains("buttons")) {
                List buttonEos = this.buttonDas.selectByInstanceId(instanceId);
                ArrayList list = new ArrayList(buttonEos.size());
                DtoHelper.eoList2DtoList((Collection)buttonEos, list, ButtonQueryResDto.class);
                List parentCodes = buttonEos.stream().map(StdButtonEo::getParentCode).collect(Collectors.toList());
                Map<String, Long> codeMapId = this.menuDas.selectByCodes(parentCodes, instanceId).stream().collect(Collectors.toMap(StdMenuEo::getCode, BaseEo::getId, (id1, id2) -> id1));
                codeMapId.put("-1", ResourceEo.ROOT_PARENT_ID);
                for (ButtonQueryResDto buttonQueryResDto : list) {
                    buttonQueryResDto.setMenuId(codeMapId.get(buttonQueryResDto.getParentCode()));
                }
                resDto.setButtons(list);
            }
        } else {
            MenuEo menuEo = (MenuEo)this.menuDas.selectByPrimaryKey(menuId);
            if (menuEo != null) {
                if (res.contains("menus")) {
                    MenuQueryResDto nodeDto = new MenuQueryResDto();
                    DtoHelper.eo2Dto((BaseEo)menuEo, (BaseVo)nodeDto);
                    nodeDto.setName_i1(menuEo.getNameI1());
                    nodeDto.setName_i2(menuEo.getNameI2());
                    resDto.setMenus(nodeDto);
                }
                if (res.contains("buttons")) {
                    List buttonEos = this.buttonDas.selectByMenuId(menuId, appInstanceResourceDto);
                    ArrayList list = new ArrayList(buttonEos.size());
                    DtoHelper.eoList2DtoList((Collection)buttonEos, list, ButtonQueryResDto.class);
                    resDto.setButtons(list);
                }
            }
        }
        return resDto;
    }

    @Override
    public AppInstanceQueryResDto queryInsByInstanceIdAndUserIdAndResources(Long instanceId, Long userId, List<String> res) {
        AppInstanceEo appInstance = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        AppInstanceQueryResDto resDto = new AppInstanceQueryResDto();
        DtoHelper.eo2Dto((BaseEo)appInstance, (BaseVo)resDto);
        UserAccessVo userAccessVo = this.accessService.queryUserAccess(instanceId, userId);
        Set accessSet = userAccessVo.getAccessSet();
        ArrayList menuDtoList = Lists.newArrayList();
        ArrayList buttonDtoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)accessSet)) {
            for (AccessDto accessDto : accessSet) {
                if (res.contains("menus") && Integer.valueOf(1).equals(accessDto.getResourceType())) {
                    MenuQueryResDto menuQueryResDto = new MenuQueryResDto();
                    CubeBeanUtils.copyProperties((Object)menuQueryResDto, (Object)accessDto.getMenuDto(), (String[])new String[0]);
                    menuDtoList.add(menuQueryResDto);
                }
                if (!res.contains("buttons") || !Integer.valueOf(2).equals(accessDto.getResourceType())) continue;
                ButtonQueryResDto buttonQueryResDto = new ButtonQueryResDto();
                CubeBeanUtils.copyProperties((Object)buttonQueryResDto, (Object)accessDto.getButtonDto(), (String[])new String[0]);
                buttonDtoList.add(buttonQueryResDto);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)menuDtoList)) {
            List rootList;
            if (menuDtoList.stream().noneMatch(e -> "-1".equals(e.getParentCode()))) {
                MenuQueryResDto root = new MenuQueryResDto();
                root.setCode("0");
                root.setParentCode("-1");
                root.setName("\u9ed8\u8ba4");
                menuDtoList.add(root);
            }
            if ((rootList = MenuDas.buildTree((String)"-1", menuDtoList.stream().filter(dto -> StringUtils.isNotBlank((CharSequence)dto.getParentCode())).collect(Collectors.toList()))).size() == 1) {
                resDto.setMenus((MenuQueryResDto)rootList.get(0));
            } else if (rootList.size() > 1) {
                throw new BizException("\u83dc\u5355\u6570\u636e\u5f02\u5e38");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)buttonDtoList)) {
            resDto.setButtons((List)buttonDtoList);
        }
        return resDto;
    }

    @Override
    @Deprecated
    @Transactional(rollbackFor={Exception.class})
    public Boolean appBindButton(Long appId, Long menuId, List<ButtonDto> buttonDtos) {
        ApplicationEo applicationEo = (ApplicationEo)this.applicationDas.selectByPrimaryKey(appId);
        if (applicationEo == null) {
            this.logger.info("\u7ed1\u5b9a\u6309\u94ae\uff0c\u65e0\u6cd5\u901a\u8fc7\u5e94\u7528id\u67e5\u8be2\u5230\u5e94\u7528\u4fe1\u606f,\u5e94\u7528id\u4e3a:" + appId);
            throw new BizException(UserExceptionCode.APPLICATION_EXCEPTION_CODE.getCode(), UserExceptionCode.APPLICATION_EXCEPTION_CODE.getMsg());
        }
        if (2 == applicationEo.getStatus()) {
            this.logger.info("\u65e0\u6cd5\u7ed1\u5b9a\u6309\u94ae\uff0c\u8be5\u5e94\u7528id\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u5e94\u7528id\uff1a{}", (Object)appId);
            throw new BizException(UserExceptionCode.APPLICATION_DISABLED.getCode(), UserExceptionCode.APPLICATION_DISABLED.getMsg());
        }
        MenuEo menuEo = (MenuEo)this.menuDas.selectByPrimaryKey(menuId);
        if (menuEo == null) {
            this.logger.info("\u83dc\u5355\u4e0d\u5b58\u5728,\u83dc\u5355id\u4e3a:" + menuId);
            throw new BizException(UserExceptionCode.MENU_NOTEXIT_FAIL.getCode(), UserExceptionCode.MENU_NOTEXIT_FAIL.getMsg());
        }
        List buttons = this.buttonDas.findByApplicationId(appId);
        for (ButtonDto buttonDto : buttonDtos) {
            for (ButtonEo buttonEo : buttons) {
                if (StringUtils.equals((CharSequence)buttonEo.getCode(), (CharSequence)buttonDto.getCode())) {
                    throw new BizException(UserExceptionCode.BUTTON_EXIT_FAIL.getCode(), UserExceptionCode.BUTTON_EXIT_FAIL.getMsg() + "\u6309\u94ae\u7f16\u7801\u4e3a" + buttonEo.getCode());
                }
                if (!StringUtils.equals((CharSequence)buttonEo.getRoutePath(), (CharSequence)buttonDto.getRoutePath())) continue;
                throw new BizException(UserExceptionCode.BUTTON_PATH_EXIT_FAIL.getCode(), UserExceptionCode.BUTTON_PATH_EXIT_FAIL.getMsg() + "\u6309\u94ae\u8def\u5f84\u4e3a" + buttonEo.getRoutePath());
            }
        }
        ArrayList buttonEos = new ArrayList();
        DtoHelper.dtoList2EoList(buttonDtos, buttonEos, ButtonEo.class);
        for (ButtonEo buttonEo : buttonEos) {
            buttonEo.setParentCode(menuEo.getCode());
            buttonEo.setInstanceId(menuEo.getInstanceId());
            this.buttonDas.insert((BaseEo)buttonEo);
        }
        return true;
    }

    @Override
    @Deprecated
    @Transactional(rollbackFor={Exception.class})
    public Boolean appUnBindButton(Long appId, Long menuId, List<Long> buttonIds) {
        ApplicationEo applicationEo = (ApplicationEo)this.applicationDas.selectByPrimaryKey(appId);
        if (applicationEo == null) {
            this.logger.info("\u89e3\u9664\u7ed1\u5b9a\u6309\u94ae\uff0c\u65e0\u6cd5\u901a\u8fc7\u5e94\u7528id\u67e5\u8be2\u5230\u5e94\u7528\u4fe1\u606f,\u5e94\u7528id\u4e3a:" + appId);
            throw new BizException(UserExceptionCode.APPLICATION_EXCEPTION_CODE.getCode(), UserExceptionCode.APPLICATION_EXCEPTION_CODE.getMsg());
        }
        if (2 == applicationEo.getStatus()) {
            this.logger.info("\u65e0\u6cd5\u89e3\u9664\u7ed1\u5b9a\u6309\u94ae\uff0c\u8be5\u5e94\u7528id\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u5e94\u7528id\uff1a{}", (Object)appId);
            throw new BizException(UserExceptionCode.APPLICATION_DISABLED.getCode(), UserExceptionCode.APPLICATION_DISABLED.getMsg());
        }
        for (Long id : buttonIds) {
            if (this.buttonDas.selectByPrimaryKey(id) != null) continue;
            throw new BizException(UserExceptionCode.BUTTON_IDCHECK_FAIL.getCode(), UserExceptionCode.BUTTON_IDCHECK_FAIL.getMsg());
        }
        List buttonEos = this.buttonDas.findByApplicationId(appId);
        for (ButtonEo buttonEo : buttonEos) {
            if (!buttonIds.contains(buttonEo.getId())) continue;
            PackageButtonRelationEo buttonRelationEo = new PackageButtonRelationEo();
            buttonRelationEo.setButtonId(buttonEo.getId());
            if (this.packageButtonRelationDas.count((BaseEo)buttonRelationEo) > 0) {
                throw new BizException("\u8be5\u6309\u94ae\u88ab\u5e94\u7528\u5957\u9910\u5f15\u7528\uff0c\u65e0\u6cd5\u89e3\u9664\u7ed1\u5b9a");
            }
            this.buttonDas.logicDelete((BaseEo)buttonEo);
        }
        return true;
    }

    @Override
    @Deprecated
    @Transactional(rollbackFor={Exception.class})
    public Long appBindMenu(Long appId, MenuDto menuDto) {
        MenuEo root;
        List menuEoss;
        Long tenantId = menuDto.getTenantId();
        Long instanceId = menuDto.getInstanceId();
        ApplicationEo applicationEo = (ApplicationEo)this.applicationDas.selectByPrimaryKey(appId);
        if (applicationEo == null) {
            this.logger.info("\u7ed1\u5b9a\u83dc\u5355\uff0c\u65e0\u6cd5\u901a\u8fc7\u5e94\u7528id\u67e5\u8be2\u5230\u5e94\u7528\u4fe1\u606f,\u5e94\u7528id\u4e3a:" + appId);
            throw new BizException(UserExceptionCode.APPLICATION_EXCEPTION_CODE.getCode(), UserExceptionCode.APPLICATION_EXCEPTION_CODE.getMsg());
        }
        if (2 == applicationEo.getStatus()) {
            this.logger.info("\u65e0\u6cd5\u7ed1\u5b9a\u83dc\u5355\uff0c\u8be5\u5e94\u7528id\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u5e94\u7528id\uff1a{}", (Object)appId);
            throw new BizException(UserExceptionCode.APPLICATION_DISABLED.getCode(), UserExceptionCode.APPLICATION_DISABLED.getMsg());
        }
        MenuEo menu = (MenuEo)this.menuDas.selectByPrimaryKey(applicationEo.getMenuId());
        if (menu != null) {
            this.validMenu(menu, menuDto);
        }
        if (CollectionUtils.isEmpty((Collection)(menuEoss = this.menuDas.selectAll()))) {
            root = new MenuEo();
            root.setName("\u6839\u8282\u70b9");
            root.setStatus(Integer.valueOf(1));
            root.setCreatePerson("System");
            root.setCreateTime(new Date());
            root.setTenantId(tenantId);
            root.setInstanceId(instanceId);
            this.menuDas.insert((BaseEo)root);
        }
        root = this.menuDas.findRootMenu();
        if (menuDto.getParentId() != null) {
            if (this.menuDas.selectByPrimaryKey(menuDto.getParentId()) == null) {
                this.logger.info("\u7ed1\u5b9a\u83dc\u5355\uff0c\u65e0\u6cd5\u627e\u5230\u83dc\u5355\u7236\u8282\u70b9\u4fe1\u606f,id\u4e3a:" + menuDto.getParentId());
                throw new BizException(UserExceptionCode.MENU_NOTEXIT_FAIL.getCode(), UserExceptionCode.MENU_NOTEXIT_FAIL.getMsg());
            }
        } else if (root != null) {
            menuDto.setParentId(root.getId());
        }
        MenuEo menuEo = new MenuEo();
        DtoHelper.dto2Eo((BaseVo)menuDto, (BaseEo)menuEo);
        if (CollectionUtils.isNotEmpty((Collection)menuDto.getChildren())) {
            menuEo.setId(Collection2SqlInConditionUtil.getId());
            List<MenuEo> list = this.recursionMenus(menuEo.getInstanceId(), menuEo.getCode(), menuDto);
            list.add(menuEo);
            this.menuDas.insertBatch(list);
        } else {
            this.menuDas.insert((BaseEo)menuEo);
        }
        if (menu == null || applicationEo.getMenuId() == null) {
            applicationEo.setMenuId(menuEo.getId());
            this.applicationDas.update((BaseEo)applicationEo);
        }
        return menuEo.getId();
    }

    private List<MenuEo> recursionMenus(Long instanceId, String parentCode, MenuDto menuDto) {
        LinkedList<MenuEo> list = new LinkedList<MenuEo>();
        if (CollectionUtils.isNotEmpty((Collection)menuDto.getChildren())) {
            for (MenuDto child : menuDto.getChildren()) {
                MenuEo eo = new MenuEo();
                DtoHelper.dto2Eo((BaseVo)child, (BaseEo)eo);
                eo.setInstanceId(instanceId);
                eo.setParentCode(parentCode);
                eo.setId(ApplicationServiceImpl.getId());
                list.add(eo);
                list.addAll(this.recursionMenus(eo.getInstanceId(), eo.getCode(), child));
            }
        }
        return list;
    }

    @Override
    public Boolean modifyAppMenu(Long appId, Long id, MenuDto menuDto) {
        MenuEo menuEo;
        ApplicationEo applicationEo = (ApplicationEo)this.applicationDas.selectByPrimaryKey(appId);
        if (applicationEo == null) {
            this.logger.info("\u7ed1\u5b9a\u83dc\u5355\uff0c\u65e0\u6cd5\u901a\u8fc7\u5e94\u7528\u6a21\u677fid\u67e5\u8be2\u5230\u5e94\u7528\u6a21\u677f\u4fe1\u606f,\u5e94\u7528\u6a21\u677fid\u4e3a:" + appId);
            throw new BizException(UserExceptionCode.APPLICATION_EXCEPTION_CODE.getCode(), UserExceptionCode.APPLICATION_EXCEPTION_CODE.getMsg());
        }
        if (2 == applicationEo.getStatus()) {
            this.logger.info("\u65e0\u6cd5\u4fee\u6539\u83dc\u5355\uff0c\u8be5\u5e94\u7528\u6a21\u677fid\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u5e94\u7528\u6a21\u677fid\uff1a{}", (Object)appId);
            throw new BizException(UserExceptionCode.APPLICATION_DISABLED.getCode(), UserExceptionCode.APPLICATION_DISABLED.getMsg());
        }
        MenuEo menu = (MenuEo)this.menuDas.selectByPrimaryKey(applicationEo.getMenuId());
        if (menu != null) {
            this.validUpdateMenu(menu, menuDto);
        }
        if ((menuEo = (MenuEo)this.menuDas.selectByPrimaryKey(id)) == null) {
            this.logger.info("\u4fee\u6539\u83dc\u5355\u8d44\u6e90\uff0c\u65e0\u6cd5\u901a\u8fc7\u83dc\u5355id\u67e5\u8be2\u5230\u83dc\u5355\u4fe1\u606f,\u83dc\u5355id\u4e3a:" + menuDto.getId());
            throw new BizException(UserExceptionCode.MENU_NOTEXIT_FAIL.getCode(), UserExceptionCode.MENU_NOTEXIT_FAIL.getMsg());
        }
        if (new Integer(2).equals(menuDto.getStatus())) {
            PackageMenuRelationEo packageMenuRelationEo = new PackageMenuRelationEo();
            packageMenuRelationEo.setMenuId(id);
            if (this.packageMenuRelationDas.count((BaseEo)packageMenuRelationEo) > 0) {
                throw new BizException("\u8be5\u83dc\u5355\u88ab\u5e94\u7528\u5957\u9910\u5f15\u7528\uff0c\u65e0\u6cd5\u7981\u7528");
            }
        }
        DtoHelper.dto2Eo((BaseVo)menuDto, (BaseEo)menuEo, (String[])new String[]{"id"});
        if (menuDto.getParentId() != null) {
            MenuEo parent = (MenuEo)this.menuDas.selectByPrimaryKey(menuDto.getParentId());
            AssertUtil.isTrue(parent != null, "\u627e\u4e0d\u5230id\u4e3a" + menuDto.getParentId() + "\u7684\u83dc\u5355\uff01");
            menuEo.setInstanceId(parent.getInstanceId());
            menuEo.setParentCode(parent.getParentCode());
        }
        this.menuDas.update((BaseEo)menuEo);
        return null;
    }

    @Override
    @Deprecated
    @Transactional(rollbackFor={Exception.class})
    public Boolean appUnBindMenu(Long appId, Long menuId) {
        ApplicationEo applicationEo = (ApplicationEo)this.applicationDas.selectByPrimaryKey(appId);
        if (applicationEo == null) {
            this.logger.info("\u89e3\u9664\u7ed1\u5b9a\u83dc\u5355\uff0c\u65e0\u6cd5\u901a\u8fc7\u5e94\u7528id\u67e5\u8be2\u5230\u5e94\u7528\u4fe1\u606f,\u5e94\u7528id\u4e3a:" + appId);
            throw new BizException(UserExceptionCode.APPLICATION_EXCEPTION_CODE.getCode(), UserExceptionCode.APPLICATION_EXCEPTION_CODE.getMsg());
        }
        if (2 == applicationEo.getStatus()) {
            this.logger.info("\u65e0\u6cd5\u89e3\u9664\u7ed1\u5b9a\u83dc\u5355\uff0c\u8be5\u5e94\u7528id\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u5e94\u7528id\uff1a{}", (Object)appId);
            throw new BizException(UserExceptionCode.APPLICATION_DISABLED.getCode(), UserExceptionCode.APPLICATION_DISABLED.getMsg());
        }
        if (this.menuDas.selectByPrimaryKey(menuId) == null) {
            this.logger.info("\u89e3\u7ed1\u7ed1\u5b9a\u83dc\u5355\uff0c\u67e5\u8be2\u83dc\u5355\u4fe1\u606f\u5f02\u5e38,id\u4e3a:" + menuId);
            throw new BizException(UserExceptionCode.MENU_NOTEXIT_FAIL.getCode(), UserExceptionCode.MENU_NOTEXIT_FAIL.getMsg());
        }
        if (applicationEo.getMenuId().compareTo(menuId) == 0) {
            applicationEo.setMenuId(null);
            this.applicationDas.update((BaseEo)applicationEo);
        }
        PackageMenuRelationEo packageMenuRelationEo = new PackageMenuRelationEo();
        packageMenuRelationEo.setMenuId(menuId);
        if (this.packageMenuRelationDas.count((BaseEo)packageMenuRelationEo) > 0) {
            throw new BizException("\u8be5\u83dc\u5355\u88ab\u5e94\u7528\u5957\u9910\u5f15\u7528\uff0c\u65e0\u6cd5\u89e3\u9664\u7ed1\u5b9a");
        }
        this.menuDas.logicDeleteById(menuId);
        return true;
    }

    public static List<MenuDto> buildTree(String parentCode, List<MenuDto> menus) {
        ArrayList<MenuDto> tree = new ArrayList<MenuDto>();
        for (MenuDto menu : menus) {
            if (!parentCode.equals(menu.getParentCode())) continue;
            tree.add(menu);
            menu.setChildren(ApplicationServiceImpl.buildTree(menu.getCode(), menus));
        }
        tree.sort(Comparator.comparing(ResourceDto::getSortNo));
        return tree;
    }

    @Override
    @Deprecated
    public ApplicationDto queryByIdAndParams(Long appId, String[] res) {
        MenuEo menuEo;
        List buttons;
        ApplicationEo application = (ApplicationEo)this.applicationDas.selectByPrimaryKey(appId);
        if (application == null) {
            this.logger.info("\u67e5\u8be2\u5e94\u7528\u8be6\u60c5\uff0c\u65e0\u6cd5\u901a\u8fc7\u5e94\u7528id\u67e5\u8be2\u5230\u5e94\u7528\u4fe1\u606f,\u5e94\u7528id\u4e3a:" + appId);
            throw new BizException(UserExceptionCode.APPLICATION_EXCEPTION_CODE.getCode(), UserExceptionCode.APPLICATION_EXCEPTION_CODE.getMsg());
        }
        ApplicationDto dto = new ApplicationDto();
        Map<String, Boolean> map = ApplicationServiceImpl.returnResourceOrNot(res);
        if (map.get("button").booleanValue() && CollectionUtils.isNotEmpty((Collection)(buttons = this.buttonDas.findByApplicationId(appId)))) {
            ArrayList buttonDtos = new ArrayList();
            DtoHelper.eoList2DtoList((Collection)buttons, buttonDtos, ButtonDto.class);
            dto.setButtons(buttonDtos);
        }
        if (map.get("menu").booleanValue() && (menuEo = (MenuEo)this.menuDas.selectByPrimaryKey(application.getMenuId())) != null && StringUtils.isNotBlank((CharSequence)menuEo.getCode())) {
            List<MenuDto> menuDtos = this.applicationResourceDas.findByAppCodeAndType(application.getCode(), Integer.valueOf(ResourceType.MENU.getValue())).stream().map(e -> {
                MenuDto menuDto = new MenuDto();
                DtoHelper.eo2Dto((BaseEo)e, (BaseVo)menuDto);
                return menuDto;
            }).collect(Collectors.toList());
            List<MenuDto> childrenDto = ApplicationServiceImpl.buildTree(menuEo.getCode(), menuDtos);
            MenuDto menuDto = new MenuDto();
            DtoHelper.eo2Dto((BaseEo)menuEo, (BaseVo)menuDto);
            menuDto.setChildren(childrenDto);
            dto.setMenus(menuDto);
        }
        if (map.get("withRoleTemplate").booleanValue()) {
            dto.setRoleTemplateRespDtos(this.getRoleTemplateByApplicationId(appId));
        }
        try {
            DtoHelper.eo2Dto((BaseEo)application, (BaseVo)dto);
        }
        catch (Exception e2) {
            this.logger.info("\u901a\u8fc7\u5e94\u7528id\u67e5\u8be2\u5e94\u7528\uff0ceo\u8f6cdto\u5c5e\u6027\u8f6c\u6362\u5931\u8d25:" + appId + "\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e2.getMessage());
            throw new BizException(UserExceptionCode.BEAN_COPY_FAIL.getCode(), UserExceptionCode.BEAN_COPY_FAIL.getMsg());
        }
        return dto;
    }

    private List<RoleTemplateRespDto> getRoleTemplateByApplicationId(Long applicationId) {
        RoleTemplateEo roleTemplateEo = new RoleTemplateEo();
        roleTemplateEo.setApplicationId(applicationId);
        List roleTemplateEos = this.roleTemplateDas.select((BaseEo)roleTemplateEo);
        ArrayList<RoleTemplateRespDto> roleTemplateRespDtos = new ArrayList<RoleTemplateRespDto>();
        DtoHelper.eoList2DtoList((Collection)roleTemplateEos, roleTemplateRespDtos, RoleTemplateRespDto.class);
        return roleTemplateRespDtos;
    }

    private void menuEoList2DtoList(List<MenuEo> menuEos, List<MenuDto> menuDtos) {
        if (CollectionUtils.isNotEmpty(menuEos)) {
            for (MenuEo menuEo : menuEos) {
                AssertUtil.isTrue(!menuEo.getCode().equals(menuEo.getParentCode()), "\u5b50\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u548c\u7236\u83dc\u5355\u7f16\u7801\u76f8\u540c");
                MenuDto menuDto = new MenuDto();
                DtoHelper.eo2Dto((BaseEo)menuEo, (BaseVo)menuDto);
                menuDtos.add(menuDto);
                if (!CollectionUtils.isNotEmpty((Collection)menuEo.getChildren())) continue;
                ArrayList childrenDtos = Lists.newArrayList();
                this.menuEoList2DtoList(menuEo.getChildren(), childrenDtos);
                menuDto.setChildren((List)childrenDtos);
            }
        }
    }

    @Override
    public AppInstanceDto queryInsByIdAndParams(Long instanceId, String[] res) {
        AppInstanceEo appInstance = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        AppInstanceDto appInstanceDto = new AppInstanceDto();
        if (appInstance != null && appInstance.getApplicationId() != null) {
            try {
                List buttons;
                Map<String, Boolean> map = ApplicationServiceImpl.returnResourceOrNot(res);
                if (map.get("button").booleanValue() && CollectionUtils.isNotEmpty((Collection)(buttons = this.buttonDas.findByApplicationId(appInstance.getApplicationId())))) {
                    ArrayList buttonDtos = new ArrayList();
                    DtoHelper.eoList2DtoList((Collection)buttons, buttonDtos, ButtonDto.class);
                    appInstanceDto.setButtons(buttonDtos);
                }
                if (map.get("menu").booleanValue()) {
                    List children = this.menuDas.selectByInstanceId(instanceId);
                    ArrayList childrenDto = Lists.newArrayList();
                    this.menuEoList2DtoList(children, childrenDto);
                    MenuDto menuDto = new MenuDto();
                    menuDto.setChildren((List)childrenDto);
                    appInstanceDto.setMenus(menuDto);
                }
                DtoHelper.eo2Dto((BaseEo)appInstance, (BaseVo)appInstanceDto);
                return appInstanceDto;
            }
            catch (Exception e) {
                this.logger.info("\u901a\u8fc7\u5e94\u7528\u5b9e\u4f8bid\u67e5\u8be2\u5e94\u7528\u5b9e\u4f8b\uff0ceo\u8f6cdto\u5c5e\u6027\u8f6c\u6362\u5931\u8d25:\u5b9e\u4f8bid\u4e3a" + instanceId + "\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
                throw new BizException(UserExceptionCode.BEAN_COPY_FAIL.getCode(), UserExceptionCode.BEAN_COPY_FAIL.getMsg());
            }
        }
        return null;
    }

    private List<SqlFilter> addApplicationSqlFilter(String filter) {
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{filter})) {
            JSONObject jsonObject = JSON.parseObject((String)filter);
            if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("name"))) {
                sqlFilterList.add(SqlFilter.like((String)"name", (Object)("%" + jsonObject.getString("name") + "%")));
            }
            if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("code"))) {
                sqlFilterList.add(SqlFilter.eq((String)"code", (Object)jsonObject.getString("code")));
            }
            if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("applicationType"))) {
                sqlFilterList.add(SqlFilter.eq((String)"applicationType", (Object)jsonObject.getString("applicationType")));
            }
            if (null != jsonObject.get((Object)"ownerId")) {
                sqlFilterList.add(SqlFilter.eq((String)"ownerId", (Object)jsonObject.getString("ownerId")));
            }
            if (null != jsonObject.get((Object)"status")) {
                sqlFilterList.add(SqlFilter.eq((String)"status", (Object)jsonObject.getString("status")));
            }
        }
        return sqlFilterList;
    }

    private List<SqlFilter> addAppInstanceSqlFilter(String filter) {
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{filter})) {
            JSONObject jsonObject = JSON.parseObject((String)filter);
            Boolean withPartner = jsonObject.getBooleanValue("withPartner");
            if (Boolean.FALSE.equals(withPartner)) {
                sqlFilterList.add(SqlFilter.in((String)"instanceChannel", Arrays.asList(InstanceChannelEnum.SELF_BUILT.getKey(), InstanceChannelEnum.THIRD_PARTY.getKey())));
            }
            if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("code"))) {
                sqlFilterList.add(SqlFilter.like((String)"code", (Object)("%" + jsonObject.getString("code") + "%")));
            }
            if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("name"))) {
                sqlFilterList.add(SqlFilter.like((String)"name", (Object)("%" + jsonObject.getString("name") + "%")));
            }
            if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("hostName"))) {
                sqlFilterList.add(SqlFilter.like((String)"hostName", (Object)("%" + jsonObject.getString("hostName") + "%")));
            }
            if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("purchaseType"))) {
                sqlFilterList.add(SqlFilter.eq((String)"purchaseType", (Object)jsonObject.getString("purchaseType")));
            }
            if (null != jsonObject.get((Object)"owner")) {
                sqlFilterList.add(SqlFilter.eq((String)"owner", (Object)jsonObject.getString("owner")));
            }
            if (null != jsonObject.get((Object)"tenantId")) {
                sqlFilterList.add(SqlFilter.eq((String)"tenantId", (Object)jsonObject.getString("tenantId")));
            } else {
                sqlFilterList.add(SqlFilter.eq((String)"tenantId", (Object)this.context.tenantId()));
            }
            if (null != jsonObject.get((Object)"instanceId")) {
                sqlFilterList.add(SqlFilter.eq((String)"instanceId", (Object)jsonObject.getString("instanceId")));
            }
            if (null != jsonObject.get((Object)"applicationId")) {
                sqlFilterList.add(SqlFilter.eq((String)"applicationId", (Object)jsonObject.getString("applicationId")));
            }
            if (null != jsonObject.get((Object)"status")) {
                sqlFilterList.add(SqlFilter.eq((String)"status", (Object)jsonObject.getString("status")));
            }
            if (null != jsonObject.get((Object)"appInsName")) {
                sqlFilterList.add(SqlFilter.like((String)"appInsName", (Object)("%" + jsonObject.getString("appInsName") + "%")));
            }
            if (null != jsonObject.get((Object)"bizSpaceCode")) {
                sqlFilterList.add(SqlFilter.eq((String)"biz_space_code", (Object)jsonObject.getString("bizSpaceCode")));
            }
        }
        return sqlFilterList;
    }

    @Override
    @Deprecated
    public void enableMenu(Long menuId, Long appId) {
        ApplicationEo applicationEo = (ApplicationEo)this.applicationDas.selectByPrimaryKey(appId);
        if (applicationEo == null) {
            throw new BizException(ExceptionCode.FAIL.getMsg());
        }
        MenuEo menuEo = (MenuEo)this.menuDas.selectByPrimaryKey(menuId);
        if (menuEo == null) {
            throw new BizException(ExceptionCode.FAIL.getMsg());
        }
        if (menuEo.getStatus() == null || !menuEo.getStatus().equals(1)) {
            menuEo.setStatus(Integer.valueOf(1));
            this.menuDas.updateSelective((BaseEo)menuEo);
        }
    }

    @Override
    @Deprecated
    public void disableMenu(Long menuId, Long appId) {
        ApplicationEo applicationEo = (ApplicationEo)this.applicationDas.selectByPrimaryKey(appId);
        if (applicationEo == null) {
            throw new BizException(ExceptionCode.FAIL.getMsg());
        }
        MenuEo menuEo = (MenuEo)this.menuDas.selectByPrimaryKey(menuId);
        if (menuEo == null) {
            throw new BizException(ExceptionCode.FAIL.getMsg());
        }
        if (menuEo.getStatus() == null || !menuEo.getStatus().equals(2)) {
            PackageMenuRelationEo packageMenuRelationEo = new PackageMenuRelationEo();
            packageMenuRelationEo.setMenuId(menuId);
            if (this.packageMenuRelationDas.count((BaseEo)packageMenuRelationEo) > 0) {
                throw new BizException("\u8be5\u83dc\u5355\u88ab\u5e94\u7528\u5957\u9910\u5f15\u7528\uff0c\u65e0\u6cd5\u7981\u7528");
            }
            menuEo.setStatus(Integer.valueOf(2));
            this.menuDas.updateSelective((BaseEo)menuEo);
        }
    }

    private List<String> getRoutePath(List<MenuEo> root, List<String> result) {
        for (int i = 0; i < root.size(); ++i) {
            List children = this.menuDas.findByParent(root.get(i).getInstanceId(), root.get(i).getCode());
            if (null != children) {
                this.getRoutePath(children, result);
            }
            if (!StringUtils.isNotBlank((CharSequence)root.get(i).getRoutePath())) continue;
            result.add(root.get(i).getRoutePath());
        }
        return result;
    }

    private List<String> getCode(List<MenuEo> root, List<String> result) {
        for (int i = 0; i < root.size(); ++i) {
            MenuEo menu = root.get(i);
            AssertUtil.isTrue(!menu.getCode().equals(menu.getParentCode()), "\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u548c\u7236\u83dc\u5355\u7f16\u7801\u76f8\u540c");
            List children = this.menuDas.findByParent(menu.getInstanceId(), menu.getCode());
            if (null != children) {
                this.getCode(children, result);
            }
            if (!StringUtils.isNotBlank((CharSequence)root.get(i).getCode())) continue;
            result.add(root.get(i).getCode());
        }
        return result;
    }

    private void validMenu(MenuEo menuEo, MenuDto menuDto) {
        ArrayList<MenuEo> menuEos = new ArrayList<MenuEo>();
        menuEos.add(menuEo);
        List<String> codes = new ArrayList<String>();
        codes = this.getCode(menuEos, codes);
        List<String> paths = new ArrayList<String>();
        paths = this.getRoutePath(menuEos, paths);
        for (String code : codes) {
            if (!code.equals(menuDto.getCode())) continue;
            throw new BizException(UserExceptionCode.MENU_CODE_EXIT_FAIL.getCode(), UserExceptionCode.MENU_CODE_EXIT_FAIL.getMsg() + "\u7f16\u7801\u4e3a\uff1a" + code);
        }
        for (String path : paths) {
            if (!path.equals(menuDto.getRoutePath())) continue;
            throw new BizException(UserExceptionCode.MENU_PATH_EXIT_FAIL.getCode(), UserExceptionCode.MENU_PATH_EXIT_FAIL.getMsg() + "\u8def\u5f84\u4e3a\uff1a" + path);
        }
    }

    private void validMenuCode(List<MenuEo> menuEoList, MenuDto menuDto) {
        for (MenuEo menuEo : menuEoList) {
            if (StringUtils.isNotBlank((CharSequence)menuEo.getCode()) && !String.valueOf(menuEo.getId()).equals(String.valueOf(menuDto.getId())) && menuEo.getCode().equals(menuDto.getCode())) {
                throw new BizException(UserExceptionCode.MENU_CODE_EXIT_FAIL.getCode(), UserExceptionCode.MENU_CODE_EXIT_FAIL.getMsg() + "\u7f16\u7801\u4e3a\uff1a" + menuEo.getCode());
            }
            List children = this.menuDas.findByParent(menuEo.getInstanceId(), menuEo.getCode());
            if (children == null) continue;
            this.validMenuCode(children, menuDto);
        }
    }

    private void validMenuRoutePath(List<MenuEo> menuEoList, MenuDto menuDto) {
        for (MenuEo menuEo : menuEoList) {
            if (StringUtils.isNotBlank((CharSequence)menuEo.getRoutePath()) && !String.valueOf(menuEo.getId()).equals(String.valueOf(menuDto.getId())) && menuEo.getRoutePath().equals(menuDto.getRoutePath())) {
                throw new BizException(UserExceptionCode.MENU_PATH_EXIT_FAIL.getCode(), UserExceptionCode.MENU_PATH_EXIT_FAIL.getMsg() + "\u8def\u5f84\u4e3a\uff1a" + menuEo.getRoutePath());
            }
            List children = this.menuDas.findByParent(menuEo.getInstanceId(), menuEo.getCode());
            if (children == null) continue;
            this.validMenuRoutePath(children, menuDto);
        }
    }

    private void validUpdateMenu(MenuEo menuEo, MenuDto menuDto) {
        ArrayList<MenuEo> menuEos = new ArrayList<MenuEo>();
        menuEos.add(menuEo);
        this.validMenuCode(menuEos, menuDto);
        this.validMenuRoutePath(menuEos, menuDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sortMenu(Long id, SortReqDto sortReqDto) {
        Assert.notNull((Object)id, (String)"\u83dc\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)sortReqDto.getInstanceId(), (String)"\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a");
        String sortType = sortReqDto.getSortType();
        Assert.hasLength((String)sortType, (String)"\u6392\u5e8f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        String desc = SortEnum.getDescByType((String)sortType);
        Assert.hasLength((String)desc, (String)"\u6392\u5e8f\u7c7b\u578b\u4e0d\u652f\u6301");
        MenuEo menuEo = (MenuEo)this.menuDas.selectByPrimaryKey(id);
        if (menuEo == null) {
            throw new BizException(UserExceptionCode.MENU_NOTEXIT_FAIL.getCode(), UserExceptionCode.MENU_NOTEXIT_FAIL.getMsg());
        }
        if (menuEo.getInstanceId() != null && !sortReqDto.getInstanceId().equals(menuEo.getInstanceId())) {
            throw new BizException(UserExceptionCode.MENU_APPID_FAIL.getCode(), UserExceptionCode.MENU_APPID_FAIL.getMsg());
        }
        MenuEo selectEo = new MenuEo();
        selectEo.setParentCode(menuEo.getParentCode());
        selectEo.setTenantId(menuEo.getTenantId());
        selectEo.setInstanceId(sortReqDto.getInstanceId());
        selectEo.setOrderBy("sort_no");
        List menuEoList = this.menuDas.select((BaseEo)selectEo);
        if (CollectionUtils.isEmpty((Collection)menuEoList) || menuEoList.size() == 1) {
            return;
        }
        ArrayList newSortMenuEoList = Lists.newArrayList();
        if (SortEnum.TOP.getType().equals(sortType)) {
            newSortMenuEoList.add(menuEo);
            for (MenuEo eo : menuEoList) {
                if (eo.getId().equals(menuEo.getId())) continue;
                newSortMenuEoList.add(eo);
            }
        } else if (SortEnum.BOTTOM.getType().equals(sortType)) {
            for (MenuEo eo : menuEoList) {
                if (eo.getId().equals(menuEo.getId())) continue;
                newSortMenuEoList.add(eo);
            }
            newSortMenuEoList.add(menuEo);
        } else {
            int size = menuEoList.size();
            for (int i = 0; i < size; ++i) {
                MenuEo eo = (MenuEo)menuEoList.get(i);
                if (!eo.getId().equals(menuEo.getId())) continue;
                Integer relatedIndex = null;
                if (SortEnum.INCR.getType().equals(sortType) && i != 0) {
                    relatedIndex = i - 1;
                } else if (SortEnum.DECR.getType().equals(sortType) && i != size - 1) {
                    relatedIndex = i + 1;
                }
                if (relatedIndex == null) break;
                menuEoList.set(i, menuEoList.get(relatedIndex));
                menuEoList.set(relatedIndex, menuEo);
                newSortMenuEoList.addAll(menuEoList);
                break;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)newSortMenuEoList)) {
            int sortno = 1;
            for (MenuEo eo : newSortMenuEoList) {
                eo.setSortNo(Integer.valueOf(sortno++));
                this.menuDas.updateSelective((BaseEo)eo);
            }
        }
    }

    @Override
    public List<Long> queryUserAuthInstanceList(Long userId) {
        return this.userService.queryUserAuthInstanceList(userId);
    }

    @Override
    public AppInstanceDto findByHostName(String hostname) {
        AppInstanceEo appInstanceEo = this.appInstanceDetectExt.detectInstance(hostname);
        if (appInstanceEo == null) {
            return null;
        }
        return this.convert2AppInstanceDto(appInstanceEo);
    }

    @Override
    public AppInstanceDto findByServerName(String serverName) {
        AppInstanceEo appInstanceEo = this.appInstanceDetectExt.detectInstanceWithServerName(serverName);
        if (appInstanceEo == null) {
            return null;
        }
        return this.convert2AppInstanceDto(appInstanceEo);
    }

    @Override
    public AppInstanceQueryResDto queryUserResources(AppInstanceUserQueryReqDto req) {
        ServiceContext context = ServiceContext.getContext();
        Long instanceId = context.getRequestInstanceId();
        Long userId = req.getUserId();
        List res = req.getRes();
        AppInstanceEo appInstance = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        AppInstanceQueryResDto resDto = new AppInstanceQueryResDto();
        DtoHelper.eo2Dto((BaseEo)appInstance, (BaseVo)resDto);
        if (appInstance != null) {
            Set<String> trustDomains = this.appInstanceTrustDomainStringToSet(appInstance.getTrustDomain());
            resDto.setTrustDomain(trustDomains);
        }
        UserAccessVo userAccessVo = this.accessService.queryUserAccess(instanceId, userId);
        Set accessSet = userAccessVo.getAccessSet();
        ArrayList menuDtoList = Lists.newArrayList();
        ArrayList buttonDtoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)accessSet)) {
            for (AccessDto accessDto : accessSet) {
                if (res.contains("menus") && Integer.valueOf(1).equals(accessDto.getResourceType())) {
                    MenuQueryResDto menuQueryResDto = new MenuQueryResDto();
                    CubeBeanUtils.copyProperties((Object)menuQueryResDto, (Object)accessDto.getMenuDto(), (String[])new String[0]);
                    menuDtoList.add(menuQueryResDto);
                }
                if (!res.contains("buttons") || !Integer.valueOf(2).equals(accessDto.getResourceType())) continue;
                ButtonQueryResDto buttonQueryResDto = new ButtonQueryResDto();
                CubeBeanUtils.copyProperties((Object)buttonQueryResDto, (Object)accessDto.getButtonDto(), (String[])new String[0]);
                buttonDtoList.add(buttonQueryResDto);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)menuDtoList)) {
            List menuList = MenuDas.buildTree((String)"0", menuDtoList.stream().filter(dto -> StringUtils.isNotBlank((CharSequence)dto.getParentCode())).collect(Collectors.toList()));
            resDto.setMenuList(menuList);
        }
        if (CollectionUtils.isNotEmpty((Collection)buttonDtoList)) {
            resDto.setButtons((List)buttonDtoList);
        }
        return resDto;
    }

    @Override
    public List<BizSpaceEnableInstanceRespDto> queryEnableInstanceNum(BizSpaceEnableInstanceReqDto bizSpaceEnableInstanceReqDto) {
        ArrayList<BizSpaceEnableInstanceRespDto> bizSpaceEnableInstanceRespDtos = new ArrayList<BizSpaceEnableInstanceRespDto>();
        Long tenantId = bizSpaceEnableInstanceReqDto.getTenantId();
        String bizSpaceCodes = bizSpaceEnableInstanceReqDto.getBizSpaceCodes();
        if (StringUtils.isNotBlank((CharSequence)bizSpaceCodes)) {
            String[] bizSpaceCodeArray;
            for (String bizSpaceCode : bizSpaceCodeArray = bizSpaceCodes.split(",")) {
                BizSpaceEnableInstanceRespDto bizSpaceEnableInstanceRespDto = new BizSpaceEnableInstanceRespDto();
                AppInstanceEo appInstanceEo = new AppInstanceEo();
                appInstanceEo.setBizSpaceCode(bizSpaceCode);
                appInstanceEo.setTenantId(tenantId);
                appInstanceEo.setStatus(Integer.valueOf(1));
                bizSpaceEnableInstanceRespDto.setBizSpaceCode(bizSpaceCode);
                bizSpaceEnableInstanceRespDto.setAppInstanceNum(Integer.valueOf(this.appInstanceDas.count((BaseEo)appInstanceEo)));
                bizSpaceEnableInstanceRespDtos.add(bizSpaceEnableInstanceRespDto);
            }
        }
        return bizSpaceEnableInstanceRespDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean modifyDataInitStatus(DataInstanceStatusUpdateReqDto dto) {
        if (dto == null || dto.getNewStatus() == null) {
            throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), "\u7f3a\u5c11\u65b0\u72b6\u6001newStatus\u4fe1\u606f");
        }
        Long instanceId = ServiceContext.getContext().getRequestInstanceId();
        if (instanceId == null || instanceId < 1L) {
            throw new BizException(UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getCode(), "\u7f3a\u5c11instantceId\u4fe1\u606f");
        }
        AppInstanceEo updateEo = new AppInstanceEo();
        updateEo.setId(instanceId);
        updateEo.setDataInitStatus(dto.getNewStatus());
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        SqlFilter drCondition = new SqlFilter();
        drCondition.setProperty("dr");
        drCondition.setOperator(SqlFilter.Operator.eq);
        drCondition.setValue((Object)0);
        sqlFilters.add(drCondition);
        if (dto.getOriginStatus() != null) {
            SqlFilter originDisCondition = new SqlFilter();
            originDisCondition.setProperty("data_init_status");
            originDisCondition.setOperator(SqlFilter.Operator.eq);
            originDisCondition.setValue((Object)dto.getOriginStatus());
            sqlFilters.add(originDisCondition);
        }
        updateEo.setSqlFilters(sqlFilters);
        int effect = this.appInstanceDas.updateSelectiveSqlFilter((BaseEo)updateEo);
        if (effect == 1) {
            return true;
        }
        if (effect < 1) {
            return false;
        }
        throw new BizException(UserExceptionCode.TOO_MATCH_REF.getCode(), "\u66f4\u65b0\u4e86\u8fc7\u591a\u8bb0\u5f55,\u56de\u6eda\u5904\u7406,effectRow=" + effect);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean appInstanceInitializeMenus(Long instanceId) {
        AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        if (appInstanceEo == null || StringUtils.isBlank((CharSequence)appInstanceEo.getApplicationCode())) {
            return false;
        }
        List menuResources = this.applicationResourceDas.findByAppCodeAndType(appInstanceEo.getApplicationCode(), Integer.valueOf(ResourceType.MENU.getValue()));
        List buttonResources = this.applicationResourceDas.findByAppCodeAndType(appInstanceEo.getApplicationCode(), Integer.valueOf(ResourceType.BUTTON.getValue()));
        this.syncAppInstanceMenuButton(appInstanceEo.getId(), menuResources, buttonResources, true, true);
        return true;
    }

    @Override
    public AppInstanceEo queryInstanceByCode(Long tenantId, String appCode) {
        AppInstanceEo queryEo = new AppInstanceEo();
        queryEo.setTenantId(tenantId);
        queryEo.setCode(appCode);
        queryEo.setStatus(Integer.valueOf(1));
        List list = this.appInstanceDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (AppInstanceEo)list.get(0);
        }
        return null;
    }

    private Set<String> appInstanceTrustDomainStringToSet(String trustDomain) {
        HashSet<String> trustDomainSet = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)trustDomain)) {
            trustDomainSet.addAll(Arrays.asList(trustDomain.split(",")));
        }
        return trustDomainSet;
    }

    @Override
    public AppInstanceDto findByHostnameInOneTime(ApplicationBatchQueryDto applicationBatchQueryDto) {
        AppInstanceDto appInstanceDto = null;
        String targetUrl = null;
        if (StringUtils.isNotBlank((CharSequence)applicationBatchQueryDto.getApplicationKey())) {
            this.logger.info("\u901a\u8fc7appKey\u786e\u5b9ainstance\u4fe1\u606f,applicationKey={}", (Object)applicationBatchQueryDto.getApplicationKey());
            appInstanceDto = this.queryByAppKey(applicationBatchQueryDto.getApplicationKey());
            targetUrl = applicationBatchQueryDto.getToReturnRequestUrl();
        }
        if (appInstanceDto == null) {
            this.logger.info("\u901a\u8fc7xRealHostname/\u8bf7\u6c42\u5730\u5740\u786e\u5b9ainstance\u4fe1\u606f,xRealHostname={}", (Object)applicationBatchQueryDto.getxRealHostname());
            appInstanceDto = this.getInstanceByXRealHostname(applicationBatchQueryDto.getxRealHostname());
            targetUrl = applicationBatchQueryDto.getToReturnRequestUrl();
        }
        if (appInstanceDto == null && StringUtils.isNotBlank((CharSequence)applicationBatchQueryDto.getReferer())) {
            this.logger.info("\u901a\u8fc7refer\u786e\u5b9ainstance\u4fe1\u606f,refer={}", (Object)applicationBatchQueryDto.getReferer());
            appInstanceDto = this.findByHostName(IAppInstanceCallBack.processWithUrl((String)applicationBatchQueryDto.getReferer(), (int)this.appRecognitionConfig.getRefererSnippetLen(), (String)this.appRecognitionConfig.getKeyWord()));
            targetUrl = applicationBatchQueryDto.getReferer();
        }
        if (appInstanceDto != null) {
            appInstanceDto.setRequestUrl(targetUrl);
        }
        return appInstanceDto;
    }

    @Override
    public AppInstanceDto getInstanceBySearchKey(String searchKey) {
        AppInstanceDto appInstanceDto = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{searchKey})) {
            if (StringUtils.isNumeric((CharSequence)searchKey)) {
                appInstanceDto = new AppInstanceDto();
                appInstanceDto.setId(Long.valueOf(searchKey));
                return this.queryInstanceOne(appInstanceDto.getId());
            }
            if (searchKey.contains("_")) {
                String[] keys = searchKey.split("_");
                if (keys.length != 2) {
                    throw new BizException("3050", "app\u5b9e\u4f8bkey\u4e0d\u5408\u6cd5");
                }
                try {
                    Long appInsId = Long.valueOf(keys[1]);
                    appInstanceDto = new AppInstanceDto();
                    appInstanceDto.setId(appInsId);
                    return this.queryInstanceOne(appInsId);
                }
                catch (Exception e) {
                    throw new BizException("3050", "app\u5b9e\u4f8bkey\u4e0d\u5408\u6cd5");
                }
            }
            if (searchKey.toLowerCase().startsWith("http") || searchKey.contains(".")) {
                appInstanceDto = this.findByServerName(IAppInstanceCallBack.processWithUrl((String)searchKey, (int)this.appRecognitionConfig.getxRealHostNameSnippetLen(), (String)this.appRecognitionConfig.getKeyWord()));
                if (appInstanceDto == null) {
                    appInstanceDto = this.findByHostName(IAppInstanceCallBack.processWithUrl((String)searchKey, (int)this.appRecognitionConfig.getRefererSnippetLen(), (String)this.appRecognitionConfig.getKeyWord()));
                }
                if (appInstanceDto != null) {
                    return appInstanceDto;
                }
                this.logger.debug("\u901a\u8fc7url\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u4f8b:{}", (Object)searchKey);
            } else {
                appInstanceDto = this.queryByAppKey(searchKey);
                if (appInstanceDto != null) {
                    return appInstanceDto;
                }
            }
        }
        this.logger.debug("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u4f8b:{}", (Object)searchKey);
        return null;
    }

    @Override
    public AppInstanceDto getInstanceByXRealHostname(String xRealHostname) {
        return (AppInstanceDto)new IAppInstanceCallBack<AppInstanceDto>(){

            public int snippetLen() {
                return ApplicationServiceImpl.this.appRecognitionConfig.getxRealHostNameSnippetLen();
            }

            public String keyWord() {
                return ApplicationServiceImpl.this.appRecognitionConfig.getKeyWord();
            }

            public AppInstanceDto searchByInstanceId(Long instanceId) {
                return ApplicationServiceImpl.this.queryInstanceOne(instanceId);
            }

            public AppInstanceDto searchByUrl(String xRealHostname) {
                return ApplicationServiceImpl.this.findByServerName(xRealHostname);
            }
        }.process(xRealHostname);
    }

    @Override
    public Long createAppInstance(AppInstanceCreateReqDto reqDto) {
        AppInstanceEo selectParam = new AppInstanceEo();
        selectParam.setCode(reqDto.getCode());
        selectParam.setTenantId(reqDto.getTenantId());
        selectParam.setStatus(StatusEnum.ENABLED.getKey());
        AppInstanceEo exist = (AppInstanceEo)this.appInstanceDas.selectOne((BaseEo)selectParam);
        if (exist != null) {
            return exist.getId();
        }
        AppInstanceEo appInstanceEo = this.saveAppInstance(reqDto);
        this.bindRelation(appInstanceEo);
        this.allocateResource(reqDto, null, appInstanceEo);
        this.initRoleAndAccess(reqDto.getAppId(), appInstanceEo.getId(), reqDto.getTenantId());
        return appInstanceEo.getId();
    }

    @Override
    public Long registerAppInstance(AppResourceDto appResourceDto, Long applicationId) {
        ApplicationEo applicationEo = (ApplicationEo)this.applicationDas.selectByPrimaryKey(applicationId);
        if (applicationEo == null) {
            throw new BizException(UserExceptionCode.APPLICATION_EXCEPTION_CODE.getCode(), UserExceptionCode.APPLICATION_EXCEPTION_CODE.getMsg());
        }
        String code = applicationEo.getCode();
        Long tenantId = 1L;
        Long appInstanceId = null;
        AppInstanceEo queryEo = new AppInstanceEo();
        queryEo.setCode(code);
        queryEo.setTenantId(tenantId);
        List existList = this.appInstanceDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)existList) && existList.size() > 1) {
            this.logger.error("\u5e94\u7528\u5df2\u5b58\u5728\u591a\u4e2a\u5b9e\u4f8b\uff0c\u65e0\u6cd5\u786e\u5b9a\u5bf9\u54ea\u4e2a\u5b9e\u4f8b\u8fdb\u884c\u66f4\u65b0");
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)existList)) {
            AppInstanceCreateReqDto instanceReqDto = new AppInstanceCreateReqDto();
            instanceReqDto.setAppCode(code);
            instanceReqDto.setCode(code);
            instanceReqDto.setAppId(applicationEo.getId());
            instanceReqDto.setHostName(appResourceDto.getHostName());
            instanceReqDto.setServerName(appResourceDto.getServerName());
            instanceReqDto.setAppInsName(appResourceDto.getAppInsName());
            instanceReqDto.setTenantId(tenantId);
            instanceReqDto.setBizSpaceCode("default");
            instanceReqDto.setTenantId(Long.valueOf(1L));
            appInstanceId = this.addAppInstance(instanceReqDto);
        } else {
            appInstanceId = ((AppInstanceEo)existList.get(0)).getId();
            AppInstanceEo updateEo = new AppInstanceEo();
            updateEo.setId(appInstanceId);
            updateEo.setAppInsName(appResourceDto.getAppInsName());
            updateEo.setHostName(appResourceDto.getHostName());
            updateEo.setServerName(appResourceDto.getServerName());
            this.appInstanceDas.updateSelective((BaseEo)updateEo);
            ArrayList<String> menuCodes = new ArrayList<String>();
            ArrayList<String> buttonCodes = new ArrayList<String>();
            List resourceDetailList = appResourceDto.getResourceDetailList();
            resourceDetailList.forEach(d -> {
                if (d.getType().equals(ResourceType.BUTTON.getValue())) {
                    buttonCodes.add(d.getResourceCode());
                } else {
                    menuCodes.add(d.getResourceCode());
                }
            });
            this.initAppInstance(appInstanceId, menuCodes, buttonCodes, true, true);
        }
        return appInstanceId;
    }

    @Override
    public List<AppInstanceEo> queryPlatformAppInstance(Long tenantId) {
        AppInstanceEo appInstanceEo = new AppInstanceEo();
        appInstanceEo.setTenantId(tenantId);
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.le((String)"application_id", (Object)10L));
        appInstanceEo.setSqlFilters(sqlFilterList);
        return this.appInstanceDas.select((BaseEo)appInstanceEo);
    }

    @Override
    public String regenerateAppSecret(Long instanceId) {
        AppInstanceEo dbEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        if (dbEo == null) {
            throw new BizException(UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getCode(), UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getMsg());
        }
        if (ObjectUtil.notEqual((Object)InstanceChannelEnum.PARTNER.getKey(), (Object)dbEo.getInstanceChannel())) {
            throw new BizException("500", "\u53ea\u66f4\u65b0\u5916\u90e8\u5e94\u7528sk");
        }
        String appSecret = Coder.md5Hex((String)Coder.randomNum((int)32));
        dbEo.setAppSecret(appSecret);
        this.appInstanceDas.updateSelective((BaseEo)dbEo);
        return appSecret;
    }

    @Override
    public ExternalAppQueryRespDto verifyExternalApp(ExternalAppQueryReqDto externalAppQueryReqDto) {
        Long tenantId = externalAppQueryReqDto.getTenantId() == null ? ServiceContext.getContext().getRequestTenantId() : externalAppQueryReqDto.getTenantId();
        AppInstanceEo queryEo = new AppInstanceEo();
        queryEo.setTenantId(tenantId);
        queryEo.setAppKey(externalAppQueryReqDto.getAppKey());
        AppInstanceEo dbEo = (AppInstanceEo)this.appInstanceDas.selectOne((BaseEo)queryEo);
        if (dbEo == null || ObjectUtil.notEqual((Object)InstanceChannelEnum.PARTNER.getKey(), (Object)dbEo.getInstanceChannel())) {
            throw new BizException(UserExceptionCode.APP_ID_ILLEGAL.getCode(), UserExceptionCode.APP_ID_ILLEGAL.getMsg());
        }
        if (StrUtil.isNotBlank((CharSequence)externalAppQueryReqDto.getAppSecret()) && ObjectUtil.notEqual((Object)externalAppQueryReqDto.getAppSecret(), (Object)dbEo.getAppSecret())) {
            throw new BizException(UserExceptionCode.APP_SECRET_ILLEGAL.getCode(), UserExceptionCode.APP_SECRET_ILLEGAL.getMsg());
        }
        ExternalAppQueryRespDto respDto = new ExternalAppQueryRespDto();
        CubeBeanUtils.copyProperties((Object)respDto, (Object)dbEo, (String[])new String[0]);
        return respDto;
    }
}

