/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.constant.ResourceStatus;
import com.dtyunxi.yundt.cube.center.user.api.constant.ResourceType;
import com.dtyunxi.yundt.cube.center.user.api.constant.SortEnum;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppRegisterDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ButtonDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.MenuDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ResourceBaseDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ResourceCreateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ResourceImportReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ResourceRegisterDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ResourceUpdateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ResourceValidateDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.SortReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.ButtonQueryResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.MenuQueryResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.ResourceImportRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.ResourceQueryResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.AppRegisterVo;
import com.dtyunxi.yundt.cube.center.user.api.exception.UserExceptionCode;
import com.dtyunxi.yundt.cube.center.user.biz.service.IApplicationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IResourceService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.AppInstanceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.ApplicationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.ApplicationResourceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.ButtonDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.MenuDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.ResourceDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AppInstanceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.ApplicationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.ApplicationResourceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.ButtonEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.MenuEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.ResourceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdResourceEo;
import com.dtyunxi.yundt.cube.center.user.ext.resource.IResourceCodeGenerateExt;
import com.dtyunxi.yundt.cube.center.user.ext.resource.IResourceCreateExt;
import com.dtyunxi.yundt.cube.center.user.ext.resource.IResourceImpotCheckExt;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ResourceServiceImpl
implements IResourceService {
    private Logger logger = LoggerFactory.getLogger(ResourceServiceImpl.class);
    @Resource
    private IApplicationService applicationService;
    @Resource
    private ButtonDas buttonDas;
    @Resource
    private MenuDas menuDas;
    @Resource
    private AppInstanceDas appInstanceDas;
    @Resource
    private ApplicationDas applicationDas;
    @Resource
    private ApplicationResourceDas applicationResourceDas;
    @Resource
    private ResourceDas resourceDas;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IResourceImpotCheckExt resourceImpotCheckExt;
    @Resource
    private IResourceCreateExt resourceCreateExt;
    @Resource
    private IResourceCodeGenerateExt resourceCodeGenerateExt;

    @Override
    public ResourceQueryResDto queryResourceByCode(String code, List<String> res, ResourceBaseDto resourceDto) {
        ArrayList<SqlFilter> sqlFilters;
        ResourceEo resourceEo = this.resourceDas.selectByCode(code);
        if (resourceEo == null) {
            throw new BusinessRuntimeException("\u8d44\u6e90\u7f16\u7801" + code + "\u4e0d\u5b58\u5728");
        }
        ResourceQueryResDto result = new ResourceQueryResDto();
        DtoHelper.eo2Dto((BaseEo)resourceEo, (BaseVo)result);
        String appCode = null;
        ApplicationResourceEo rEo = new ApplicationResourceEo();
        rEo.setResourceCode(code);
        List rList = this.applicationResourceDas.select((BaseEo)rEo);
        if (CollectionUtils.isNotEmpty((Collection)rList) && rList.size() == 1) {
            appCode = ((ApplicationResourceEo)rList.get(0)).getApplicationCode();
            result.setAppCode(appCode);
        }
        if (res != null && res.contains("menus")) {
            ResourceEo record = new ResourceEo();
            if (resourceDto.getStatus() != null) {
                if (resourceDto.getStatus() != 1 && resourceDto.getStatus() != 2) {
                    throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), UserExceptionCode.REQ_PARAM_ERROR.getMsg() + "\uff1a\u72b6\u6001\u503c\u6709\u8bef\uff0c\u542f\u7528 1  \u7981\u7528 2");
                }
                record.setStatus(resourceDto.getStatus());
            }
            if (StringUtils.isNotBlank((CharSequence)resourceDto.getName())) {
                sqlFilters = new ArrayList<SqlFilter>();
                sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + resourceDto.getName() + "%")));
                record.setSqlFilters(sqlFilters);
            }
            record.setType(Integer.valueOf(ResourceType.MENU.getValue()));
            record.setOrderBy("sort_no");
            List rootList = ResourceDas.buildTree((String)code, (String)appCode, this.resourceDas.select((BaseEo)record).stream().map(e -> {
                ResourceQueryResDto nodeDto = new ResourceQueryResDto();
                DtoHelper.eo2Dto((BaseEo)e, (BaseVo)nodeDto);
                return nodeDto;
            }).collect(Collectors.toList()));
            result.setMenus(rootList);
        }
        if (res != null && res.contains("buttons")) {
            ResourceEo selectButtons = new ResourceEo();
            selectButtons.setParentCode(result.getCode());
            selectButtons.setType(Integer.valueOf(ResourceType.BUTTON.getValue()));
            if (resourceDto.getStatus() != null) {
                if (resourceDto.getStatus() != 1 && resourceDto.getStatus() != 2) {
                    throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), UserExceptionCode.REQ_PARAM_ERROR.getMsg() + "\uff1a\u72b6\u6001\u503c\u6709\u8bef\uff0c\u542f\u7528 1  \u7981\u7528 2");
                }
                selectButtons.setStatus(resourceDto.getStatus());
            }
            if (StringUtils.isNotBlank((CharSequence)resourceDto.getName())) {
                sqlFilters = new ArrayList();
                sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + resourceDto.getName() + "%")));
                selectButtons.setSqlFilters(sqlFilters);
            }
            selectButtons.setOrderBy("sort_no");
            List buttonEos = this.resourceDas.select((BaseEo)selectButtons);
            ArrayList buttonDtos = new ArrayList();
            DtoHelper.eoList2DtoList((Collection)buttonEos, buttonDtos, ResourceQueryResDto.class);
            result.setButtons(buttonDtos);
        }
        return result;
    }

    private void getParent(int i, ResourceEo resourceEo, List<ResourceQueryResDto> list) {
        if (i++ > 10 || resourceEo == null) {
            return;
        }
        String code = resourceEo.getParentCode();
        if ("-1".equals(code)) {
            return;
        }
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)code), (String)"\u9012\u5f52\u6570\u636e\u5f02\u5e38:code\u4e3a\u7a7a");
        ResourceQueryResDto resDto = new ResourceQueryResDto();
        DtoHelper.eo2Dto((BaseEo)resourceEo, (BaseVo)resDto);
        list.add(resDto);
        this.getParent(i, this.resourceDas.selectByCode(code), list);
    }

    @Override
    public List<ResourceQueryResDto> queryResourceParentsByCode(String code) {
        ResourceEo resourceEo = this.resourceDas.selectByCode(code);
        ArrayList<ResourceQueryResDto> result = new ArrayList<ResourceQueryResDto>();
        if (resourceEo == null) {
            return result;
        }
        this.getParent(0, resourceEo, result);
        return result;
    }

    @Override
    public PageInfo<ResourceQueryResDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ResourceQueryResDto resourceReqDto = (ResourceQueryResDto)JSON.parseObject((String)filter, ResourceQueryResDto.class);
        ResourceEo resourceEo = new ResourceEo();
        DtoHelper.dto2Eo((BaseVo)resourceReqDto, (BaseEo)resourceEo);
        resourceEo.setDr(0);
        PageInfo eoPageInfo = this.resourceDas.selectPage((BaseEo)resourceEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ResourceQueryResDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void addResourceCheck(ResourceCreateReqDto reqDto) {
        AssertUtil.isTrue(ResourceType.get((Integer)reqDto.getType()) != null, "10002", "\u7c7b\u578btype\u53ea\u80fd\u662f\u83dc\u5355,\u6309\u94ae", new Object[0]);
        if (StringUtils.isBlank((CharSequence)reqDto.getCode())) {
            String code = this.resourceCodeGenerateExt.generateCode((Object)reqDto);
            reqDto.setCode(code);
            reqDto.setId(Long.valueOf(code));
        }
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)reqDto.getCode()), "10002", "\u7f16\u7801code\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        AssertUtil.isTrue(!reqDto.getCode().equals(reqDto.getParentCode()), "10002", "\u7f16\u7801code\u4e0d\u80fd\u548c\u7236\u7f16\u7801parentCode\u4e00\u6837", new Object[0]);
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)reqDto.getName()), "10002", "\u540d\u79f0name\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        ResourceEo record = new ResourceEo();
        if ("0".equals(reqDto.getCode()) || StringUtils.isBlank((CharSequence)reqDto.getParentCode())) {
            reqDto.setCode("0");
            reqDto.setParentCode("-1");
            record.setCode("0");
            if (this.resourceDas.count((BaseEo)record) > 0) {
                throw new BizException("10002", "\u6839\u8282\u70b9\u5df2\u5b58\u5728,code\u4e0d\u80fd\u4e3a0\u4e14parent_code\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return;
        }
        record.setCode(reqDto.getParentCode());
        if (this.resourceDas.count((BaseEo)record) < 1) {
            throw new BizException("10002", "\u7236\u7f16\u7801parentCode\u4e0d\u5b58\u5728");
        }
        record = new ResourceEo();
        record.setParentCode(reqDto.getParentCode());
        record.setName(reqDto.getName());
        if (this.resourceDas.count((BaseEo)record) > 0) {
            throw new BizException("\u8be5\u8d44\u6e90\u540d\u79f0\u5728\u540c\u7ea7\u4e0b\u5df2\u5b58\u5728");
        }
        record = new ResourceEo();
        record.setCode(reqDto.getCode());
        if (this.resourceDas.count((BaseEo)record) > 0) {
            throw new BizException("\u8be5\u8d44\u6e90\u7f16\u7801\u5df2\u5b58\u5728");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addResource(ResourceCreateReqDto reqDto) {
        this.resourceCreateExt.addResourceCheck(reqDto);
        if (new Integer(ResourceType.MENU.getValue()).equals(reqDto.getType())) {
            ResourceEo record = new ResourceEo();
            record.setParentCode(reqDto.getParentCode());
            record.setType(Integer.valueOf(ResourceType.MENU.getValue()));
            reqDto.setSortNo(Integer.valueOf(this.resourceDas.count((BaseEo)record) + 1));
        }
        ResourceEo resourceEo = new ResourceEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)resourceEo);
        String key = "user:us_resource:" + reqDto.getCode();
        if (!this.cacheService.setCache(key, (Object)"1", 8)) {
            throw new BusinessRuntimeException("\u5176\u5b83\u4eba\u6b63\u5728\u6dfb\u52a0\u6b64\u8d44\u6e90,\u8bf7\u7a0d\u540e\u5c1d\u8bd5");
        }
        try {
            this.resourceDas.insert((BaseEo)resourceEo);
        }
        finally {
            this.cacheService.delCache(key);
        }
        return resourceEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyResource(ResourceUpdateReqDto reqDto) {
        ResourceEo resourceEoDb;
        AssertUtil.isTrue(reqDto.getId() != null || StringUtils.isNotBlank((CharSequence)reqDto.getCode()), "10002", "\u4e3b\u952e\u6216\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        Integer type = reqDto.getType();
        AssertUtil.isTrue(type == null || ResourceType.get((Integer)type) != null, "10002", "\u7c7b\u578b\u53ea\u80fd\u662f\u83dc\u5355,\u6309\u94ae", new Object[0]);
        ResourceEo resourceEo = resourceEoDb = reqDto.getId() != null ? (ResourceEo)this.resourceDas.selectByPrimaryKey(reqDto.getId()) : this.resourceDas.selectByCode(reqDto.getCode());
        if (resourceEoDb == null) {
            throw new BusinessRuntimeException("\u6b64\u8d44\u6e90\u4e0d\u5b58\u5728");
        }
        ResourceEo record = new ResourceEo();
        record.setParentCode(resourceEoDb.getParentCode());
        record.setName(reqDto.getName());
        record.setSqlFilters(Collections.singletonList(SqlFilter.ne((String)"id", (Object)resourceEoDb.getId())));
        if (this.resourceDas.count((BaseEo)record) > 0) {
            throw new BizException("\u8be5\u8d44\u6e90\u540d\u79f0\u5728\u540c\u7ea7\u4e0b\u5df2\u5b58\u5728");
        }
        ResourceEo resourceEo2 = new ResourceEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)resourceEo2);
        resourceEo2.setId(resourceEoDb.getId());
        resourceEo2.setCode(null);
        resourceEo2.setParentCode(null);
        this.resourceDas.updateSelective((BaseEo)resourceEo2);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeResource(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            Long idLong = Long.valueOf(id);
            ResourceEo resourceEo = (ResourceEo)this.resourceDas.selectByPrimaryKey(idLong);
            if (resourceEo == null || resourceEo.getCode() == null) continue;
            String code = resourceEo.getCode();
            resourceEo = new ResourceEo();
            resourceEo.setParentCode(code);
            if (this.resourceDas.count((BaseEo)resourceEo) > 0) {
                throw new BizException("\u8be5\u8d44\u6e90\u8282\u70b9\u4e0b\u5b58\u5728\u5b50\u8282\u70b9\uff0c\u4e0d\u53ef\u5220\u9664");
            }
            this.resourceDas.logicDeleteById(idLong);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sortResourceMenu(SortReqDto sortReqDto) {
        Assert.notNull((Object)sortReqDto.getCode(), (String)"\u8d44\u6e90\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String sortType = sortReqDto.getSortType();
        Assert.hasLength((String)sortType, (String)"\u6392\u5e8f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasLength((String)SortEnum.getDescByType((String)sortType), (String)"\u6392\u5e8f\u7c7b\u578b\u4e0d\u652f\u6301");
        ResourceEo resourceMenu = this.resourceDas.selectByCodeAndType(sortReqDto.getCode(), ResourceType.MENU.getValue());
        if (resourceMenu == null) {
            throw new BizException(UserExceptionCode.MENU_NOTEXIT_FAIL.getCode(), UserExceptionCode.MENU_NOTEXIT_FAIL.getMsg());
        }
        ResourceEo selectEo = new ResourceEo();
        selectEo.setParentCode(resourceMenu.getParentCode());
        selectEo.setType(Integer.valueOf(ResourceType.MENU.getValue()));
        selectEo.setOrderBy("sort_no");
        List menuEoList = this.resourceDas.select((BaseEo)selectEo);
        if (CollectionUtils.isEmpty((Collection)menuEoList) || menuEoList.size() == 1) {
            return;
        }
        ArrayList<ResourceEo> newSortMenuEoList = new ArrayList<ResourceEo>();
        if (SortEnum.TOP.getType().equals(sortType)) {
            newSortMenuEoList.add(resourceMenu);
            for (ResourceEo eo : menuEoList) {
                if (eo.getId().equals(resourceMenu.getId())) continue;
                newSortMenuEoList.add(eo);
            }
        } else if (SortEnum.BOTTOM.getType().equals(sortType)) {
            for (ResourceEo eo : menuEoList) {
                if (eo.getId().equals(resourceMenu.getId())) continue;
                newSortMenuEoList.add(eo);
            }
            newSortMenuEoList.add(resourceMenu);
        } else {
            int size = menuEoList.size();
            for (int i = 0; i < size; ++i) {
                ResourceEo eo = (ResourceEo)menuEoList.get(i);
                if (!eo.getId().equals(resourceMenu.getId())) continue;
                Integer relatedIndex = null;
                if (SortEnum.INCR.getType().equals(sortType) && i != 0) {
                    relatedIndex = i - 1;
                } else if (SortEnum.DECR.getType().equals(sortType) && i != size - 1) {
                    relatedIndex = i + 1;
                }
                if (relatedIndex == null) break;
                menuEoList.set(i, menuEoList.get(relatedIndex));
                menuEoList.set(relatedIndex, resourceMenu);
                newSortMenuEoList.addAll(menuEoList);
                break;
            }
        }
        if (CollectionUtils.isNotEmpty(newSortMenuEoList)) {
            int sortno = 1;
            for (ResourceEo eo : newSortMenuEoList) {
                eo.setSortNo(Integer.valueOf(sortno++));
                this.resourceDas.updateSelective((BaseEo)eo);
            }
        }
    }

    @Override
    public List<ResourceImportReqDto> importResourceCheck(List<ResourceImportReqDto> dtoList) {
        Integer value = 1000;
        if (dtoList.size() > value) {
            throw new BizException("\u5355\u6b21\u5bfc\u5165\u8d44\u6e90\u6761\u6570\u4e0d\u80fd\u8d85\u8fc7" + value + "\u6761");
        }
        Map<String, List<ResourceImportReqDto>> resourceMap = dtoList.stream().peek(e -> {
            if (!Arrays.asList(ResourceType.MENU.getValue(), ResourceType.BUTTON.getValue()).contains(e.getType())) {
                e.setErrorMsg(e.getErrorMsg().append("\u8d44\u6e90\u7684\u7c7b\u578b\u53ea\u80fd\u4e3a\u83dc\u53551\u6216\u6309\u94ae2"));
            }
            if (e.getStatus() != null && !Arrays.asList(ResourceStatus.ENABLE.getValue(), ResourceStatus.DISABLE.getValue()).contains(e.getStatus())) {
                e.setErrorMsg(e.getErrorMsg().append("\u8d44\u6e90\u7684\u72b6\u6001\u53ea\u80fd\u4e3a\u542f\u75281\u6216\u7981\u75282"));
            }
            if (StringUtils.isEmpty((CharSequence)e.getCode())) {
                e.setErrorMsg(e.getErrorMsg().append("\u8d44\u6e90\u7f16\u7801code\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (StringUtils.isEmpty((CharSequence)e.getParentCode())) {
                e.setErrorMsg(e.getErrorMsg().append("\u8d44\u6e90\u7236\u7f16\u7801parentCode\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (e.getCode().equals(e.getParentCode())) {
                e.setErrorMsg(e.getErrorMsg().append("\u8d44\u6e90\u7f16\u7801code\u548c\u7236\u7f16\u7801parentCode\u4e0d\u80fd\u4e00\u6837"));
            }
        }).collect(Collectors.groupingBy(ResourceImportReqDto::getCode));
        dtoList.stream().map(ResourceImportReqDto::getCode).collect(Collectors.groupingBy(e -> e, Collectors.counting())).forEach((k, v) -> {
            if (v > 1L) {
                ((List)resourceMap.get(k)).stream().forEach(r -> r.setErrorMsg(r.getErrorMsg().append("\u8d44\u6e90\u7f16\u7801code").append((String)k).append("\u91cd\u590d")));
            }
        });
        List codes = dtoList.stream().map(ResourceImportReqDto::getCode).collect(Collectors.toList());
        List existList = this.resourceDas.selectByCodes(codes);
        existList.stream().forEach(e -> ((List)resourceMap.get(e.getCode())).forEach(r -> r.setErrorMsg(r.getErrorMsg().append("\u8d44\u6e90\u7f16\u7801code").append(e.getCode()).append("\u5df2\u5b58\u5728"))));
        List parentCodes = dtoList.stream().map(ResourceImportReqDto::getParentCode).collect(Collectors.toList());
        Map<String, List<ResourceImportReqDto>> parentResourceMap = dtoList.stream().collect(Collectors.groupingBy(ResourceImportReqDto::getParentCode));
        parentCodes.removeAll(codes);
        List existParentList = this.resourceDas.selectByCodes(parentCodes);
        List existParentCodes = existParentList.stream().map(StdResourceEo::getCode).collect(Collectors.toList());
        parentCodes.removeAll(existParentCodes);
        if (CollectionUtils.isNotEmpty(parentCodes)) {
            parentCodes.stream().forEach(e -> ((List)parentResourceMap.get(e)).forEach(r -> r.setErrorMsg(r.getErrorMsg().append("\u8d44\u6e90\u7236\u7f16\u7801parentCode").append((String)e).append("\u7f3a\u5931"))));
        }
        return dtoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ResourceImportRespDto importResources(List<ResourceImportReqDto> dtoList) {
        List errorList = (dtoList = this.resourceImpotCheckExt.importResourceCheck(dtoList)).stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getErrorMsg())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(errorList)) {
            return new ResourceImportRespDto(UserExceptionCode.RESOURCE_IMPORT_ERROR.getCode(), UserExceptionCode.RESOURCE_IMPORT_ERROR.getMsg(), errorList);
        }
        List resourceEos = dtoList.stream().map(e -> {
            ResourceEo resourceEo = new ResourceEo();
            DtoHelper.dto2Eo((BaseVo)e, (BaseEo)resourceEo, (String[])new String[]{"menus"});
            resourceEo.setExtension("");
            if (resourceEo.getDescription() == null) {
                resourceEo.setDescription("");
            }
            if (resourceEo.getUserId() == null) {
                resourceEo.setUserId(Long.valueOf(0L));
            }
            if (resourceEo.getPersonId() == null) {
                resourceEo.setPersonId(Long.valueOf(0L));
            }
            if (StringUtils.isBlank((CharSequence)resourceEo.getAction())) {
                resourceEo.setAction("");
            }
            if (resourceEo.getSortNo() == null) {
                resourceEo.setSortNo(Integer.valueOf(0));
            }
            if (resourceEo.getStatus() == null) {
                resourceEo.setStatus(Integer.valueOf(ResourceStatus.ENABLE.getValue()));
            }
            return resourceEo;
        }).collect(Collectors.toList());
        this.resourceDas.insertBatch(resourceEos);
        return new ResourceImportRespDto("0", "\u6210\u529f\u5bfc\u5165" + resourceEos.size() + "\u6761");
    }

    @Override
    public void registerResources(ResourceRegisterDto resourceRegisterDto) {
        String appCode = resourceRegisterDto.getAppCode();
        List resources = resourceRegisterDto.getResources();
        if (StringUtils.isBlank((CharSequence)appCode) || CollectionUtils.isEmpty((Collection)resources)) {
            throw new BizException("\u5e94\u7528\u7f16\u7801\u6216\u8d44\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ApplicationEo applicationEo = new ApplicationEo();
        applicationEo.setCode(appCode);
        applicationEo = (ApplicationEo)this.applicationDas.selectOne((BaseEo)applicationEo);
        List applicationResourceEoList = null;
        if (applicationEo == null) {
            AppRegisterDto appRegisterDto = new AppRegisterDto();
            appRegisterDto.setCode(appCode);
            appRegisterDto.setName(appCode);
            appRegisterDto.setOwnerId(Long.valueOf(1L));
            AppRegisterVo appRegisterVo = this.applicationService.register(appRegisterDto);
        }
        ApplicationResourceEo applicationResourceEo = new ApplicationResourceEo();
        applicationResourceEo.setApplicationCode(appCode);
        applicationResourceEoList = this.applicationResourceDas.select((BaseEo)applicationResourceEo);
        if (CollectionUtils.isEmpty((Collection)applicationResourceEoList)) {
            resources.forEach(r -> {
                ResourceEo resourceEo = new ResourceEo();
                CubeBeanUtils.copyProperties((Object)resourceEo, (Object)r, (String[])new String[0]);
                resourceEo.setStatus(Integer.valueOf(ResourceStatus.ENABLE.getValue()));
                this.resourceDas.insert((BaseEo)resourceEo);
                ApplicationResourceEo appResourceEo = new ApplicationResourceEo();
                appResourceEo.setApplicationCode(appCode);
                appResourceEo.setResourceCode(r.getCode());
                this.applicationResourceDas.insert((BaseEo)appResourceEo);
            });
        }
    }

    @Override
    public Boolean checkResourceExist(ResourceValidateDto resourceValidateDto) {
        ResourceEo eo = new ResourceEo();
        eo.setCode(resourceValidateDto.getCode());
        List list = this.resourceDas.select((BaseEo)eo);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return true;
        }
        return false;
    }

    @Override
    public MenuQueryResDto queryMenuByInstanceIdAndCode(Long instanceId, String code) {
        MenuEo menuEo = this.menuDas.selectByInstanceIdAndCode(instanceId, code);
        if (menuEo == null) {
            throw new BusinessRuntimeException("\u8d44\u6e90\u7f16\u7801" + code + "\u4e0d\u5b58\u5728");
        }
        MenuQueryResDto result = new MenuQueryResDto();
        DtoHelper.eo2Dto((BaseEo)menuEo, (BaseVo)result);
        List rootList = MenuDas.buildTree((String)code, this.menuDas.selectByInstanceId(instanceId).stream().map(e -> {
            MenuQueryResDto nodeDto = new MenuQueryResDto();
            DtoHelper.eo2Dto((BaseEo)e, (BaseVo)nodeDto);
            return nodeDto;
        }).collect(Collectors.toList()));
        result.setChildren(rootList);
        ButtonEo selectButtons = new ButtonEo();
        selectButtons.setParentCode(result.getCode());
        List buttonEos = this.buttonDas.select((BaseEo)selectButtons);
        ArrayList buttonDtos = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)buttonEos, buttonDtos, ButtonQueryResDto.class);
        result.setButtons(buttonDtos);
        return result;
    }

    @Override
    public List<MenuEo> findMenuByIds(List<Long> menuIds) {
        if (CollectionUtils.isEmpty(menuIds)) {
            return Lists.newArrayList();
        }
        return this.menuDas.findByIds(menuIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addMenu(MenuDto menuDto) {
        AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(menuDto.getInstanceId());
        if (appInstanceEo == null) {
            this.logger.info("\u7528\u6237\u7ed1\u5b9a\u83dc\u5355\u4fe1\u606f\uff0c\u901a\u8fc7\u5e94\u7528id\u65e0\u6cd5\u627e\u5230\u5e94\u7528\u5b9e\u4f8b,\u5e94\u7528\u5b9e\u4f8bid\u4e3a:" + menuDto.getInstanceId());
            throw new BizException(UserExceptionCode.APPLICATION_EXCEPTION_CODE.getCode(), UserExceptionCode.APPLICATION_EXCEPTION_CODE.getMsg());
        }
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)menuDto.getParentCode()), "10002", "\u7236\u7f16\u7801parentCode\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        MenuEo parent = this.menuDas.selectByInstanceIdAndCode(menuDto.getInstanceId(), menuDto.getParentCode());
        if (parent == null) {
            this.logger.info("\u7ed1\u5b9a\u83dc\u5355\u8d44\u6e90\uff0c\u7236\u83dc\u5355\u4e0d\u5b58\u5728,\u7236\u7f16\u7801parentCode\u4e3a:" + menuDto.getParentCode());
            throw new BizException(UserExceptionCode.MENU_NOTEXIT_FAIL.getCode(), UserExceptionCode.MENU_NOTEXIT_FAIL.getMsg());
        }
        if (menuDto.getStatus() == null) {
            menuDto.setStatus(Integer.valueOf(1));
        }
        MenuEo menuEo = new MenuEo();
        DtoHelper.dto2Eo((BaseVo)menuDto, (BaseEo)menuEo);
        menuEo.setNameI1(menuDto.getName_i1());
        menuEo.setNameI2(menuDto.getName_i2());
        this.menuDas.insert((BaseEo)menuEo);
        return menuEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long modifyMenu(MenuDto menuDto) {
        MenuEo menuEo;
        MenuEo menuEo2 = menuEo = menuDto.getId() != null ? (MenuEo)this.menuDas.selectByPrimaryKey(menuDto.getId()) : this.menuDas.selectByInstanceIdAndCode(menuDto.getInstanceId(), menuDto.getCode());
        if (menuEo == null) {
            this.logger.info("\u4fee\u6539\u83dc\u5355\u8d44\u6e90\uff0c\u65e0\u6cd5\u901a\u8fc7\u83dc\u5355id\u67e5\u8be2\u5230\u83dc\u5355\u4fe1\u606f,\u83dc\u5355id\u4e3a:" + menuDto.getId());
            throw new BizException(UserExceptionCode.MENU_NOTEXIT_FAIL.getCode(), UserExceptionCode.MENU_NOTEXIT_FAIL.getMsg());
        }
        if (StringUtils.isNotBlank((CharSequence)menuDto.getAction())) {
            menuEo.setAction(menuDto.getAction());
        }
        if (StringUtils.isNotBlank((CharSequence)menuDto.getRoutePath())) {
            menuEo.setRoutePath(menuDto.getRoutePath());
        }
        if (StringUtils.isNotBlank((CharSequence)menuDto.getName())) {
            menuEo.setName(menuDto.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)menuDto.getCode())) {
            menuEo.setCode(menuDto.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)menuDto.getIcon())) {
            menuEo.setIcon(menuDto.getIcon());
        }
        if (menuDto.getSortNo() != null) {
            menuEo.setSortNo(menuDto.getSortNo());
        }
        if (menuDto.getStatus() != null) {
            menuEo.setStatus(menuDto.getStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)menuDto.getName_i1())) {
            menuEo.setNameI1(menuDto.getName_i1());
        }
        if (StringUtils.isNotBlank((CharSequence)menuDto.getName_i2())) {
            menuEo.setNameI2(menuDto.getName_i2());
        }
        if (menuDto.getParentCode() != null) {
            MenuEo parent = this.menuDas.selectByInstanceIdAndCode(menuDto.getInstanceId(), menuDto.getParentCode());
            AssertUtil.isTrue(parent != null, "\u627e\u4e0d\u5230id\u4e3a" + menuDto.getParentCode() + "\u7684\u83dc\u5355\uff01");
            menuEo.setParentCode(parent.getCode());
        }
        this.menuDas.update((BaseEo)menuEo);
        return menuEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeMenu(Long instanceId, Long id) {
        AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        if (appInstanceEo == null) {
            this.logger.info("\u7528\u6237\u5220\u9664\u6309\u94ae\u4fe1\u606f\uff0c\u901a\u8fc7\u5e94\u7528id\u65e0\u6cd5\u627e\u5230\u5e94\u7528,\u5e94\u7528id\u4e3a:" + instanceId);
            throw new BizException(UserExceptionCode.APPLICATION_EXCEPTION_CODE.getCode(), UserExceptionCode.APPLICATION_EXCEPTION_CODE.getMsg());
        }
        MenuEo menuEo = (MenuEo)this.menuDas.selectByPrimaryKey(id);
        if (menuEo == null) {
            this.logger.info("\u4fee\u6539\u83dc\u5355\u8d44\u6e90\uff0c\u65e0\u6cd5\u901a\u8fc7\u83dc\u5355id\u67e5\u8be2\u5230\u83dc\u5355\u4fe1\u606f,\u83dc\u5355id\u4e3a:" + id);
            throw new BizException(UserExceptionCode.MENU_NOTEXIT_FAIL.getCode(), UserExceptionCode.MENU_NOTEXIT_FAIL.getMsg());
        }
        Long count = this.menuDas.countByInstanceIdAndParentCode(instanceId, menuEo.getCode());
        if (count > 0L) {
            this.logger.info("\u8be5\u83dc\u5355\u8282\u70b9\u4e0b\u6709\u5b50\u8282\u70b9\uff0c\u4e0d\u80fd\u5220\u9664");
            throw new BizException(UserExceptionCode.MENU_CHILD_FAIL.getCode(), UserExceptionCode.MENU_CHILD_FAIL.getMsg());
        }
        this.menuDas.logicDeleteById(id);
        ButtonEo buttonEo = new ButtonEo();
        buttonEo.setParentCode(menuEo.getCode());
        this.buttonDas.logicDeleteByExample((BaseEo)buttonEo);
    }

    @Override
    public List<ButtonDto> findButtonByInstanceIdAndMenuId(Long instanceId, Long menuId) {
        MenuEo menuEo = (MenuEo)this.menuDas.selectByPrimaryKey(menuId);
        if (menuEo == null) {
            this.logger.info("\u83dc\u5355[id=" + menuId + "]\u4e0d\u5b58\u5728");
            throw new BizException(UserExceptionCode.MENU_NOTEXIT_FAIL.getCode(), UserExceptionCode.MENU_NOTEXIT_FAIL.getMsg());
        }
        if (StringUtils.isBlank((CharSequence)menuEo.getCode())) {
            this.logger.info("\u83dc\u5355[id=" + menuId + "]\u7684\u7f16\u7801\u4e3a\u7a7a");
            throw new BizException(UserExceptionCode.MENU_NOTEXIT_FAIL.getCode(), "\u5bf9\u5e94\u7684\u83dc\u5355\u7684\u7f16\u7801\u4e3a\u7a7a");
        }
        ButtonEo buttonEo = new ButtonEo();
        buttonEo.setInstanceId(menuEo.getInstanceId());
        buttonEo.setParentCode(menuEo.getCode());
        List buttonEos = this.buttonDas.select((BaseEo)buttonEo, Integer.valueOf(1), Integer.valueOf(1000));
        if (CollectionUtils.isNotEmpty((Collection)buttonEos)) {
            ArrayList<ButtonDto> buttonDtos = new ArrayList<ButtonDto>();
            DtoHelper.eoList2DtoList((Collection)buttonEos, buttonDtos, ButtonDto.class);
            return buttonDtos;
        }
        return new ArrayList<ButtonDto>();
    }

    @Override
    public List<ButtonEo> findButtonByIds(List<Long> buttonIds) {
        if (CollectionUtils.isEmpty(buttonIds)) {
            return Lists.newArrayList();
        }
        return this.buttonDas.findByIds(buttonIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addButton(ButtonDto buttonDto) {
        MenuEo menuEo;
        AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(buttonDto.getInstanceId());
        if (appInstanceEo == null) {
            this.logger.info("\u7528\u6237\u7ed1\u5b9a\u6309\u94ae\u4fe1\u606f\uff0c\u901a\u8fc7\u5e94\u7528id\u65e0\u6cd5\u627e\u5230\u5e94\u7528,\u5e94\u7528id\u4e3a:" + buttonDto.getInstanceId());
            throw new BizException(UserExceptionCode.APPLICATION_EXCEPTION_CODE.getCode(), UserExceptionCode.APPLICATION_EXCEPTION_CODE.getMsg());
        }
        MenuEo menuEo2 = menuEo = buttonDto.getMenuId() != null ? (MenuEo)this.menuDas.selectByPrimaryKey(buttonDto.getMenuId()) : this.menuDas.selectByInstanceIdAndCode(appInstanceEo.getInstanceId(), buttonDto.getParentCode());
        if (menuEo == null) {
            throw new BizException(UserExceptionCode.MENU_NOTEXIT_FAIL.getCode(), UserExceptionCode.MENU_NOTEXIT_FAIL.getMsg());
        }
        AssertUtil.isTrue(this.buttonDas.selectByCodes(Collections.singletonList(buttonDto.getCode()), menuEo.getInstanceId()) != null, "\u6309\u94ae\u7f16\u53f7\u5df2\u88ab\u4f7f\u7528");
        if (buttonDto.getStatus() == null) {
            buttonDto.setStatus(Integer.valueOf(1));
        }
        ButtonEo buttonEo = new ButtonEo();
        DtoHelper.dto2Eo((BaseVo)buttonDto, (BaseEo)buttonEo);
        buttonEo.setParentCode(menuEo.getCode());
        this.buttonDas.insert((BaseEo)buttonEo);
        return buttonEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long modifyButton(ButtonDto buttonDto) {
        ButtonEo buttonEo = (ButtonEo)this.buttonDas.selectByPrimaryKey(buttonDto.getId());
        if (buttonEo == null) {
            this.logger.info("\u6dfb\u52a0\u6309\u94ae\u8d44\u6e90\uff0c\u65e0\u6cd5\u901a\u8fc7\u6309\u94aeid\u67e5\u8be2\u5230\u6309\u94ae\u4fe1\u606f,\u6309\u94aeid\u4e3a:" + buttonDto.getId());
            throw new BizException(UserExceptionCode.BUTTON_IDCHECK_FAIL.getCode(), UserExceptionCode.BUTTON_IDCHECK_FAIL.getMsg());
        }
        DtoHelper.dto2Eo((BaseVo)buttonDto, (BaseEo)buttonEo, (String[])new String[]{"id"});
        this.buttonDas.updateSelective((BaseEo)buttonEo);
        return buttonEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeButton(Long instanceId, Long buttonId) {
        this.buttonDas.logicDeleteById(buttonId);
    }
}

