/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.data.limit.biz.service.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.data.limit.api.constant.IdentityTypeEnum;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.response.IgnoreRuleQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.enums.DataLimitRuleIdLinkTypeEnum;
import com.dtyunxi.yundt.cube.center.data.limit.api.exception.DataLimitExceptionCode;
import com.dtyunxi.yundt.cube.center.data.limit.biz.service.IDataLimitRuleIdlinkService;
import com.dtyunxi.yundt.cube.center.data.limit.dao.das.DataLimitRuleIdlinkDas;
import com.dtyunxi.yundt.cube.center.data.limit.dao.eo.DataLimitRuleIdlinkEo;
import com.dtyunxi.yundt.cube.center.data.limit.dao.eo.StdDataLimitRuleIdlinkEo;
import com.dtyunxi.yundt.cube.center.user.biz.service.IRoleService;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataLimitRuleIdlinkServiceImpl
implements IDataLimitRuleIdlinkService {
    @Resource
    private DataLimitRuleIdlinkDas dataLimitRuleIdlinkDas;
    @Resource
    private IRoleService roleService;

    @Override
    public List<Long> queryIdentityIdList(Long ruleId, String identityType) {
        DataLimitRuleIdlinkEo idLinkEo = new DataLimitRuleIdlinkEo();
        idLinkEo.setRuleId(ruleId);
        idLinkEo.setIdentityType(identityType);
        List idLinkEoList = this.dataLimitRuleIdlinkDas.select((BaseEo)idLinkEo);
        if (CollectionUtils.isNotEmpty((Collection)idLinkEoList)) {
            return idLinkEoList.stream().map(StdDataLimitRuleIdlinkEo::getIdentityId).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public PageInfo<DataLimitRuleIdlinkEo> selectPageByIgnoreRule(IgnoreRuleQueryReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        DataLimitRuleIdlinkEo eo = new DataLimitRuleIdlinkEo();
        CubeBeanUtils.copyProperties((Object)eo, (Object)queryReqDto, (String[])new String[0]);
        eo.setInstanceId(queryReqDto.getRefAppInstId());
        eo.setLinkType(Integer.valueOf(DataLimitRuleIdLinkTypeEnum.IGNORE.getCode()));
        eo.setDr(0);
        eo.setOrderBy("create_time");
        return this.dataLimitRuleIdlinkDas.selectPage((BaseEo)eo, pageNum, pageSize);
    }

    public DataLimitRuleIdlinkEo findByIgnoreRuleLink(Long ruleId) {
        DataLimitRuleIdlinkEo queryEo = new DataLimitRuleIdlinkEo();
        queryEo.setRuleId(ruleId);
        queryEo.setDr(0);
        return (DataLimitRuleIdlinkEo)this.dataLimitRuleIdlinkDas.selectOne((BaseEo)queryEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateIgnoreRuleLink(Long ruleId, String sceneCode, Long refAppInstId, Long identityId, IdentityTypeEnum identityTypeEnum) {
        DataLimitRuleIdlinkEo eo = this.findByIgnoreRuleLink(ruleId);
        if (null == eo) {
            throw DataLimitExceptionCode.DATA_LIMIT_RULE_ID_LINK_NOT_EXIST.buildBizException();
        }
        eo.setRuleId(ruleId);
        eo.setSceneCode(sceneCode);
        eo.setInstanceId(refAppInstId);
        eo.setIdentityId(identityId);
        eo.setIdentityType(identityTypeEnum.getCode());
        eo.setLinkType(Integer.valueOf(DataLimitRuleIdLinkTypeEnum.IGNORE.getCode()));
        this.dataLimitRuleIdlinkDas.update((BaseEo)eo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addIgnoreRuleLink(Long ruleId, String sceneCode, Long refAppInstId, Long identityId, IdentityTypeEnum identityTypeEnum) {
        DataLimitRuleIdlinkEo eo = new DataLimitRuleIdlinkEo();
        eo.setDr(0);
        eo.setRuleId(ruleId);
        eo.setSceneCode(sceneCode);
        eo.setInstanceId(refAppInstId);
        eo.setIdentityId(identityId);
        eo.setIdentityType(identityTypeEnum.getCode());
        eo.setLinkType(Integer.valueOf(DataLimitRuleIdLinkTypeEnum.IGNORE.getCode()));
        this.dataLimitRuleIdlinkDas.insert((BaseEo)eo);
        return eo.getId();
    }
}

