/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.user.api.constant.AbacAttrApplicationStatusEnum;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AbacAttrApplicationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.AbacAttrApplicationRespDto;
import com.dtyunxi.yundt.cube.center.user.biz.service.IAbacAttrApplicationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IQueryUserAttrValue;
import com.dtyunxi.yundt.cube.center.user.dao.das.AbacAttrApplicationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.AbacAttrDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.AppInstanceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.ApplicationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserRoleRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AbacAttrApplicationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AbacAttrEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AppInstanceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdAbacAttrApplicationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdApplicationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserRoleRelationEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class AbacAttrApplicationServiceImpl
implements IAbacAttrApplicationService {
    private static Logger logger = LoggerFactory.getLogger(IAbacAttrApplicationService.class);
    @Resource
    private AbacAttrApplicationDas abacAttrApplicationDas;
    @Resource
    private AbacAttrDas abacAttrDas;
    @Resource
    private ApplicationDas applicationDas;
    @Autowired
    private UserRoleRelationDas userRoleRelationDas;
    @Autowired
    private AppInstanceDas appInstanceDas;
    @Autowired
    private Map<String, IQueryUserAttrValue> queryUserAttrValueMap;

    @Override
    public List<AbacAttrEo> queryAttrByAppId(Long appId) {
        AbacAttrApplicationEo attrAppEo = this.abacAttrApplicationDas.selectEnableByAppId(appId);
        if (attrAppEo != null) {
            return this.abacAttrDas.selectByIdList(attrAppEo.getAttrIds());
        }
        AbacAttrApplicationEo defaultAttrAppEo = this.abacAttrApplicationDas.selectByAppId(Long.valueOf(0L));
        if (defaultAttrAppEo != null) {
            return this.abacAttrDas.selectByIdList(defaultAttrAppEo.getAttrIds());
        }
        return Lists.newArrayList();
    }

    @Override
    public PageInfo<AbacAttrApplicationRespDto> pageByFilter(String filter, Integer pageSize, Integer pageNum) {
        AbacAttrApplicationEo queryEo = StringUtils.isBlank((CharSequence)filter) ? new AbacAttrApplicationEo() : (AbacAttrApplicationEo)JSONObject.parseObject((String)filter, AbacAttrApplicationEo.class);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List eoList = this.abacAttrApplicationDas.select((BaseEo)queryEo);
        if (CollectionUtils.isEmpty((Collection)eoList)) {
            return new PageInfo((List)Lists.newArrayList());
        }
        Set appIdSet = eoList.stream().map(StdAbacAttrApplicationEo::getAppId).collect(Collectors.toSet());
        List applicationList = this.applicationDas.selectByIdList(appIdSet);
        Map<Object, Object> appCodeMap = CollectionUtils.isNotEmpty((Collection)applicationList) ? applicationList.stream().collect(Collectors.toMap(BaseEo::getId, StdApplicationEo::getCode)) : Maps.newHashMap();
        List respDtoList = eoList.stream().map(c -> {
            AbacAttrApplicationRespDto dto = new AbacAttrApplicationRespDto();
            BeanUtils.copyProperties((Object)c, (Object)dto);
            dto.setAppCode((String)appCodeMap.get(c.getAppId()));
            return dto;
        }).collect(Collectors.toList());
        return new PageInfo(respDtoList);
    }

    @Override
    public Long insert(AbacAttrApplicationReqDto reqDto) {
        if (CollectionUtils.isEmpty((Collection)reqDto.getAttrIdList()) || CollectionUtils.isEmpty((Collection)reqDto.getAttrNameList())) {
            throw new BizException("\u8bf7\u9009\u62e9\u5173\u8054\u7684\u5c5e\u6027\u9879");
        }
        AbacAttrApplicationEo eo = new AbacAttrApplicationEo();
        BeanUtils.copyProperties((Object)reqDto, (Object)eo);
        eo.setAttrIds(StringUtils.join((Iterable)reqDto.getAttrIdList(), (String)","));
        eo.setAttrNames(StringUtils.join((Iterable)reqDto.getAttrNameList(), (String)"\u3001"));
        if (eo.getAppId() == null) {
            AbacAttrApplicationEo defaultEo = this.abacAttrApplicationDas.selectByAppId(Long.valueOf(0L));
            if (defaultEo != null) {
                throw new BizException("\u9ed8\u8ba4\u6a21\u677f\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
            }
            eo.setAppId(Long.valueOf(0L));
            eo.setAppName("\u6240\u6709\u5e94\u7528");
        }
        eo.setStatus(AbacAttrApplicationStatusEnum.ENABLED.getKey());
        this.abacAttrApplicationDas.insert((BaseEo)eo);
        return null;
    }

    @Override
    public AbacAttrApplicationRespDto queryById(Long id) {
        if (id == null) {
            return null;
        }
        AbacAttrApplicationEo eo = (AbacAttrApplicationEo)this.abacAttrApplicationDas.selectByPrimaryKey(id);
        if (eo == null) {
            return null;
        }
        AbacAttrApplicationRespDto respDto = new AbacAttrApplicationRespDto();
        BeanUtils.copyProperties((Object)eo, (Object)respDto);
        respDto.setAttrIdList(Lists.newArrayList((Object[])StringUtils.split((String)eo.getAttrIds(), (String)",")).stream().map(c -> Long.parseLong(c)).collect(Collectors.toList()));
        respDto.setAttrNameList((List)Lists.newArrayList((Object[])StringUtils.split((String)eo.getAttrNames(), (String)"\u3001")));
        return respDto;
    }

    @Override
    public void update(AbacAttrApplicationReqDto reqDto) {
        if (reqDto.getId() == null) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)reqDto.getAttrIdList()) || CollectionUtils.isEmpty((Collection)reqDto.getAttrNameList())) {
            throw new BizException("\u8bf7\u9009\u62e9\u5173\u8054\u7684\u5c5e\u6027\u9879");
        }
        if (reqDto.getAppId() == null || StringUtils.isBlank((CharSequence)reqDto.getAppName())) {
            throw new BizException("\u8bf7\u9009\u62e9\u5173\u8054\u7684\u5e94\u7528");
        }
        AbacAttrApplicationEo existEo = (AbacAttrApplicationEo)this.abacAttrApplicationDas.selectByPrimaryKey(reqDto.getId());
        if (existEo == null) {
            return;
        }
        if (existEo.getAppId() == 0L && reqDto.getAppId() != 0L) {
            throw new BizException("\u9ed8\u8ba4\u914d\u7f6e\u4e0d\u80fd\u66f4\u6539\u5173\u8054\u7684\u5e94\u7528\u6a21\u677f");
        }
        AbacAttrApplicationEo eo = new AbacAttrApplicationEo();
        BeanUtils.copyProperties((Object)reqDto, (Object)eo);
        eo.setAttrIds(StringUtils.join((Iterable)reqDto.getAttrIdList(), (String)","));
        eo.setAttrNames(StringUtils.join((Iterable)reqDto.getAttrNameList(), (String)"\u3001"));
        this.abacAttrApplicationDas.updateSelective((BaseEo)eo);
    }

    @Override
    public void updateStatus(AbacAttrApplicationReqDto reqDto) {
        if (reqDto.getId() == null || reqDto.getStatus() == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)AbacAttrApplicationStatusEnum.getValueByKey((Integer)reqDto.getStatus()))) {
            return;
        }
        AbacAttrApplicationEo updateEo = new AbacAttrApplicationEo();
        updateEo.setId(reqDto.getId());
        updateEo.setStatus(reqDto.getStatus());
        this.abacAttrApplicationDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void deleteById(Long id) {
        if (id == null) {
            return;
        }
        this.abacAttrApplicationDas.deleteById(id);
    }

    @Override
    public List<UserRoleRelationEo> getUserRoleRelationByUserAttr(Long userId, Long instanceId) {
        if (userId == null) {
            return Lists.newArrayList();
        }
        Map<String, String> abacAttrEntityCode2FieldNameMap = this.getAbacAttrConfig(instanceId);
        HashMap userAttrValueMap = Maps.newHashMap();
        Map<String, IQueryUserAttrValue> attrEntryCode2BeanMap = this.getAttrEntryCode2BeanMap();
        for (Map.Entry<String, String> entry : abacAttrEntityCode2FieldNameMap.entrySet()) {
            IQueryUserAttrValue queryBean = attrEntryCode2BeanMap.get(entry.getKey());
            if (queryBean == null) {
                userAttrValueMap.put(entry.getValue(), Lists.newArrayList());
                continue;
            }
            String headerValue = this.getAttrRequestHeaderValue(entry.getValue());
            if (StringUtils.isNotBlank((CharSequence)headerValue)) {
                if (!queryBean.checkUserAttrValue(headerValue)) {
                    throw new BizException(String.format("\u4f20\u5165\u7684\u7528\u6237\u5c5e\u6027\u9879%s\u5bf9\u5e94\u7684\u5c5e\u6027\u503c\u4e0d\u5c5e\u4e8e\u8be5\u7528\u6237\u6240\u62e5\u6709", entry.getKey()));
                }
                userAttrValueMap.put(entry.getValue(), Lists.newArrayList((Object[])new String[]{headerValue}));
                continue;
            }
            List<String> userAttrValueList = queryBean.getUserAttrValue(userId);
            userAttrValueMap.put(entry.getValue(), userAttrValueList == null ? Lists.newArrayList() : userAttrValueList);
        }
        return this.userRoleRelationDas.selectByUserAttrValue(userId, (Map)userAttrValueMap, null);
    }

    private Map<String, IQueryUserAttrValue> getAttrEntryCode2BeanMap() {
        HashMap attrEntryCode2BeanMap = Maps.newHashMap();
        for (Map.Entry<String, IQueryUserAttrValue> entry : this.queryUserAttrValueMap.entrySet()) {
            String entryCode = entry.getValue().getAbacAttrEntryCode();
            if (!StringUtils.isNotBlank((CharSequence)entryCode)) continue;
            attrEntryCode2BeanMap.put(entryCode, entry.getValue());
        }
        return attrEntryCode2BeanMap;
    }

    private String getAttrRequestHeaderValue(String attrFieldName) {
        if (StringUtils.isBlank((CharSequence)attrFieldName)) {
            return null;
        }
        String attrValue = null;
        try {
            HttpServletRequest req = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            if (req != null) {
                attrValue = req.getHeader("yes-req-" + attrFieldName.replace("_", "-"));
            }
        }
        catch (Exception e) {
            logger.error("get {} value from request header exception: {}", (Object)attrFieldName, (Object)e);
        }
        logger.info("get {} value from request header, value is : {}", (Object)attrFieldName, attrValue);
        return attrValue;
    }

    private Map<String, String> getAbacAttrConfig(Long instanceId) {
        AppInstanceEo instanceEo;
        HashMap abacAttrEntityCode2FieldNameMap = Maps.newHashMap();
        List<AbacAttrEo> abacAttrList = instanceId == null ? this.abacAttrDas.selectAll() : this.queryAttrByAppId((instanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId)) == null ? null : instanceEo.getApplicationId());
        if (CollectionUtils.isNotEmpty((Collection)abacAttrList)) {
            for (AbacAttrEo abacAttr : abacAttrList) {
                if (StringUtils.isBlank((CharSequence)abacAttr.getEntityCode()) || StringUtils.isBlank((CharSequence)abacAttr.getFieldName())) continue;
                abacAttrEntityCode2FieldNameMap.put(abacAttr.getEntityCode(), abacAttr.getFieldName());
            }
        }
        return abacAttrEntityCode2FieldNameMap;
    }
}

