/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.data.limit.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.limit.api.constant.DataLimitConstant;
import com.dtyunxi.yundt.cube.center.data.limit.api.constant.DesenRuleEnum;
import com.dtyunxi.yundt.cube.center.data.limit.api.constant.FieldTypeEnum;
import com.dtyunxi.yundt.cube.center.data.limit.api.constant.IdentityTypeEnum;
import com.dtyunxi.yundt.cube.center.data.limit.api.constant.LimitWayEnum;
import com.dtyunxi.yundt.cube.center.data.limit.api.constant.RuleTypeEnum;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.CommonFieldReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.CustomFieldReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.FieldLimitDetailReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.FieldLimitRuleCreateReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.FieldLimitRuleModifyReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.FieldLimitRuleQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.FieldLimitRuleReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.RoleQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.RoleQueryRespDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.RuleIdLinkReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.UserFieldLimitRuleQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.response.AppInstanceAndRoleRespDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.response.CommonFieldRespDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.response.FieldLimitRuleDetailRespDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.response.FieldLimitRuleRespDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.response.UserFieldLimitRuleQueryRespDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.exception.DataLimitExceptionCode;
import com.dtyunxi.yundt.cube.center.data.limit.biz.config.CommonFieldProperties;
import com.dtyunxi.yundt.cube.center.data.limit.biz.service.IDataLimitRuleIdlinkService;
import com.dtyunxi.yundt.cube.center.data.limit.biz.service.IFieldLimitRuleService;
import com.dtyunxi.yundt.cube.center.data.limit.biz.util.BeanValidatorUtil;
import com.dtyunxi.yundt.cube.center.data.limit.biz.vo.CommonFieldVo;
import com.dtyunxi.yundt.cube.center.data.limit.biz.vo.FieldLimitDetailVo;
import com.dtyunxi.yundt.cube.center.data.limit.dao.das.DataLimitRuleDas;
import com.dtyunxi.yundt.cube.center.data.limit.dao.das.DataLimitRuleIdlinkDas;
import com.dtyunxi.yundt.cube.center.data.limit.dao.das.FieldLimitDetailDas;
import com.dtyunxi.yundt.cube.center.data.limit.dao.eo.DataLimitRuleEo;
import com.dtyunxi.yundt.cube.center.data.limit.dao.eo.DataLimitRuleIdlinkEo;
import com.dtyunxi.yundt.cube.center.data.limit.dao.eo.FieldLimitDetailEo;
import com.dtyunxi.yundt.cube.center.data.limit.dao.eo.StdDataLimitRuleIdlinkEo;
import com.dtyunxi.yundt.cube.center.data.limit.dao.eo.StdFieldLimitDetailEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppInstanceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserRoleRespDto;
import com.dtyunxi.yundt.cube.center.user.api.exception.IExceptionEnum;
import com.dtyunxi.yundt.cube.center.user.biz.constant.RoleStatus;
import com.dtyunxi.yundt.cube.center.user.biz.service.IAccessService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IApplicationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IRoleService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.vo.RoleQueryVo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RoleEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@EnableConfigurationProperties(value={CommonFieldProperties.class})
@Service
public class FieldLimitRuleServiceImpl
implements IFieldLimitRuleService {
    @Autowired(required=false)
    private CommonFieldProperties commonFieldProperties;
    @Resource
    private FieldLimitDetailDas fieldLimitDetailDas;
    @Resource
    private DataLimitRuleDas dataLimitRuleDas;
    @Resource
    private DataLimitRuleIdlinkDas dataLimitRuleIdlinkDas;
    @Resource
    private IDataLimitRuleIdlinkService dataLimitRuleIdlinkService;
    @Resource
    private IApplicationService applicationService;
    @Resource
    private IRoleService roleService;
    @Resource
    private IAccessService accessService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addFieldLimitRule(FieldLimitRuleCreateReqDto addReqDto) {
        Long instanceId = addReqDto.getInstanceId() == null ? ServiceContext.getContext().getRequestInstanceId() : addReqDto.getInstanceId();
        Long tenantId = addReqDto.getTenantId() == null ? ServiceContext.getContext().getRequestTenantId() : addReqDto.getTenantId();
        String ruleCode = this.generateRuleCode(addReqDto);
        int codeCount = this.dataLimitRuleDas.countByCodeAndRuleType(ruleCode, instanceId, RuleTypeEnum.FIELD_LIMIT.getType());
        AssertUtil.isTrue(codeCount == 0, (IExceptionEnum)DataLimitExceptionCode.FIELD_LIMIT_RULE_CODE_EXIST);
        DataLimitRuleEo dataLimitRuleEo = this.buildDataLimitRuleEo(addReqDto, instanceId, tenantId, ruleCode);
        this.dataLimitRuleDas.insert((BaseEo)dataLimitRuleEo);
        this.saveIdLink(addReqDto.getIdentityIds(), addReqDto.getIdentityType(), dataLimitRuleEo.getId());
        this.saveFieldLimitDetail(addReqDto.getCustomFields(), dataLimitRuleEo.getId());
        return dataLimitRuleEo.getId();
    }

    private DataLimitRuleEo buildDataLimitRuleEo(FieldLimitRuleCreateReqDto addReqDto, Long instanceId, Long tenantId, String ruleCode) {
        DataLimitRuleEo dataLimitRuleEo = new DataLimitRuleEo();
        dataLimitRuleEo.setCode(ruleCode);
        dataLimitRuleEo.setRemark(addReqDto.getRemark());
        dataLimitRuleEo.setRuleType(RuleTypeEnum.FIELD_LIMIT.getType());
        dataLimitRuleEo.setStatus(DataLimitConstant.STATUS_NORMAL);
        dataLimitRuleEo.setTenantId(tenantId);
        dataLimitRuleEo.setInstanceId(instanceId);
        return dataLimitRuleEo;
    }

    private String generateRuleCode(FieldLimitRuleCreateReqDto addReqDto) {
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)addReqDto.getIdentityIds()), (IExceptionEnum)DataLimitExceptionCode.DATA_LIMIT_RULE_ROLE_ID_IS_NULL);
        Long roleId = (Long)addReqDto.getIdentityIds().get(0);
        RoleDto roleDto = this.roleService.queryRoleByRoleId(roleId);
        AssertUtil.isTrue(null != roleDto, (IExceptionEnum)DataLimitExceptionCode.DATA_LIMIT_RULE_ROLE_NOT_EXISTS);
        return String.format("%s:%s", addReqDto.getRefAppInstId(), roleDto.getCode());
    }

    private void saveFieldLimitDetail(List<CustomFieldReqDto> customFields, Long ruleId) {
        List<FieldLimitDetailEo> list;
        ArrayList<FieldLimitDetailVo> voList = new ArrayList<FieldLimitDetailVo>();
        if (CollectionUtil.isNotEmpty(customFields)) {
            Map<String, String> validateResult = BeanValidatorUtil.validateList(customFields, new Class[0]);
            Assert.isTrue((boolean)CollectionUtil.isEmpty(validateResult), (String)JSON.toJSONString(validateResult));
            ArrayList vos = new ArrayList();
            CubeBeanUtils.copyCollection(vos, customFields, FieldLimitDetailVo.class);
            vos.forEach(commonField -> commonField.setFieldType(FieldTypeEnum.CUSTOM.getType()));
            voList.addAll(vos);
        }
        if (CollectionUtil.isNotEmpty(list = this.getDetailEos(voList, ruleId))) {
            this.fieldLimitDetailDas.insertBatch(list);
        }
    }

    private List<FieldLimitDetailEo> getDetailEos(List<FieldLimitDetailVo> voList, Long ruleId) {
        List<CommonFieldRespDto> commonFieldRespDtos = this.queryCommonField();
        Map<String, Integer> code2DesenRuleMap = commonFieldRespDtos.stream().filter(common -> DataLimitConstant.STATUS_DISABLE.equals(common.getStatus()) && LimitWayEnum.DESEN.getType().equals(common.getLimitWay())).collect(Collectors.toMap(CommonFieldRespDto::getCode, CommonFieldRespDto::getDesenRule, (s, a) -> s));
        List customDetailEos = null;
        if (CollectionUtil.isNotEmpty(voList)) {
            customDetailEos = voList.stream().map(vo -> {
                Integer desenRule = vo.getDesenRule();
                if (desenRule == null) {
                    desenRule = (Integer)code2DesenRuleMap.get(vo.getCode());
                }
                if (desenRule == null) {
                    desenRule = DesenRuleEnum.ASTERISK_REPLACE.getType();
                }
                vo.setDesenRule(desenRule);
                FieldLimitDetailEo detailEo = new FieldLimitDetailEo();
                detailEo.setRuleId(ruleId);
                detailEo.setExtension("");
                CubeBeanUtils.copyProperties((Object)detailEo, (Object)vo, (String[])new String[0]);
                return detailEo;
            }).collect(Collectors.toList());
        }
        return customDetailEos;
    }

    private void saveIdLink(List<Long> identityIds, String identityType, Long ruleId) {
        if (StringUtils.isEmpty((CharSequence)identityType)) {
            identityType = IdentityTypeEnum.ROLE.getCode();
        } else {
            Assert.notNull((Object)IdentityTypeEnum.getDescByCode((String)identityType), (String)"\u8eab\u4efd\u7c7b\u578b\u9519\u8bef\uff01");
        }
        if (CollectionUtil.isNotEmpty(identityIds)) {
            ArrayList idLinkEoList = Lists.newArrayList();
            for (Long identityId : identityIds) {
                DataLimitRuleIdlinkEo idLinkEo = new DataLimitRuleIdlinkEo();
                idLinkEo.setRuleId(ruleId);
                idLinkEo.setIdentityId(identityId);
                idLinkEo.setIdentityType(identityType);
                idLinkEo.setSceneCode("");
                idLinkEo.setExtension("");
                idLinkEoList.add(idLinkEo);
            }
            this.dataLimitRuleIdlinkDas.deleteByRuleId(ruleId, identityType);
            this.dataLimitRuleIdlinkDas.insertBatch((List)idLinkEoList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyFieldLimitRule(FieldLimitRuleModifyReqDto modifyReqDto) {
        Assert.notNull((Object)modifyReqDto.getRuleId(), (String)"\u89c4\u5219ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DataLimitRuleEo ruleEo = this.ruleParamCheck(modifyReqDto.getRuleId());
        if (StringUtils.isNotBlank((CharSequence)modifyReqDto.getRemark())) {
            ruleEo.setRemark(modifyReqDto.getRemark());
            this.dataLimitRuleDas.updateSelective((BaseEo)ruleEo);
        }
        this.saveIdLink(modifyReqDto.getIdentityIds(), modifyReqDto.getIdentityType(), modifyReqDto.getRuleId());
        this.fieldLimitDetailDas.deleteByRuleId(modifyReqDto.getRuleId());
        this.saveFieldLimitDetail(modifyReqDto.getCustomFields(), modifyReqDto.getRuleId());
    }

    private DataLimitRuleEo ruleParamCheck(Long ruleId) {
        DataLimitRuleEo ruleEo = (DataLimitRuleEo)this.dataLimitRuleDas.selectByPrimaryKey(ruleId);
        if (ruleEo == null) {
            throw new BizException(DataLimitExceptionCode.FIELD_LIMIT_RULE_NOT_EXIST.getCode(), DataLimitExceptionCode.FIELD_LIMIT_RULE_NOT_EXIST.getMsg());
        }
        return ruleEo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeFieldLimitRule(Long id) {
        this.dataLimitRuleDas.logicDeleteById(id);
        FieldLimitDetailEo detailEo = new FieldLimitDetailEo();
        detailEo.setRuleId(id);
        this.fieldLimitDetailDas.logicDeleteByExample((BaseEo)detailEo);
        DataLimitRuleIdlinkEo ruleIdlinkEo = new DataLimitRuleIdlinkEo();
        ruleIdlinkEo.setRuleId(id);
        this.dataLimitRuleIdlinkDas.logicDeleteByExample((BaseEo)ruleIdlinkEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logicDeleteFieldDetail(List<Long> ruleIdList) {
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        SqlFilter sqlFilter = new SqlFilter();
        sqlFilter.setProperty("rule_id");
        sqlFilter.setOperator(SqlFilter.Operator.in);
        sqlFilter.setValue(ruleIdList);
        sqlFilterList.add(sqlFilter);
        FieldLimitDetailEo fieldLimitDetailEo = new FieldLimitDetailEo();
        fieldLimitDetailEo.setSqlFilters(sqlFilterList);
        this.fieldLimitDetailDas.logicDeleteByExample((BaseEo)fieldLimitDetailEo);
    }

    @Override
    public FieldLimitRuleDetailRespDto queryById(FieldLimitRuleReqDto reqDto) {
        Assert.notNull((Object)reqDto.getId(), (String)"\u89c4\u5219ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DataLimitRuleEo ruleEo = this.ruleParamCheck(reqDto.getId());
        FieldLimitRuleDetailRespDto respDto = new FieldLimitRuleDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)ruleEo, (BaseVo)respDto);
        String identityType = StringUtils.isEmpty((CharSequence)reqDto.getIdentityType()) ? IdentityTypeEnum.ROLE.getCode() : reqDto.getIdentityType();
        respDto.setIdentityIds(this.dataLimitRuleIdlinkService.queryIdentityIdList(reqDto.getId(), identityType));
        List list = this.fieldLimitDetailDas.selectByRuleId(reqDto.getId());
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            List<FieldLimitDetailEo> customDetailEos;
            Map<Integer, List<FieldLimitDetailEo>> detailGroupByFieldTypeMap = list.stream().filter(a -> a.getFieldType() != null).collect(Collectors.groupingBy(StdFieldLimitDetailEo::getFieldType));
            List<FieldLimitDetailEo> commonDetailEos = detailGroupByFieldTypeMap.get(FieldTypeEnum.COMMON.getType());
            if (CollectionUtil.isNotEmpty(commonDetailEos)) {
                ArrayList commonFields = new ArrayList(commonDetailEos.size());
                CubeBeanUtils.copyCollection(commonFields, commonDetailEos, CommonFieldReqDto.class);
                respDto.setCommonFields(commonFields);
            }
            if (CollectionUtil.isNotEmpty(customDetailEos = detailGroupByFieldTypeMap.get(FieldTypeEnum.CUSTOM.getType()))) {
                ArrayList customFields = new ArrayList(customDetailEos.size());
                CubeBeanUtils.copyCollection(customFields, customDetailEos, CustomFieldReqDto.class);
                respDto.setCustomFields(customFields);
            }
        }
        return respDto;
    }

    @Override
    public PageInfo<FieldLimitRuleRespDto> queryByPage(FieldLimitRuleQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        Set ruleIdList = null;
        if (StringUtils.isNotBlank((CharSequence)reqDto.getIdentityIds())) {
            List<String> stringIds = Arrays.asList(reqDto.getIdentityIds().split(","));
            Set ids = stringIds.stream().map(Long::valueOf).collect(Collectors.toSet());
            List idLinkEoList = this.dataLimitRuleIdlinkDas.select(null, ids, IdentityTypeEnum.ROLE.getCode());
            if (CollectionUtils.isNotEmpty((Collection)idLinkEoList)) {
                ruleIdList = idLinkEoList.stream().map(StdDataLimitRuleIdlinkEo::getRuleId).collect(Collectors.toSet());
            } else {
                return null;
            }
        }
        DataLimitRuleEo dataLimitRuleEo = new DataLimitRuleEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)dataLimitRuleEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getName())) {
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + reqDto.getName() + "%")));
        }
        if (CollectionUtils.isNotEmpty(ruleIdList)) {
            dataLimitRuleEo.setId(null);
            sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ruleIdList, (String)",")));
        }
        dataLimitRuleEo.setSqlFilters(sqlFilters);
        dataLimitRuleEo.setOrderByDesc("update_time");
        dataLimitRuleEo.setRuleType(RuleTypeEnum.FIELD_LIMIT.getType());
        PageInfo eoPageInfo = this.dataLimitRuleDas.selectPage((BaseEo)dataLimitRuleEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, FieldLimitRuleRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<FieldLimitRuleDetailRespDto> queryFieldLimitDetailByPage(FieldLimitDetailReqDto reqDto, Integer pageNum, Integer pageSize) {
        FieldLimitDetailEo fieldLimitDetailEo = new FieldLimitDetailEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)fieldLimitDetailEo);
        PageInfo eoPageInfo = this.fieldLimitDetailDas.selectPage((BaseEo)fieldLimitDetailEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        return dtoPageInfo;
    }

    @Override
    public List<CommonFieldRespDto> queryCommonField() {
        ArrayList<CommonFieldRespDto> list = new ArrayList<CommonFieldRespDto>();
        if (this.commonFieldProperties != null && CollectionUtil.isNotEmpty(this.commonFieldProperties.getCommonFields())) {
            List<CommonFieldVo> commonFields = this.commonFieldProperties.getCommonFields();
            CubeBeanUtils.copyCollection(list, commonFields, CommonFieldRespDto.class);
        }
        return list;
    }

    @Override
    public List<AppInstanceAndRoleRespDto> queryAppInstanceAndRole(FieldLimitRuleReqDto queryReqDto) {
        Long tenantId = queryReqDto.getTenantId() == null ? ServiceContext.getContext().getRequestTenantId() : queryReqDto.getTenantId();
        Assert.isTrue((tenantId != null && tenantId != -1L ? 1 : 0) != 0, (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<Long> identityIdList = null;
        if (queryReqDto.getId() != null) {
            String identityType = StringUtils.isEmpty((CharSequence)queryReqDto.getIdentityType()) ? IdentityTypeEnum.ROLE.getCode() : queryReqDto.getIdentityType();
            identityIdList = this.dataLimitRuleIdlinkService.queryIdentityIdList(queryReqDto.getId(), identityType);
        }
        ArrayList respDtoList = Lists.newArrayList();
        List<RoleEo> roleEoList = this.roleService.queryByTenantId(tenantId);
        Map<Long, List<RoleEo>> instanceRoleMap = roleEoList.stream().collect(Collectors.groupingBy(BaseEo::getInstanceId));
        List<AppInstanceDto> appInstanceDtoList = this.applicationService.queryAppInstanceByTenantId(tenantId);
        for (AppInstanceDto appInstanceDto : appInstanceDtoList) {
            AppInstanceAndRoleRespDto respDto = new AppInstanceAndRoleRespDto();
            CubeBeanUtils.copyProperties((Object)respDto, (Object)appInstanceDto, (String[])new String[0]);
            List<RoleEo> roleEos = instanceRoleMap.get(appInstanceDto.getId());
            if (CollectionUtils.isNotEmpty(roleEos)) {
                ArrayList roleRespDtos = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)roleRespDtos, roleEos, AppInstanceAndRoleRespDto.RoleRespDto.class);
                for (AppInstanceAndRoleRespDto.RoleRespDto roleRespDto : roleRespDtos) {
                    roleRespDto.setSelectable(true);
                    if (!CollectionUtil.isNotEmpty(identityIdList) || !identityIdList.contains(roleRespDto.getId())) continue;
                    roleRespDto.setSelectable(false);
                }
                respDto.setRoles((List)roleRespDtos);
            }
            respDtoList.add(respDto);
        }
        return respDtoList;
    }

    @Override
    public PageInfo<RoleQueryRespDto> queryRoleByPage(RoleQueryReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        Long tenantId = queryReqDto.getTenantId() == null ? ServiceContext.getContext().getRequestTenantId() : queryReqDto.getTenantId();
        PageInfo dtoPageInfo = new PageInfo();
        List<Long> identityIdList = this.dataLimitRuleIdlinkService.queryIdentityIdList(queryReqDto.getRuleId(), IdentityTypeEnum.ROLE.getCode());
        HashSet<Long> ids = null;
        if (CollectionUtil.isNotEmpty(identityIdList)) {
            ids = new HashSet<Long>(identityIdList);
        }
        PageInfo<RoleQueryVo> voPageInfo = null;
        switch (queryReqDto.getStatus()) {
            case 0: {
                RoleEo roleEo = new RoleEo();
                roleEo.setName(queryReqDto.getRoleName());
                roleEo.setTenantId(tenantId);
                voPageInfo = this.roleService.queryRoleAndAppInstanceNotInIds(ids, roleEo, pageNum, pageSize);
                break;
            }
            case 1: {
                if (!CollectionUtil.isNotEmpty(ids)) break;
                voPageInfo = this.roleService.queryRoleAndAppInstanceByIds(ids, queryReqDto.getRoleName(), pageNum, pageSize);
            }
        }
        if (voPageInfo != null) {
            CubeBeanUtils.copyProperties((Object)dtoPageInfo, voPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList dtoList = new ArrayList();
            CubeBeanUtils.copyCollection(dtoList, (Collection)voPageInfo.getList(), RoleQueryRespDto.class);
            dtoPageInfo.setList(dtoList);
        }
        return dtoPageInfo;
    }

    @Override
    public UserFieldLimitRuleQueryRespDto queryUserFieldLimitRule(UserFieldLimitRuleQueryReqDto queryReqDto) {
        Set ruleIdList;
        List ruleEoList;
        Long userId = queryReqDto.getUserId() == null ? ServiceContext.getContext().getRequestUserId() : queryReqDto.getUserId();
        Assert.notNull((Object)userId, (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        UserFieldLimitRuleQueryRespDto respDto = new UserFieldLimitRuleQueryRespDto();
        UserRoleReqDto userRoleReqDto = new UserRoleReqDto();
        userRoleReqDto.setUserId(userId);
        Long instanceId = queryReqDto.getInstanceId() == null ? ServiceContext.getContext().getRequestInstanceId() : queryReqDto.getInstanceId();
        userRoleReqDto.setInstanceId(instanceId);
        List<UserRoleRespDto> userRoleRespDtoList = this.accessService.queryUserRole(userRoleReqDto);
        if (CollectionUtils.isEmpty(userRoleRespDtoList)) {
            return respDto;
        }
        Set roleIdList = userRoleRespDtoList.stream().filter(role -> RoleStatus.ACTIVE.equals(role.getStatus())).map(UserRoleRespDto::getRoleId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(roleIdList)) {
            return respDto;
        }
        List idlinkEoList = this.dataLimitRuleIdlinkDas.select(null, roleIdList, IdentityTypeEnum.ROLE.getCode());
        if (CollectionUtils.isNotEmpty((Collection)idlinkEoList) && CollectionUtils.isNotEmpty((Collection)(ruleEoList = this.dataLimitRuleDas.select(ruleIdList = idlinkEoList.stream().map(StdDataLimitRuleIdlinkEo::getRuleId).collect(Collectors.toSet()), null, RuleTypeEnum.FIELD_LIMIT.getType(), DataLimitConstant.STATUS_NORMAL)))) {
            Set ruleIds = ruleEoList.stream().map(BaseEo::getId).collect(Collectors.toSet());
            List list = this.fieldLimitDetailDas.selectByRuleIds(ruleIds, DataLimitConstant.STATUS_DISABLE);
            this.setField(respDto, list);
        }
        return respDto;
    }

    private void setField(UserFieldLimitRuleQueryRespDto respDto, List<FieldLimitDetailEo> list) {
        if (CollectionUtil.isNotEmpty(list)) {
            List<FieldLimitDetailEo> customDetailEos;
            Map<Integer, List<FieldLimitDetailEo>> detailGroupByFieldTypeMap = list.stream().filter(a -> a.getFieldType() != null).collect(Collectors.groupingBy(StdFieldLimitDetailEo::getFieldType));
            List<FieldLimitDetailEo> commonDetailEos = detailGroupByFieldTypeMap.get(FieldTypeEnum.COMMON.getType());
            if (CollectionUtil.isNotEmpty(commonDetailEos)) {
                Map<String, List<FieldLimitDetailEo>> detailGroupByCodeMap = commonDetailEos.stream().collect(Collectors.groupingBy(StdFieldLimitDetailEo::getCode));
                List<FieldLimitDetailEo> eos = this.getHandleDetailEos(detailGroupByCodeMap);
                ArrayList commonFields = new ArrayList(eos.size());
                CubeBeanUtils.copyCollection(commonFields, eos, CommonFieldReqDto.class);
                respDto.setCommonFields(commonFields);
            }
            if (CollectionUtil.isNotEmpty(customDetailEos = detailGroupByFieldTypeMap.get(FieldTypeEnum.CUSTOM.getType()))) {
                Map<String, List<FieldLimitDetailEo>> detailGroupByDomainCodeMap = customDetailEos.stream().collect(Collectors.groupingBy(k -> k.getDomainCode() + k.getEntityCode() + k.getCode()));
                List<FieldLimitDetailEo> eos = this.getHandleDetailEos(detailGroupByDomainCodeMap);
                ArrayList customFields = new ArrayList(eos.size());
                CubeBeanUtils.copyCollection(customFields, eos, CustomFieldReqDto.class);
                respDto.setCustomFields(customFields);
            }
        }
    }

    private List<FieldLimitDetailEo> getHandleDetailEos(Map<String, List<FieldLimitDetailEo>> detailGroupByCodeMap) {
        ArrayList<FieldLimitDetailEo> eos = new ArrayList<FieldLimitDetailEo>();
        detailGroupByCodeMap.forEach((key, value) -> {
            if (value.size() > 1) {
                FieldLimitDetailEo eo = (FieldLimitDetailEo)value.get(0);
                Set limitWaySet = value.stream().map(StdFieldLimitDetailEo::getLimitWay).collect(Collectors.toSet());
                if (limitWaySet.size() > 1 || limitWaySet.size() == 1 && LimitWayEnum.HIDDEN.getType().equals(limitWaySet.iterator().next())) {
                    eo.setLimitWay(LimitWayEnum.HIDDEN.getType());
                    eo.setDesenRule(null);
                } else {
                    Set desenRuleSet = value.stream().map(StdFieldLimitDetailEo::getDesenRule).collect(Collectors.toSet());
                    if (desenRuleSet.size() > 1) {
                        eo.setDesenRule(DesenRuleEnum.ASTERISK_REPLACE.getType());
                    }
                }
                eos.add(eo);
            } else {
                eos.addAll((Collection<FieldLimitDetailEo>)value);
            }
        });
        return eos;
    }

    @Override
    public void enabled(Long id) {
        DataLimitRuleEo eo = this.ruleParamCheck(id);
        if (!DataLimitConstant.STATUS_NORMAL.equals(eo.getStatus())) {
            eo.setStatus(DataLimitConstant.STATUS_NORMAL);
            this.dataLimitRuleDas.updateSelective((BaseEo)eo);
        }
    }

    @Override
    public void disabled(Long id) {
        DataLimitRuleEo eo = this.ruleParamCheck(id);
        if (!DataLimitConstant.STATUS_DISABLE.equals(eo.getStatus())) {
            eo.setStatus(DataLimitConstant.STATUS_DISABLE);
            this.dataLimitRuleDas.updateSelective((BaseEo)eo);
        }
    }

    @Override
    public void modifyRuleIdLink(RuleIdLinkReqDto reqDto) {
        String identityType;
        Assert.notNull((Object)reqDto.getRuleId(), (String)"\u89c4\u5219ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)reqDto.getIdentityId(), (String)"\u8eab\u4efdID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)reqDto.getStatus(), (String)"\u5173\u8054\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String string = identityType = StringUtils.isEmpty((CharSequence)reqDto.getIdentityType()) ? IdentityTypeEnum.ROLE.getCode() : reqDto.getIdentityType();
        if (DataLimitConstant.STATUS_DISABLE.equals(reqDto.getStatus())) {
            this.dataLimitRuleIdlinkDas.deleteByRuleId(reqDto.getRuleId(), identityType, reqDto.getIdentityId());
        } else {
            DataLimitRuleIdlinkEo idLinkEo = this.dataLimitRuleIdlinkDas.selectByRuleId(reqDto.getRuleId(), identityType, reqDto.getIdentityId());
            if (idLinkEo == null) {
                this.dataLimitRuleIdlinkDas.insert(reqDto.getRuleId(), identityType, reqDto.getIdentityId());
            }
        }
    }
}

