/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.meta.sql.biz.parser;

import com.dtyunxi.yundt.cube.center.meta.sql.biz.parser.DefaultSqlWhereParamsParser;
import com.dtyunxi.yundt.cube.center.meta.sql.biz.parser.InSqlWhereParamsParser;
import com.dtyunxi.yundt.cube.center.meta.sql.biz.parser.SqlWhereParamsParseItemResult;
import com.dtyunxi.yundt.cube.center.meta.sql.biz.parser.SqlWhereParamsParseResult;
import com.dtyunxi.yundt.cube.center.meta.sql.biz.parser.SqlWhereParamsParser;
import com.dtyunxi.yundt.cube.center.meta.sql.biz.parser.TimeSqlWhereParamsParser;
import com.dtyunxi.yundt.cube.center.meta.sql.biz.util.SqlStringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class DefaultSqlWhereParamsHandler {
    private static final String AND = "and";
    private static final String OR = "or";
    private static final String PLACE_HOLDER = "?";
    private String andKey = "$and";
    private String orKey = "$or";
    private String separatorFlag = "@";
    private List<SqlWhereParamsParser> sqlWhereParamsParsers = new ArrayList<SqlWhereParamsParser>();

    public DefaultSqlWhereParamsHandler() {
        this.sqlWhereParamsParsers.add(new DefaultSqlWhereParamsParser());
        this.sqlWhereParamsParsers.add(new InSqlWhereParamsParser());
        this.sqlWhereParamsParsers.add(new TimeSqlWhereParamsParser());
        this.sqlWhereParamsParsers.add(new TimeSqlWhereParamsParser("yyyy-MM-dd HH:mm:ss", "full_"));
    }

    public SqlWhereParamsParseResult getSqlWhereParamsResult(Map<String, Object> params) {
        return this.getSqlWhereParamsResultByAndOr(params, AND, true, new SqlWhereParamsParseResult());
    }

    public String getSqlWhereParams(Map<String, Object> params) {
        return this.getSqlWhereParamsResultByAndOr(params, AND, false, new SqlWhereParamsParseResult()).getBaseWhereSql().toString();
    }

    private SqlWhereParamsParseResult getSqlWhereParamsResultByAndOr(Map<String, Object> params, String andOr, boolean isPlaceHolder, SqlWhereParamsParseResult sqlWhereParamsParseResult) {
        if (params != null) {
            String andOrDelititer = " " + andOr + " ";
            for (String key : params.keySet()) {
                Object value;
                SqlWhereParamsParseItemResult sqlWhereParamsParseItemResult = this.processNormalSqlWhereParams(key, value = params.get(key), isPlaceHolder);
                if (sqlWhereParamsParseItemResult == null) continue;
                sqlWhereParamsParseResult.addSqlModel(andOrDelititer);
                sqlWhereParamsParseResult.addSqlModel(sqlWhereParamsParseItemResult.getSqlModel(isPlaceHolder, PLACE_HOLDER));
                sqlWhereParamsParseResult.addArgument(sqlWhereParamsParseItemResult.getValue());
            }
            StringBuilder baseWhereSql = sqlWhereParamsParseResult.getBaseWhereSql();
            if (StringUtils.isNotEmpty((CharSequence)baseWhereSql)) {
                sqlWhereParamsParseResult.setBaseWhereSql(new StringBuilder(baseWhereSql.substring(andOrDelititer.length())));
            }
        }
        return sqlWhereParamsParseResult;
    }

    private SqlWhereParamsParseResult processModelSqlWhereParams(Map<String, Object> params, String andOr, boolean isPlaceHolder) {
        return this.getSqlWhereParamsResultByAndOr(params, andOr, isPlaceHolder, new SqlWhereParamsParseResult());
    }

    private SqlWhereParamsParseItemResult processNormalSqlWhereParams(String key, Object value, boolean isPlaceHolder) {
        SqlWhereParamsParseItemResult sqlWhereParamsParseItemResult = null;
        String[] parts = key.split(this.separatorFlag);
        if (parts.length == 2) {
            for (SqlWhereParamsParser sqlWhereParamsParser : this.sqlWhereParamsParsers) {
                if (!sqlWhereParamsParser.support(parts[1])) continue;
                sqlWhereParamsParseItemResult = isPlaceHolder ? sqlWhereParamsParser.getPlaceHolderParamsResult(parts[0], value, parts[1]) : sqlWhereParamsParser.getParamsResult(parts[0], value, parts[1]);
                break;
            }
        } else {
            Object tmpValue = value;
            if (!isPlaceHolder) {
                tmpValue = SqlStringUtils.processString(value);
            }
            sqlWhereParamsParseItemResult = new SqlWhereParamsParseItemResult(key, "=", tmpValue);
        }
        return sqlWhereParamsParseItemResult;
    }

    public void setSeparatorFlag(String separatorFlag) {
        this.separatorFlag = separatorFlag;
    }

    public void registerSqlParamsParser(SqlWhereParamsParser sqlWhereParamsParser) {
        if (sqlWhereParamsParser != null) {
            this.sqlWhereParamsParsers.add(sqlWhereParamsParser);
        }
    }

    public void registerSqlParamsParser(List<SqlWhereParamsParser> sqlWhereParamsParsers) {
        if (sqlWhereParamsParsers != null) {
            for (SqlWhereParamsParser sqlWhereParamsParser : sqlWhereParamsParsers) {
                this.registerSqlParamsParser(sqlWhereParamsParser);
            }
        }
    }

    public void setAndKey(String andKey) {
        this.andKey = andKey;
    }

    public void setOrKey(String orKey) {
        this.orKey = orKey;
    }

    public String getAndKey() {
        return this.andKey;
    }

    public String getOrKey() {
        return this.orKey;
    }
}

