/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.TokenUtil;
import com.dtyunxi.yundt.cube.center.user.api.query.IAccessQueryApi;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class UserAuthInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(UserAuthInterceptor.class);
    private static final String resp_Result = "{\"resultCode\":403,\"resultMsg\":\"not allowed\"}";
    private static final ObjectMapper om = new ObjectMapper();
    @Autowired
    private IAccessQueryApi accessApi;

    public boolean preHandle(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Object handler) throws Exception {
        String uri = httpRequest.getRequestURI().replace(httpRequest.getContextPath(), "");
        String token = httpRequest.getHeader("Access-Token");
        String appKey = httpRequest.getHeader("Application-Key");
        Long instanceId = null;
        Long tenantId = null;
        String example = httpRequest.getParameter("example");
        String filter = httpRequest.getParameter("filter");
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            JSONObject jsonObject = JSON.parseObject((String)filter);
            instanceId = jsonObject.getLong("instanceId");
            tenantId = jsonObject.getLong("tenantId");
        }
        HashMap<String, String> query = new HashMap<String, String>();
        Long userId = (Long)TokenUtil.parse((String)token).get("userId");
        query.put("routePath", uri);
        ServiceContext.getContext().set("tenantId", (Object)tenantId);
        ServiceContext.getContext().set("instanceId", (Object)instanceId);
        Integer access = (Integer)this.accessApi.queryPermissions(instanceId, userId, example, om.writeValueAsString(query)).getData();
        if (access > 0) {
            logger.debug("\u8be5url\uff1a{} \uff0c\u6388\u6743\u901a\u8fc7 \uff0c\u5e94\u7528ID:{}\uff0c\u7528\u6237ID:{} ", new Object[]{uri, appKey, userId});
            return true;
        }
        logger.info("\u975e\u6cd5\u8bbf\u95ee\uff0c\u7528\u6237ID\uff1a{},\u5e94\u7528ID:{},url:{}", new Object[]{userId, appKey, uri});
        httpResponse.setStatus(403);
        PrintWriter out = httpResponse.getWriter();
        out.append(resp_Result);
        out.close();
        return false;
    }
}

