/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.partner.wechat.service.impl;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.user.api.partner.wechat.dto.request.WxaCodeUnlimitReqDto;
import com.dtyunxi.yundt.cube.center.user.biz.partner.wechat.config.WechatConfig;
import com.dtyunxi.yundt.cube.center.user.biz.partner.wechat.config.WechatIdenInfoDto;
import com.dtyunxi.yundt.cube.center.user.biz.partner.wechat.service.IWechatClientService;
import com.dtyunxi.yundt.cube.center.user.biz.partner.wechat.utils.WechatUtil;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatClientServiceImpl
implements IWechatClientService {
    private static final Logger logger = LoggerFactory.getLogger(WechatClientServiceImpl.class);
    @Autowired
    private ICacheService cacheService;
    @Autowired
    private WechatConfig wechatConfig;

    @Override
    public String getAccessToken(String appName) {
        WechatIdenInfoDto wechatIdenInfoDto = this.wechatConfig.getWechatIdenInfoDtoByAppName(appName);
        AssertUtil.isTrue(null != wechatIdenInfoDto, "\u6ca1\u6709\u5339\u914d\u7684\u5fae\u4fe1appId\u3001appSecret\uff0c\u8bf7\u68c0\u67e5appName\uff1a" + appName);
        String redisKey = "wechat_accesstoken_redis_key_" + wechatIdenInfoDto.getAppId();
        String accessToken = (String)this.cacheService.getCache(redisKey, String.class);
        if (StringUtils.isBlank((String)accessToken)) {
            accessToken = WechatUtil.getAccessToken(wechatIdenInfoDto.getAppId(), wechatIdenInfoDto.getAppSecret());
            boolean flag = this.cacheService.add(redisKey, (Object)accessToken, 5400);
            AssertUtil.isTrue(flag, "\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u7b495\u79d2\u518d\u8bd5\u8bd5");
        }
        return accessToken;
    }

    @Override
    public String getWxaCodeUnlimit(String appName, WxaCodeUnlimitReqDto wxaCodeUnlimitReqDto) {
        return WechatUtil.getWxaCodeUnlimit(this.getAccessToken(appName), wxaCodeUnlimitReqDto);
    }
}

