/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.starter.api.auth.ApiValidateDto;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.constant.ApiNeedAuthoredEnum;
import com.dtyunxi.yundt.cube.center.user.api.dto.ResourceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ApiBindReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ApiReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.ApiQueryRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserAccessRespDto;
import com.dtyunxi.yundt.cube.center.user.biz.service.IAccessService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IApiService;
import com.dtyunxi.yundt.cube.center.user.dao.das.ApiDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.ResourceApiRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.ApiEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.ResourceApiRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdResourceApiRelationEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiServiceImpl
implements IApiService {
    @Autowired
    private ApiDas apiDas;
    @Autowired
    private ResourceApiRelationDas resourceApiRelationDas;
    @Autowired
    private IAccessService accessService;

    @Override
    public Long add(ApiReqDto reqDto) {
        ApiEo eo = new ApiEo();
        eo.setModule(reqDto.getModule());
        eo.setPath(reqDto.getPath());
        eo.setMethod(reqDto.getMethod());
        if (this.apiDas.count((BaseEo)eo) > 0) {
            throw new BusinessRuntimeException("11001", "API\u91cd\u590d");
        }
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)eo);
        this.apiDas.insert((BaseEo)eo);
        return eo.getId();
    }

    @Override
    public void modify(Long id, ApiReqDto reqDto) {
        ApiEo eo = new ApiEo();
        eo.setId(id);
        if (this.apiDas.count((BaseEo)eo) < 1) {
            throw new BusinessRuntimeException("11002", "API\u4e0d\u5b58\u5728");
        }
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)eo);
        this.apiDas.updateSelective((BaseEo)eo);
    }

    @Override
    public void remove(Long id) {
        ApiEo eo = (ApiEo)this.apiDas.selectByPrimaryKey(id);
        if (eo == null) {
            throw new BusinessRuntimeException("11002", "API\u4e0d\u5b58\u5728");
        }
        ResourceApiRelationEo relationEo = new ResourceApiRelationEo();
        relationEo.setApiId(id);
        List list = this.resourceApiRelationDas.select((BaseEo)relationEo);
        if (list != null && !list.isEmpty()) {
            throw new BusinessRuntimeException("10001", "\u8bf7\u5148\u89e3\u7ed1API\u8d44\u6e90");
        }
        this.apiDas.logicDelete((BaseEo)eo);
    }

    @Override
    public void bindResource(ApiBindReqDto bindReqDto) {
        ResourceApiRelationEo relationEo = new ResourceApiRelationEo();
        relationEo.setResourceCode(bindReqDto.getResourceCode());
        relationEo.setApiId(bindReqDto.getApiId());
        List list = this.resourceApiRelationDas.select((BaseEo)relationEo);
        if (list != null && !list.isEmpty()) {
            throw new BusinessRuntimeException("11001", "API\u5df2\u7ed1\u5b9a\u8be5\u8d44\u6e90");
        }
        this.resourceApiRelationDas.insert((BaseEo)relationEo);
    }

    @Override
    public void unbindResource(ApiBindReqDto bindReqDto) {
        ResourceApiRelationEo relationEo = new ResourceApiRelationEo();
        relationEo.setResourceCode(bindReqDto.getResourceCode());
        relationEo.setApiId(bindReqDto.getApiId());
        relationEo = (ResourceApiRelationEo)this.resourceApiRelationDas.selectOne((BaseEo)relationEo);
        if (relationEo != null) {
            this.resourceApiRelationDas.delete((BaseEo)relationEo);
        }
    }

    @Override
    public ApiQueryRespDto queryById(Long id) {
        ApiEo eo = new ApiEo();
        eo.setId(id);
        eo = (ApiEo)this.apiDas.selectOne((BaseEo)eo);
        if (eo == null) {
            throw new BusinessRuntimeException("11002", "API\u4e0d\u5b58\u5728");
        }
        ApiQueryRespDto dto = new ApiQueryRespDto();
        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
        return dto;
    }

    @Override
    public PageInfo<ApiQueryRespDto> queryByPage(ApiReqDto reqDto, Integer pageNum, Integer pageSize) {
        ApiEo eo = new ApiEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)eo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)reqDto.getApiName())) {
            sqlFilters.add(SqlFilter.like((String)"apiName", (Object)("%" + reqDto.getApiName() + "%")));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getResourceCodes())) {
            List<Long> apiIds = Arrays.asList(new Long[0]);
            ResourceApiRelationEo relationEo = new ResourceApiRelationEo();
            ArrayList<SqlFilter> relationFilters = new ArrayList<SqlFilter>();
            relationFilters.add(SqlFilter.in((String)"resourceCode", (Object)reqDto.getResourceCodes()));
            relationEo.setSqlFilters(relationFilters);
            List relationList = this.resourceApiRelationDas.select((BaseEo)relationEo, Integer.valueOf(0), Integer.valueOf(1000));
            apiIds = relationList.stream().map(StdResourceApiRelationEo::getApiId).collect(Collectors.toList());
            sqlFilters.add(SqlFilter.in((String)"id", apiIds));
        }
        eo.setSqlFilters(sqlFilters);
        PageInfo eoPageInfo = this.apiDas.selectPage((BaseEo)eo, pageNum, pageSize);
        ArrayList dtoList = new ArrayList();
        PageInfo dtoPageInfo = new PageInfo(dtoList);
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ApiQueryRespDto.class);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        return dtoPageInfo;
    }

    @Override
    public Boolean validate(ApiValidateDto validateDto) {
        Set matchSet;
        ApiEo eo = new ApiEo();
        eo.setModule(validateDto.getModule());
        eo.setPath(validateDto.getPath());
        eo.setMethod(validateDto.getMethod());
        List list = this.apiDas.select((BaseEo)eo);
        if (list == null || list.isEmpty()) {
            return true;
        }
        if (validateDto.getUserId() == null) {
            return false;
        }
        eo = (ApiEo)list.get(0);
        if (ApiNeedAuthoredEnum.N.equals(eo.getNeedAuthored())) {
            return true;
        }
        Long instanceId = ServiceContext.getContext().getRequestInstanceId();
        UserAccessRespDto userAccessRespDto = this.accessService.queryUserAccessResources(instanceId, validateDto.getUserId(), "");
        if (CollectionUtils.isEmpty((Collection)userAccessRespDto.getMenus()) && CollectionUtils.isEmpty((Collection)userAccessRespDto.getButtons())) {
            return false;
        }
        Set menuCodes = userAccessRespDto.getMenus().stream().map(ResourceDto::getCode).collect(Collectors.toSet());
        Set buttonCodes = userAccessRespDto.getButtons().stream().map(ResourceDto::getCode).collect(Collectors.toSet());
        HashSet resourceCodes = Sets.newHashSet();
        resourceCodes.addAll(menuCodes);
        resourceCodes.addAll(buttonCodes);
        if (CollectionUtils.isEmpty((Collection)resourceCodes)) {
            return false;
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"resourceCode", (Object)resourceCodes));
        ResourceApiRelationEo relationEo = new ResourceApiRelationEo();
        relationEo.setSqlFilters(sqlFilters);
        List relationEos = this.resourceApiRelationDas.select((BaseEo)relationEo);
        HashSet apiSet = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty((Collection)relationEos)) {
            Set ids = relationEos.stream().map(StdResourceApiRelationEo::getApiId).collect(Collectors.toSet());
            List apiEos = this.apiDas.selectByIds(ids);
            apiSet.addAll(apiEos);
        }
        if (CollectionUtils.isNotEmpty(matchSet = apiSet.stream().filter(a -> a.getModule().equals(validateDto.getModule()) && a.getPath().equals(validateDto.getPath()) && a.getMethod().equals(validateDto.getMethod())).collect(Collectors.toSet()))) {
            return true;
        }
        return false;
    }
}

