/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.PersonalInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.PersonalInfoExtDto;
import com.dtyunxi.yundt.cube.center.user.biz.condition.Criteria;
import com.dtyunxi.yundt.cube.center.user.biz.service.IBizPersonalInfoService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.util.QueryUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.PersonalInfoDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.PersonalInfoEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="bizPersonalInfoService")
public class BizPersonalInfoServiceImpl
implements IBizPersonalInfoService {
    @Resource
    private PersonalInfoDas personalInfoDas;

    @Override
    public Long addPersonalInfo(PersonalInfoExtDto personInfoExtDto) {
        AssertUtil.isTrue(personInfoExtDto != null, "\u53c2\u6570\u5f02\u5e38\uff01");
        PersonalInfoEo personalInfoEo = new PersonalInfoEo();
        DtoHelper.dto2Eo((BaseVo)personInfoExtDto, (BaseEo)personalInfoEo);
        this.personalInfoDas.insert((BaseEo)personalInfoEo);
        return personalInfoEo.getId();
    }

    @Override
    public void updatePersonalInfo(Long id, PersonalInfoExtDto personalInfoExtDto) {
        AssertUtil.isTrue(id != null, "id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtil.isTrue(this.personalInfoDas.selectByPrimaryKey(id) != null, "\u4e2a\u4eba\u4fe1\u606f\u4e0d\u5b58\u5728");
        PersonalInfoEo personalInfoEo = new PersonalInfoEo();
        DtoHelper.dto2Eo((BaseVo)personalInfoExtDto, (BaseEo)personalInfoEo);
        personalInfoEo.setId(id);
        this.personalInfoDas.update((BaseEo)personalInfoEo);
    }

    @Override
    public PersonalInfoExtDto queryByid(Long id, String filter) {
        AssertUtil.isTrue(id != null, "id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        PersonalInfoEo personalInfoEo = StringUtils.isNotBlank((CharSequence)filter) ? (PersonalInfoEo)JSON.parseObject((String)filter, PersonalInfoEo.class) : new PersonalInfoEo();
        personalInfoEo.setId(id);
        personalInfoEo = (PersonalInfoEo)this.personalInfoDas.selectOne((BaseEo)personalInfoEo);
        if (personalInfoEo != null) {
            PersonalInfoExtDto personalInfoExtDto = new PersonalInfoExtDto();
            DtoHelper.eo2Dto((BaseEo)personalInfoEo, (BaseVo)personalInfoExtDto);
            return personalInfoExtDto;
        }
        return null;
    }

    @Override
    public PageInfo<PersonalInfoExtDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        AssertUtil.isTrue(pageNum > 0, "\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
        AssertUtil.isTrue(pageSize >= 0, "\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
        Criteria criteria = (Criteria)ObjectHelper.Json2Bean((String)filter, Criteria.class);
        PersonalInfoEo personalInfoEo = new PersonalInfoEo();
        personalInfoEo.setSqlFilters(criteria.getFilters());
        personalInfoEo.setOrderBy(criteria.getOrderBy());
        personalInfoEo.setOrderByDesc(criteria.getOrderByDesc());
        PageInfo eoPageInfo = this.personalInfoDas.selectPage((BaseEo)personalInfoEo, pageNum, pageSize);
        PageInfo<PersonalInfoExtDto> dtoPageInfo = QueryUtil.eoPage2DtoPage((PageInfo<? extends BaseEo>)eoPageInfo, PersonalInfoExtDto.class);
        return dtoPageInfo;
    }

    @Override
    public PersonalInfoExtDto queryBySourceUid(Long sourceUid, String filter) {
        AssertUtil.isTrue(sourceUid != null, "sourceUid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        PersonalInfoEo personalInfoEo = StringUtils.isNotBlank((CharSequence)filter) ? (PersonalInfoEo)JSON.parseObject((String)filter, PersonalInfoEo.class) : new PersonalInfoEo();
        personalInfoEo.setSourceUid(sourceUid);
        personalInfoEo = (PersonalInfoEo)this.personalInfoDas.selectOne((BaseEo)personalInfoEo);
        if (personalInfoEo != null) {
            PersonalInfoExtDto personalInfoExtDto = new PersonalInfoExtDto();
            DtoHelper.eo2Dto((BaseEo)personalInfoEo, (BaseVo)personalInfoExtDto);
            return personalInfoExtDto;
        }
        return null;
    }

    @Override
    public List<PersonalInfoExtDto> queryByids(List<Long> ids, String filter) {
        AssertUtil.isTrue(!ids.isEmpty(), "id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        PersonalInfoEo personalInfoEo = StringUtils.isNotBlank((CharSequence)filter) ? (PersonalInfoEo)JSON.parseObject((String)filter, PersonalInfoEo.class) : new PersonalInfoEo();
        ArrayList eoList = Lists.newArrayList();
        for (Long id : ids) {
            personalInfoEo.setId(id);
            PersonalInfoEo eo = (PersonalInfoEo)this.personalInfoDas.selectOne((BaseEo)personalInfoEo);
            if (eo == null) continue;
            PersonalInfoExtDto personalInfoExtDto = new PersonalInfoExtDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)personalInfoExtDto);
            eoList.add(personalInfoExtDto);
        }
        return eoList;
    }

    @Override
    public PersonalInfoDto queryByPosition(String position) {
        if (StringUtils.isBlank((CharSequence)position)) {
            return null;
        }
        PersonalInfoEo ex = new PersonalInfoEo();
        ex.setPosition(position);
        PersonalInfoEo personalInfoEo = (PersonalInfoEo)this.personalInfoDas.selectOne((BaseEo)ex);
        if (null == personalInfoEo) {
            return null;
        }
        PersonalInfoDto personalInfoDto = new PersonalInfoDto();
        DtoHelper.eo2Dto((BaseEo)personalInfoEo, (BaseVo)personalInfoDto);
        return personalInfoDto;
    }
}

