/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.UserAccessVo;
import com.dtyunxi.yundt.cube.center.user.biz.service.IAccessService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IBizUserService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.LoginConfigDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.PersonalInfoDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.LoginConfigEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizUserServiceImpl
implements IBizUserService {
    @Resource
    private UserDas userDas;
    @Resource
    private LoginConfigDas loginConfigDas;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IAccessService accessService;
    @Resource
    private PersonalInfoDas personalInfoDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(Long userId) {
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(null != userEo, "\u7528\u6237\u4e0d\u5b58\u5728");
        userEo.setDr(1);
        userEo.setStatus(Integer.valueOf(2));
        this.cacheService.delCache(userEo.getUserNameUniValue());
        this.cacheService.delCache(userEo.getPhoneUniValue());
        this.cacheService.delCache(userEo.getEmailUniValue());
        userEo.setUserNameUniValue((String)null);
        userEo.setPhoneUniValue((String)null);
        userEo.setEmailUniValue((String)null);
        this.userDas.update((BaseEo)userEo);
        this.userDas.logicDeleteById(userEo.getId());
        LoginConfigEo loginConfigEo = new LoginConfigEo();
        loginConfigEo.setOwnerId(userId);
        this.loginConfigDas.logicDeleteByExample((BaseEo)loginConfigEo);
        if (null != userEo.getPersonId()) {
            this.personalInfoDas.logicDeleteById(userEo.getPersonId());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateFlag(Long appInstanceId, Long userId) {
        UserAccessVo userAccessVo = this.accessService.queryUserAccess(appInstanceId, userId);
        Integer isRoleDistribute = 0;
        if (CollectionUtils.isNotEmpty((Collection)userAccessVo.getRoleSet())) {
            isRoleDistribute = 1;
        }
        UserEo ex = new UserEo();
        ex.setId(userId);
        ex.setIsRoleDistribute(isRoleDistribute);
        this.userDas.updateSelective((BaseEo)ex);
        this.userDas.updateSelective((BaseEo)ex);
    }
}

