/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.datalimit.aop.DataLimitAspect;
import com.dtyunxi.yundt.cube.center.user.api.dto.AccessDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppInstanceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleAccessDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleListDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.request.RoleCreateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.request.RoleModifyDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.response.ApplicationAndRelatedRolesRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.response.RoleDetailAndAccessRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.response.RoleRelateDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleAccessCreateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleAccessModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.biz.constant.RelateStatus;
import com.dtyunxi.yundt.cube.center.user.biz.constant.RoleStatus;
import com.dtyunxi.yundt.cube.center.user.biz.service.IAccessService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IApplicationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IBizAccessService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IBocAccessService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IRoleService;
import com.dtyunxi.yundt.cube.center.user.biz.utils.DataConverter;
import com.dtyunxi.yundt.cube.center.user.dao.das.RoleDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RoleEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BocAccessServiceImpl
implements IBocAccessService {
    @Resource
    private IApplicationService applicationService;
    @Resource
    private IRoleService roleService;
    @Resource
    private IBizAccessService bizAccessService;
    @Resource
    private IAccessService accessService;
    @Resource
    private RoleDas roleDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void giveUserRoles(Long instanceId, Long roleId, List<Long> userIdList) {
        ArrayList roleIdList = Lists.newArrayList();
        roleIdList.add(roleId);
        if (CollectionUtils.isNotEmpty(userIdList)) {
            for (Long userId : userIdList) {
                this.accessService.giveUserRole(instanceId, userId, roleIdList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long createRoleAndGiveResource(RoleCreateReqDto roleCreateReqDto, Long instanceId) {
        RoleAccessCreateReqDto createReqDto = new RoleAccessCreateReqDto();
        CubeBeanUtils.copyProperties((Object)createReqDto, (Object)roleCreateReqDto.getRoleDto(), (String[])new String[0]);
        createReqDto.setStatus(RoleStatus.ACTIVE);
        RoleDto newRole = this.roleService.create(instanceId, createReqDto);
        List roleAccessList = roleCreateReqDto.getRoleAccessDtoList();
        for (RoleAccessDto roleAccessDto : roleAccessList) {
            roleAccessDto.setRoleId(newRole.getId());
            if (!CollectionUtils.isNotEmpty((Collection)roleAccessDto.getAccessSet())) continue;
            Set accessSet = roleAccessDto.getAccessSet();
            for (AccessDto accessDto : accessSet) {
                accessDto.setPermissions(Integer.valueOf(15));
            }
        }
        this.accessService.giveRoleResource(instanceId, roleAccessList);
        return newRole.getId();
    }

    @Override
    public List<ApplicationAndRelatedRolesRespDto> queryAppsAndRoles(Long instanceId, Long userId) {
        AppInstanceDto appInstanceDto = this.applicationService.queryInstanceOne(instanceId);
        Set relateRoles = null;
        if (userId != null) {
            relateRoles = this.accessService.queryUserAccess(instanceId, userId).getRoleSet();
        }
        List roleListDtoList = this.getNormalRoleListDtoPageInfo(instanceId, 1, 50).getList();
        ArrayList<RoleRelateDto> roleRelateDtoList = new ArrayList<RoleRelateDto>();
        CubeBeanUtils.copyCollection(roleRelateDtoList, (Collection)roleListDtoList, RoleRelateDto.class);
        return this.getApplicationAndRelatedRolesRespDtos(relateRoles, appInstanceDto, roleRelateDtoList);
    }

    @Override
    public PageInfo<ApplicationAndRelatedRolesRespDto> queryAppsAndRolesByPage(Long instanceId, Long userId, Integer pageNum, Integer pageSize) {
        Set relateRoles = null;
        if (userId != null) {
            relateRoles = this.accessService.queryUserAccess(instanceId, userId).getRoleSet();
        }
        AppInstanceDto appInstanceDto = this.applicationService.queryInstanceOne(instanceId);
        PageInfo<RoleListDto> roleListDtoPage = this.getNormalRoleListDtoPageInfo(instanceId, pageNum, pageSize);
        ArrayList<RoleRelateDto> roleRelateDtoList = new ArrayList<RoleRelateDto>();
        CubeBeanUtils.copyCollection(roleRelateDtoList, (Collection)roleListDtoPage.getList(), RoleRelateDto.class);
        List<ApplicationAndRelatedRolesRespDto> applicationAndRelatedRolesRespDtoList = this.getApplicationAndRelatedRolesRespDtos(relateRoles, appInstanceDto, roleRelateDtoList);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, roleListDtoPage, (String[])new String[]{"list", "navigatepageNums"});
        dtoPageInfo.setList(applicationAndRelatedRolesRespDtoList);
        return dtoPageInfo;
    }

    private PageInfo<RoleListDto> getNormalRoleListDtoPageInfo(Long instanceId, Integer pageNum, Integer pageSize) {
        RoleEo roleEo = new RoleEo();
        roleEo.setInstanceId(instanceId);
        roleEo.setStatus(Integer.valueOf(1));
        PageInfo roleEoPageInfo = this.roleDas.selectPage((BaseEo)roleEo, pageNum, pageSize);
        return DataConverter.buildConverter().convertPageData(roleEoPageInfo, RoleListDto.class);
    }

    private List<ApplicationAndRelatedRolesRespDto> getApplicationAndRelatedRolesRespDtos(Set<RoleDto> relateRoles, AppInstanceDto appInstanceDto, List<RoleRelateDto> roleRelateDtoList) {
        ApplicationAndRelatedRolesRespDto applicationAndRelatedRolesRespDto = new ApplicationAndRelatedRolesRespDto();
        ArrayList<ApplicationAndRelatedRolesRespDto> applicationAndRelatedRolesRespDtoList = new ArrayList<ApplicationAndRelatedRolesRespDto>();
        block0: for (RoleRelateDto roleRelateDto : roleRelateDtoList) {
            if (CollectionUtils.isNotEmpty(relateRoles)) {
                for (RoleDto roleDto : relateRoles) {
                    if (roleRelateDto.getId().equals(roleDto.getId())) {
                        roleRelateDto.setIsRelateUser(RelateStatus.IS_RELATE);
                        continue block0;
                    }
                    roleRelateDto.setIsRelateUser(RelateStatus.NOT_RELATE);
                }
                continue;
            }
            roleRelateDto.setIsRelateUser(RelateStatus.NOT_RELATE);
        }
        applicationAndRelatedRolesRespDto.setRoleRelateDto(roleRelateDtoList);
        applicationAndRelatedRolesRespDto.setAppInstanceDto(appInstanceDto);
        applicationAndRelatedRolesRespDtoList.add(applicationAndRelatedRolesRespDto);
        return applicationAndRelatedRolesRespDtoList;
    }

    @Override
    public RoleDetailAndAccessRespDto queryById(Long roleId) {
        DataLimitAspect.skipAllTable();
        RoleAccessDto roleAccessDto = this.roleService.queryById(roleId);
        RoleDto roleDto = this.roleService.queryRoleByRoleId(roleId);
        RoleDetailAndAccessRespDto roleDetailAndAccessRespDto = new RoleDetailAndAccessRespDto();
        roleDetailAndAccessRespDto.setRoleAccessDto(roleAccessDto);
        roleDetailAndAccessRespDto.setRoleDto(roleDto);
        DataLimitAspect.cleanSkipTable();
        return roleDetailAndAccessRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyRoleAndAddResource(Long roleId, RoleModifyDto roleModifyDto) {
        RoleDto roleDto = roleModifyDto.getRoleDto();
        RoleAccessModifyReqDto ramqDto = new RoleAccessModifyReqDto();
        CubeBeanUtils.copyProperties((Object)ramqDto, (Object)roleDto, (String[])new String[0]);
        this.roleService.update(roleId, ramqDto);
        List roleAccessList = roleModifyDto.getRoleAccessDtoList();
        if (CollectionUtils.isNotEmpty((Collection)roleAccessList)) {
            for (RoleAccessDto roleAccessDto : roleAccessList) {
                roleAccessDto.setRoleId(roleId);
                roleAccessDto.setCode(roleDto.getCode());
                if (!CollectionUtils.isNotEmpty((Collection)roleAccessDto.getAccessSet())) continue;
                Set accessSet = roleAccessDto.getAccessSet();
                for (AccessDto accessDto : accessSet) {
                    accessDto.setPermissions(Integer.valueOf(15));
                }
            }
            this.accessService.updateRoleResources(roleDto.getInstanceId(), roleAccessList);
        }
    }
}

