/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.ChartDefinitionDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ChartDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.ChartDefinitionVo;
import com.dtyunxi.yundt.cube.center.user.biz.service.IChartDefinitionService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.util.QueryUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.ChartDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.ChartDefinitionDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserRoleRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.ChartDefinitionEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.ChartEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserRoleRelationEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChartDefinitionServiceImpl
implements IChartDefinitionService {
    @Autowired
    ChartDefinitionDas chartDefinitionDas;
    @Autowired
    ChartDas chartDas;
    @Autowired
    IUserService userService;
    @Autowired
    UserRoleRelationDas userRoleRelationDas;

    @Override
    public List<ChartDto> queryAllCharts() {
        List chartEos = this.chartDas.queryAllChartsType();
        if (chartEos.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ChartDto> result = new ArrayList<ChartDto>();
        DtoHelper.eoList2DtoList((Collection)chartEos, result, ChartDto.class);
        return result;
    }

    @Override
    public List<ChartDefinitionVo> queryChartDefinitions(Long userId) {
        List chartDefinitionEos;
        if (this.isTenantAdmin(userId)) {
            chartDefinitionEos = this.chartDefinitionDas.selectAll();
        } else {
            List<Long> appIds = this.userService.queryUserAuthInstanceList(userId);
            if (appIds.isEmpty()) {
                return Collections.emptyList();
            }
            chartDefinitionEos = this.chartDefinitionDas.queryChartDefinitionsByWebInstance(appIds);
        }
        return chartDefinitionEos.stream().map(chartDefinitionEo -> {
            ChartDefinitionVo chartDefinitionVo = new ChartDefinitionVo();
            DtoHelper.eo2Dto((BaseEo)chartDefinitionEo, (BaseVo)chartDefinitionVo);
            String code = chartDefinitionEo.getChartCode();
            ChartEo chartEo = new ChartEo();
            chartEo.setCode(code);
            chartEo = (ChartEo)this.chartDas.selectOne((BaseEo)chartEo);
            ChartDto chartDto = new ChartDto();
            DtoHelper.eo2Dto((BaseEo)chartEo, (BaseVo)chartDto);
            chartDefinitionVo.setChartDto(chartDto);
            return chartDefinitionVo;
        }).collect(Collectors.toList());
    }

    @Override
    public void insertChartDefinition(ChartDefinitionDto chartDefinitionDto) {
        AssertUtil.isTrue(chartDefinitionDto != null, "\u53c2\u6570\u5f02\u5e38\uff01");
        ChartDefinitionEo chartDefinitionEo = new ChartDefinitionEo();
        DtoHelper.dto2Eo((BaseVo)chartDefinitionDto, (BaseEo)chartDefinitionEo);
        this.chartDefinitionDas.insert((BaseEo)chartDefinitionEo);
    }

    @Override
    public void updateChartDefinition(Long id, ChartDefinitionDto chartDefinitionDto) {
        AssertUtil.isTrue(id != null, "id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtil.isTrue(this.chartDefinitionDas.selectByPrimaryKey(id) != null, "\u62a5\u8868\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728");
        ChartDefinitionEo eo = new ChartDefinitionEo();
        DtoHelper.dto2Eo((BaseVo)chartDefinitionDto, (BaseEo)eo);
        eo.setId(id);
        this.chartDefinitionDas.update((BaseEo)eo);
    }

    @Override
    public void deleteChartDefinition(Long id) {
        AssertUtil.isTrue(id != null, "id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.chartDefinitionDas.deleteById(id);
    }

    @Override
    public PageInfo<ChartDto> queryChartPage(String type, Integer pageNum, Integer pageSize) {
        ChartEo chartEo = new ChartEo();
        PageInfo chartEoPageInfo = this.chartDas.selectPage((BaseEo)chartEo, pageNum, pageSize);
        return QueryUtil.eoPage2DtoPage((PageInfo<? extends BaseEo>)chartEoPageInfo, ChartDto.class);
    }

    private boolean isTenantAdmin(Long userId) {
        UserRoleRelationEo userRoleRelationEo = new UserRoleRelationEo();
        userRoleRelationEo.setUserId(userId);
        userRoleRelationEo.setRoleCode("TENANT_ADMIN");
        return this.userRoleRelationDas.selectOne((BaseEo)userRoleRelationEo) != null;
    }
}

