/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.yundt.cube.center.user.biz.service.IInstanceRelationService;
import com.dtyunxi.yundt.cube.center.user.biz.util.HostnameUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.AppInstanceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.InstanceHostNameRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AppInstanceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.InstanceHostNameRelationEo;
import com.dtyunxi.yundt.module.context.common.callback.IAppInstanceCallBack;
import com.dtyunxi.yundt.module.context.common.config.AppRecognitionConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InstanceRelationServiceImpl
implements IInstanceRelationService {
    @Resource
    private InstanceHostNameRelationDas instanceHostNameRelationDas;
    @Autowired
    private AppRecognitionConfig appRecognitionConfig;
    @Resource
    private AppInstanceDas appInstanceDas;

    @Override
    public AppInstanceEo getByMoreHostName(String hostName) {
        InstanceHostNameRelationEo relationEo = this.instanceHostNameRelationDas.selectByHostName(hostName);
        if (relationEo == null) {
            return null;
        }
        AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(relationEo.getAppInstanceId());
        String serverName = hostName;
        if (hostName.toLowerCase().startsWith("http") || hostName.contains(".")) {
            serverName = IAppInstanceCallBack.processWithUrl((String)hostName, (int)this.appRecognitionConfig.getxRealHostNameSnippetLen(), (String)this.appRecognitionConfig.getKeyWord());
        }
        appInstanceEo.setServerName(serverName);
        appInstanceEo.setHostName(relationEo.getHostName());
        return appInstanceEo;
    }

    @Override
    public Map<Long, String> queryHostnameBySiteName(Set<Long> instanceIds, String siteName) {
        if (CollectionUtils.isEmpty(instanceIds)) {
            return null;
        }
        List appInstances = this.instanceHostNameRelationDas.selectInstanceIdBySiteName(siteName);
        if (CollectionUtils.isEmpty((Collection)appInstances)) {
            return null;
        }
        HashMap<Long, String> resultMap = new HashMap<Long, String>();
        for (InstanceHostNameRelationEo appInstance : appInstances) {
            if (!instanceIds.contains(appInstance.getAppInstanceId())) continue;
            resultMap.put(appInstance.getAppInstanceId(), appInstance.getHostName());
        }
        return resultMap;
    }

    private String extraHostNameCore(String hostName) {
        if (hostName.toLowerCase().startsWith("http") || hostName.contains(".")) {
            hostName = IAppInstanceCallBack.processWithUrl((String)hostName, (int)this.appRecognitionConfig.getRefererSnippetLen(), (String)this.appRecognitionConfig.getKeyWord());
        }
        return hostName;
    }

    @Override
    public String getHostName() {
        ServiceContext context = ServiceContext.getContext();
        String hostName = context.getAttachment("Referer");
        if (null == hostName) {
            hostName = context.getAttachment("X-Real-Hostname");
        }
        return HostnameUtil.extraSiteName(hostName);
    }
}

