/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.cube.utils.codec.RSAUtils;
import com.dtyunxi.yundt.cube.center.user.api.dto.ext.user.PasswordEncryptDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ext.user.PasswordVerifyDto;
import com.dtyunxi.yundt.cube.center.user.biz.exception.BizException;
import com.dtyunxi.yundt.cube.center.user.biz.service.IPasswordService;
import com.dtyunxi.yundt.cube.center.user.ext.user.IPasswordEncryptExt;
import com.dtyunxi.yundt.cube.center.user.ext.user.IPasswordVerifytExt;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PasswordServiceImpl
implements IPasswordService {
    @Autowired
    IPasswordEncryptExt<String, PasswordEncryptDto> passwordEncryptExt;
    @Autowired
    IPasswordVerifytExt<Boolean, PasswordVerifyDto> passwordVerifytExt;
    @Value(value="${token.rsa.privateKey:}")
    protected String rsaPrivateKey;

    @Override
    public String encryptPassword(String inputPassword, String salt, Long tenantId, Long instantceId) {
        return (String)this.passwordEncryptExt.execute((Object)PasswordEncryptDto.init((String)inputPassword, (String)salt, (Long)tenantId, (Long)instantceId));
    }

    @Override
    public boolean verifyPassword(String inputPassword, String dbPassword, String salt, Long tenantId, Long instantceId) {
        return (Boolean)this.passwordVerifytExt.execute((Object)PasswordVerifyDto.init((String)inputPassword, (String)dbPassword, (String)salt, (Long)tenantId, (Long)instantceId));
    }

    @Override
    public String RSAEncrypt(String inputPassword) {
        String result = inputPassword;
        if (StringUtils.isNotBlank((CharSequence)this.rsaPrivateKey) && StringUtils.isNotBlank((CharSequence)inputPassword)) {
            try {
                byte[] pwByte = RSAUtils.decryptByPrivateKey((String)inputPassword, (String)this.rsaPrivateKey);
                result = new String(pwByte);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BizException("\u89e3\u5bc6\u5931\u8d25");
            }
        }
        return result;
    }
}

