/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.AddressDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.BillInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ContactsInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.DeviceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.PersonalInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserInvoiceTitleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.DeviceReqDto;
import com.dtyunxi.yundt.cube.center.user.api.exception.UserExceptionCode;
import com.dtyunxi.yundt.cube.center.user.biz.service.IPersonalInfoService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.util.QueryUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.AddressDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.BillInfoDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.ContactsInfoDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.DeviceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.PersonalInfoDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AddressEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.BillInfoEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.ContactsInfoEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.DeviceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.PersonalInfoEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PersonalInfoServiceImpl
implements IPersonalInfoService {
    private Logger logger = LoggerFactory.getLogger(PersonalInfoServiceImpl.class);
    @Resource
    private UserDas userDas;
    @Resource
    private PersonalInfoDas personalInfoDas;
    @Resource
    private BillInfoDas billInfoDas;
    @Resource
    private ContactsInfoDas contactsInfoDas;
    @Resource
    private AddressDas addressDas;
    @Resource
    private DeviceDas deviceDas;

    @Override
    public boolean checkIdCardUnique(String identityCard) {
        if (StringUtils.isBlank((CharSequence)identityCard)) {
            return false;
        }
        return this.personalInfoDas.findByIdentityCard(identityCard) != null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addPersonalInfo(Long userId, PersonalInfoDto personalInfoDto) {
        AssertUtil.isTrue(null != userId, "userId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        UserEo user = (UserEo)this.userDas.selectByPrimaryKey(userId);
        if (user != null) {
            if (user.getPersonId() == null) {
                if (personalInfoDto.isCheckIdCardUnique()) {
                    AssertUtil.isTrue(!this.checkIdCardUnique(personalInfoDto.getIdentityCard()), "\u8bc1\u4ef6\u53f7\u7801\u5df2\u7ecf\u5b58\u5728");
                }
                PersonalInfoEo personalInfoEo = new PersonalInfoEo();
                DtoHelper.dto2Eo((BaseVo)personalInfoDto, (BaseEo)personalInfoEo);
                personalInfoEo.setInstanceId(user.getInstanceId());
                this.personalInfoDas.insert((BaseEo)personalInfoEo);
                user.setPersonId(personalInfoEo.getId());
                this.userDas.update((BaseEo)user);
                return personalInfoEo.getId();
            }
            this.logger.error("\u8be5\u7528\u6237\u5df2\u5b58\u5728\u4e2a\u4eba\u4fe1\u606f");
            throw new BizException(UserExceptionCode.PERSONALINFO_EXIST_FAIL.getCode(), UserExceptionCode.PERSONALINFO_EXIST_FAIL.getMsg());
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updatePersonalInfo(Long userId, PersonalInfoDto personalInfoDto) {
        AssertUtil.isTrue(null != userId, "userId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        UserEo user = (UserEo)this.userDas.selectByPrimaryKey(userId);
        if (user != null) {
            PersonalInfoEo personalInfo = (PersonalInfoEo)this.personalInfoDas.selectByPrimaryKey(personalInfoDto.getId());
            if (personalInfo == null) {
                this.logger.error("\u8be5\u7528\u6237\u5bf9\u5e94\u7684\u4e2a\u4eba\u4fe1\u606f\u4e0d\u5b58\u5728");
                throw new BizException(UserExceptionCode.PERSONALINFO_NON_EXIST_FAIL.getCode(), UserExceptionCode.PERSONALINFO_NON_EXIST_FAIL.getMsg());
            }
            DtoHelper.dto2Eo((BaseVo)personalInfoDto, (BaseEo)personalInfo, (String[])new String[]{"tenantId", "instanceId"});
            this.personalInfoDas.update((BaseEo)personalInfo);
            return personalInfoDto.getId();
        }
        return null;
    }

    @Override
    public PersonalInfoDto queryByPersonalInfoId(Long personalInfoId) {
        PersonalInfoEo personalInfoEo = (PersonalInfoEo)this.personalInfoDas.selectByPrimaryKey(personalInfoId);
        PersonalInfoDto personalInfoDto = null;
        if (personalInfoEo != null) {
            personalInfoDto = new PersonalInfoDto();
            DtoHelper.eo2Dto((BaseEo)personalInfoEo, (BaseVo)personalInfoDto);
            UserEo userEo = this.userDas.findByPersonId(personalInfoId);
            personalInfoDto.setUserId(userEo.getId());
        }
        return personalInfoDto;
    }

    @Override
    public PersonalInfoDto queryPersonalInfo(Long personalInfoId) {
        PersonalInfoEo personalInfoEo = (PersonalInfoEo)this.personalInfoDas.selectByPrimaryKey(personalInfoId);
        PersonalInfoDto personalInfoDto = null;
        if (personalInfoEo != null) {
            personalInfoDto = new PersonalInfoDto();
            DtoHelper.eo2Dto((BaseEo)personalInfoEo, (BaseVo)personalInfoDto);
        }
        return personalInfoDto;
    }

    @Override
    public PageInfo<PersonalInfoDto> queryByPersonalInfoExample(PersonalInfoDto personalInfoDto, Integer pageNumber, Integer pageSize) {
        AssertUtil.isTrue(null != personalInfoDto, "personalInfoDto \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        PersonalInfoEo personalInfoEo = new PersonalInfoEo();
        DtoHelper.dto2Eo((BaseVo)personalInfoDto, (BaseEo)personalInfoEo);
        PageInfo page = this.personalInfoDas.selectPage((BaseEo)personalInfoEo, pageNumber, pageSize);
        return QueryUtil.eoPage2DtoPage((PageInfo<? extends BaseEo>)page, PersonalInfoDto.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addBillInfo(Long userId, BillInfoDto billInfoDto) {
        UserEo user = (UserEo)this.userDas.selectByPrimaryKey(userId);
        if (user != null) {
            BillInfoEo billInfoEo = new BillInfoEo();
            DtoHelper.dto2Eo((BaseVo)billInfoDto, (BaseEo)billInfoEo);
            billInfoEo.setUserId(userId);
            this.billInfoDas.insert((BaseEo)billInfoEo);
            return billInfoEo.getId();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateBillInfo(Long userId, BillInfoDto billInfoDto) {
        UserEo user = (UserEo)this.userDas.selectByPrimaryKey(userId);
        if (user != null) {
            BillInfoEo billInfoEo = (BillInfoEo)this.billInfoDas.selectByPrimaryKey(billInfoDto.getId());
            if (billInfoEo == null) {
                this.logger.error("\u5f00\u7968\u4fe1\u606f\u4e0d\u5b58\u5728");
                throw new BizException(UserExceptionCode.BILLINFO_NON_EXIST_FAIL.getCode(), UserExceptionCode.BILLINFO_NON_EXIST_FAIL.getMsg());
            }
            DtoHelper.dto2Eo((BaseVo)billInfoDto, (BaseEo)billInfoEo, (String[])new String[]{"tenantId", "instanceId"});
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.eq((String)"id", (Object)billInfoDto.getId()));
            sqlFilterList.add(SqlFilter.eq((String)"user_id", (Object)userId));
            billInfoEo.setSqlFilters(sqlFilterList);
            this.billInfoDas.updateSelectiveSqlFilter((BaseEo)billInfoEo);
            return billInfoDto.getId();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBillInfo(Long billInfoId) {
        BillInfoEo billInfoEo = new BillInfoEo();
        billInfoEo.setId(billInfoId);
        this.billInfoDas.logicDelete((BaseEo)billInfoEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setDefaultBillInfo(UserInvoiceTitleDto userInvoiceTitleDto) {
        try {
            Long userId = userInvoiceTitleDto.getUserId();
            BillInfoEo temp = new BillInfoEo();
            temp.setId(userInvoiceTitleDto.getBillInfoId());
            temp.setUserId(userId);
            BillInfoEo billInfoEo = (BillInfoEo)this.billInfoDas.selectOne((BaseEo)temp);
            if (null == billInfoEo) {
                return;
            }
            billInfoEo = new BillInfoEo();
            billInfoEo.setInvoiceStatus(Integer.valueOf(0));
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.eq((String)"user_id", (Object)userId));
            billInfoEo.setSqlFilters(sqlFilterList);
            this.billInfoDas.updateSelectiveSqlFilter((BaseEo)billInfoEo);
            temp.setInvoiceStatus(Integer.valueOf(1));
            temp.setUserId(null);
            this.billInfoDas.updateSelective((BaseEo)temp);
        }
        catch (Exception e) {
            this.logger.error("\u8bbe\u7f6e\u9ed8\u8ba4\u5f00\u7968\u4fe1\u606f\u65f6\u51fa\u9519\uff01", (Throwable)e);
        }
    }

    @Override
    public BillInfoDto queryByBillInfoId(Long billInfoId, String filter) {
        BillInfoEo temp = null == filter ? new BillInfoEo() : (BillInfoEo)JSON.parseObject((String)filter, BillInfoEo.class);
        temp.setId(billInfoId);
        BillInfoEo billInfoEo = (BillInfoEo)this.billInfoDas.selectOne((BaseEo)temp);
        BillInfoDto billInfoDto = null;
        if (billInfoEo != null) {
            billInfoDto = new BillInfoDto();
            billInfoDto.setUserId(billInfoEo.getUserId());
            DtoHelper.eo2Dto((BaseEo)billInfoEo, (BaseVo)billInfoDto);
        }
        return billInfoDto;
    }

    @Override
    public PageInfo<BillInfoDto> queryByBillInfoExample(BillInfoDto billInfoDto, Integer pageNumber, Integer pageSize) {
        AssertUtil.isTrue(null != billInfoDto, "billInfoDto \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BillInfoEo billInfoEo = new BillInfoEo();
        DtoHelper.dto2Eo((BaseVo)billInfoDto, (BaseEo)billInfoEo);
        PageInfo page = this.billInfoDas.selectPage((BaseEo)billInfoEo, pageNumber, pageSize);
        return QueryUtil.eoPage2DtoPage((PageInfo<? extends BaseEo>)page, BillInfoDto.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addContactsInfo(Long userId, ContactsInfoDto contactsInfoDto) {
        UserEo user = (UserEo)this.userDas.selectByPrimaryKey(userId);
        if (user != null) {
            ContactsInfoEo contactsInfoEo = new ContactsInfoEo();
            DtoHelper.dto2Eo((BaseVo)contactsInfoDto, (BaseEo)contactsInfoEo);
            contactsInfoEo.setUserId(user.getId());
            if (null != contactsInfoDto.getStatus() && contactsInfoDto.getStatus() == 1) {
                this.contactsInfoDas.updateStatus(userId);
            }
            this.contactsInfoDas.insert((BaseEo)contactsInfoEo);
            return contactsInfoEo.getId();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateContactsInfo(Long userId, ContactsInfoDto contactsInfoDto) {
        UserEo user = (UserEo)this.userDas.selectByPrimaryKey(userId);
        if (user != null) {
            ContactsInfoEo contactsInfoEo = (ContactsInfoEo)this.contactsInfoDas.selectByPrimaryKey(contactsInfoDto.getId());
            if (contactsInfoEo == null) {
                this.logger.error("\u8054\u7cfb\u4eba\u4fe1\u606f\u4e0d\u5b58\u5728");
                throw new BizException(UserExceptionCode.CONTACTINFO_NON_EXIST_FAIL.getCode(), UserExceptionCode.CONTACTINFO_NON_EXIST_FAIL.getMsg());
            }
            DtoHelper.dto2Eo((BaseVo)contactsInfoDto, (BaseEo)contactsInfoEo, (String[])new String[]{"tenantId", "instanceId"});
            if (contactsInfoDto.getStatus() != null && contactsInfoDto.getStatus() == 1) {
                this.contactsInfoDas.updateStatus(userId);
            }
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.eq((String)"id", (Object)contactsInfoDto.getId()));
            sqlFilterList.add(SqlFilter.eq((String)"user_id", (Object)userId));
            contactsInfoEo.setSqlFilters(sqlFilterList);
            this.contactsInfoDas.updateSelectiveSqlFilter((BaseEo)contactsInfoEo);
            return contactsInfoDto.getId();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long deleteContactsInfo(Long userId, Long contactsId) {
        ContactsInfoEo contactsInfoEo = new ContactsInfoEo();
        contactsInfoEo.setId(contactsId);
        contactsInfoEo.setUserId(userId);
        this.contactsInfoDas.logicDelete((BaseEo)contactsInfoEo);
        return 1L;
    }

    @Override
    public ContactsInfoDto queryByContactId(Long contactId, String filter) {
        ContactsInfoEo temp = null == filter ? new ContactsInfoEo() : (ContactsInfoEo)JSON.parseObject((String)filter, ContactsInfoEo.class);
        temp.setId(contactId);
        ContactsInfoEo contactsInfoEo = (ContactsInfoEo)this.contactsInfoDas.selectOne((BaseEo)temp);
        ContactsInfoDto contactsInfoDto = null;
        if (contactsInfoEo != null) {
            contactsInfoDto = new ContactsInfoDto();
            contactsInfoDto.setUserId(contactsInfoEo.getUserId());
            DtoHelper.eo2Dto((BaseEo)contactsInfoEo, (BaseVo)contactsInfoDto);
        }
        return contactsInfoDto;
    }

    @Override
    public PageInfo<ContactsInfoDto> queryByContactExample(ContactsInfoDto contactsInfoDto, Integer pageNumber, Integer pageSize) {
        AssertUtil.isTrue(null != contactsInfoDto, "contactsInfoDto \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ContactsInfoEo contactsInfoEo = new ContactsInfoEo();
        UserEo userEo = new UserEo();
        userEo.setRegisterTime(null);
        userEo.setStatus(null);
        userEo.setId(contactsInfoDto.getUserId());
        DtoHelper.dto2Eo((BaseVo)contactsInfoDto, (BaseEo)contactsInfoEo);
        contactsInfoEo.setUserId(userEo.getId());
        PageInfo page = this.contactsInfoDas.selectPage((BaseEo)contactsInfoEo, pageNumber, pageSize);
        return QueryUtil.eoPage2DtoPage((PageInfo<? extends BaseEo>)page, ContactsInfoDto.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addAddress(Long userId, AddressDto addressDto) {
        UserEo user = (UserEo)this.userDas.selectByPrimaryKey(userId);
        if (user != null) {
            AddressEo addressEo = new AddressEo();
            DtoHelper.dto2Eo((BaseVo)addressDto, (BaseEo)addressEo);
            addressEo.setUserId(user.getId());
            this.addressDas.insert((BaseEo)addressEo);
            if (null != addressDto.getStatus() && addressDto.getStatus() == 1) {
                AddressEo queryEo = new AddressEo();
                queryEo.setUserId(userId);
                queryEo.setStatus(Integer.valueOf(1));
                List addressEoList = this.addressDas.selectList((BaseEo)queryEo);
                if (CollectionUtil.isNotEmpty((Collection)addressEoList)) {
                    addressEoList.forEach(eo -> {
                        if (!eo.getId().equals(addressEo.getId())) {
                            eo.setStatus(Integer.valueOf(0));
                            this.addressDas.updateSelective((BaseEo)eo);
                        }
                    });
                }
            }
            return addressEo.getId();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateAddress(Long userId, AddressDto addressDto) {
        UserEo user = (UserEo)this.userDas.selectByPrimaryKey(userId);
        if (user != null && addressDto != null) {
            AddressEo addressEo = (AddressEo)this.addressDas.selectByPrimaryKey(addressDto.getId());
            if (addressEo == null) {
                this.logger.error("\u5730\u5740\u4fe1\u606f\u4e0d\u5b58\u5728");
                throw new BizException(UserExceptionCode.ADDRESSINFO_NON_EXIST_FAIL.getCode(), UserExceptionCode.ADDRESSINFO_NON_EXIST_FAIL.getMsg());
            }
            DtoHelper.dto2Eo((BaseVo)addressDto, (BaseEo)addressEo, (String[])new String[]{"tenantId", "instanceId"});
            Long addressId = addressEo.getId();
            if (addressDto.getStatus() != null && addressDto.getStatus() == 1) {
                this.addressDas.updateStatus(userId, addressId);
            }
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.eq((String)"id", (Object)addressDto.getId()));
            sqlFilterList.add(SqlFilter.eq((String)"user_id", (Object)userId));
            addressEo.setSqlFilters(sqlFilterList);
            this.addressDas.updateSelectiveSqlFilter((BaseEo)addressEo);
            return addressDto.getId();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long deleteAddress(Long userId, Long addressId) {
        AddressEo addressEo = new AddressEo();
        addressEo.setUserId(userId);
        addressEo.setId(addressId);
        this.addressDas.logicDelete((BaseEo)addressEo);
        return 1L;
    }

    @Override
    public AddressDto queryByAddressId(Long addressId, String filter) {
        AddressEo temp = null == filter ? new AddressEo() : (AddressEo)JSON.parseObject((String)filter, AddressEo.class);
        temp.setId(addressId);
        AddressEo addressEo = (AddressEo)this.addressDas.selectOne((BaseEo)temp);
        AddressDto addressDto = null;
        if (addressEo != null) {
            addressDto = new AddressDto();
            addressDto.setUserId(addressEo.getUserId());
            DtoHelper.eo2Dto((BaseEo)addressEo, (BaseVo)addressDto);
        }
        return addressDto;
    }

    @Override
    public PageInfo<AddressDto> queryByAddressExample(AddressDto addressDto, Integer pageNumber, Integer pageSize) {
        AssertUtil.isTrue(null != addressDto, "addressDto \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AddressEo addressEo = new AddressEo();
        DtoHelper.dto2Eo((BaseVo)addressDto, (BaseEo)addressEo);
        PageInfo page = this.addressDas.selectPage((BaseEo)addressEo, pageNumber, pageSize);
        return QueryUtil.eoPage2DtoPage((PageInfo<? extends BaseEo>)page, AddressDto.class);
    }

    @Override
    public List<AddressDto> queryAddressByUserId(Long userId) {
        List addressEos = this.addressDas.queryByUserId(userId);
        ArrayList addressDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)addressEos, (Collection)addressDtos, AddressDto.class);
        return addressDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean setDefaultAddress(Long userId, Long addressId) {
        try {
            AddressEo temp = new AddressEo();
            temp.setId(addressId);
            temp.setUserId(userId);
            AddressEo addressEo = (AddressEo)this.addressDas.selectOne((BaseEo)temp);
            if (null == addressEo) {
                return false;
            }
            userId = addressEo.getUserId();
            this.addressDas.updateStatus(userId, addressId);
            addressEo.setStatus(Integer.valueOf(1));
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.eq((String)"id", (Object)addressEo.getId()));
            sqlFilterList.add(SqlFilter.eq((String)"user_id", (Object)userId));
            addressEo.setSqlFilters(sqlFilterList);
            this.addressDas.updateSelectiveSqlFilter((BaseEo)addressEo);
            return true;
        }
        catch (Exception e) {
            this.logger.error("\u8bbe\u7f6e\u9ed8\u8ba4\u5730\u5740\u65f6\u51fa\u9519\uff01", (Throwable)e);
            return false;
        }
    }

    @Override
    public PageInfo<ContactsInfoDto> queryContactsByExample(Long userId, String filter, Integer pageNum, Integer pageSize) {
        ContactsInfoEo contactsInfoEo = QueryUtil.validateExampleAndReturn(filter, ContactsInfoEo.class);
        UserEo userEo = new UserEo();
        userEo.setRegisterTime(null);
        userEo.setStatus(null);
        userEo.setId(userId);
        contactsInfoEo.setUserId(userEo.getId());
        PageInfo page = this.contactsInfoDas.selectPage((BaseEo)contactsInfoEo, pageNum, pageSize);
        return QueryUtil.eoPage2DtoPage((PageInfo<? extends BaseEo>)page, ContactsInfoDto.class);
    }

    @Override
    public Long addDevice(DeviceReqDto deviceDto) {
        DeviceEo deviceEo = new DeviceEo();
        DtoHelper.dto2Eo((BaseVo)deviceDto, (BaseEo)deviceEo);
        this.deviceDas.insert((BaseEo)deviceEo);
        return deviceEo.getId();
    }

    @Override
    public List<DeviceDto> queryDeviceById(Long userId) {
        DeviceEo deviceEo = new DeviceEo();
        deviceEo.setUserId(userId);
        List deviceEos = this.deviceDas.select((BaseEo)deviceEo);
        if (deviceEos == null || deviceEos.isEmpty()) {
            throw new BizException(UserExceptionCode.DEVICE_FIND_FAIL.getCode(), UserExceptionCode.DEVICE_FIND_FAIL.getMsg());
        }
        ArrayList deviceDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)deviceEos, (Collection)deviceDtos, DeviceDto.class);
        return deviceDtos;
    }
}

